/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AlwaysVisibleActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CompactActionGroup;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionMenuItem;
import com.intellij.openapi.actionSystem.impl.PresentationFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class Utils {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.actionSystem.impl.Utils");
    @NonNls
    public static final String NOTHING_HERE = "Nothing here";
    public static final AnAction EMPTY_MENU_FILLER = new AnAction("Nothing here"){
        {
            this.getTemplatePresentation().setEnabled(false);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                1.$$$reportNull$$$0(0);
            }
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                1.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(false);
            super.update(e);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            objectArray2[0] = "e";
            objectArray2[1] = "com/intellij/openapi/actionSystem/impl/Utils$1";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    };

    private Utils() {
    }

    private static void handleUpdateException(AnAction action, Presentation presentation, Throwable exc) {
        String id = ActionManager.getInstance().getId(action);
        if (id != null) {
            LOG.error("update failed for AnAction(" + action.getClass().getName() + ") with ID=" + id, exc);
        } else {
            LOG.error("update failed for ActionGroup: " + action + "[" + presentation.getText() + "]", exc);
        }
    }

    public static void expandActionGroup(boolean isInModalContext, @NotNull ActionGroup group, List<? super AnAction> list2, PresentationFactory presentationFactory, @NotNull DataContext context, String place, ActionManager actionManager) {
        if (group == null) {
            Utils.$$$reportNull$$$0(0);
        }
        if (context == null) {
            Utils.$$$reportNull$$$0(1);
        }
        Utils.expandActionGroup(isInModalContext, group, list2, presentationFactory, context, place, actionManager, false, group instanceof CompactActionGroup);
    }

    private static void expandActionGroup(boolean isInModalContext, @NotNull ActionGroup group, List<? super AnAction> list2, PresentationFactory presentationFactory, DataContext context, @NotNull String place, ActionManager actionManager, boolean transparentOnly, boolean hideDisabled) {
        if (group == null) {
            Utils.$$$reportNull$$$0(2);
        }
        if (place == null) {
            Utils.$$$reportNull$$$0(3);
        }
        Utils.expandActionGroup(isInModalContext, group, list2, presentationFactory, context, place, actionManager, transparentOnly, hideDisabled, false, false);
    }

    public static void expandActionGroup(boolean isInModalContext, @NotNull ActionGroup group, List<? super AnAction> list2, PresentationFactory presentationFactory, DataContext context, @NotNull String place, ActionManager actionManager, boolean transparentOnly, boolean hideDisabled, boolean isContextMenuAction, boolean isToolbarAction) {
        Presentation presentation;
        AnActionEvent e;
        if (group == null) {
            Utils.$$$reportNull$$$0(4);
        }
        if (place == null) {
            Utils.$$$reportNull$$$0(5);
        }
        if (!Utils.doUpdate(isInModalContext, (AnAction)group, e = new AnActionEvent(null, context, place, presentation = presentationFactory.getPresentation((AnAction)group), actionManager, 0, isContextMenuAction, isToolbarAction), presentation)) {
            return;
        }
        if (!presentation.isVisible()) {
            return;
        }
        AnAction[] children2 = group.getChildren(e);
        for (int i = 0; i < children2.length; ++i) {
            AnAction child2 = children2[i];
            if (child2 == null) {
                String groupId = ActionManager.getInstance().getId((AnAction)group);
                LOG.error("action is null: i=" + i + " group=" + group + " group id=" + groupId);
                continue;
            }
            presentation = presentationFactory.getPresentation(child2);
            AnActionEvent e1 = new AnActionEvent(null, context, place, presentation, actionManager, 0, isContextMenuAction, isToolbarAction);
            e1.setInjectedContext(child2.isInInjectedContext());
            if ((!transparentOnly || child2.isTransparentUpdate()) && !Utils.doUpdate(isInModalContext, child2, e1, presentation) || !presentation.isVisible() || !presentation.isEnabled() && hideDisabled) continue;
            if (child2 instanceof ActionGroup) {
                boolean skip;
                ActionGroup actionGroup = (ActionGroup)child2;
                boolean bl = skip = hideDisabled && !Utils.hasEnabledChildren(actionGroup, presentationFactory, context, place);
                if (skip) continue;
                if (actionGroup.isPopup()) {
                    if (actionGroup.disableIfNoVisibleChildren()) {
                        boolean visibleChildren = Utils.hasVisibleChildren(actionGroup, presentationFactory, context, place);
                        if (actionGroup.hideIfNoVisibleChildren() && !visibleChildren) continue;
                        presentation.setEnabled(actionGroup.canBePerformed(context) || visibleChildren);
                    }
                    list2.add((AnAction)child2);
                    continue;
                }
                boolean hideDisabledChildren = hideDisabled || actionGroup instanceof CompactActionGroup;
                Utils.expandActionGroup(isInModalContext, (ActionGroup)child2, list2, presentationFactory, context, place, actionManager, false, hideDisabledChildren, isContextMenuAction, isToolbarAction);
                continue;
            }
            if (child2 instanceof Separator) {
                if (StringUtil.isEmpty((String)((Separator)child2).getText()) && (list2.isEmpty() || list2.get(list2.size() - 1) instanceof Separator)) continue;
                list2.add((AnAction)child2);
                continue;
            }
            if (hideDisabled && !Utils.hasEnabledChildren((ActionGroup)new DefaultActionGroup(new AnAction[]{child2}), presentationFactory, context, place)) continue;
            list2.add((AnAction)child2);
        }
    }

    private static boolean doUpdate(boolean isInModalContext, AnAction action, AnActionEvent e, Presentation presentation) throws ProcessCanceledException {
        boolean result2;
        if (ApplicationManager.getApplication().isDisposed()) {
            return false;
        }
        long startTime = System.currentTimeMillis();
        try {
            result2 = !ActionUtil.performDumbAwareUpdate((boolean)isInModalContext, (AnAction)action, (AnActionEvent)e, (boolean)false);
        }
        catch (ProcessCanceledException ex) {
            throw ex;
        }
        catch (Throwable exc) {
            Utils.handleUpdateException(action, presentation, exc);
            return false;
        }
        long endTime = System.currentTimeMillis();
        if (endTime - startTime > 10L && LOG.isDebugEnabled()) {
            LOG.debug("Action " + action + ": updated in " + (endTime - startTime) + " ms");
        }
        return result2;
    }

    private static boolean hasVisibleChildren(ActionGroup group, PresentationFactory factory, DataContext context, String place) {
        return Utils.hasChildrenWithState(group, factory, context, place, true, false);
    }

    private static boolean hasEnabledChildren(ActionGroup group, PresentationFactory factory, DataContext context, String place) {
        return Utils.hasChildrenWithState(group, factory, context, place, false, true);
    }

    private static boolean hasChildrenWithState(ActionGroup group, PresentationFactory factory, DataContext context, String place, boolean checkVisible, boolean checkEnabled) {
        if (group instanceof AlwaysVisibleActionGroup) {
            return true;
        }
        AnActionEvent event = new AnActionEvent(null, context, place, factory.getPresentation((AnAction)group), ActionManager.getInstance(), 0);
        event.setInjectedContext(group.isInInjectedContext());
        for (AnAction anAction : group.getChildren(event)) {
            ActionGroup childGroup;
            Project project;
            if (anAction == null) {
                LOG.error("Null action found in group " + group + ", " + factory.getPresentation((AnAction)group));
                continue;
            }
            if (anAction instanceof Separator || (project = (Project)CommonDataKeys.PROJECT.getData(context)) != null && DumbService.getInstance((Project)project).isDumb() && !anAction.isDumbAware()) continue;
            Presentation presentation = factory.getPresentation(anAction);
            Utils.updateGroupChild(context, place, anAction, presentation);
            if (!(anAction instanceof ActionGroup ? !((childGroup = (ActionGroup)anAction).isPopup() && (checkVisible && !presentation.isVisible() || checkEnabled && !presentation.isEnabled()) || !Utils.hasChildrenWithState(childGroup, factory, context, place, checkVisible, checkEnabled)) : checkVisible && presentation.isVisible() || checkEnabled && presentation.isEnabled())) continue;
            return true;
        }
        return false;
    }

    public static void updateGroupChild(DataContext context, String place, AnAction anAction, Presentation presentation) {
        AnActionEvent event1 = new AnActionEvent(null, context, place, presentation, ActionManager.getInstance(), 0);
        event1.setInjectedContext(anAction.isInInjectedContext());
        Utils.doUpdate(false, anAction, event1, presentation);
    }

    public static void fillMenu(@NotNull ActionGroup group, final JComponent component, boolean enableMnemonics, PresentationFactory presentationFactory, @NotNull DataContext context, String place, boolean isWindowMenu, boolean mayDataContextBeInvalid, boolean isInModalContext, boolean useDarkIcons) {
        if (group == null) {
            Utils.$$$reportNull$$$0(6);
        }
        if (context == null) {
            Utils.$$$reportNull$$$0(7);
        }
        ActionCallback menuBuilt = new ActionCallback();
        boolean checked = group instanceof CheckedActionGroup;
        ArrayList list2 = new ArrayList();
        Utils.expandActionGroup(isInModalContext, group, list2, presentationFactory, context, place, ActionManager.getInstance(), false, group instanceof CompactActionGroup, true, false);
        boolean fixMacScreenMenu = SystemInfo.isMacSystemMenu && isWindowMenu && Registry.is((String)"actionSystem.mac.screenMenuNotUpdatedFix");
        ArrayList<Object> children2 = new ArrayList<Object>();
        int size = list2.size();
        for (int i = 0; i < size; ++i) {
            AnAction action = (AnAction)list2.get(i);
            if (action instanceof Separator) {
                final String text = ((Separator)action).getText();
                if (StringUtil.isEmpty((String)text) && (i <= 0 || i >= size - 1)) continue;
                component.add(new JPopupMenu.Separator(){
                    private final JMenuItem myMenu;
                    {
                        this.myMenu = !StringUtil.isEmpty((String)text) ? new JMenuItem(text) : null;
                    }

                    @Override
                    public void doLayout() {
                        super.doLayout();
                        if (this.myMenu != null) {
                            this.myMenu.setBounds(this.getBounds());
                        }
                    }

                    @Override
                    protected void paintComponent(Graphics g) {
                        if (UIUtil.isUnderDarcula() || UIUtil.isUnderWin10LookAndFeel()) {
                            g.setColor(component.getBackground());
                            g.fillRect(0, 0, this.getWidth(), this.getHeight());
                        }
                        if (this.myMenu != null) {
                            this.myMenu.paint(g);
                        } else {
                            super.paintComponent(g);
                        }
                    }

                    @Override
                    public Dimension getPreferredSize() {
                        return this.myMenu != null ? this.myMenu.getPreferredSize() : super.getPreferredSize();
                    }
                });
                continue;
            }
            if (action instanceof ActionGroup && (!((ActionGroup)action).canBePerformed(context) || Utils.hasVisibleChildren((ActionGroup)action, presentationFactory, context, place))) {
                ActionMenu menu = new ActionMenu(context, place, (ActionGroup)action, presentationFactory, enableMnemonics, useDarkIcons);
                component.add((Component)((Object)menu));
                children2.add((Object)menu);
                continue;
            }
            ActionMenuItem each = new ActionMenuItem(action, presentationFactory.getPresentation(action), place, context, enableMnemonics, !fixMacScreenMenu, checked, useDarkIcons);
            component.add((Component)((Object)each));
            children2.add((Object)each);
        }
        if (list2.isEmpty()) {
            ActionMenuItem each = new ActionMenuItem(EMPTY_MENU_FILLER, presentationFactory.getPresentation(EMPTY_MENU_FILLER), place, context, enableMnemonics, !fixMacScreenMenu, checked, useDarkIcons);
            component.add((Component)((Object)each));
            children2.add((Object)each);
        }
        if (fixMacScreenMenu) {
            SwingUtilities.invokeLater(() -> {
                for (Component each : children2) {
                    if (each.getParent() == null || !(each instanceof ActionMenuItem)) continue;
                    ((ActionMenuItem)((Object)((Object)each))).prepare();
                }
                menuBuilt.setDone();
            });
        } else {
            menuBuilt.setDone();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/actionSystem/impl/Utils";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "expandActionGroup";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "fillMenu";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

