/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions.searcheverywhere;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.actions.ChooseRunConfigurationPopup;
import com.intellij.execution.actions.ExecutorProvider;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereCommandInfo;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributor;
import com.intellij.ide.actions.searcheverywhere.SearchEverywhereContributorFilter;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.psi.codeStyle.MinusculeMatcher;
import com.intellij.psi.codeStyle.NameUtil;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RunConfigurationsSEContributor
implements SearchEverywhereContributor<Void> {
    private final SearchEverywhereCommandInfo RUN_COMMAND = new SearchEverywhereCommandInfo("run", IdeBundle.message((String)"searcheverywhere.runconfigurations.command.run.description", (Object[])new Object[0]), (SearchEverywhereContributor)this);
    private final SearchEverywhereCommandInfo DEBUG_COMMAND = new SearchEverywhereCommandInfo("debug", IdeBundle.message((String)"searcheverywhere.runconfigurations.command.debug.description", (Object[])new Object[0]), (SearchEverywhereContributor)this);
    private static final int RUN_MODE = 0;
    private static final int DEBUG_MODE = 1;
    private final Project myProject;
    private final Component myContextComponent;
    private final Supplier<String> myCommandSupplier;
    private final Renderer renderer = new Renderer();

    public RunConfigurationsSEContributor(Project project, Component component, Supplier<String> commandSupplier) {
        this.myProject = project;
        this.myContextComponent = component;
        this.myCommandSupplier = commandSupplier;
    }

    @NotNull
    public String getSearchProviderId() {
        String string = this.getClass().getSimpleName();
        if (string == null) {
            RunConfigurationsSEContributor.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getGroupName() {
        String string = IdeBundle.message((String)"searcheverywhere.run.configs.tab.name", (Object[])new Object[0]);
        if (string == null) {
            RunConfigurationsSEContributor.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public String includeNonProjectItemsText() {
        return null;
    }

    public int getSortWeight() {
        return 350;
    }

    public boolean showInFindResults() {
        return false;
    }

    public boolean processSelectedItem(@NotNull Object selected, int modifiers, @NotNull String searchText) {
        int mode;
        Executor executor;
        ChooseRunConfigurationPopup.ItemWrapper itemWrapper;
        RunnerAndConfigurationSettings settings;
        if (selected == null) {
            RunConfigurationsSEContributor.$$$reportNull$$$0(2);
        }
        if (searchText == null) {
            RunConfigurationsSEContributor.$$$reportNull$$$0(3);
        }
        if ((settings = (RunnerAndConfigurationSettings)ObjectUtils.tryCast((itemWrapper = (ChooseRunConfigurationPopup.ItemWrapper)selected).getValue(), RunnerAndConfigurationSettings.class)) != null && (executor = RunConfigurationsSEContributor.findExecutor(settings, mode = this.getMode(searchText, modifiers))) != null) {
            DataManager dataManager = DataManager.getInstance();
            itemWrapper.perform(this.myProject, executor, dataManager.getDataContext(this.myContextComponent));
        }
        return true;
    }

    @Nullable
    public Object getDataForItem(@NotNull Object element, @NotNull String dataId) {
        if (element == null) {
            RunConfigurationsSEContributor.$$$reportNull$$$0(4);
        }
        if (dataId == null) {
            RunConfigurationsSEContributor.$$$reportNull$$$0(5);
        }
        return null;
    }

    @NotNull
    public ListCellRenderer getElementsRenderer(@NotNull JList<?> list2) {
        if (list2 == null) {
            RunConfigurationsSEContributor.$$$reportNull$$$0(6);
        }
        Renderer renderer = this.renderer;
        if (renderer == null) {
            RunConfigurationsSEContributor.$$$reportNull$$$0(7);
        }
        return renderer;
    }

    @NotNull
    public List<SearchEverywhereCommandInfo> getSupportedCommands() {
        List<SearchEverywhereCommandInfo> list2 = Arrays.asList(this.RUN_COMMAND, this.DEBUG_COMMAND);
        if (list2 == null) {
            RunConfigurationsSEContributor.$$$reportNull$$$0(8);
        }
        return list2;
    }

    public void fetchElements(@NotNull String pattern, boolean everywhere, @Nullable SearchEverywhereContributorFilter<Void> filter, @NotNull ProgressIndicator progressIndicator, @NotNull Function<Object, Boolean> consumer) {
        ChooseRunConfigurationPopup.ItemWrapper[] wrappers;
        if (pattern == null) {
            RunConfigurationsSEContributor.$$$reportNull$$$0(9);
        }
        if (progressIndicator == null) {
            RunConfigurationsSEContributor.$$$reportNull$$$0(10);
        }
        if (consumer == null) {
            RunConfigurationsSEContributor.$$$reportNull$$$0(11);
        }
        if (StringUtil.isEmptyOrSpaces((String)pattern)) {
            return;
        }
        pattern = this.filterString(pattern);
        MinusculeMatcher matcher = NameUtil.buildMatcher((String)pattern).build();
        for (ChooseRunConfigurationPopup.ItemWrapper wrapper2 : wrappers = ChooseRunConfigurationPopup.createSettingsList(this.myProject, new ExecutorProvider(){

            @Override
            public Executor getExecutor() {
                return ExecutorRegistry.getInstance().getExecutorById(ToolWindowId.DEBUG);
            }
        }, false)) {
            if (!matcher.matches(wrapper2.getText()) || consumer.apply(wrapper2).booleanValue()) continue;
            return;
        }
    }

    private int getMode(String searchText, int modifiers) {
        if (RunConfigurationsSEContributor.isCommand(searchText, this.DEBUG_COMMAND)) {
            return 1;
        }
        if (RunConfigurationsSEContributor.isCommand(searchText, this.RUN_COMMAND)) {
            return 0;
        }
        return (modifiers & 1) == 0 ? 1 : 0;
    }

    private static Optional<String> extractFirstWord(String input) {
        if (!StringUtil.isEmptyOrSpaces((String)input) && input.contains(" ")) {
            return Optional.of(input.split(" ")[0]);
        }
        return Optional.empty();
    }

    private String filterString(String input) {
        return RunConfigurationsSEContributor.extractFirstWord(input).filter(firstWord -> this.RUN_COMMAND.getCommandWithPrefix().startsWith((String)firstWord) || this.DEBUG_COMMAND.getCommandWithPrefix().startsWith((String)firstWord)).map(firstWord -> input.substring(firstWord.length() + 1)).orElse(input);
    }

    private static boolean isCommand(String input, SearchEverywhereCommandInfo command) {
        if (input == null) {
            return false;
        }
        return RunConfigurationsSEContributor.extractFirstWord(input).map(firstWord -> command.getCommandWithPrefix().startsWith((String)firstWord)).orElse(false);
    }

    @Nullable
    private static Executor findExecutor(@NotNull RunnerAndConfigurationSettings settings, int mode) {
        Executor executor;
        if (settings == null) {
            RunConfigurationsSEContributor.$$$reportNull$$$0(12);
        }
        Executor runExecutor = DefaultRunExecutor.getRunExecutorInstance();
        Executor debugExecutor = ExecutorRegistry.getInstance().getExecutorById(ToolWindowId.DEBUG);
        Executor executor2 = executor = mode == 0 ? runExecutor : debugExecutor;
        if (executor == null) {
            return null;
        }
        RunConfiguration runConf = settings.getConfiguration();
        if (ProgramRunner.getRunner((String)executor.getId(), (RunProfile)runConf) == null) {
            executor = runExecutor == executor ? debugExecutor : runExecutor;
        }
        return executor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/actions/searcheverywhere/RunConfigurationsSEContributor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selected";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchText";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSearchProviderId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupName";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/actions/searcheverywhere/RunConfigurationsSEContributor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getElementsRenderer";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getSupportedCommands";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "processSelectedItem";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getDataForItem";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getElementsRenderer";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "fetchElements";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findExecutor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class Renderer
    extends JPanel
    implements ListCellRenderer<ChooseRunConfigurationPopup.ItemWrapper> {
        private final SimpleColoredComponent runConfigInfo;
        private final SimpleColoredComponent executorInfo;

        private Renderer() {
            super(new BorderLayout());
            this.runConfigInfo = new SimpleColoredComponent();
            this.executorInfo = new SimpleColoredComponent();
            this.add((Component)this.runConfigInfo, "Center");
            this.add((Component)this.executorInfo, "East");
            this.setBorder((Border)JBUI.Borders.empty((int)1, (int)(UIUtil.isUnderWin10LookAndFeel() ? 0 : JBUI.scale((int)UIUtil.getListCellHPadding()))));
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends ChooseRunConfigurationPopup.ItemWrapper> list2, ChooseRunConfigurationPopup.ItemWrapper wrapper2, int index, boolean isSelected, boolean cellHasFocus) {
            this.runConfigInfo.clear();
            this.executorInfo.clear();
            this.setBackground(UIUtil.getListBackground((boolean)isSelected));
            this.setFont(list2.getFont());
            Color foreground = isSelected ? list2.getSelectionForeground() : list2.getForeground();
            this.runConfigInfo.append(wrapper2.getText(), new SimpleTextAttributes(0, foreground));
            this.runConfigInfo.setIcon(wrapper2.getIcon());
            this.fillExecutorInfo(wrapper2, list2, isSelected);
            return this;
        }

        private void fillExecutorInfo(ChooseRunConfigurationPopup.ItemWrapper wrapper2, JList<?> list2, boolean selected) {
            SimpleTextAttributes commandAttributes = selected ? new SimpleTextAttributes(0, list2.getSelectionForeground()) : SimpleTextAttributes.GRAYED_ATTRIBUTES;
            SimpleTextAttributes shortcutAttributes = selected ? new SimpleTextAttributes(0, list2.getSelectionForeground()) : SimpleTextAttributes.GRAY_ATTRIBUTES;
            String input = (String)RunConfigurationsSEContributor.this.myCommandSupplier.get();
            if (RunConfigurationsSEContributor.isCommand(input, RunConfigurationsSEContributor.this.RUN_COMMAND)) {
                this.fillWithMode(wrapper2, 0, commandAttributes);
                return;
            }
            if (RunConfigurationsSEContributor.isCommand(input, RunConfigurationsSEContributor.this.DEBUG_COMMAND)) {
                this.fillWithMode(wrapper2, 1, commandAttributes);
                return;
            }
            Executor debugExecutor = ExecutorRegistry.getInstance().getExecutorById(ToolWindowId.DEBUG);
            Executor runExecutor = DefaultRunExecutor.getRunExecutorInstance();
            KeyStroke enterStroke = KeyStroke.getKeyStroke(10, 0);
            KeyStroke shiftEnterStroke = KeyStroke.getKeyStroke(10, 64);
            if (debugExecutor != null) {
                this.executorInfo.append(debugExecutor.getId(), commandAttributes);
                this.executorInfo.append("(" + KeymapUtil.getKeystrokeText((KeyStroke)enterStroke) + ")", shortcutAttributes);
                if (runExecutor != null) {
                    this.executorInfo.append(" / " + runExecutor.getId(), commandAttributes);
                    this.executorInfo.append("(" + KeymapUtil.getKeystrokeText((KeyStroke)shiftEnterStroke) + ")", shortcutAttributes);
                }
            } else if (runExecutor != null) {
                this.executorInfo.append(runExecutor.getId(), commandAttributes);
                this.executorInfo.append("(" + KeymapUtil.getKeystrokeText((KeyStroke)enterStroke) + ")", shortcutAttributes);
            }
        }

        private void fillWithMode(ChooseRunConfigurationPopup.ItemWrapper wrapper2, int mode, SimpleTextAttributes attributes) {
            Optional.ofNullable(ObjectUtils.tryCast(wrapper2.getValue(), RunnerAndConfigurationSettings.class)).map(settings -> RunConfigurationsSEContributor.findExecutor(settings, mode)).ifPresent(executor -> {
                this.executorInfo.append(executor.getId(), attributes);
                this.executorInfo.setIcon(executor.getToolWindowIcon());
            });
        }
    }
}

