/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.actions;

import com.intellij.find.FindManager;
import com.intellij.find.FindUtil;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.IdeDocumentHistory;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import org.jetbrains.annotations.NotNull;

public class SearchAgainAction
extends AnAction
implements DumbAware {
    public SearchAgainAction() {
        this.setEnabledInModalContext(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            SearchAgainAction.$$$reportNull$$$0(0);
        }
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        FileEditor editor = (FileEditor)e.getData(PlatformDataKeys.FILE_EDITOR);
        if (editor == null || project == null) {
            return;
        }
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(project, () -> {
            PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            IdeDocumentHistory.getInstance(project).includeCurrentCommandAsNavigation();
            FindManager findManager = FindManager.getInstance((Project)project);
            if (!findManager.selectNextOccurrenceWasPerformed() && findManager.findNextUsageInEditor(editor)) {
                return;
            }
            FindUtil.searchAgain(project, editor, e.getDataContext());
        }, IdeBundle.message((String)"command.find.next", (Object[])new Object[0]), null);
    }

    public void update(@NotNull AnActionEvent event) {
        if (event == null) {
            SearchAgainAction.$$$reportNull$$$0(1);
        }
        Presentation presentation = event.getPresentation();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            presentation.setEnabled(false);
            return;
        }
        FileEditor editor = (FileEditor)event.getData(PlatformDataKeys.FILE_EDITOR);
        presentation.setEnabled(editor instanceof TextEditor && !((TextEditor)editor).getEditor().isOneLineMode());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
        }
        objectArray2[1] = "com/intellij/ide/actions/SearchAgainAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "update";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

