/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.externalDependencies.impl;

import com.intellij.externalDependencies.DependencyOnPlugin;
import com.intellij.externalDependencies.ExternalDependenciesManager;
import com.intellij.externalDependencies.ProjectExternalDependency;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ComboboxSpeedSearch;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBUI;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalDependenciesConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private static final Logger LOG = Logger.getInstance(ExternalDependenciesConfigurable.class);
    private final ExternalDependenciesManager myDependenciesManager;
    private final CollectionListModel<ProjectExternalDependency> myListModel = new CollectionListModel((Object[])new ProjectExternalDependency[0]);
    private Map<String, String> myPluginNameById;

    public ExternalDependenciesConfigurable(Project project) {
        this.myDependenciesManager = ExternalDependenciesManager.getInstance(project);
    }

    public void reset() {
        List<ProjectExternalDependency> dependencies = this.myDependenciesManager.getAllDependencies();
        this.myListModel.replaceAll(dependencies);
    }

    public boolean isModified() {
        return !new HashSet<ProjectExternalDependency>(this.myDependenciesManager.getAllDependencies()).equals(new HashSet(this.myListModel.getItems()));
    }

    public void apply() throws ConfigurationException {
        this.myDependenciesManager.setAllDependencies(this.myListModel.getItems());
    }

    @Nls
    public String getDisplayName() {
        return "Required Plugins";
    }

    @Nullable
    public JComponent createComponent() {
        final JBList dependenciesList = new JBList();
        dependenciesList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<ProjectExternalDependency>(){

            protected void customizeCellRenderer(@NotNull JList<? extends ProjectExternalDependency> list2, ProjectExternalDependency dependency, int index, boolean selected, boolean hasFocus) {
                if (list2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (dependency instanceof DependencyOnPlugin) {
                    DependencyOnPlugin value = (DependencyOnPlugin)dependency;
                    this.append(ExternalDependenciesConfigurable.this.getPluginNameById(value.getPluginId()), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    String minVersion = value.getMinVersion();
                    String maxVersion = value.getMaxVersion();
                    if (minVersion != null || maxVersion != null) {
                        this.append(", version ");
                    }
                    if (minVersion != null && minVersion.equals(maxVersion)) {
                        this.append(minVersion, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else if (minVersion != null && maxVersion != null) {
                        this.append("between ");
                        this.append(minVersion, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                        this.append(" and ");
                        this.append(maxVersion, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else if (minVersion != null) {
                        this.append("at least ");
                        this.append(minVersion, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else if (maxVersion != null) {
                        this.append("at most ");
                        this.append(maxVersion, SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    }
                } else {
                    LOG.error("Unsupported external dependency: " + dependency.getClass());
                    this.append(dependency.toString());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/externalDependencies/impl/ExternalDependenciesConfigurable$1", "customizeCellRenderer"));
            }
        });
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                return ExternalDependenciesConfigurable.this.editSelectedDependency(dependenciesList);
            }
        }.installOn((Component)dependenciesList);
        dependenciesList.setModel(this.myListModel);
        JPanel dependenciesPanel = ToolbarDecorator.createDecorator((JList)dependenciesList).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ExternalDependenciesConfigurable.this.replaceDependency(new DependencyOnPlugin("", null, null), dependenciesList);
            }
        }).setEditAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ExternalDependenciesConfigurable.this.editSelectedDependency(dependenciesList);
            }
        }).createPanel();
        String text = XmlStringUtil.wrapInHtml((CharSequence)("Specify a list of plugins required for your project. " + ApplicationNamesInfo.getInstance().getFullProductName() + " will notify you if a required plugin is missing or needs an update. "));
        return JBUI.Panels.simplePanel((int)0, (int)4).addToCenter((Component)dependenciesPanel).addToTop((Component)new JBLabel(text));
    }

    public boolean editSelectedDependency(JBList dependenciesList) {
        DependencyOnPlugin selected = (DependencyOnPlugin)dependenciesList.getSelectedValue();
        if (selected != null) {
            this.replaceDependency(selected, dependenciesList);
            return true;
        }
        return false;
    }

    private void replaceDependency(DependencyOnPlugin original, JBList dependenciesList) {
        DependencyOnPlugin dependency = this.editPluginDependency((JComponent)dependenciesList, original);
        if (dependency != null) {
            for (ProjectExternalDependency dependency1 : new ArrayList(this.myListModel.getItems())) {
                if (!(dependency1 instanceof DependencyOnPlugin) || !((DependencyOnPlugin)dependency1).getPluginId().equals(dependency.getPluginId())) continue;
                this.myListModel.remove((Object)dependency1);
            }
            this.myListModel.add((Object)dependency);
            dependenciesList.setSelectedValue((Object)dependency, true);
        }
    }

    private String getPluginNameById(@NotNull String pluginId) {
        if (pluginId == null) {
            ExternalDependenciesConfigurable.$$$reportNull$$$0(0);
        }
        return (String)ObjectUtils.notNull((Object)this.getPluginNameByIdMap().get(pluginId), (Object)pluginId);
    }

    private Map<String, String> getPluginNameByIdMap() {
        if (this.myPluginNameById == null) {
            this.myPluginNameById = new HashMap<String, String>();
            for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
                String idString = descriptor.getPluginId().getIdString();
                String name = "com.intellij".equals(idString) ? "IDE Core" : descriptor.getName();
                this.myPluginNameById.put(idString, name);
            }
        }
        return this.myPluginNameById;
    }

    @NotNull
    public String getId() {
        if ("preferences.externalDependencies" == null) {
            ExternalDependenciesConfigurable.$$$reportNull$$$0(1);
        }
        return "preferences.externalDependencies";
    }

    @Nullable
    private DependencyOnPlugin editPluginDependency(@NotNull JComponent parent, @NotNull DependencyOnPlugin original) {
        if (parent == null) {
            ExternalDependenciesConfigurable.$$$reportNull$$$0(2);
        }
        if (original == null) {
            ExternalDependenciesConfigurable.$$$reportNull$$$0(3);
        }
        ArrayList<String> pluginIds = new ArrayList<String>(this.getPluginNameByIdMap().keySet());
        if (!original.getPluginId().isEmpty() && !pluginIds.contains(original.getPluginId())) {
            pluginIds.add(original.getPluginId());
        }
        Collections.sort(pluginIds, (o1, o2) -> this.getPluginNameById((String)o1).compareToIgnoreCase(this.getPluginNameById((String)o2)));
        final ComboBox pluginChooser = new ComboBox((Object[])ArrayUtilRt.toStringArray(pluginIds), 250);
        pluginChooser.setRenderer((ListCellRenderer)new ListCellRendererWrapper<String>(){

            public void customize(JList list2, String value, int index, boolean selected, boolean hasFocus) {
                this.setText(ExternalDependenciesConfigurable.this.getPluginNameById(value));
            }
        });
        new ComboboxSpeedSearch((JComboBox)pluginChooser){

            @Override
            protected String getElementText(Object element) {
                return ExternalDependenciesConfigurable.this.getPluginNameById((String)element);
            }
        };
        pluginChooser.setSelectedItem((Object)original.getPluginId());
        JBTextField minVersionField = new JBTextField(StringUtil.notNullize((String)original.getMinVersion()));
        JBTextField maxVersionField = new JBTextField(StringUtil.notNullize((String)original.getMaxVersion()));
        minVersionField.getEmptyText().setText("<any>");
        minVersionField.setColumns(10);
        maxVersionField.getEmptyText().setText("<any>");
        maxVersionField.setColumns(10);
        JPanel panel2 = FormBuilder.createFormBuilder().addLabeledComponent("Plugin:", (JComponent)pluginChooser).addLabeledComponent("Minimum version:", (JComponent)minVersionField).addLabeledComponent("Maximum version:", (JComponent)maxVersionField).getPanel();
        final DialogBuilder dialogBuilder = new DialogBuilder((Component)parent).title("Required Plugin").centerPanel((JComponent)panel2);
        dialogBuilder.setPreferredFocusComponent((JComponent)pluginChooser);
        pluginChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                dialogBuilder.setOkActionEnabled(!StringUtil.isEmpty((String)((String)pluginChooser.getSelectedItem())));
            }
        });
        if (dialogBuilder.show() == 0) {
            return new DependencyOnPlugin((String)pluginChooser.getSelectedItem(), StringUtil.nullize((String)minVersionField.getText().trim()), StringUtil.nullize((String)maxVersionField.getText().trim()));
        }
        return null;
    }

    @Nullable
    public String getHelpTopic() {
        return "Required_Plugin";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/externalDependencies/impl/ExternalDependenciesConfigurable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/externalDependencies/impl/ExternalDependenciesConfigurable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPluginNameById";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "editPluginDependency";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

