/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.cherrypick;

import com.google.common.collect.Lists;
import com.intellij.dvcs.cherrypick.VcsCherryPicker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.progress.BackgroundTaskQueue;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VcsCherryPickManager {
    private static final Logger LOG = Logger.getInstance(VcsCherryPickManager.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final ProjectLevelVcsManager myProjectLevelVcsManager;
    @NotNull
    private final Set<CommitId> myIdsInProgress;
    @NotNull
    private final BackgroundTaskQueue myTaskQueue;

    public VcsCherryPickManager(@NotNull Project project, @NotNull ProjectLevelVcsManager projectLevelVcsManager) {
        if (project == null) {
            VcsCherryPickManager.$$$reportNull$$$0(0);
        }
        if (projectLevelVcsManager == null) {
            VcsCherryPickManager.$$$reportNull$$$0(1);
        }
        this.myIdsInProgress = ContainerUtil.newConcurrentSet();
        this.myProject = project;
        this.myProjectLevelVcsManager = projectLevelVcsManager;
        this.myTaskQueue = new BackgroundTaskQueue(project, "Cherry-picking");
    }

    public void cherryPick(@NotNull VcsLog log2) {
        if (log2 == null) {
            VcsCherryPickManager.$$$reportNull$$$0(2);
        }
        log2.requestSelectedDetails(details -> this.myTaskQueue.run(new CherryPickingTask(ContainerUtil.reverse((List)details))));
    }

    public boolean isCherryPickAlreadyStartedFor(@NotNull List<CommitId> commits) {
        if (commits == null) {
            VcsCherryPickManager.$$$reportNull$$$0(3);
        }
        for (CommitId commit : commits) {
            if (!this.myIdsInProgress.contains(commit)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private VcsCherryPicker getCherryPickerForCommit(@NotNull VcsFullCommitDetails commitDetails) {
        AbstractVcs vcs;
        if (commitDetails == null) {
            VcsCherryPickManager.$$$reportNull$$$0(4);
        }
        if ((vcs = this.myProjectLevelVcsManager.getVcsFor(commitDetails.getRoot())) == null) {
            return null;
        }
        VcsKey key = vcs.getKeyInstanceMethod();
        return this.getCherryPickerFor(key);
    }

    @Nullable
    public VcsCherryPicker getCherryPickerFor(@NotNull VcsKey key) {
        if (key == null) {
            VcsCherryPickManager.$$$reportNull$$$0(5);
        }
        return (VcsCherryPicker)ContainerUtil.find((Object[])VcsCherryPicker.EXTENSION_POINT_NAME.getExtensions((AreaInstance)this.myProject), picker -> picker.getSupportedVcs().equals((Object)key));
    }

    public static VcsCherryPickManager getInstance(@NotNull Project project) {
        if (project == null) {
            VcsCherryPickManager.$$$reportNull$$$0(6);
        }
        return (VcsCherryPickManager)ServiceManager.getService((Project)project, VcsCherryPickManager.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectLevelVcsManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "log";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commits";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commitDetails";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dvcs/cherrypick/VcsCherryPickManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "cherryPick";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isCherryPickAlreadyStartedFor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getCherryPickerForCommit";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getCherryPickerFor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class CherryPickingTask
    extends Task.Backgroundable {
        @NotNull
        private final List<VcsFullCommitDetails> myAllDetailsInReverseOrder;
        @NotNull
        private final ChangeListManagerEx myChangeListManager;

        CherryPickingTask(List<VcsFullCommitDetails> detailsInReverseOrder) {
            if (detailsInReverseOrder == null) {
                CherryPickingTask.$$$reportNull$$$0(0);
            }
            super(VcsCherryPickManager.this.myProject, "Cherry-Picking");
            this.myAllDetailsInReverseOrder = detailsInReverseOrder;
            this.myChangeListManager = (ChangeListManagerEx)ChangeListManager.getInstance((Project)this.myProject);
            this.myChangeListManager.blockModalNotifications();
        }

        @Nullable
        private VcsCherryPicker getCherryPickerOrReportError(@NotNull VcsFullCommitDetails details) {
            if (details == null) {
                CherryPickingTask.$$$reportNull$$$0(1);
            }
            CommitId commitId = new CommitId((Hash)details.getId(), details.getRoot());
            if (VcsCherryPickManager.this.myIdsInProgress.contains(commitId)) {
                this.showError("Cherry pick process is already started for commit " + commitId.getHash().toShortString() + " from root " + commitId.getRoot().getName());
                return null;
            }
            VcsCherryPickManager.this.myIdsInProgress.add(commitId);
            VcsCherryPicker cherryPicker = VcsCherryPickManager.this.getCherryPickerForCommit(details);
            if (cherryPicker == null) {
                this.showError("Cherry pick is not supported for commit " + ((Hash)details.getId()).toShortString() + " from root " + details.getRoot().getName());
                return null;
            }
            return cherryPicker;
        }

        public void showError(@NotNull String message) {
            if (message == null) {
                CherryPickingTask.$$$reportNull$$$0(2);
            }
            VcsNotifier.getInstance(this.myProject).notifyWeakError(message);
            LOG.warn(message);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                CherryPickingTask.$$$reportNull$$$0(3);
            }
            try {
                boolean isOk = true;
                MultiMap<VcsCherryPicker, VcsFullCommitDetails> groupedCommits = this.createArrayMultiMap();
                for (VcsFullCommitDetails details : this.myAllDetailsInReverseOrder) {
                    VcsCherryPicker cherryPicker = this.getCherryPickerOrReportError(details);
                    if (cherryPicker == null) {
                        isOk = false;
                        break;
                    }
                    groupedCommits.putValue((Object)cherryPicker, (Object)details);
                }
                if (isOk) {
                    for (Map.Entry entry : groupedCommits.entrySet()) {
                        ((VcsCherryPicker)entry.getKey()).cherryPick((List)Lists.newArrayList((Iterable)((Iterable)entry.getValue())));
                    }
                }
            }
            finally {
                ApplicationManager.getApplication().invokeLater(() -> {
                    this.myChangeListManager.unblockModalNotifications();
                    for (VcsFullCommitDetails details : this.myAllDetailsInReverseOrder) {
                        VcsCherryPickManager.this.myIdsInProgress.remove(new CommitId((Hash)details.getId(), details.getRoot()));
                    }
                });
            }
        }

        @NotNull
        public MultiMap<VcsCherryPicker, VcsFullCommitDetails> createArrayMultiMap() {
            MultiMap<VcsCherryPicker, VcsFullCommitDetails> multiMap = new MultiMap<VcsCherryPicker, VcsFullCommitDetails>(){

                @NotNull
                protected Collection<VcsFullCommitDetails> createCollection() {
                    ArrayList<VcsFullCommitDetails> arrayList = new ArrayList<VcsFullCommitDetails>();
                    if (arrayList == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return arrayList;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dvcs/cherrypick/VcsCherryPickManager$CherryPickingTask$1", "createCollection"));
                }
            };
            if (multiMap == null) {
                CherryPickingTask.$$$reportNull$$$0(4);
            }
            return multiMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "detailsInReverseOrder";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "details";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "message";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/dvcs/cherrypick/VcsCherryPickManager$CherryPickingTask";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/dvcs/cherrypick/VcsCherryPickManager$CherryPickingTask";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createArrayMultiMap";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getCherryPickerOrReportError";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "showError";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "run";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

