/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.ClassExpressionType;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitor;
import org.semanticweb.owlapi.model.OWLClassExpressionVisitorEx;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import uk.ac.manchester.cs.owl.owlapi.OWLAnonymousClassExpressionImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectUnionOfImpl;

public class OWLObjectOneOfImpl
extends OWLAnonymousClassExpressionImpl
implements OWLObjectOneOf {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final Set<OWLIndividual> values;

    @Override
    protected int index() {
        return 3004;
    }

    public OWLObjectOneOfImpl(@Nonnull Set<? extends OWLIndividual> values) {
        this.values = new HashSet<OWLIndividual>((Collection)OWLAPIPreconditions.checkNotNull(values, "values cannot be null"));
    }

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        for (OWLIndividual individual : this.values) {
            if (!individual.isNamed()) continue;
            entities.add(individual.asOWLNamedIndividual());
        }
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
        for (OWLIndividual individual : this.values) {
            if (!individual.isAnonymous()) continue;
            anons.add(individual.asOWLAnonymousIndividual());
        }
    }

    @Override
    public ClassExpressionType getClassExpressionType() {
        return ClassExpressionType.OBJECT_ONE_OF;
    }

    @Override
    public Set<OWLIndividual> getIndividuals() {
        return CollectionFactory.getCopyOnRequestSetFromImmutableCollection(this.values);
    }

    @Override
    public boolean isClassExpressionLiteral() {
        return false;
    }

    @Override
    public OWLClassExpression asObjectUnionOf() {
        if (this.values.size() == 1) {
            return this;
        }
        HashSet<OWLObjectOneOfImpl> ops = new HashSet<OWLObjectOneOfImpl>();
        for (OWLIndividual ind : this.values) {
            assert (ind != null);
            ops.add(new OWLObjectOneOfImpl(CollectionFactory.createSet(ind)));
        }
        return new OWLObjectUnionOfImpl(ops);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof OWLObjectOneOf)) {
            return false;
        }
        return ((OWLObjectOneOf)obj).getIndividuals().equals(this.values);
    }

    @Override
    public void accept(OWLClassExpressionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLClassExpressionVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(OWLObject object) {
        return OWLObjectOneOfImpl.compareSets(this.values, ((OWLObjectOneOf)object).getIndividuals());
    }
}

