/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.manchester.cs.owl.owlapi;

import com.google.common.base.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitor;
import org.semanticweb.owlapi.model.OWLAnnotationValueVisitorEx;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLDataVisitor;
import org.semanticweb.owlapi.model.OWLDataVisitorEx;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import uk.ac.manchester.cs.owl.owlapi.OWL2DatatypeImpl;
import uk.ac.manchester.cs.owl.owlapi.OWLObjectImplWithoutEntityAndAnonCaching;

public class OWLLiteralImplNoCompression
extends OWLObjectImplWithoutEntityAndAnonCaching
implements OWLLiteral {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private static final OWLDatatype RDF_PLAIN_LITERAL = new OWL2DatatypeImpl(OWL2Datatype.RDF_PLAIN_LITERAL);
    @Nonnull
    private final String literal;
    @Nonnull
    private final OWLDatatype datatype;
    @Nonnull
    private final String language;

    @Override
    public void addSignatureEntitiesToSet(Set<OWLEntity> entities) {
        entities.add(this.datatype);
    }

    @Override
    public void addAnonymousIndividualsToSet(Set<OWLAnonymousIndividual> anons) {
    }

    @Override
    protected int index() {
        return 4008;
    }

    public OWLLiteralImplNoCompression(@Nonnull String literal, @Nullable String lang, @Nullable OWLDatatype datatype) {
        this.literal = literal;
        if (lang == null || lang.isEmpty()) {
            this.language = "";
            this.datatype = datatype == null ? RDF_PLAIN_LITERAL : datatype;
        } else {
            if (datatype != null && !datatype.isRDFPlainLiteral()) {
                throw new OWLRuntimeException("Error: cannot build a literal with type: " + datatype.getIRI() + " and language: " + lang);
            }
            this.language = lang;
            this.datatype = RDF_PLAIN_LITERAL;
        }
        this.hashCode = this.getHashCode();
    }

    @Override
    @Nonnull
    public String getLiteral() {
        return this.literal;
    }

    @Override
    public boolean isRDFPlainLiteral() {
        return this.datatype.getIRI().equals(OWL2Datatype.RDF_PLAIN_LITERAL.getIRI());
    }

    @Override
    public boolean hasLang() {
        return !this.language.isEmpty();
    }

    @Override
    public boolean isInteger() {
        return this.datatype.getIRI().equals(OWL2Datatype.XSD_INTEGER.getIRI());
    }

    @Override
    public int parseInteger() {
        return Integer.parseInt(this.getLiteral());
    }

    @Override
    public boolean isBoolean() {
        return this.datatype.getIRI().equals(OWL2Datatype.XSD_BOOLEAN.getIRI());
    }

    @Override
    public boolean parseBoolean() {
        if (this.literal.equals("0")) {
            return false;
        }
        if (this.literal.equals("1")) {
            return true;
        }
        if (this.literal.equals("true")) {
            return true;
        }
        if (this.literal.equals("false")) {
            return false;
        }
        return Boolean.parseBoolean(this.literal);
    }

    @Override
    public boolean isDouble() {
        return this.datatype.getIRI().equals(OWL2Datatype.XSD_DOUBLE.getIRI());
    }

    @Override
    public double parseDouble() {
        return Double.parseDouble(this.literal);
    }

    @Override
    public boolean isFloat() {
        return this.datatype.getIRI().equals(OWL2Datatype.XSD_FLOAT.getIRI());
    }

    @Override
    public float parseFloat() {
        if ("inf".equalsIgnoreCase(this.literal)) {
            return Float.POSITIVE_INFINITY;
        }
        if ("-inf".equalsIgnoreCase(this.literal)) {
            return Float.NEGATIVE_INFINITY;
        }
        return Float.parseFloat(this.literal);
    }

    @Override
    @Nonnull
    public String getLang() {
        return this.language;
    }

    @Override
    public boolean hasLang(@Nullable String lang) {
        if (lang == null) {
            return this.language.isEmpty();
        }
        return this.language.equalsIgnoreCase(lang.trim());
    }

    @Override
    @Nonnull
    public OWLDatatype getDatatype() {
        return this.datatype;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    private final int getHashCode() {
        int code = 277;
        code = code * 37 + this.getDatatype().hashCode();
        code *= 37;
        try {
            code = this.isInteger() ? (code += this.parseInteger() * 65536) : (this.isDouble() ? (code += (int)this.parseDouble() * 65536) : (this.isFloat() ? (code += (int)this.parseFloat() * 65536) : (this.isBoolean() ? (code += this.parseBoolean() ? 65536 : 0) : (code += this.getLiteral().hashCode() * 65536))));
        }
        catch (NumberFormatException e) {
            code += this.getLiteral().hashCode() * 65536;
        }
        if (this.hasLang()) {
            code = code * 37 + this.getLang().hashCode();
        }
        return code;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof OWLLiteral)) {
            return false;
        }
        OWLLiteral other = (OWLLiteral)obj;
        if (other instanceof OWLLiteralImplNoCompression) {
            return this.literal.equals(((OWLLiteralImplNoCompression)other).literal) && this.datatype.equals(other.getDatatype()) && this.language.equals(other.getLang());
        }
        return this.literal.equals(other.getLiteral()) && this.datatype.equals(other.getDatatype()) && this.language.equals(other.getLang());
    }

    @Override
    public void accept(@Nonnull OWLDataVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    @Nonnull
    public <O> O accept(@Nonnull OWLDataVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public void accept(@Nonnull OWLAnnotationValueVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    @Nonnull
    public <O> O accept(@Nonnull OWLAnnotationValueVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    protected int compareObjectOfSameType(@Nonnull OWLObject object) {
        OWLLiteral other = (OWLLiteral)object;
        int diff = this.literal.compareTo(other.getLiteral());
        if (diff != 0) {
            return diff;
        }
        diff = this.datatype.compareTo(other.getDatatype());
        if (diff != 0) {
            return diff;
        }
        return this.language.compareTo(other.getLang());
    }

    @Override
    public void accept(@Nonnull OWLObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    @Nonnull
    public <O> O accept(@Nonnull OWLObjectVisitorEx<O> visitor) {
        return visitor.visit(this);
    }

    @Override
    public Optional<IRI> asIRI() {
        return Optional.absent();
    }

    @Override
    public Optional<OWLAnonymousIndividual> asAnonymousIndividual() {
        return Optional.absent();
    }

    @Override
    public Optional<OWLLiteral> asLiteral() {
        return Optional.of((Object)this);
    }
}

