# MicroBenchmark
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L9)</span>

Synchronous benchmarks must provide this trait. The `apply` method defines a
single iteration in a sample. Setup and Teardown are defined by the `before`
and `after` methods respectively. The `before` method runs before a sample
of benchmarks and `after` runs after the all iterations in the sample have
completed. If your benchmark requires setup and/or teardown to occur beween
each iteration of the benchmark, then you can use `before_iteration` and
`after_iteration` methods respectively that run before/after each iteration.


```pony
trait iso MicroBenchmark
```

## Public Functions

### name
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L19)</span>


```pony
fun box name()
: String val
```

#### Returns

* [String](builtin-String.md) val

---

### config
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L20)</span>


```pony
fun box config()
: BenchConfig val
```

#### Returns

* [BenchConfig](ponybench-BenchConfig.md) val

---

### overhead
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L21)</span>


```pony
fun box overhead()
: MicroBenchmark iso^
```

#### Returns

* [MicroBenchmark](ponybench-MicroBenchmark.md) iso^

---

### before
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L22)</span>


```pony
fun ref before()
: None val ?
```

#### Returns

* [None](builtin-None.md) val ?

---

### before_iteration
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L23)</span>


```pony
fun ref before_iteration()
: None val ?
```

#### Returns

* [None](builtin-None.md) val ?

---

### apply
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L24)</span>


```pony
fun ref apply()
: None val ?
```

#### Returns

* [None](builtin-None.md) val ?

---

### after
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L25)</span>


```pony
fun ref after()
: None val ?
```

#### Returns

* [None](builtin-None.md) val ?

---

### after_iteration
<span class="source-link">[[Source]](src/ponybench/benchmark.md#L26)</span>


```pony
fun ref after_iteration()
: None val ?
```

#### Returns

* [None](builtin-None.md) val ?

---

