/*
 * Decompiled with CFR 0.152.
 */
package org.sejda.sambox.filter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import org.sejda.sambox.cos.COSArray;
import org.sejda.sambox.cos.COSBase;
import org.sejda.sambox.cos.COSDictionary;
import org.sejda.sambox.cos.COSName;
import org.sejda.sambox.filter.DecodeResult;
import org.sejda.sambox.filter.MissingImageReaderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Filter {
    private static final Logger LOG = LoggerFactory.getLogger(Filter.class);
    public static final String SYSPROP_DEFLATELEVEL = "org.sejda.sambox.filter.deflatelevel";

    protected Filter() {
    }

    public abstract DecodeResult decode(InputStream var1, OutputStream var2, COSDictionary var3, int var4) throws IOException;

    public abstract void encode(InputStream var1, OutputStream var2, COSDictionary var3) throws IOException;

    protected COSDictionary getDecodeParams(COSDictionary dictionary, int index) {
        COSArray array;
        COSBase filter = dictionary.getDictionaryObject(COSName.FILTER, COSName.F);
        COSBase dp = Optional.ofNullable(dictionary.getDictionaryObject(COSName.DECODE_PARMS, COSName.DP)).orElseGet(COSDictionary::new);
        if (filter instanceof COSName && dp instanceof COSDictionary) {
            return (COSDictionary)dp;
        }
        if (filter instanceof COSArray && dp instanceof COSArray && index < (array = (COSArray)dp).size()) {
            COSBase params = Optional.ofNullable(array.getObject(index)).orElseGet(COSDictionary::new);
            if (params instanceof COSDictionary) {
                return (COSDictionary)params;
            }
            LOG.error("Ignoring invalid DecodeParams. Expected dictionary but found {}", (Object)params.getClass().getName());
            return new COSDictionary();
        }
        if (!(filter instanceof COSArray) && !(dp instanceof COSArray)) {
            LOG.error("Ignoring invalid DecodeParams. Expected array or dictionary but found {}", (Object)dp.getClass().getName());
        }
        return new COSDictionary();
    }

    protected static ImageReader findImageReader(String formatName, String errorCause) throws MissingImageReaderException {
        Iterator<ImageReader> readers = ImageIO.getImageReadersByFormatName(formatName);
        ImageReader reader = null;
        while (!(!readers.hasNext() || Objects.nonNull(reader = readers.next()) && reader.canReadRaster())) {
        }
        if (reader == null) {
            throw new MissingImageReaderException("Cannot read " + formatName + " image: " + errorCause);
        }
        return reader;
    }

    public static int getCompressionLevel() {
        int compressionLevel = -1;
        try {
            compressionLevel = Integer.parseInt(System.getProperty(SYSPROP_DEFLATELEVEL, "-1"));
        }
        catch (NumberFormatException ex) {
            LOG.warn(ex.getMessage(), (Throwable)ex);
        }
        return Math.max(-1, Math.min(9, compressionLevel));
    }
}

