# Contributing to RSpec::Wait

RSpec::Wait is open source and contributions from the community are encouraged!
No contribution is too small.

Please consider:

* Adding a feature
* Squashing a bug
* Writing documentation
* Fixing a typo
* Correcting [style](https://github.com/styleguide/ruby)

## How do I contribute?

For the best chance of having your changes merged, please:

1. [Fork](https://github.com/laserlemon/rspec-wait/fork) the project.
2. [Write](http://en.wikipedia.org/wiki/Test-driven_development) a failing test.
3. [Commit](http://tbaggery.com/2008/04/19/a-note-about-git-commit-messages.html) changes that fix the tests.
4. [Submit](https://github.com/laserlemon/rspec-wait/pulls) a pull request with *at least* one animated GIF.
5. Be patient.

If your proposed changes only affect documentation, include the following on a
new line in each of your commit messages:

```
[ci skip]
```

This will signal [Travis](https://travis-ci.org) that running the test suite is
not necessary for these changes.

## Bug Reports

If you are experiencing unexpected behavior and, after having read RSpec::Wait's
documentation, are convinced this behavior is a bug, please:

1. [Search](https://github.com/laserlemon/rspec-wait/issues) existing issues.
2. Collect enough information to reproduce the issue:
  * RSpec::Wait version
  * Ruby version
  * RSpec version
  * Specific setup conditions
  * Description of expected behavior
  * Description of actual behavior
3. [Submit](https://github.com/laserlemon/rspec-wait/issues/new) an issue.
4. Be patient.
