/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.ui.paint.PaintUtil;
import com.intellij.util.HiDPIScaledGraphics;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.JBUI;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import org.imgscalr.Scalr;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBHiDPIScaledImage
extends BufferedImage {
    @Nullable
    private final Image myImage;
    private final double myUserWidth;
    private final double myUserHeight;
    private final double myScale;

    public JBHiDPIScaledImage(int width, int height, int type2) {
        this((double)width, (double)height, type2);
    }

    public JBHiDPIScaledImage(double width, double height, int type2) {
        this((GraphicsConfiguration)null, width, height, type2);
    }

    public JBHiDPIScaledImage(@Nullable GraphicsConfiguration gc, double width, double height, int type2) {
        this(gc, width, height, type2, PaintUtil.RoundingMode.FLOOR);
    }

    /*
     * WARNING - void declaration
     */
    public JBHiDPIScaledImage(@Nullable GraphicsConfiguration gc, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void rm;
        void type2;
        if (roundingMode == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(2);
        }
        this(JBUI.sysScale(gc), width, height, (int)type2, (PaintUtil.RoundingMode)rm);
    }

    /*
     * WARNING - void declaration
     */
    private JBHiDPIScaledImage(double scale, double width, double height, int n, @NotNull PaintUtil.RoundingMode roundingMode) {
        void type2;
        void rm;
        if (roundingMode == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(3);
        }
        super(rm.round(width * scale), rm.round(height * scale), (int)type2);
        this.myImage = null;
        this.myUserWidth = width;
        this.myUserHeight = height;
        this.myScale = scale;
    }

    /*
     * WARNING - void declaration
     */
    public JBHiDPIScaledImage(@NotNull Image image, double width, double height, int n) {
        void type2;
        if (image == null) {
            JBHiDPIScaledImage.$$$reportNull$$$0(5);
        }
        super(1, 1, (int)type2);
        this.myImage = image;
        this.myUserWidth = width;
        this.myUserHeight = height;
        this.myScale = this.myUserWidth > 0.0 ? (double)this.myImage.getWidth(null) / this.myUserWidth : 1.0;
    }

    public double getScale() {
        return this.myScale;
    }

    public JBHiDPIScaledImage scale(double scaleFactor) {
        Image img = this.myImage == null ? this : this.myImage;
        int w = (int)(scaleFactor * (double)this.getRealWidth(null));
        int h = (int)(scaleFactor * (double)this.getRealHeight(null));
        if (w <= 0 || h <= 0) {
            return this;
        }
        BufferedImage scaled = Scalr.resize((BufferedImage)ImageUtil.toBufferedImage(img), (Scalr.Method)Scalr.Method.QUALITY, (int)w, (int)h, (BufferedImageOp[])new BufferedImageOp[0]);
        double newUserWidth = (double)w / this.myScale;
        double newUserHeight = (double)h / this.myScale;
        if (this.myImage != null) {
            return new JBHiDPIScaledImage(scaled, newUserWidth, newUserHeight, this.getType());
        }
        JBHiDPIScaledImage newImg = new JBHiDPIScaledImage(this.myScale, newUserWidth, newUserHeight, this.getType(), PaintUtil.RoundingMode.ROUND);
        Graphics2D g = newImg.createGraphics();
        g.drawImage(scaled, 0, 0, (int)Math.round(newUserWidth), (int)Math.round(newUserHeight), 0, 0, ((Image)scaled).getWidth(null), ((Image)scaled).getHeight(null), null);
        g.dispose();
        return newImg;
    }

    public Image getDelegate() {
        return this.myImage;
    }

    @Override
    public int getWidth() {
        return this.getWidth(null);
    }

    @Override
    public int getHeight() {
        return this.getHeight(null);
    }

    @Override
    public int getWidth(ImageObserver observer) {
        return this.myImage != null ? this.getUserWidth(observer) : this.getRealWidth(observer);
    }

    @Override
    public int getHeight(ImageObserver observer) {
        return this.myImage != null ? this.getUserHeight(observer) : this.getRealHeight(observer);
    }

    public int getUserWidth(ImageObserver observer) {
        return this.myImage != null ? (int)Math.round(this.myUserWidth) : (int)Math.round((double)super.getWidth(observer) / this.myScale);
    }

    public int getUserHeight(ImageObserver observer) {
        return this.myImage != null ? (int)Math.round(this.myUserHeight) : (int)Math.round((double)super.getHeight(observer) / this.myScale);
    }

    public int getRealWidth(ImageObserver observer) {
        return this.myImage != null ? this.myImage.getWidth(observer) : super.getWidth(observer);
    }

    public int getRealHeight(ImageObserver observer) {
        return this.myImage != null ? this.myImage.getHeight(observer) : super.getHeight(observer);
    }

    @Override
    public Graphics2D createGraphics() {
        Graphics2D g = super.createGraphics();
        if (this.myImage == null) {
            g.scale(this.myScale, this.myScale);
            return new HiDPIScaledGraphics(g);
        }
        return g;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "rm";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[0] = "image";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/JBHiDPIScaledImage";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

