/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.minimize.forcefield;

import javajs.util.Lst;
import org.jmol.minimize.MinTorsion;
import org.jmol.minimize.forcefield.Calculation;

class MMFFTorsionCalc
extends Calculation {
    MMFFTorsionCalc() {
    }

    void setData(Lst<Object[]> calc, MinTorsion t) {
        if (this.calcs.isLinear(t.data[1]) || this.calcs.isLinear(t.data[2])) {
            return;
        }
        Object data = this.calcs.getParameterObj(t);
        if (data == null) {
            return;
        }
        calc.addLast(new Object[]{t.data, data, t.key});
    }

    @Override
    double compute(Object[] dataIn) {
        this.key = (Integer)dataIn[2];
        this.getPointers(dataIn);
        double v1 = this.dData[0];
        double v2 = this.dData[1];
        double v3 = this.dData[2];
        this.calcs.setTorsionVariables(this);
        double cosTheta = Math.cos(this.theta);
        double cosTheta2 = cosTheta * cosTheta;
        this.energy = 0.5 * (v1 * (1.0 + cosTheta) + v2 * (2.0 - 2.0 * cosTheta2) + v3 * (1.0 + cosTheta * (4.0 * cosTheta2 - 3.0)));
        if (this.calcs.gradients) {
            double sinTheta = Math.sin(this.theta);
            this.dE = 0.5 * (-v1 * sinTheta + 4.0 * v2 * sinTheta * cosTheta + 3.0 * v3 * sinTheta * (1.0 - 4.0 * cosTheta2));
            this.calcs.addForces(this, 4);
        }
        if (this.calcs.logging) {
            this.calcs.appendLogData(this.calcs.getDebugLine(3, this));
        }
        return this.energy;
    }
}

