/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.SB;
import javajs.util.T3;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAromatic;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesMeasure;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesRing;
import org.jmol.smiles.SmilesStereo;
import org.jmol.smiles.VTemp;
import org.jmol.util.BSUtil;
import org.jmol.util.Edge;
import org.jmol.util.JmolMolecule;
import org.jmol.util.Logger;
import org.jmol.util.Node;
import org.jmol.util.SimpleNode;

public class SmilesSearch
extends JmolMolecule {
    boolean isSmarts;
    SmilesSearch top;
    String pattern;
    SmilesAtom[] patternAtoms = new SmilesAtom[16];
    Node[] targetAtoms;
    int targetAtomCount;
    private BS bsSelected;
    VTemp v;
    boolean aromaticOpen;
    boolean aromaticStrict;
    boolean aromaticPlanar;
    boolean aromaticDouble;
    boolean noAromatic;
    boolean ignoreAtomClass;
    boolean ignoreStereochemistry;
    boolean invertStereochemistry;
    boolean exitFirstMatch;
    boolean groupByModel;
    boolean setAtropicity;
    boolean patternAromatic;
    boolean haveTopo;
    boolean isTopology;
    boolean patternBioSequence;
    SmilesSearch[] subSearches;
    boolean haveSelected;
    boolean haveBondStereochemistry;
    SmilesStereo stereo;
    boolean needRingData;
    boolean needAromatic = true;
    boolean needRingMemberships;
    int nDouble;
    int ringDataMax = Integer.MIN_VALUE;
    Lst<BS> ringSets;
    int ringCount;
    Lst<SmilesMeasure> measures = new Lst();
    int flags;
    BS bsAromatic = new BS();
    BS bsAromatic5 = new BS();
    BS bsAromatic6 = new BS();
    String atropKeys;
    SmilesAtom lastChainAtom;
    boolean asVector;
    boolean getMaps;
    boolean isNormalized;
    boolean haveComponents;
    private boolean isSilent;
    private boolean isRingCheck;
    private int selectedAtomCount;
    private BS[] ringData;
    private int[] ringCounts;
    private int[] ringConnections;
    private BS bsFound = new BS();
    private Map<String, Object> htNested;
    private int nNested;
    private SmilesBond nestedBond;
    private Lst<Object> vReturn;
    private Lst<BS> uniqueList;
    private BS bsReturn = new BS();
    private BS bsCheck;
    public boolean mapUnique;
    private BS bsAromaticRings;
    private static final int SUBMODE_NESTED = 1;
    private static final int SUBMODE_RINGCHECK = 2;
    private static final int SUBMODE_OR = 3;

    public SmilesSearch() {
        this.top = this;
        this.v = new VTemp();
    }

    void setTop(SmilesSearch smilesSearch) {
        while (smilesSearch.top != smilesSearch) {
            smilesSearch = smilesSearch.top;
        }
        this.top = smilesSearch;
    }

    static final int addFlags(int n, String string) {
        if (string.indexOf("OPEN") >= 0) {
            n |= 5;
        }
        if (string.indexOf("BIO") >= 0) {
            n |= 0x100000;
        }
        if (string.indexOf("HYDROGEN") >= 0) {
            n |= 0x1000;
        }
        if (string.indexOf("FIRSTMATCHONLY") >= 0) {
            n |= 8;
        }
        if (string.indexOf("STRICT") >= 0) {
            n |= 0x100;
        }
        if (string.indexOf("PLANAR") >= 0) {
            n |= 0x400;
        }
        if (string.indexOf("NOAROMATIC") >= 0 || string.indexOf("NONAROMATIC") >= 0) {
            n |= 0x10;
        }
        if (string.indexOf("AROMATICDOUBLE") >= 0) {
            n |= 0x200;
        }
        if (string.indexOf("AROMATICDEFINED") >= 0) {
            n |= 0x80;
        }
        if (string.indexOf("MMFF94") >= 0) {
            n |= 0x300;
        }
        if (string.indexOf("TOPOLOGY") >= 0) {
            n |= 0x2000;
        }
        if (string.indexOf("NOATOMCLASS") >= 0) {
            n |= 0x800;
        }
        if (string.indexOf("NOSTEREO") >= 0) {
            n |= 0x20;
        } else if (string.indexOf("INVERTSTEREO") >= 0) {
            n = (n & 0x40) != 0 ? (n &= 0xFFFFFFBF) : (n |= 0x40);
        }
        if (string.indexOf("ATOMCOMMENT") >= 0) {
            n |= 0x20000;
        }
        if (string.indexOf("GROUPBYMODEL") >= 0) {
            n |= 0x4000000;
        }
        if ((n & 0x100000) == 0x100000) {
            if (string.indexOf("NOCOMMENT") >= 0) {
                n |= 0x2100000;
            }
            if (string.indexOf("UNMATCHED") >= 0) {
                n |= 0x300000;
            }
            if (string.indexOf("COVALENT") >= 0) {
                n |= 0x500000;
            }
            if (string.indexOf("HBOND") >= 0) {
                n |= 0x900000;
            }
        }
        return n;
    }

    void setFlags(int n) {
        this.flags = n;
        this.exitFirstMatch |= (n & 8) == 8;
        this.aromaticOpen = (n & 5) == 5;
        this.aromaticDouble = (n & 0x200) == 512;
        this.aromaticStrict = (n & 0x100) == 256;
        this.aromaticPlanar = (n & 0x400) == 1024;
        this.groupByModel = (n & 0x4000000) == 0x4000000;
        this.noAromatic = (n & 0x10) == 16;
        this.ignoreAtomClass = (n & 0x800) == 2048;
        this.ignoreStereochemistry = (n & 0x20) == 32;
        this.invertStereochemistry = !this.ignoreStereochemistry && (n & 0x40) == 64;
    }

    void set() throws InvalidSmilesException {
        SmilesAtom smilesAtom;
        if (this.patternAtoms.length > this.ac) {
            this.patternAtoms = (SmilesAtom[])AU.arrayCopyObject(this.patternAtoms, this.ac);
        }
        this.nodes = this.patternAtoms;
        this.isTopology = true;
        this.patternAromatic = false;
        this.patternBioSequence = true;
        int n = this.ac;
        while (--n >= 0) {
            smilesAtom = this.patternAtoms[n];
            if (this.isTopology && smilesAtom.isDefined()) {
                this.isTopology = false;
            }
            if (!smilesAtom.isBioResidue) {
                this.patternBioSequence = false;
            }
            if (smilesAtom.isAromatic) {
                this.patternAromatic = true;
            }
            smilesAtom.setBondArray();
            if (this.isSmarts || smilesAtom.bioType != '\u0000' || smilesAtom.setHydrogenCount()) continue;
            throw new InvalidSmilesException("unbracketed atoms must be one of: B, C, N, O, P, S, F, Cl, Br, I, *,");
        }
        if (this.haveComponents) {
            n = this.ac;
            while (--n >= 0) {
                smilesAtom = this.patternAtoms[n];
                SmilesBond[] smilesBondArray = smilesAtom.bonds;
                int n2 = smilesAtom.component;
                int n3 = smilesAtom.bondCount;
                while (--n3 >= 0) {
                    int n4;
                    SmilesBond smilesBond = smilesBondArray[n3];
                    if (!smilesBond.isConnection || smilesBond.atom2 != smilesAtom || (n4 = smilesBond.atom1.component) == n2) continue;
                    int n5 = this.ac;
                    while (--n5 >= 0) {
                        if (this.patternAtoms[n5].component != n2) continue;
                        this.patternAtoms[n5].component = n4;
                    }
                }
            }
        }
    }

    void setSelected(BS bS) {
        if (bS == null) {
            bS = BS.newN(this.targetAtomCount);
            bS.setBits(0, this.targetAtomCount);
        }
        this.bsSelected = bS;
    }

    SmilesAtom addAtom() {
        return this.appendAtom(new SmilesAtom());
    }

    SmilesAtom appendAtom(SmilesAtom smilesAtom) {
        if (this.ac >= this.patternAtoms.length) {
            this.patternAtoms = (SmilesAtom[])AU.doubleLength(this.patternAtoms);
        }
        this.patternAtoms[this.ac] = smilesAtom.setIndex(this.ac++);
        return this.patternAtoms[this.ac];
    }

    int addNested(String string) {
        if (this.htNested == null) {
            this.htNested = new Hashtable<String, Object>();
        }
        this.setNested(++this.nNested, string);
        return this.nNested;
    }

    void clear() {
        this.bsReturn.clearAll();
        this.nNested = 0;
        this.htNested = null;
        this.nestedBond = null;
        this.clearBsFound(-1);
    }

    private void clearBsFound(int n) {
        if (n < 0) {
            if (this.bsCheck == null) {
                this.bsFound.clearAll();
            }
        } else {
            this.bsFound.clear(n);
        }
    }

    void setNested(int n, Object object) {
        this.top.htNested.put("_" + n, object);
    }

    Object getNested(int n) {
        return this.top.htNested.get("_" + n);
    }

    int getMissingHydrogenCount() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.ac) {
            int n3 = this.patternAtoms[n2].explicitHydrogenCount;
            if (n3 >= 0) {
                n += n3;
            }
            ++n2;
        }
        return n;
    }

    void setRingData(BS bS, Lst<BS>[] lstArray, boolean bl) throws InvalidSmilesException {
        if (this.isTopology || this.patternBioSequence) {
            this.needAromatic = false;
        }
        if (this.needAromatic) {
            this.needRingData = true;
        }
        boolean bl2 = (this.flags & 0x10) == 16;
        this.needAromatic &= bS == null & !bl2;
        if (!this.needAromatic) {
            this.bsAromatic.clearAll();
            if (bS != null) {
                this.bsAromatic.or(bS);
            }
            if (!this.needRingMemberships && !this.needRingData) {
                return;
            }
        }
        this.getRingData(lstArray, this.needRingData, bl);
    }

    void getRingData(Lst<BS>[] lstArray, boolean bl, boolean bl2) throws InvalidSmilesException {
        Object object;
        Object object2;
        int n;
        boolean bl3;
        int[] nArray;
        boolean bl4;
        boolean bl5 = this.aromaticStrict || !this.aromaticOpen && !this.aromaticPlanar;
        boolean bl6 = bl4 = this.aromaticOpen && !this.aromaticStrict;
        int n2 = !bl5 ? 0 : ((this.flags & 0x300) == 768 ? 2 : 1);
        boolean bl7 = n2 == 0;
        boolean bl8 = (this.flags & 0x80) == 128;
        boolean bl9 = this.needAromatic && bl2 && (bl5 || bl4);
        int n3 = 7;
        Lst<BS> lst = lstArray == null ? new Lst<BS>() : new Lst();
        Lst<SmilesRing> lst2 = bl9 ? new Lst<SmilesRing>() : null;
        int[] nArray2 = nArray = bl9 ? new int[this.targetAtomCount] : null;
        if (bl8 && this.needAromatic) {
            SmilesAromatic.checkAromaticDefined(this.targetAtoms, this.bsSelected, this.bsAromatic);
            n2 = 0;
        }
        boolean bl10 = bl3 = (n = this.targetAtomCount) == 0 || this.targetAtoms[0] instanceof SmilesAtom;
        if (this.ringDataMax < 0) {
            this.ringDataMax = 8;
        }
        if (n2 > 0 && this.ringDataMax < 6) {
            this.ringDataMax = 6;
        }
        if (bl) {
            this.ringCounts = new int[n];
            this.ringConnections = new int[this.targetAtomCount];
            this.ringData = new BS[this.ringDataMax + 1];
        }
        this.ringSets = new Lst();
        String string = "****";
        int n4 = this.ringDataMax;
        while (string.length() < n4) {
            string = String.valueOf(string) + string;
        }
        int n5 = 3;
        while (n5 <= n4) {
            if (n5 <= n) {
                object2 = "*1" + string.substring(0, n5 - 2) + "*1";
                object = SmilesParser.newSearch((String)object2, true, true);
                Lst lst3 = (Lst)this.subsearch((SmilesSearch)object, 2);
                if (lstArray != null && n5 <= 5) {
                    Lst<BS> lst4 = new Lst<BS>();
                    int n6 = lst3.size();
                    while (--n6 >= 0) {
                        lst4.addLast((BS)lst3.get(n6));
                    }
                    lstArray[n5 - 3] = lst4;
                }
                if (lst3.size() != 0) {
                    if (this.needAromatic && !bl8 && n5 >= 4 && n5 <= n3) {
                        SmilesAromatic.setAromatic(n5, this.targetAtoms, this.bsSelected, lst3, this.bsAromatic, n2, bl4, bl3, bl7, this.v, lst, lst2, nArray, bl2);
                    }
                    if (bl) {
                        this.ringData[n5] = new BS();
                        int n7 = lst3.size();
                        while (--n7 >= 0) {
                            BS bS = (BS)lst3.get(n7);
                            this.ringData[n5].or(bS);
                            int n8 = bS.nextSetBit(0);
                            while (n8 >= 0) {
                                int n9 = n8;
                                this.ringCounts[n9] = this.ringCounts[n9] + 1;
                                n8 = bS.nextSetBit(n8 + 1);
                            }
                        }
                    }
                }
            }
            ++n5;
        }
        if (this.needAromatic) {
            if (bl9) {
                SmilesAromatic.finalizeAromatic(this.targetAtoms, this.bsAromatic, lst, lst2, nArray, bl4, bl5);
            }
            this.bsAromatic5.clearAll();
            this.bsAromatic6.clearAll();
            n5 = lst.size();
            while (--n5 >= 0) {
                object2 = (BS)lst.get(n5);
                ((BS)object2).and(this.bsAromatic);
                switch (((BS)object2).cardinality()) {
                    case 5: {
                        this.bsAromatic5.or((BS)object2);
                        break;
                    }
                    case 6: {
                        this.bsAromatic6.or((BS)object2);
                    }
                }
            }
        }
        if (bl) {
            n5 = this.bsSelected.nextSetBit(0);
            while (n5 >= 0) {
                object2 = this.targetAtoms[n5];
                object = object2.getEdges();
                if (object != null) {
                    int n10 = ((Edge[])object).length;
                    while (--n10 >= 0) {
                        if (this.ringCounts[object2.getBondedAtomIndex(n10)] <= 0) continue;
                        int n11 = n5;
                        this.ringConnections[n11] = this.ringConnections[n11] + 1;
                    }
                }
                n5 = this.bsSelected.nextSetBit(n5 + 1);
            }
        }
    }

    Object subsearch(SmilesSearch smilesSearch, int n) throws InvalidSmilesException {
        smilesSearch.ringSets = this.ringSets;
        smilesSearch.mapUnique = this.mapUnique;
        smilesSearch.targetAtoms = this.targetAtoms;
        smilesSearch.targetAtomCount = this.targetAtomCount;
        smilesSearch.bsSelected = this.bsSelected;
        smilesSearch.htNested = this.htNested;
        smilesSearch.haveTopo = this.haveTopo;
        smilesSearch.bsCheck = this.bsCheck;
        smilesSearch.isSmarts = true;
        smilesSearch.bsAromatic = this.bsAromatic;
        smilesSearch.bsAromatic5 = this.bsAromatic5;
        smilesSearch.bsAromatic6 = this.bsAromatic6;
        smilesSearch.ringData = this.ringData;
        smilesSearch.ringCounts = this.ringCounts;
        smilesSearch.ringConnections = this.ringConnections;
        switch (n) {
            case 1: {
                smilesSearch.exitFirstMatch = false;
                break;
            }
            case 2: {
                smilesSearch.isRingCheck = true;
                smilesSearch.isSilent = true;
                smilesSearch.asVector = true;
                break;
            }
            case 3: {
                smilesSearch.ignoreAtomClass = this.ignoreAtomClass;
                smilesSearch.aromaticDouble = this.aromaticDouble;
                smilesSearch.haveSelected = this.haveSelected;
                smilesSearch.exitFirstMatch = this.exitFirstMatch;
                smilesSearch.getMaps = this.getMaps;
                smilesSearch.asVector = this.asVector;
                smilesSearch.vReturn = this.vReturn;
                smilesSearch.bsReturn = this.bsReturn;
                smilesSearch.haveBondStereochemistry = this.haveBondStereochemistry;
            }
        }
        return smilesSearch.search2(n == 1);
    }

    Object search() throws InvalidSmilesException {
        return this.search2(false);
    }

    private Object search2(boolean bl) throws InvalidSmilesException {
        this.setFlags(this.flags);
        if (!this.isRingCheck && Logger.debugging && !this.isSilent) {
            Logger.debug("SmilesSearch processing " + this.pattern);
        }
        if (this.vReturn == null && (this.asVector || this.getMaps)) {
            this.vReturn = new Lst();
        }
        if (this.bsSelected == null) {
            this.bsSelected = BS.newN(this.targetAtomCount);
            this.bsSelected.setBits(0, this.targetAtomCount);
        }
        this.selectedAtomCount = this.bsSelected.cardinality();
        if (this.subSearches != null) {
            int n = 0;
            while (n < this.subSearches.length) {
                if (this.subSearches[n] != null) {
                    this.subsearch(this.subSearches[n], 3);
                    if (this.exitFirstMatch && (this.vReturn == null ? this.bsReturn.nextSetBit(0) >= 0 : this.vReturn.size() > 0)) break;
                }
                ++n;
            }
        } else if (this.ac > 0) {
            if (this.nestedBond == null) {
                this.clearBsFound(-1);
            } else {
                this.bsReturn.clearAll();
            }
            this.nextPatternAtom(-1, -1, bl, -1);
        }
        return this.asVector || this.getMaps ? this.vReturn : this.bsReturn;
    }

    /*
     * Unable to fully structure code
     */
    private boolean nextPatternAtom(int var1_1, int var2_2, boolean var3_3, int var4_4) throws InvalidSmilesException {
        if (++var1_1 < this.ac) {
            var7_5 = this.patternAtoms[var1_1];
            v0 = var2_2 >= 0 ? var7_5.getBondTo(null) : (var8_7 = var1_1 == 0 ? this.nestedBond : null);
            if (var8_7 == null) {
                var9_9 = BSUtil.copy(this.bsFound);
                var10_15 = BSUtil.copy(this.bsFound);
                if (var7_5.notBondedIndex >= 0) {
                    var11_20 = this.patternAtoms[var7_5.notBondedIndex];
                    var12_25 = var11_20.getMatchingAtom();
                    if (var11_20.isBioAtom) {
                        var13_29 = var12_25.getOffsetResidueAtom("\u0000", 1);
                        if (var13_29 >= 0) {
                            var9_9.set(var13_29);
                        }
                        if ((var13_29 = var12_25.getOffsetResidueAtom("\u0000", -1)) >= 0) {
                            var9_9.set(var13_29);
                        }
                    } else {
                        var6_32 = var12_25.getEdges();
                        var13_29 = 0;
                        while (var13_29 < var6_32.length) {
                            var9_9.set(var6_32[var13_29].getOtherNode(var12_25).getIndex());
                            ++var13_29;
                        }
                    }
                }
                var11_21 = var7_5.isBioAtomWild;
                var12_26 = this.bsSelected.nextSetBit(0);
                var12_26 = var11_21 != false && var12_26 >= 0 ? this.targetAtoms[var12_26].getOffsetResidueAtom("\u0000", var12_26) : var12_26;
                var14_34 = (var1_1 > 0 ? this.patternAtoms[var1_1 - 1] : var7_5).component;
                var15_36 = var7_5.component;
                var16_37 = this.haveComponents != false && var15_36 != -2147483648;
                var17_38 = var12_26;
                while (var17_38 >= 0) {
                    if (!var9_9.get(var17_38) && !this.bsFound.get(var17_38)) {
                        var5_39 = this.targetAtoms[var17_38];
                        if (!var16_37 || this.isRingCheck || var14_34 == var15_36 == ((var13_29 = var1_1 > 0 ? this.patternAtoms[var1_1 - 1].matchingComponent : var4_4) == (var4_4 = this.groupByModel != false ? var5_39.getModelIndex() : var5_39.getMoleculeNumber(false)))) {
                            if (!this.nextTargetAtom(var7_5, var5_39, var1_1, var17_38, var3_3, var4_4)) {
                                return false;
                            } else {
                                ** GOTO lbl-1000
                            }
                        }
                    } else if (var11_21 && (var12_26 = this.targetAtoms[var17_38].getOffsetResidueAtom(var7_5.bioAtomName, 1)) >= 0) {
                        var17_38 = var12_26 - 1;
                    }
                    var17_38 = this.bsSelected.nextSetBit(var17_38 + 1);
                }
                this.bsFound = var10_15;
                return true;
            }
            var5_40 = var8_7.atom1.getMatchingAtom();
            switch (var8_7.order) {
                case 96: {
                    var9_10 = var5_40.getOffsetResidueAtom(var7_5.bioAtomName, 1);
                    if (var9_10 >= 0) {
                        var10_16 = BSUtil.copy(this.bsFound);
                        var5_40.getGroupBits(this.bsFound);
                        if (this.doCheckAtom(var9_10) && !this.nextTargetAtom(var7_5, this.targetAtoms[var9_10], var1_1, var9_10, var3_3, var4_4)) {
                            return false;
                        }
                        this.bsFound = var10_16;
                    }
                    return true;
                }
                case 112: {
                    var10_17 = new Lst<Integer>();
                    var5_40.getCrossLinkVector(var10_17, true, true);
                    var11_22 = BSUtil.copy(this.bsFound);
                    var5_40.getGroupBits(this.bsFound);
                    var12_27 = 2;
                    while (var12_27 < var10_17.size()) {
                        var13_30 = (Integer)var10_17.get(var12_27);
                        if (this.doCheckAtom(var13_30) && !this.nextTargetAtom(var7_5, this.targetAtoms[var13_30], var1_1, var13_30, var3_3, var4_4)) {
                            return false;
                        }
                        var12_27 += 3;
                    }
                    this.bsFound = var11_22;
                    return true;
                }
            }
            var6_33 = var5_40.getEdges();
            if (var6_33 != null) {
                var9_11 = 0;
                while (var9_11 < var6_33.length) {
                    var10_18 = var5_40.getBondedAtomIndex(var9_11);
                    if (this.doCheckAtom(var10_18) && !this.nextTargetAtom(var7_5, this.targetAtoms[var10_18], var1_1, var10_18, var3_3, var4_4)) {
                        return false;
                    }
                    ++var9_11;
                }
            }
            this.clearBsFound(var2_2);
            return true;
        }
        if (!(this.ignoreStereochemistry || this.isRingCheck || this.checkStereochemistry())) {
            return true;
        }
        var7_6 = new BS();
        var8_8 = 0;
        var9_12 = 0;
        while (var9_12 < this.ac) {
            var10_19 = this.patternAtoms[var9_12].getMatchingAtomIndex();
            if (var3_3 || !this.top.haveSelected || this.patternAtoms[var9_12].selected) {
                ++var8_8;
                var7_6.set(var10_19);
                if (this.patternAtoms[var9_12].isBioAtomWild) {
                    this.targetAtoms[var10_19].getGroupBits(var7_6);
                }
                if (var3_3) break;
                if (!this.isSmarts && !this.setAtropicity && this.patternAtoms[var9_12].explicitHydrogenCount > 0) {
                    var11_23 = this.targetAtoms[var10_19];
                    var12_28 = 0;
                    var13_31 = var11_23.getEdges().length;
                    while (var12_28 < var13_31) {
                        var14_35 = var11_23.getBondedAtomIndex(var12_28);
                        if (this.targetAtoms[var14_35].getElementNumber() == 1) {
                            var7_6.set(var14_35);
                        }
                        ++var12_28;
                    }
                }
            }
            ++var9_12;
        }
        if (!this.isSmarts && var7_6.cardinality() != this.selectedAtomCount) {
            return true;
        }
        if (this.bsCheck != null) {
            if (var3_3) {
                this.bsCheck.clearAll();
                var9_12 = 0;
                while (var9_12 < this.ac) {
                    this.bsCheck.set(this.patternAtoms[var9_12].getMatchingAtomIndex());
                    ++var9_12;
                }
                if (this.bsCheck.cardinality() != this.ac) {
                    return true;
                }
            } else if (var7_6.cardinality() != this.ac) {
                return true;
            }
        }
        this.bsReturn.or(var7_6);
        if (this.getMaps) {
            if (this.mapUnique) {
                if (this.uniqueList == null) {
                    this.uniqueList = new Lst<V>();
                }
                var9_12 = this.uniqueList.size();
                while (--var9_12 >= 0) {
                    if (!((BS)this.uniqueList.get(var9_12)).equals(var7_6)) continue;
                    return true;
                }
                this.uniqueList.addLast(var7_6);
            }
            var9_13 = new int[var8_8];
            var10_19 = 0;
            var11_24 = 0;
            while (var10_19 < this.ac) {
                if (var3_3 || !this.top.haveSelected || this.patternAtoms[var10_19].selected) {
                    var9_13[var11_24++] = this.patternAtoms[var10_19].getMatchingAtomIndex();
                }
                ++var10_19;
            }
            this.vReturn.addLast(var9_13);
            return this.exitFirstMatch == false;
        }
        if (this.asVector) {
            var9_12 = 1;
            var10_19 = this.vReturn.size();
            while (--var10_19 >= 0 && var9_12 != 0) {
                v1 = var9_12 = ((BS)this.vReturn.get(var10_19)).equals(var7_6) != false ? 0 : 1;
            }
            if (var9_12 == 0) {
                return true;
            }
            this.vReturn.addLast(var7_6);
        }
        if (this.isRingCheck) {
            var9_14 = new BS();
            var10_19 = var1_1 * 3 + 2;
            while (--var10_19 > var1_1) {
                var9_14.set(this.patternAtoms[(var10_19 <= var1_1 * 2 ? var1_1 * 2 - var10_19 + 1 : var10_19 - 1) % var1_1].getMatchingAtomIndex());
            }
            this.ringSets.addLast(var9_14);
            return true;
        }
        if (this.exitFirstMatch) {
            return false;
        }
        return var7_6.cardinality() != this.selectedAtomCount;
    }

    private boolean doCheckAtom(int n) {
        return this.bsSelected.get(n) && !this.bsFound.get(n);
    }

    private final boolean nextTargetAtom(SmilesAtom smilesAtom, Node node, int n, int n2, boolean bl, int n3) throws InvalidSmilesException {
        int n4;
        if (!this.isRingCheck && !this.isTopology) {
            if (smilesAtom.subAtoms == null) {
                if (!this.checkPrimitiveAtom(smilesAtom, n2)) {
                    return true;
                }
            } else if (smilesAtom.isAND) {
                n4 = 0;
                while (n4 < smilesAtom.nSubAtoms) {
                    if (!this.checkPrimitiveAtom(smilesAtom.subAtoms[n4], n2)) {
                        return true;
                    }
                    ++n4;
                }
            } else {
                int n5 = 0;
                while (n5 < smilesAtom.nSubAtoms) {
                    if (!this.nextTargetAtom(smilesAtom.subAtoms[n5], node, n, n2, bl, n3)) {
                        return false;
                    }
                    ++n5;
                }
                return true;
            }
        }
        Edge[] edgeArray = node.getEdges();
        n4 = smilesAtom.getBondCount();
        block5: while (--n4 >= 0) {
            SmilesBond smilesBond = smilesAtom.getBond(n4);
            if (smilesBond.getAtomIndex2() != smilesAtom.index) continue;
            SmilesAtom smilesAtom2 = smilesBond.atom1;
            int n6 = smilesAtom2.getMatchingAtomIndex();
            switch (smilesBond.order) {
                case 96: 
                case 112: {
                    if (this.checkMatchBond(smilesAtom, smilesAtom2, smilesBond, n2, n6, null)) continue block5;
                    return true;
                }
                default: {
                    int n7 = 0;
                    Edge edge = null;
                    while (n7 < edgeArray.length) {
                        edge = edgeArray[n7];
                        if (edge.isCovalent() && (edge.getAtomIndex1() == n6 || edge.getAtomIndex2() == n6)) break;
                        ++n7;
                    }
                    if (n7 == edgeArray.length) {
                        return true;
                    }
                    if (this.checkMatchBond(smilesAtom, smilesAtom2, smilesBond, n2, n6, edge)) continue block5;
                    return true;
                }
            }
        }
        smilesAtom = this.patternAtoms[smilesAtom.index];
        smilesAtom.setMatchingAtom(this.targetAtoms[n2], n2);
        smilesAtom.matchingComponent = n3;
        if (Logger.debuggingHigh && !this.isRingCheck) {
            n4 = 0;
            while (n4 <= n) {
                Logger.debug("pattern atoms " + this.patternAtoms[n4] + " " + this.patternAtoms[n4].matchingComponent);
                ++n4;
            }
            Logger.debug("--ss--");
        }
        this.bsFound.set(n2);
        if (!this.nextPatternAtom(n, n2, bl, n3)) {
            return false;
        }
        if (n2 >= 0) {
            this.clearBsFound(n2);
        }
        return true;
    }

    private boolean checkPrimitiveAtom(SmilesAtom smilesAtom, int n) throws InvalidSmilesException {
        boolean bl;
        block23: {
            block26: {
                int n2;
                block28: {
                    block29: {
                        Node node;
                        block27: {
                            int n3;
                            block24: {
                                Node node2;
                                block25: {
                                    block22: {
                                        if (smilesAtom.nSubAtoms > 0) {
                                            int n4 = 0;
                                            while (n4 < smilesAtom.nSubAtoms) {
                                                if (this.checkPrimitiveAtom(smilesAtom.subAtoms[n4], n)) {
                                                    return true;
                                                }
                                                ++n4;
                                            }
                                            return false;
                                        }
                                        node = this.targetAtoms[n];
                                        bl = smilesAtom.not;
                                        if (smilesAtom.iNested <= 0) break block22;
                                        Object object = this.getNested(smilesAtom.iNested);
                                        if (object instanceof SmilesSearch) {
                                            SmilesSearch smilesSearch = (SmilesSearch)object;
                                            if (smilesAtom.isBioAtom) {
                                                smilesSearch.nestedBond = smilesAtom.getBondTo(null);
                                            }
                                            if ((object = this.subsearch(smilesSearch, 1)) == null) {
                                                object = new BS();
                                            }
                                            if (!smilesAtom.isBioAtom) {
                                                this.setNested(smilesAtom.iNested, object);
                                            }
                                        }
                                        bl = smilesAtom.not ^ ((BS)object).get(n);
                                        break block23;
                                    }
                                    n3 = node.getElementNumber();
                                    n2 = smilesAtom.elementNumber;
                                    if (n3 >= 0 && n2 >= 0 && n2 != n3) break block23;
                                    if (!smilesAtom.isBioResidue) break block24;
                                    node2 = node;
                                    if (smilesAtom.bioAtomName != null && (!smilesAtom.isLeadAtom() ? !smilesAtom.bioAtomName.equals(node2.getAtomName().toUpperCase()) : !node2.isLeadAtom())) break block23;
                                    if (smilesAtom.residueName != null && !smilesAtom.residueName.equals(node2.getGroup3(false).toUpperCase()) || smilesAtom.residueNumber != Integer.MIN_VALUE && smilesAtom.residueNumber != node2.getResno() || smilesAtom.insCode != '\u0000' && smilesAtom.insCode != node2.getInsertionCode()) break block23;
                                    if (smilesAtom.residueChar == null && smilesAtom.elementNumber != -2) break block25;
                                    char c = node2.getBioSmilesType();
                                    char c2 = smilesAtom.getBioSmilesType();
                                    boolean bl2 = true;
                                    boolean bl3 = false;
                                    switch (c2) {
                                        case '\u0000': 
                                        case '*': {
                                            bl2 = true;
                                            break;
                                        }
                                        case 'n': {
                                            bl2 = c == 'r' || c == 'c';
                                            bl3 = true;
                                            break;
                                        }
                                        case 'c': 
                                        case 'r': {
                                            bl3 = true;
                                        }
                                        default: {
                                            boolean bl4 = bl2 = c == c2;
                                        }
                                    }
                                    if (!bl2) break block23;
                                    String string = node2.getGroup1('\u0000').toUpperCase();
                                    char c3 = smilesAtom.residueChar == null ? (char)'*' : (char)smilesAtom.residueChar.charAt(0);
                                    boolean bl5 = c3 == string.charAt(0);
                                    switch (c3) {
                                        case '*': {
                                            bl5 = true;
                                            break;
                                        }
                                        case 'N': {
                                            bl5 = bl3 ? c == 'r' || c == 'c' : bl5;
                                            break;
                                        }
                                        case 'R': {
                                            bl5 = bl3 ? node2.isPurine() : bl5;
                                            break;
                                        }
                                        case 'Y': {
                                            boolean bl6 = bl5 = bl3 ? node2.isPyrimidine() : bl5;
                                        }
                                    }
                                    if (!bl5) break block23;
                                }
                                if (!smilesAtom.isBioAtom || !smilesAtom.notCrossLinked || !node2.getCrossLinkVector(null, true, true)) break block26;
                                break block23;
                            }
                            if (smilesAtom.atomNumber != Integer.MIN_VALUE && smilesAtom.atomNumber != node.getAtomNumber() || smilesAtom.jmolIndex >= 0 && node.getIndex() != smilesAtom.jmolIndex || smilesAtom.atomType != null && !smilesAtom.atomType.equals(node.getAtomType()) || (n2 = smilesAtom.getAtomicMass()) != Integer.MIN_VALUE && (n2 >= 0 && n2 != (n3 = node.getIsotopeNumber()) || n2 < 0 && n3 != 0 && -n2 != n3) || !this.noAromatic && !smilesAtom.aromaticAmbiguous && smilesAtom.isAromatic != this.bsAromatic.get(n) || (n2 = smilesAtom.getCharge()) != Integer.MIN_VALUE && n2 != node.getFormalCharge() || (n2 = smilesAtom.getCovalentHydrogenCount() + smilesAtom.explicitHydrogenCount) >= 0 && n2 != node.getTotalHydrogenCount()) break block23;
                            n2 = smilesAtom.implicitHydrogenCount;
                            if (n2 == Integer.MIN_VALUE) break block27;
                            n3 = node.getImplicitHydrogenCount();
                            if (n2 != -1 ? n2 != n3 : n3 == 0) break block23;
                        }
                        if (smilesAtom.degree > 0 && smilesAtom.degree != node.getCovalentBondCount() - node.getImplicitHydrogenCount() || smilesAtom.nonhydrogenDegree > 0 && smilesAtom.nonhydrogenDegree != node.getCovalentBondCount() - node.getCovalentHydrogenCount() || this.isSmarts && smilesAtom.valence > 0 && smilesAtom.valence != node.getTotalValence() || smilesAtom.connectivity > 0 && smilesAtom.connectivity != node.getCovalentBondCountPlusMissingH() || smilesAtom.atomNumber != Integer.MIN_VALUE && smilesAtom.atomNumber != node.getAtomNumber() || smilesAtom.jmolIndex >= 0 && node.getIndex() != smilesAtom.jmolIndex || smilesAtom.atomType != null && !smilesAtom.atomType.equals(node.getAtomType()) || (!this.ignoreAtomClass || this.isSmarts) && !Float.isNaN(smilesAtom.atomClass) && smilesAtom.atomClass != node.getFloatProperty("property_atomclass")) break block23;
                        if (this.ringData == null) break block26;
                        if (smilesAtom.ringSize < -1) break block28;
                        if (smilesAtom.ringSize > 0) break block29;
                        if (this.ringCounts[n] == 0 == (smilesAtom.ringSize == 0)) break block28;
                        break block23;
                    }
                    BS bS = this.ringData[smilesAtom.ringSize == 500 ? 5 : (smilesAtom.ringSize == 600 ? 6 : smilesAtom.ringSize)];
                    if (bS == null || !bS.get(n) || !this.noAromatic && (smilesAtom.ringSize != 500 ? smilesAtom.ringSize == 600 && !this.bsAromatic6.get(n) : !this.bsAromatic5.get(n))) break block23;
                }
                if (smilesAtom.ringMembership >= -1 && (smilesAtom.ringMembership != -1 ? this.ringCounts[n] != smilesAtom.ringMembership : this.ringCounts[n] == 0)) break block23;
                if (smilesAtom.ringConnectivity < 0) break block26;
                n2 = this.ringConnections[n];
                if (smilesAtom.ringConnectivity == -1 && n2 == 0 || smilesAtom.ringConnectivity != -1 && n2 != smilesAtom.ringConnectivity) break block23;
            }
            bl = !bl;
        }
        return bl;
    }

    private boolean checkMatchBond(SmilesAtom smilesAtom, SmilesAtom smilesAtom2, SmilesBond smilesBond, int n, int n2, Edge edge) {
        if (smilesBond.bondsOr != null) {
            int n3 = 0;
            while (n3 < smilesBond.nBondsOr) {
                if (this.checkMatchBond(smilesAtom, smilesAtom2, smilesBond.bondsOr[n3], n, n2, edge)) {
                    return true;
                }
                ++n3;
            }
            return false;
        }
        if (!this.isRingCheck && !this.isTopology) {
            if (smilesBond.nPrimitives == 0) {
                if (!this.checkPrimitiveBond(smilesBond, n, n2, edge)) {
                    return false;
                }
            } else {
                int n4 = 0;
                while (n4 < smilesBond.nPrimitives) {
                    SmilesBond smilesBond2 = smilesBond.setPrimitive(n4);
                    if (!this.checkPrimitiveBond(smilesBond2, n, n2, edge)) {
                        return false;
                    }
                    ++n4;
                }
            }
        }
        smilesBond.matchingBond = edge;
        return true;
    }

    private boolean checkPrimitiveBond(SmilesBond smilesBond, int n, int n2, Edge edge) {
        boolean bl = false;
        switch (smilesBond.order) {
            case 96: {
                return smilesBond.isNot ^ this.targetAtoms[n2].getOffsetResidueAtom("\u0000", 1) == this.targetAtoms[n].getOffsetResidueAtom("\u0000", 0);
            }
            case 112: {
                return smilesBond.isNot ^ this.targetAtoms[n].isCrossLinked(this.targetAtoms[n2]);
            }
        }
        boolean bl2 = !this.noAromatic && this.bsAromatic.get(n);
        boolean bl3 = !this.noAromatic && this.bsAromatic.get(n2);
        int n3 = edge.getCovalentOrder();
        int n4 = smilesBond.order;
        if (bl2 && bl3) {
            switch (n4) {
                case 17: 
                case 65: {
                    bl = SmilesSearch.isRingBond(this.ringSets, null, n, n2);
                    break;
                }
                case 1: {
                    bl = !this.isSmarts || !SmilesSearch.isRingBond(this.ringSets, this.getBSAromaticRings(), n, n2);
                    break;
                }
                case 2: {
                    bl = this.isNormalized || this.aromaticDouble && (n3 == 2 || n3 == 514);
                    break;
                }
                case 65537: 
                case 65538: {
                    bl = !smilesBond.isNot;
                    break;
                }
                case -1: 
                case 81: {
                    bl = true;
                }
            }
        } else {
            switch (n4) {
                case 17: {
                    if (!this.noAromatic) break;
                }
                case -1: 
                case 81: {
                    bl = true;
                    break;
                }
                case 1: 
                case 1025: 
                case 1041: {
                    switch (n3) {
                        case 1: 
                        case 1025: 
                        case 1041: {
                            bl = true;
                        }
                    }
                    break;
                }
                case 65537: 
                case 65538: {
                    switch (n3) {
                        case 1: 
                        case 65537: 
                        case 65538: {
                            bl = !smilesBond.isNot;
                        }
                    }
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    bl = n3 == n4;
                    break;
                }
                case 65: {
                    bl = SmilesSearch.isRingBond(this.ringSets, null, n, n2);
                }
            }
        }
        return bl ^ smilesBond.isNot;
    }

    private BS getBSAromaticRings() {
        if (this.bsAromaticRings == null) {
            this.bsAromaticRings = new BS();
            if (this.ringSets != null && this.bsAromatic != null) {
                int n = this.ringSets.size();
                while (--n >= 0) {
                    BS bS = (BS)((BS)this.ringSets.get(n)).clone();
                    bS.andNot(this.bsAromatic);
                    if (!bS.isEmpty()) continue;
                    this.bsAromaticRings.set(n);
                }
            }
        }
        return this.bsAromaticRings;
    }

    static boolean isRingBond(Lst<BS> lst, BS bS, int n, int n2) {
        if (lst != null) {
            int n3 = lst.size();
            while (--n3 >= 0) {
                BS bS2 = (BS)lst.get(n3);
                if (!bS2.get(n) || !bS2.get(n2) || bS != null && !bS.get(n3)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkStereochemistry() {
        int n = 0;
        while (n < this.measures.size()) {
            if (!((SmilesMeasure)this.measures.get(n)).check()) {
                return false;
            }
            ++n;
        }
        if (this.stereo != null && !this.stereo.checkStereoChemistry(this, this.v)) {
            return false;
        }
        if (!this.haveBondStereochemistry) {
            return true;
        }
        Lst<SmilesBond> lst = null;
        SmilesBond smilesBond = null;
        int n2 = 0;
        while (n2 < this.ac) {
            block34: {
                Object object;
                Object object2;
                boolean bl;
                boolean bl2;
                int n3;
                int n4;
                int n5;
                SmilesAtom smilesAtom;
                SmilesAtom smilesAtom2;
                SmilesAtom smilesAtom3;
                SmilesAtom smilesAtom4;
                block35: {
                    int n6;
                    int n7;
                    int n8;
                    block32: {
                        block33: {
                            smilesAtom4 = this.patternAtoms[n2];
                            smilesAtom3 = null;
                            smilesAtom2 = null;
                            smilesAtom = null;
                            n5 = 0;
                            n4 = 0;
                            n3 = 0;
                            n8 = smilesAtom4.getBondCount();
                            bl2 = false;
                            bl = true;
                            int n9 = 0;
                            while (n9 < n8) {
                                smilesBond = smilesAtom4.getBond(n9);
                                n7 = smilesBond.atom2 == smilesAtom4 ? 1 : 0;
                                bl = smilesBond.atom1.index < smilesBond.atom2.index;
                                n6 = smilesBond.order;
                                switch (n6) {
                                    case 65537: 
                                    case 65538: {
                                        if (!bl) break;
                                    }
                                    case 2: {
                                        if (n7 != 0) break;
                                        smilesAtom3 = smilesBond.atom2;
                                        n3 = n6;
                                        boolean bl3 = bl2 = n6 != 2;
                                        if (!bl2) break;
                                        n5 = smilesBond.isNot ? -1 : 1;
                                        break;
                                    }
                                    case 1025: 
                                    case 1041: {
                                        smilesAtom2 = n7 != 0 ? smilesBond.atom1 : smilesBond.atom2;
                                        n5 = n7 != (n6 == 1025 ? 1 : 0) ? 1 : -1;
                                    }
                                }
                                ++n9;
                            }
                            if (!bl2) break block32;
                            if (!this.setAtropicity) break block33;
                            if (lst == null) {
                                lst = new Lst<SmilesBond>();
                            }
                            lst.addLast(smilesBond);
                            break block34;
                        }
                        object2 = smilesAtom4.getBond(smilesBond.atropType[0]);
                        if (object2 == null) {
                            return false;
                        }
                        smilesAtom2 = ((SmilesBond)object2).getOtherAtom(smilesAtom4);
                        object2 = smilesAtom3.getBond(smilesBond.atropType[1]);
                        if (object2 == null) {
                            return false;
                        }
                        smilesAtom = ((SmilesBond)object2).getOtherAtom(smilesAtom3);
                        if (Logger.debugging) {
                            Logger.info("atropisomer check for atoms " + smilesAtom2 + smilesAtom4 + " " + smilesAtom3 + smilesAtom);
                        }
                        break block35;
                    }
                    if (smilesAtom3 == null || n5 == 0) break block34;
                    object2 = smilesAtom4;
                    n7 = 0;
                    while (smilesAtom3.getBondCount() == 2 && smilesAtom3.getValence() == 4) {
                        Edge[] edgeArray;
                        ++n7;
                        object = edgeArray[(edgeArray = smilesAtom3.getEdges())[0].getOtherNode(smilesAtom3) == object2 ? 1 : 0];
                        object2 = smilesAtom3;
                        smilesAtom3 = (SmilesAtom)object.getOtherNode(smilesAtom3);
                    }
                    if (n7 % 2 == 1) break block34;
                    n8 = smilesAtom3.getBondCount();
                    n6 = 0;
                    while (n6 < n8 && n4 == 0) {
                        smilesBond = smilesAtom3.getBond(n6);
                        int n10 = smilesBond.order;
                        switch (n10) {
                            case 1025: 
                            case 1041: {
                                boolean bl4 = smilesBond.atom2 == smilesAtom3;
                                smilesAtom = bl4 ? smilesBond.atom1 : smilesBond.atom2;
                                n4 = bl4 != (n10 == 1025) ? 1 : -1;
                            }
                        }
                        ++n6;
                    }
                    if (n4 == 0) break block34;
                }
                object2 = smilesAtom4.getMatchingAtom();
                Node node = smilesAtom3.getMatchingAtom();
                Node node2 = smilesAtom2.getMatchingAtom();
                object = smilesAtom.getMatchingAtom();
                if (node2 == null || object == null) {
                    return false;
                }
                if (this.haveTopo) {
                    this.setTopoCoordinates((SmilesAtom)object2, (SmilesAtom)node, (SmilesAtom)node2, (SmilesAtom)object, n3);
                }
                float f = SmilesMeasure.setTorsionData((T3)((Object)node2), (T3)object2, (T3)((Object)node), (T3)object, this.v, bl2);
                if (bl2) {
                    f *= (float)(n5 * (n3 == 65537 ? 1 : -1) * (bl ? 1 : -1));
                    if (Logger.debugging) {
                        Logger.info("atrop dihedral " + f + " " + smilesAtom4 + " " + smilesAtom3 + " " + smilesBond);
                    }
                    if (f < 1.0f) {
                        return false;
                    }
                } else if (this.v.vTemp1.dot(this.v.vTemp2) * (float)n5 * (float)n4 < 0.0f) {
                    return false;
                }
            }
            ++n2;
        }
        if (this.setAtropicity) {
            this.atropKeys = "";
            n2 = 0;
            while (n2 < lst.size()) {
                smilesBond = (SmilesBond)lst.get(n2);
                this.atropKeys = String.valueOf(this.atropKeys) + "," + this.getAtropIndex(smilesBond, true) + this.getAtropIndex(smilesBond, false);
                ++n2;
            }
        }
        return true;
    }

    private int getAtropIndex(SmilesBond smilesBond, boolean bl) {
        SmilesAtom smilesAtom = bl ? smilesBond.atom1 : smilesBond.atom2;
        Node node = smilesAtom.getMatchingAtom();
        Node node2 = Edge.getAtropismNode(smilesBond.matchingBond.order, node, bl);
        SmilesBond[] smilesBondArray = smilesAtom.bonds;
        int n = smilesAtom.getBondCount();
        while (--n >= 0) {
            if (((SmilesAtom)smilesBondArray[n].getOtherNode(smilesAtom)).getMatchingAtom() != node2) continue;
            return n + 1;
        }
        return 0;
    }

    private void setTopoCoordinates(SmilesAtom smilesAtom, SmilesAtom smilesAtom2, SmilesAtom smilesAtom3, SmilesAtom smilesAtom4, int n) {
        Node[] nodeArray;
        smilesAtom.set(-1.0f, 0.0f, 0.0f);
        smilesAtom2.set(1.0f, 0.0f, 0.0f);
        if (n != 2) {
            SmilesBond smilesBond = smilesAtom.getBondTo(smilesAtom2);
            int n2 = smilesBond.order == 65537 ? 1 : -1;
            smilesAtom3.set(-1.0f, 1.0f, 0.0f);
            smilesAtom4.set(1.0f, 1.0f, (float)n2 / 2.0f);
            return;
        }
        int n3 = 0;
        int n4 = 0;
        Edge[] edgeArray = smilesAtom.getEdges();
        int n5 = edgeArray.length;
        while (--n5 >= 0) {
            nodeArray = edgeArray[n5];
            if (nodeArray.order == 2) continue;
            SimpleNode simpleNode = nodeArray.getOtherNode(smilesAtom);
            ((Node)simpleNode).set(-1.0f, n3++ == 0 ? -1 : 1, 0.0f);
            int n6 = nodeArray.getAtomIndex2() == smilesAtom.getIndex() ? n3 : -n3;
            switch (nodeArray.order) {
                case 1025: {
                    n4 = n6;
                    break;
                }
                case 1041: {
                    n4 = -n6;
                }
            }
        }
        n5 = 0;
        n3 = 0;
        nodeArray = new Node[2];
        edgeArray = smilesAtom2.getEdges();
        int n7 = edgeArray.length;
        while (--n7 >= 0) {
            Edge edge = edgeArray[n7];
            if (edge.order == 2) continue;
            SimpleNode simpleNode = edge.getOtherNode(smilesAtom2);
            nodeArray[n3] = simpleNode;
            ((Node)simpleNode).set(1.0f, n3++ == 0 ? 1 : -1, 0.0f);
            int n8 = edge.getAtomIndex2() == smilesAtom2.getIndex() ? n3 : -n3;
            switch (edge.order) {
                case 1025: {
                    n5 = n8;
                    break;
                }
                case 1041: {
                    n5 = -n8;
                }
            }
        }
        if (n4 * n5 > 0 == (Math.abs(n4) % 2 == Math.abs(n5) % 2)) {
            float f = ((P3)((Object)nodeArray[0])).y;
            ((P3)((Object)nodeArray[0])).y = ((P3)((Object)nodeArray[1])).y;
            ((P3)((Object)nodeArray[1])).y = f;
        }
    }

    void createTopoMap(BS bS) throws InvalidSmilesException {
        Object object;
        Object object2;
        SmilesBond[] smilesBondArray;
        boolean bl = bS == null;
        int n = this.getMissingHydrogenCount();
        int n2 = this.ac + n;
        SmilesAtom[] smilesAtomArray = new SmilesAtom[n2];
        this.targetAtoms = smilesAtomArray;
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.ac) {
            smilesBondArray = this.patternAtoms[n3];
            int n5 = smilesBondArray.explicitHydrogenCount;
            if (n5 < 0) {
                n5 = 0;
            }
            smilesAtomArray[n4] = new SmilesAtom().setTopoAtom(smilesBondArray.component, n4, smilesBondArray.symbol, smilesBondArray.getCharge(), n3);
            object2 = smilesAtomArray[n4];
            ((SmilesAtom)object2).implicitHydrogenCount = n5;
            if (!bl) {
                ((SmilesAtom)object2).mapIndex = n3;
                ((SmilesAtom)object2).stereo = smilesBondArray.stereo;
                ((SmilesAtom)object2).setAtomicMass(smilesBondArray.getAtomicMass());
                ((SmilesAtom)object2).bioAtomName = smilesBondArray.bioAtomName;
                ((SmilesAtom)object2).residueName = smilesBondArray.residueName;
                ((SmilesAtom)object2).residueChar = smilesBondArray.residueChar;
                ((SmilesAtom)object2).residueNumber = smilesBondArray.residueNumber;
                ((SmilesAtom)object2).atomNumber = smilesBondArray.residueNumber;
                ((SmilesAtom)object2).insCode = smilesBondArray.insCode;
                ((SmilesAtom)object2).atomClass = smilesBondArray.atomClass;
                ((SmilesAtom)object2).explicitHydrogenCount = 0;
                ((SmilesAtom)object2).isBioAtom = smilesBondArray.isBioAtom;
                ((SmilesAtom)object2).bioType = smilesBondArray.bioType;
                ((SmilesAtom)object2).isLeadAtom = smilesBondArray.isLeadAtom;
                if (!bl && smilesBondArray.isAromatic) {
                    bS.set(n4);
                }
                smilesBondArray.setMatchingAtom(null, n4);
                SmilesBond[] smilesBondArray2 = new SmilesBond[smilesBondArray.getBondCount() + n5];
                ((SmilesAtom)object2).setBonds(smilesBondArray2);
                while (--n5 >= 0) {
                    smilesAtomArray[++n4] = new SmilesAtom().setTopoAtom(((SmilesAtom)object2).component, n4, "H", 0, -1);
                    object = smilesAtomArray[++n4];
                    ((SmilesAtom)object).mapIndex = -n3 - 1;
                    ((SmilesAtom)object).setBonds(new SmilesBond[1]);
                    SmilesBond smilesBond = new SmilesBond((SmilesAtom)object2, (SmilesAtom)object, 1, false);
                    if (!Logger.debugging) continue;
                    Logger.info("" + smilesBond);
                }
            }
            ++n3;
            ++n4;
        }
        if (bl) {
            return;
        }
        n3 = 0;
        while (n3 < this.ac) {
            SmilesAtom smilesAtom = this.patternAtoms[n3];
            int n6 = smilesAtom.getMatchingAtomIndex();
            SmilesAtom smilesAtom2 = smilesAtomArray[n6];
            int n7 = smilesAtom.getBondCount();
            int n8 = 0;
            while (n8 < n7) {
                Object object3;
                boolean bl2;
                object = smilesAtom.getBond(n8);
                boolean bl3 = bl2 = ((SmilesBond)object).atom1 == smilesAtom;
                if (bl2) {
                    int n9 = 1;
                    switch (((SmilesBond)object).order) {
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: 
                        case 96: 
                        case 112: 
                        case 1025: 
                        case 1041: 
                        case 65537: 
                        case 65538: {
                            n9 = ((SmilesBond)object).order;
                            break;
                        }
                        case 17: {
                            n9 = 514;
                        }
                    }
                    object3 = smilesAtomArray[((SmilesBond)object).atom2.getMatchingAtomIndex()];
                    SmilesBond smilesBond = new SmilesBond(smilesAtom2, (SmilesAtom)object3, n9, false);
                    smilesBond.isConnection = ((SmilesBond)object).isConnection;
                    --((SmilesAtom)object3).bondCount;
                    if (Logger.debugging) {
                        Logger.info("" + smilesBond);
                    }
                } else {
                    SmilesAtom smilesAtom3 = smilesAtomArray[((SmilesBond)object).atom1.getMatchingAtomIndex()];
                    object3 = smilesAtom3.getBondTo(smilesAtom2);
                    smilesAtom2.addBond((SmilesBond)object3);
                }
                ++n8;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            SmilesAtom smilesAtom = smilesAtomArray[n3];
            smilesBondArray = smilesAtom.bonds;
            if (smilesBondArray.length >= 2 && !smilesBondArray[0].isFromPreviousTo(smilesAtom)) {
                int n10 = smilesBondArray.length;
                while (--n10 >= 1) {
                    if (!smilesBondArray[n10].isFromPreviousTo(smilesAtom)) continue;
                    object2 = smilesBondArray[n10];
                    smilesBondArray[n10] = smilesBondArray[0];
                    smilesBondArray[0] = object2;
                    break;
                }
            }
            ++n3;
        }
        if (!this.ignoreStereochemistry) {
            n3 = this.ac;
            while (--n3 >= 0) {
                SmilesAtom smilesAtom = this.patternAtoms[n3];
                if (smilesAtom.stereo == null) continue;
                smilesAtom.stereo.fixStereo(smilesAtom);
            }
        }
    }

    static void normalizeAromaticity(SmilesAtom[] smilesAtomArray, BS bS, int n) throws InvalidSmilesException {
        SmilesSearch smilesSearch = new SmilesSearch();
        smilesSearch.setFlags(n);
        smilesSearch.targetAtoms = smilesAtomArray;
        smilesSearch.targetAtomCount = smilesAtomArray.length;
        smilesSearch.bsSelected = BSUtil.newBitSet2(0, smilesAtomArray.length);
        Lst<type>[] lstArray = AU.createArrayOfArrayList(4);
        smilesSearch.setRingData(null, lstArray, true);
        bS.or(smilesSearch.bsAromatic);
        if (!bS.isEmpty()) {
            Lst lst = lstArray[3];
            int n2 = lst.size();
            while (--n2 >= 0) {
                BS bS2 = (BS)lst.get(n2);
                int n3 = bS2.nextSetBit(0);
                while (n3 >= 0) {
                    SmilesAtom smilesAtom = smilesAtomArray[n3];
                    if (!smilesAtom.isAromatic && smilesAtom.elementNumber != -2 && smilesAtom.elementNumber != 0) {
                        smilesAtom.setSymbol(smilesAtom.symbol.toLowerCase());
                    }
                    n3 = bS2.nextSetBit(n3 + 1);
                }
            }
        }
    }

    void getSelections() {
        Map<String, Object> map = this.top.htNested;
        if (map == null || this.targetAtoms.length == 0) {
            return;
        }
        Hashtable<String, BS> hashtable = new Hashtable<String, BS>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            BS bS;
            String string = entry.getValue().toString();
            if (!string.startsWith("select")) continue;
            BS bS2 = bS = hashtable.containsKey(string) ? (BS)hashtable.get(string) : this.targetAtoms[0].findAtomsLike(string.substring(6));
            if (bS == null) {
                bS = new BS();
            }
            hashtable.put(string, bS);
            entry.setValue(bS);
        }
    }

    Node findImplicitHydrogen(Node node) {
        Edge[] edgeArray = node.getEdges();
        int n = edgeArray.length;
        while (--n >= 0) {
            int n2 = node.getBondedAtomIndex(n);
            if (this.targetAtoms[n2].getElementNumber() != 1 || this.bsFound.get(n2)) continue;
            return this.targetAtoms[n2];
        }
        return null;
    }

    public String toString() {
        SB sB = new SB().append(this.pattern);
        sB.append("\nmolecular formula: " + this.getMolecularFormula(true, null, false));
        return sB.toString();
    }
}

