/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import javajs.util.SB;
import org.jmol.jvxl.readers.MapFileReader;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.util.Logger;

class MrcBinaryReader
extends MapFileReader {
    protected String[] labels;
    private static byte[] b8 = new byte[8];

    MrcBinaryReader() {
    }

    @Override
    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        String string = (String)((Object[])surfaceGenerator.getReaderData())[0];
        this.init2MFR(surfaceGenerator, bufferedReader);
        this.binarydoc = this.newBinaryDocument();
        this.setStream(string, true);
        this.nSurfaces = 1;
        if (this.params.thePlane == null) {
            this.params.insideOut = !this.params.insideOut;
        }
        this.allowSigma = true;
    }

    @Override
    protected void readParameters() throws Exception {
        byte[] byArray = new byte[100];
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = new byte[4];
        this.n0 = this.binarydoc.readInt();
        if (this.n0 < 0 || this.n0 > 256) {
            this.setStream(null, false);
            this.n0 = this.binarydoc.swapBytesI(this.n0);
            if (this.n0 < 0 || this.n0 > 1000) {
                Logger.info("nx=" + this.n0 + " not displayable as MRC file");
                throw new Exception("MRC file type not readable");
            }
            Logger.info("reading little-endian MRC file");
        }
        this.n1 = this.binarydoc.readInt();
        this.n2 = this.binarydoc.readInt();
        this.mode = this.binarydoc.readInt();
        if (this.mode < 0 || this.mode > 6) {
            this.setStream(null, false);
            this.n0 = this.binarydoc.swapBytesI(this.n0);
            this.n1 = this.binarydoc.swapBytesI(this.n1);
            this.n2 = this.binarydoc.swapBytesI(this.n2);
            this.mode = this.binarydoc.swapBytesI(this.mode);
        }
        Logger.info("MRC header: mode: " + this.mode);
        Logger.info("MRC header: nx ny nz: " + this.n0 + " " + this.n1 + " " + this.n2);
        this.xyzStart[0] = this.binarydoc.readInt();
        this.xyzStart[1] = this.binarydoc.readInt();
        this.xyzStart[2] = this.binarydoc.readInt();
        Logger.info("MRC header: nxyzStart: " + this.xyzStart[0] + " " + this.xyzStart[1] + " " + this.xyzStart[2]);
        this.na = this.binarydoc.readInt();
        this.nb = this.binarydoc.readInt();
        this.nc = this.binarydoc.readInt();
        if (this.na == 0) {
            this.na = this.n0 - 1;
        }
        if (this.nb == 0) {
            this.nb = this.n1 - 1;
        }
        if (this.nc == 0) {
            this.nc = this.n2 - 1;
        }
        Logger.info("MRC header: na nb nc: " + this.na + " " + this.nb + " " + this.nc);
        this.a = this.binarydoc.readFloat();
        this.b = this.binarydoc.readFloat();
        this.c = this.binarydoc.readFloat();
        this.alpha = this.binarydoc.readFloat();
        this.beta = this.binarydoc.readFloat();
        this.gamma = this.binarydoc.readFloat();
        if (this.alpha == 0.0f) {
            this.gamma = 90.0f;
            this.beta = 90.0f;
            this.alpha = 90.0f;
            Logger.info("MRC header: alpha,beta,gamma 0 changed to 90,90,90");
            Logger.info("MRC header: alpha,beta,gamma 0 reversing insideOut sense");
            if (this.params.thePlane == null) {
                this.params.insideOut = !this.params.insideOut;
            }
        }
        this.mapc = this.binarydoc.readInt();
        this.mapr = this.binarydoc.readInt();
        this.maps = this.binarydoc.readInt();
        if (this.mapc == 2 && this.mapr == 1 && this.params.thePlane == null) {
            this.params.insideOut = !this.params.insideOut;
        }
        String string = "" + this.mapc + this.mapr + this.maps;
        Logger.info("MRC header: mapc mapr maps: " + string);
        if (this.params.thePlane == null && "21321".indexOf(string) >= 1) {
            Logger.info("MRC header: data are xy-reversed");
            this.params.dataXYReversed = true;
        }
        this.dmin = this.binarydoc.readFloat();
        this.dmax = this.binarydoc.readFloat();
        this.dmean = this.binarydoc.readFloat();
        Logger.info("MRC header: dmin,dmax,dmean: " + this.dmin + "," + this.dmax + "," + this.dmean);
        int n = this.binarydoc.readInt();
        int n2 = this.binarydoc.readInt();
        Logger.info("MRC header: ispg,nsymbt: " + n + "," + n2);
        this.binarydoc.readByteArray(byArray, 0, byArray.length);
        this.origin.x = this.binarydoc.readFloat();
        this.origin.y = this.binarydoc.readFloat();
        this.origin.z = this.binarydoc.readFloat();
        Logger.info("MRC header: origin: " + this.origin);
        this.binarydoc.readByteArray(byArray2, 0, byArray2.length);
        this.binarydoc.readByteArray(byArray3, 0, byArray3.length);
        float f = this.binarydoc.readFloat();
        Logger.info("MRC header: rms: " + f);
        int n3 = this.binarydoc.readInt();
        Logger.info("MRC header: labels: " + n3);
        this.labels = new String[n3];
        if (n3 > 0) {
            this.labels[0] = "Jmol MrcBinaryReader";
        }
        int n4 = 0;
        while (n4 < 10) {
            string = this.binarydoc.readString(80).trim();
            if (n4 < n3) {
                this.labels[n4] = string;
                Logger.info(this.labels[n4]);
            }
            ++n4;
        }
        n4 = 0;
        while (n4 < n2) {
            long l = this.binarydoc.getPosition();
            string = this.binarydoc.readString(80).trim();
            if (string.indexOf(0) != string.lastIndexOf(0)) {
                Logger.error("File indicates " + n2 + " symmetry lines, but " + n4 + " found!");
                this.binarydoc.seek(l);
                break;
            }
            Logger.info("MRC file symmetry information: " + string);
            n4 += 80;
        }
        Logger.info("MRC header: bytes read: " + this.binarydoc.getPosition() + "\n");
        this.getVectorsAndOrigin();
        if (this.params.thePlane == null && (this.params.cutoffAutomatic || !Float.isNaN(this.params.sigma))) {
            float f2 = this.params.sigma < 0.0f || Float.isNaN(this.params.sigma) ? 1.0f : this.params.sigma;
            this.params.cutoff = f * f2 + this.dmean;
            Logger.info("Cutoff set to (mean + rmsDeviation*" + f2 + " = " + this.params.cutoff + ")\n");
        }
        this.jvxlFileHeaderBuffer = new SB();
        this.jvxlFileHeaderBuffer.append("MRC DATA ").append(n3 > 0 ? this.labels[0] : "").append("\n");
        this.jvxlFileHeaderBuffer.append("see http://ami.scripps.edu/software/mrctools/mrc_specification.php\n");
    }

    @Override
    protected float nextVoxel() throws Exception {
        float f;
        switch (this.mode) {
            case 0: {
                f = this.binarydoc.readByte();
                break;
            }
            case 1: {
                f = this.binarydoc.readShort();
                break;
            }
            default: {
                f = this.binarydoc.readFloat();
                break;
            }
            case 3: {
                f = this.binarydoc.readShort();
                this.binarydoc.readShort();
                break;
            }
            case 4: {
                f = this.binarydoc.readFloat();
                this.binarydoc.readFloat();
                break;
            }
            case 6: {
                f = this.binarydoc.readUnsignedShort();
            }
        }
        this.nBytes = this.binarydoc.getPosition();
        return f;
    }

    @Override
    protected void skipData(int n) throws Exception {
        int n2 = 0;
        while (n2 < n) {
            switch (this.mode) {
                case 0: {
                    this.binarydoc.readByte();
                    break;
                }
                case 1: 
                case 6: {
                    this.binarydoc.readByteArray(b8, 0, 2);
                    break;
                }
                default: {
                    this.binarydoc.readByteArray(b8, 0, 4);
                    break;
                }
                case 4: {
                    this.binarydoc.readByteArray(b8, 0, 8);
                }
            }
            ++n2;
        }
    }
}

