/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.scratch;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.core.script.ModuleNameFileAttributeKt;
import org.jetbrains.kotlin.idea.core.script.ScriptDependenciesModificationTracker;
import org.jetbrains.kotlin.idea.scratch.ScratchUtilsKt;
import org.jetbrains.kotlin.idea.scratch.ui.ScratchTopPanel;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.parsing.KotlinParserDefinition;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000bB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\t\u001a\u00020\nH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchFileModuleInfoProvider;", "Lcom/intellij/openapi/components/ProjectComponent;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getProject", "()Lcom/intellij/openapi/project/Project;", "projectOpened", "", "ScratchFileModuleListener", "idea-jvm"})
public final class ScratchFileModuleInfoProvider
implements ProjectComponent {
    private final Logger LOG;
    @NotNull
    private final Project project;

    public void projectOpened() {
        this.project.getMessageBus().connect((Disposable)this.project).subscribe(FileEditorManagerListener.FILE_EDITOR_MANAGER, (Object)new ScratchFileModuleListener());
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public ScratchFileModuleInfoProvider(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        this.project = project;
        Logger logger = Logger.getInstance(this.getClass());
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"Logger.getInstance(this.javaClass)");
        this.LOG = logger;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/scratch/ScratchFileModuleInfoProvider$ScratchFileModuleListener;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "(Lorg/jetbrains/kotlin/idea/scratch/ScratchFileModuleInfoProvider;)V", "fileOpened", "", "source", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "idea-jvm"})
    private final class ScratchFileModuleListener
    implements FileEditorManagerListener {
        public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
            block11: {
                ScratchTopPanel scratchPanel;
                block10: {
                    Module module;
                    Module module2;
                    Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
                    Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
                    if (!file2.isValid()) {
                        return;
                    }
                    if (!ScratchFileService.isInScratchRoot((VirtualFile)file2)) {
                        return;
                    }
                    PsiFile psiFile = PsiManager.getInstance((Project)ScratchFileModuleInfoProvider.this.getProject()).findFile(file2);
                    if (!(psiFile instanceof KtFile)) {
                        psiFile = null;
                    }
                    KtFile ktFile = (KtFile)psiFile;
                    if (ktFile == null) {
                        return;
                    }
                    KtFile ktFile2 = ktFile;
                    if (Intrinsics.areEqual((Object)file2.getExtension(), (Object)"kt")) {
                        ApplicationUtilsKt.runWriteAction((Function0)((Function0)new Function0<Unit>(this, file2){
                            final /* synthetic */ ScratchFileModuleListener this$0;
                            final /* synthetic */ VirtualFile $file;

                            public final void invoke() {
                                String newName = this.$file.getNameWithoutExtension() + KotlinParserDefinition.STD_SCRIPT_EXT;
                                int i = 1;
                                while (this.$file.getParent().findChild(newName) != null) {
                                    newName = this.$file.getNameWithoutExtension() + "_" + i + KotlinParserDefinition.STD_SCRIPT_EXT;
                                    ++i;
                                }
                                this.$file.rename((Object)this.this$0, newName);
                            }
                            {
                                this.this$0 = scratchFileModuleListener;
                                this.$file = virtualFile2;
                                super(0);
                            }
                        }));
                    }
                    if (Intrinsics.areEqual((Object)file2.getExtension(), (Object)KotlinParserDefinition.STD_SCRIPT_SUFFIX) ^ true) {
                        ScratchFileModuleInfoProvider.this.LOG.error("Kotlin Scratch file should have .kts extension. Cannot add scratch panel for " + file2.getPath());
                        return;
                    }
                    Pair<TextEditor, ScratchTopPanel> pair = ScratchUtilsKt.getEditorWithScratchPanel(source, file2);
                    ScratchTopPanel scratchTopPanel = scratchPanel = pair != null ? (ScratchTopPanel)pair.getSecond() : null;
                    if (scratchTopPanel != null) {
                        scratchTopPanel.addModuleListener((Function2<? super PsiFile, ? super Module, Unit>)((Function2)new Function2<PsiFile, Module, Unit>(this){
                            final /* synthetic */ ScratchFileModuleListener this$0;

                            public final void invoke(@NotNull PsiFile psiFile, @NotNull Module module) {
                                Intrinsics.checkParameterIsNotNull((Object)psiFile, (String)"psiFile");
                                Intrinsics.checkParameterIsNotNull((Object)module, (String)"module");
                                VirtualFile virtualFile2 = psiFile.getVirtualFile();
                                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"psiFile.virtualFile");
                                ModuleNameFileAttributeKt.setScriptRelatedModuleName((VirtualFile)virtualFile2, (String)module.getName());
                                ScriptDependenciesModificationTracker.Companion.getInstance(this.this$0.ScratchFileModuleInfoProvider.this.getProject()).incModificationCount();
                                DaemonCodeAnalyzer.getInstance((Project)this.this$0.ScratchFileModuleInfoProvider.this.getProject()).restart(psiFile);
                            }
                            {
                                this.this$0 = scratchFileModuleListener;
                                super(2);
                            }
                        }));
                    }
                    VirtualFile virtualFile2 = ktFile2.getVirtualFile();
                    Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile2, (String)"ktFile.virtualFile");
                    String string = ModuleNameFileAttributeKt.getScriptRelatedModuleName((VirtualFile)virtualFile2);
                    if (string != null) {
                        String string2;
                        String it = string2 = string;
                        module2 = ModuleManager.getInstance((Project)ScratchFileModuleInfoProvider.this.getProject()).findModuleByName(it);
                    } else {
                        module2 = module = null;
                    }
                    if (module == null) break block10;
                    ScratchTopPanel scratchTopPanel2 = scratchPanel;
                    if (scratchTopPanel2 == null) break block11;
                    scratchTopPanel2.setModule(module);
                    break block11;
                }
                ModuleManager moduleManager = ModuleManager.getInstance((Project)ScratchFileModuleInfoProvider.this.getProject());
                Intrinsics.checkExpressionValueIsNotNull((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                Object[] objectArray = moduleManager.getModules();
                Intrinsics.checkExpressionValueIsNotNull((Object)objectArray, (String)"ModuleManager.getInstance(project).modules");
                Module firstModule = (Module)ArraysKt.firstOrNull((Object[])objectArray);
                if (firstModule == null) break block11;
                ScratchTopPanel scratchTopPanel = scratchPanel;
                if (scratchTopPanel != null) {
                    scratchTopPanel.setModule(firstModule);
                }
            }
        }
    }
}

