/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.evaluate;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.eval4j.Value;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.codegen.ClassBuilderFactories;
import org.jetbrains.kotlin.codegen.ClassBuilderFactory;
import org.jetbrains.kotlin.codegen.state.GenerationState;
import org.jetbrains.kotlin.codegen.state.KotlinTypeMapper;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ModuleDescriptor;
import org.jetbrains.kotlin.idea.ProgressUtilKt;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.debugger.BinaryCacheKey;
import org.jetbrains.kotlin.idea.debugger.BytecodeDebugInfo;
import org.jetbrains.kotlin.idea.debugger.evaluate.FrameVisitor;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches;
import org.jetbrains.kotlin.idea.debugger.evaluate.KotlinEvaluationBuilderKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.classLoading.ClassToLoad;
import org.jetbrains.kotlin.idea.util.application.ApplicationUtilsKt;
import org.jetbrains.kotlin.psi.KtCodeFragment;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.org.objectweb.asm.Type;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001a2\u00020\u0001:\u0004\u001a\u001b\u001c\u001dB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002R@\u0010\u0005\u001a4\u00120\u0012.\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t \u000b*\u0016\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\f\u001a(\u0012$\u0012\"\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e \u000b*\u0010\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\r0\r0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R4\u0010\u000f\u001a(\u0012$\u0012\"\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0010 \u000b*\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0010\u0018\u00010\u00070\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R8\u0010\u0011\u001a,\u0012(\u0012&\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u0014 \u000b*\u0012\u0012\u0004\u0012\u00020\u0013\u0012\u0006\u0012\u0004\u0018\u00010\u0014\u0018\u00010\u00120\u00120\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "cachedClassNames", "Lcom/intellij/psi/util/CachedValue;", "", "Lcom/intellij/psi/PsiElement;", "", "", "kotlin.jvm.PlatformType", "cachedCompiledData", "Lcom/intellij/util/containers/MultiMap;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$CompiledDataDescriptor;", "cachedTypeMappers", "Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;", "debugInfoCache", "Ljava/util/concurrent/ConcurrentMap;", "Lorg/jetbrains/kotlin/idea/debugger/BinaryCacheKey;", "Lorg/jetbrains/kotlin/idea/debugger/BytecodeDebugInfo;", "canBeEvaluatedInThisContext", "", "compiledData", "context", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "Companion", "CompiledDataDescriptor", "ComputedClassNames", "Parameter", "idea-jvm"})
public final class KotlinDebuggerCaches {
    private final CachedValue<MultiMap<String, CompiledDataDescriptor>> cachedCompiledData;
    private final CachedValue<Map<PsiElement, List<String>>> cachedClassNames;
    private final CachedValue<Map<PsiElement, KotlinTypeMapper>> cachedTypeMappers;
    private final CachedValue<ConcurrentMap<BinaryCacheKey, BytecodeDebugInfo>> debugInfoCache;
    private static final Logger LOG;
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    private final boolean canBeEvaluatedInThisContext(CompiledDataDescriptor compiledData2, EvaluationContextImpl context) {
        boolean bl;
        block6: {
            FrameVisitor frameVisitor = new FrameVisitor(context);
            Iterable $receiver$iv = compiledData2.getParameters();
            if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $receiver$iv) {
                    boolean bl2;
                    void name;
                    Parameter p;
                    Parameter parameter = p = (Parameter)element$iv;
                    String string = parameter.component1();
                    KotlinType jetType = parameter.component2();
                    Value value = frameVisitor.findValue((String)name, null, false, false);
                    if (value == null) {
                        bl2 = false;
                    } else {
                        Type type = value.getAsmType();
                        DebugProcessImpl debugProcessImpl = context.getDebugProcess();
                        Intrinsics.checkExpressionValueIsNotNull((Object)debugProcessImpl, (String)"context.debugProcess");
                        GlobalSearchScope globalSearchScope = debugProcessImpl.getSearchScope();
                        Intrinsics.checkExpressionValueIsNotNull((Object)globalSearchScope, (String)"context.debugProcess.searchScope");
                        ClassDescriptor thisDescriptor = KotlinEvaluationBuilderKt.getClassDescriptor(type, globalSearchScope);
                        ClassifierDescriptor classifierDescriptor = jetType.getConstructor().getDeclarationDescriptor();
                        if (!(classifierDescriptor instanceof ClassDescriptor)) {
                            classifierDescriptor = null;
                        }
                        ClassDescriptor superClassDescriptor = (ClassDescriptor)classifierDescriptor;
                        bl2 = thisDescriptor != null && superClassDescriptor != null && (Boolean)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(thisDescriptor, superClassDescriptor){
                            final /* synthetic */ ClassDescriptor $thisDescriptor;
                            final /* synthetic */ ClassDescriptor $superClassDescriptor;

                            public final boolean invoke() {
                                return DescriptorUtils.isSubclass((ClassDescriptor)this.$thisDescriptor, (ClassDescriptor)this.$superClassDescriptor);
                            }
                            {
                                this.$thisDescriptor = classDescriptor;
                                this.$superClassDescriptor = classDescriptor2;
                                super(0);
                            }
                        })) != false;
                    }
                    if (bl2) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return bl;
    }

    public KotlinDebuggerCaches(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        CachedValue cachedValue = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)cachedCompiledData.1.INSTANCE, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)cachedValue, (String)"CachedValuesManager.getM\u2026NT)\n            }, false)");
        this.cachedCompiledData = cachedValue;
        CachedValue cachedValue2 = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)cachedClassNames.1.INSTANCE, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)cachedValue2, (String)"CachedValuesManager.getM\u2026NT)\n            }, false)");
        this.cachedClassNames = cachedValue2;
        CachedValue cachedValue3 = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)cachedTypeMappers.1.INSTANCE, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)cachedValue3, (String)"CachedValuesManager.getM\u2026NT)\n            }, false)");
        this.cachedTypeMappers = cachedValue3;
        CachedValue cachedValue4 = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)debugInfoCache.1.INSTANCE, false);
        Intrinsics.checkExpressionValueIsNotNull((Object)cachedValue4, (String)"CachedValuesManager.getM\u2026NT)\n            }, false)");
        this.debugInfoCache = cachedValue4;
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getLogger(KotlinDebuggerCaches.class);
        if (logger == null) {
            Intrinsics.throwNpe();
        }
        LOG = logger;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\u0002\u0010\tJ\u000f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0006H\u00c6\u0003J\u000f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0003J3\u0010\u0012\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003H\u00c6\u0001J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$CompiledDataDescriptor;", "", "classes", "", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/classLoading/ClassToLoad;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "parameters", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$Parameter;", "(Ljava/util/List;Lcom/intellij/debugger/SourcePosition;Ljava/util/List;)V", "getClasses", "()Ljava/util/List;", "getParameters", "getSourcePosition", "()Lcom/intellij/debugger/SourcePosition;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "idea-jvm"})
    public static final class CompiledDataDescriptor {
        @NotNull
        private final List<ClassToLoad> classes;
        @NotNull
        private final SourcePosition sourcePosition;
        @NotNull
        private final List<Parameter> parameters;

        @NotNull
        public final List<ClassToLoad> getClasses() {
            return this.classes;
        }

        @NotNull
        public final SourcePosition getSourcePosition() {
            return this.sourcePosition;
        }

        @NotNull
        public final List<Parameter> getParameters() {
            return this.parameters;
        }

        public CompiledDataDescriptor(@NotNull List<ClassToLoad> classes, @NotNull SourcePosition sourcePosition, @NotNull List<Parameter> parameters) {
            Intrinsics.checkParameterIsNotNull(classes, (String)"classes");
            Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
            Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
            this.classes = classes;
            this.sourcePosition = sourcePosition;
            this.parameters = parameters;
        }

        @NotNull
        public final List<ClassToLoad> component1() {
            return this.classes;
        }

        @NotNull
        public final SourcePosition component2() {
            return this.sourcePosition;
        }

        @NotNull
        public final List<Parameter> component3() {
            return this.parameters;
        }

        @NotNull
        public final CompiledDataDescriptor copy(@NotNull List<ClassToLoad> classes, @NotNull SourcePosition sourcePosition, @NotNull List<Parameter> parameters) {
            Intrinsics.checkParameterIsNotNull(classes, (String)"classes");
            Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
            Intrinsics.checkParameterIsNotNull(parameters, (String)"parameters");
            return new CompiledDataDescriptor(classes, sourcePosition, parameters);
        }

        @NotNull
        public static /* synthetic */ CompiledDataDescriptor copy$default(CompiledDataDescriptor compiledDataDescriptor, List list2, SourcePosition sourcePosition, List list3, int n, Object object) {
            if ((n & 1) != 0) {
                list2 = compiledDataDescriptor.classes;
            }
            if ((n & 2) != 0) {
                sourcePosition = compiledDataDescriptor.sourcePosition;
            }
            if ((n & 4) != 0) {
                list3 = compiledDataDescriptor.parameters;
            }
            return compiledDataDescriptor.copy(list2, sourcePosition, list3);
        }

        @NotNull
        public String toString() {
            return "CompiledDataDescriptor(classes=" + this.classes + ", sourcePosition=" + this.sourcePosition + ", parameters=" + this.parameters + ")";
        }

        public int hashCode() {
            List<ClassToLoad> list2 = this.classes;
            SourcePosition sourcePosition = this.sourcePosition;
            List<Parameter> list3 = this.parameters;
            return ((list2 != null ? ((Object)list2).hashCode() : 0) * 31 + (sourcePosition != null ? sourcePosition.hashCode() : 0)) * 31 + (list3 != null ? ((Object)list3).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CompiledDataDescriptor)) break block3;
                    CompiledDataDescriptor compiledDataDescriptor = (CompiledDataDescriptor)object;
                    if (!Intrinsics.areEqual(this.classes, compiledDataDescriptor.classes) || !Intrinsics.areEqual((Object)this.sourcePosition, (Object)compiledDataDescriptor.sourcePosition) || !Intrinsics.areEqual(this.parameters, compiledDataDescriptor.parameters)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\u000b\u0010\u0016\u001a\u0004\u0018\u00010\tH\u00c6\u0003J5\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$Parameter;", "", "callText", "", "type", "Lorg/jetbrains/kotlin/types/KotlinType;", "value", "Lorg/jetbrains/eval4j/Value;", "error", "Lcom/intellij/debugger/engine/evaluation/EvaluateException;", "(Ljava/lang/String;Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/eval4j/Value;Lcom/intellij/debugger/engine/evaluation/EvaluateException;)V", "getCallText", "()Ljava/lang/String;", "getError", "()Lcom/intellij/debugger/engine/evaluation/EvaluateException;", "getType", "()Lorg/jetbrains/kotlin/types/KotlinType;", "getValue", "()Lorg/jetbrains/eval4j/Value;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "idea-jvm"})
    public static final class Parameter {
        @NotNull
        private final String callText;
        @NotNull
        private final KotlinType type;
        @Nullable
        private final Value value;
        @Nullable
        private final EvaluateException error;

        @NotNull
        public final String getCallText() {
            return this.callText;
        }

        @NotNull
        public final KotlinType getType() {
            return this.type;
        }

        @Nullable
        public final Value getValue() {
            return this.value;
        }

        @Nullable
        public final EvaluateException getError() {
            return this.error;
        }

        public Parameter(@NotNull String callText, @NotNull KotlinType type, @Nullable Value value, @Nullable EvaluateException error2) {
            Intrinsics.checkParameterIsNotNull((Object)callText, (String)"callText");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            this.callText = callText;
            this.type = type;
            this.value = value;
            this.error = error2;
        }

        public /* synthetic */ Parameter(String string, KotlinType kotlinType, Value value, EvaluateException evaluateException, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                value = null;
            }
            if ((n & 8) != 0) {
                evaluateException = null;
            }
            this(string, kotlinType, value, evaluateException);
        }

        @NotNull
        public final String component1() {
            return this.callText;
        }

        @NotNull
        public final KotlinType component2() {
            return this.type;
        }

        @Nullable
        public final Value component3() {
            return this.value;
        }

        @Nullable
        public final EvaluateException component4() {
            return this.error;
        }

        @NotNull
        public final Parameter copy(@NotNull String callText, @NotNull KotlinType type, @Nullable Value value, @Nullable EvaluateException error2) {
            Intrinsics.checkParameterIsNotNull((Object)callText, (String)"callText");
            Intrinsics.checkParameterIsNotNull((Object)type, (String)"type");
            return new Parameter(callText, type, value, error2);
        }

        @NotNull
        public static /* synthetic */ Parameter copy$default(Parameter parameter, String string, KotlinType kotlinType, Value value, EvaluateException evaluateException, int n, Object object) {
            if ((n & 1) != 0) {
                string = parameter.callText;
            }
            if ((n & 2) != 0) {
                kotlinType = parameter.type;
            }
            if ((n & 4) != 0) {
                value = parameter.value;
            }
            if ((n & 8) != 0) {
                evaluateException = parameter.error;
            }
            return parameter.copy(string, kotlinType, value, evaluateException);
        }

        @NotNull
        public String toString() {
            return "Parameter(callText=" + this.callText + ", type=" + this.type + ", value=" + this.value + ", error=" + (Object)((Object)this.error) + ")";
        }

        public int hashCode() {
            String string = this.callText;
            KotlinType kotlinType = this.type;
            Value value = this.value;
            EvaluateException evaluateException = this.error;
            return (((string != null ? string.hashCode() : 0) * 31 + (kotlinType != null ? kotlinType.hashCode() : 0)) * 31 + (value != null ? value.hashCode() : 0)) * 31 + (evaluateException != null ? ((Object)((Object)evaluateException)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Parameter)) break block3;
                    Parameter parameter = (Parameter)object;
                    if (!Intrinsics.areEqual((Object)this.callText, (Object)parameter.callText) || !Intrinsics.areEqual((Object)this.type, (Object)parameter.type) || !Intrinsics.areEqual((Object)this.value, (Object)parameter.value) || !Intrinsics.areEqual((Object)((Object)this.error), (Object)((Object)parameter.error))) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u001b\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0006\u0010\f\u001a\u00020\u0000J\u0011\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u0000H\u0086\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "", "classNames", "", "", "shouldBeCached", "", "(Ljava/util/List;Z)V", "getClassNames", "()Ljava/util/List;", "getShouldBeCached", "()Z", "distinct", "plus", "other", "Companion", "idea-jvm"})
    public static final class ComputedClassNames {
        @NotNull
        private final List<String> classNames;
        private final boolean shouldBeCached;
        @NotNull
        private static final ComputedClassNames EMPTY;
        public static final Companion Companion;

        @NotNull
        public final ComputedClassNames distinct() {
            return new ComputedClassNames(CollectionsKt.distinct((Iterable)this.classNames), this.shouldBeCached);
        }

        @NotNull
        public final ComputedClassNames plus(@NotNull ComputedClassNames other) {
            Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
            return new ComputedClassNames(CollectionsKt.plus((Collection)this.classNames, (Iterable)other.classNames), this.shouldBeCached && other.shouldBeCached);
        }

        @NotNull
        public final List<String> getClassNames() {
            return this.classNames;
        }

        public final boolean getShouldBeCached() {
            return this.shouldBeCached;
        }

        public ComputedClassNames(@NotNull List<String> classNames, boolean shouldBeCached) {
            Intrinsics.checkParameterIsNotNull(classNames, (String)"classNames");
            this.classNames = classNames;
            this.shouldBeCached = shouldBeCached;
        }

        static {
            Companion = new Companion(null);
            EMPTY = Companion.Cached(CollectionsKt.emptyList());
        }

        @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\b\u001a\u00020\tJ\u0014\u0010\u0007\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bJ\u0014\u0010\f\u001a\u00020\u00042\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u000bR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames$Companion;", "", "()V", "EMPTY", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "getEMPTY", "()Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "Cached", "className", "", "classNames", "", "NonCached", "idea-jvm"})
        public static final class Companion {
            @NotNull
            public final ComputedClassNames getEMPTY() {
                return EMPTY;
            }

            @NotNull
            public final ComputedClassNames Cached(@NotNull List<String> classNames) {
                Intrinsics.checkParameterIsNotNull(classNames, (String)"classNames");
                return new ComputedClassNames(classNames, true);
            }

            @NotNull
            public final ComputedClassNames Cached(@NotNull String className) {
                Intrinsics.checkParameterIsNotNull((Object)className, (String)"className");
                List<String> list2 = Collections.singletonList(className);
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.singletonList(className)");
                return new ComputedClassNames(list2, true);
            }

            @NotNull
            public final ComputedClassNames NonCached(@NotNull List<String> classNames) {
                Intrinsics.checkParameterIsNotNull(classNames, (String)"classNames");
                return new ComputedClassNames(classNames, false);
            }

            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0018\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0012\u0010\u0012\u001a\u00020\u00102\b\u0010\u000f\u001a\u0004\u0018\u00010\u0013H\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017J9\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019\"\b\b\u0000\u0010\u001b*\u00020\u00132\b\u0010\u001c\u001a\u0004\u0018\u0001H\u001b2\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u0002H\u001b\u0012\u0004\u0012\u00020\u001f0\u001e\u00a2\u0006\u0002\u0010 J8\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0018\u0010\u001d\u001a\u0014\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020\"0)J\u000e\u0010*\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u0013J \u0010+\u001a\u0004\u0018\u00010,2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010-\u001a\u00020.2\u0006\u0010\u0007\u001a\u00020/R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$Companion;", "", "()V", "LOG", "Lorg/apache/log4j/Logger;", "addTypeMapper", "", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "typeMapper", "Lorg/jetbrains/kotlin/codegen/state/KotlinTypeMapper;", "createTypeMapper", "analysisResult", "Lorg/jetbrains/kotlin/analyzer/AnalysisResult;", "createTypeMapperForLibraryFile", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "createTypeMapperForSourceFile", "getElementToCreateTypeMapperForLibraryFile", "Lcom/intellij/psi/PsiElement;", "getInstance", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches;", "project", "Lcom/intellij/openapi/project/Project;", "getOrComputeClassNames", "", "", "T", "psiElement", "create", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$ComputedClassNames;", "(Lcom/intellij/psi/PsiElement;Lkotlin/jvm/functions/Function1;)Ljava/util/List;", "getOrCreateCompiledData", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/KotlinDebuggerCaches$CompiledDataDescriptor;", "codeFragment", "Lorg/jetbrains/kotlin/psi/KtCodeFragment;", "sourcePosition", "Lcom/intellij/debugger/SourcePosition;", "evaluationContext", "Lcom/intellij/debugger/engine/evaluation/EvaluationContextImpl;", "Lkotlin/Function2;", "getOrCreateTypeMapper", "getOrReadDebugInfoFromBytecode", "Lorg/jetbrains/kotlin/idea/debugger/BytecodeDebugInfo;", "jvmName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "Lcom/intellij/openapi/vfs/VirtualFile;", "idea-jvm"})
    public static final class Companion {
        @NotNull
        public final KotlinDebuggerCaches getInstance(@NotNull Project project) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Object object = ServiceManager.getService((Project)project, KotlinDebuggerCaches.class);
            if (object == null) {
                Intrinsics.throwNpe();
            }
            return (KotlinDebuggerCaches)object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NotNull
        public final CompiledDataDescriptor getOrCreateCompiledData(@NotNull KtCodeFragment codeFragment, @NotNull SourcePosition sourcePosition, @NotNull EvaluationContextImpl evaluationContext, @NotNull Function2<? super KtCodeFragment, ? super SourcePosition, CompiledDataDescriptor> create2) {
            Object v3;
            Object object;
            String text2;
            KotlinDebuggerCaches evaluateExpressionCache;
            block9: {
                Intrinsics.checkParameterIsNotNull((Object)codeFragment, (String)"codeFragment");
                Intrinsics.checkParameterIsNotNull((Object)sourcePosition, (String)"sourcePosition");
                Intrinsics.checkParameterIsNotNull((Object)evaluationContext, (String)"evaluationContext");
                Intrinsics.checkParameterIsNotNull(create2, (String)"create");
                Project project = codeFragment.getProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"codeFragment.project");
                evaluateExpressionCache = this.getInstance(project);
                text2 = codeFragment.importsToString() + '\n' + codeFragment.getText();
                CachedValue cachedValue = evaluateExpressionCache.cachedCompiledData;
                synchronized (cachedValue) {
                    Object object2 = evaluateExpressionCache.cachedCompiledData.getValue();
                    if (object2 == null) {
                        Intrinsics.throwNpe();
                    }
                    MultiMap cache2 = (MultiMap)object2;
                    Collection collection = cache2.get((Object)text2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)collection, (String)"cache[text]");
                    object = collection;
                }
                Collection cached = object;
                Iterable $receiver$iv = cached;
                for (Object element$iv : $receiver$iv) {
                    CompiledDataDescriptor it = (CompiledDataDescriptor)element$iv;
                    if (!(Intrinsics.areEqual((Object)it.getSourcePosition(), (Object)sourcePosition) || evaluateExpressionCache.canBeEvaluatedInThisContext(it, evaluationContext))) continue;
                    v3 = element$iv;
                    break block9;
                }
                v3 = null;
            }
            CompiledDataDescriptor answer = v3;
            if (answer != null) {
                return answer;
            }
            CompiledDataDescriptor newCompiledData = (CompiledDataDescriptor)create2.invoke((Object)codeFragment, (Object)sourcePosition);
            LOG.debug((Object)("Compile bytecode for " + codeFragment.getText()));
            object = evaluateExpressionCache.cachedCompiledData;
            synchronized (object) {
                ((MultiMap)evaluateExpressionCache.cachedCompiledData.getValue()).putValue((Object)text2, (Object)newCompiledData);
                Unit unit = Unit.INSTANCE;
            }
            return newCompiledData;
        }

        @NotNull
        public final <T extends PsiElement> List<String> getOrComputeClassNames(@Nullable T psiElement, @NotNull Function1<? super T, ComputedClassNames> create2) {
            Intrinsics.checkParameterIsNotNull(create2, (String)"create");
            if (psiElement == null) {
                List<String> list2 = Collections.emptyList();
                Intrinsics.checkExpressionValueIsNotNull(list2, (String)"Collections.emptyList()");
                return list2;
            }
            Object object = ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Project>(psiElement){
                final /* synthetic */ PsiElement $psiElement;

                @NotNull
                public final Project invoke() {
                    return this.$psiElement.getProject();
                }
                {
                    this.$psiElement = psiElement;
                    super(0);
                }
            }));
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"runReadAction { psiElement.project }");
            KotlinDebuggerCaches cache2 = this.getInstance((Project)object);
            Map classNamesCache = (Map)cache2.cachedClassNames.getValue();
            List cachedValue = (List)classNamesCache.get(psiElement);
            if (cachedValue != null) {
                return cachedValue;
            }
            ComputedClassNames computedClassNames = (ComputedClassNames)create2.invoke(psiElement);
            if (computedClassNames.getShouldBeCached()) {
                Map map2 = classNamesCache;
                Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"classNamesCache");
                Map map3 = map2;
                List<String> list3 = computedClassNames.getClassNames();
                map3.put(psiElement, list3);
            }
            return computedClassNames.getClassNames();
        }

        @NotNull
        public final KotlinTypeMapper getOrCreateTypeMapper(@NotNull PsiElement psiElement) {
            KotlinTypeMapper kotlinTypeMapper;
            Intrinsics.checkParameterIsNotNull((Object)psiElement, (String)"psiElement");
            Object object = ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<Project>(psiElement){
                final /* synthetic */ PsiElement $psiElement;

                @NotNull
                public final Project invoke() {
                    return this.$psiElement.getProject();
                }
                {
                    this.$psiElement = psiElement;
                    super(0);
                }
            }));
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"runReadAction { psiElement.project }");
            KotlinDebuggerCaches cache2 = this.getInstance((Project)object);
            KtFile file2 = (KtFile)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<KtFile>(psiElement){
                final /* synthetic */ PsiElement $psiElement;

                @NotNull
                public final KtFile invoke() {
                    PsiFile psiFile = this.$psiElement.getContainingFile();
                    if (psiFile == null) {
                        throw new TypeCastException("null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
                    }
                    return (KtFile)psiFile;
                }
                {
                    this.$psiElement = psiElement;
                    super(0);
                }
            }));
            boolean isInLibrary2 = ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<OrderEntry>(file2){
                final /* synthetic */ KtFile $file;

                @Nullable
                public final OrderEntry invoke() {
                    return LibraryUtil.findLibraryEntry((VirtualFile)this.$file.getVirtualFile(), (Project)this.$file.getProject());
                }
                {
                    this.$file = ktFile;
                    super(0);
                }
            })) != null;
            PsiElement key = !isInLibrary2 ? (PsiElement)file2 : psiElement;
            Map typeMappersCache = (Map)cache2.cachedTypeMappers.getValue();
            KotlinTypeMapper cachedValue = (KotlinTypeMapper)typeMappersCache.get(key);
            if (cachedValue != null) {
                return cachedValue;
            }
            if (!isInLibrary2) {
                kotlinTypeMapper = this.createTypeMapperForSourceFile(file2);
            } else {
                KtElement element = this.getElementToCreateTypeMapperForLibraryFile(psiElement);
                kotlinTypeMapper = this.createTypeMapperForLibraryFile(element, file2);
            }
            KotlinTypeMapper newValue = kotlinTypeMapper;
            Map map2 = typeMappersCache;
            Intrinsics.checkExpressionValueIsNotNull((Object)map2, (String)"typeMappersCache");
            Map map3 = map2;
            KotlinTypeMapper kotlinTypeMapper2 = newValue;
            map3.put(key, kotlinTypeMapper2);
            return newValue;
        }

        @Nullable
        public final BytecodeDebugInfo getOrReadDebugInfoFromBytecode(@NotNull Project project, @NotNull JvmClassName jvmName, @NotNull VirtualFile file2) {
            Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
            Intrinsics.checkParameterIsNotNull((Object)jvmName, (String)"jvmName");
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            KotlinDebuggerCaches cache2 = this.getInstance(project);
            return (BytecodeDebugInfo)((ConcurrentMap)cache2.debugInfoCache.getValue()).get(new BinaryCacheKey(project, jvmName, file2));
        }

        private final KtElement getElementToCreateTypeMapperForLibraryFile(PsiElement element) {
            return (KtElement)ApplicationUtilsKt.runReadAction((Function0)((Function0)new Function0<KtElement>(element){
                final /* synthetic */ PsiElement $element;

                @NotNull
                public final KtElement invoke() {
                    KtElement ktElement;
                    PsiElement psiElement = this.$element;
                    if (!(psiElement instanceof KtElement)) {
                        psiElement = null;
                    }
                    if ((ktElement = (KtElement)psiElement) == null) {
                        PsiElement psiElement2 = PsiTreeUtil.getParentOfType((PsiElement)this.$element, KtElement.class);
                        if (psiElement2 == null) {
                            Intrinsics.throwNpe();
                        }
                        Intrinsics.checkExpressionValueIsNotNull((Object)psiElement2, (String)"PsiTreeUtil.getParentOfT\u2026 KtElement::class.java)!!");
                        ktElement = (KtElement)psiElement2;
                    }
                    return ktElement;
                }
                {
                    this.$element = psiElement;
                    super(0);
                }
            }));
        }

        private final KotlinTypeMapper createTypeMapperForLibraryFile(KtElement element, KtFile file2) {
            return (KotlinTypeMapper)ProgressUtilKt.runInReadActionWithWriteActionPriorityWithPCE((Function0)((Function0)new Function0<KotlinTypeMapper>(file2, element){
                final /* synthetic */ KtFile $file;
                final /* synthetic */ KtElement $element;

                @NotNull
                public final KotlinTypeMapper invoke() {
                    return org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches$Companion.access$createTypeMapper(KotlinDebuggerCaches.Companion, this.$file, ResolutionUtils.analyzeAndGetResult((KtElement)this.$element));
                }
                {
                    this.$file = ktFile;
                    this.$element = ktElement;
                    super(0);
                }
            }));
        }

        private final KotlinTypeMapper createTypeMapperForSourceFile(KtFile file2) {
            return (KotlinTypeMapper)ProgressUtilKt.runInReadActionWithWriteActionPriorityWithPCE((Function0)((Function0)new Function0<KotlinTypeMapper>(file2){
                final /* synthetic */ KtFile $file;

                @NotNull
                public final KotlinTypeMapper invoke() {
                    AnalysisResult analysisResult = ResolutionUtils.analyzeWithAllCompilerChecks((KtFile)this.$file, (KtFile[])new KtFile[0]);
                    KtFile ktFile = this.$file;
                    Companion companion = KotlinDebuggerCaches.Companion;
                    AnalysisResult p1 = analysisResult;
                    p1.throwIfError();
                    AnalysisResult analysisResult2 = analysisResult;
                    return org.jetbrains.kotlin.idea.debugger.evaluate.KotlinDebuggerCaches$Companion.access$createTypeMapper(companion, ktFile, analysisResult2);
                }
                {
                    this.$file = ktFile;
                    super(0);
                }
            }));
        }

        private final KotlinTypeMapper createTypeMapper(KtFile file2, AnalysisResult analysisResult) {
            Project project = file2.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            ClassBuilderFactory classBuilderFactory = ClassBuilderFactories.THROW_EXCEPTION;
            Intrinsics.checkExpressionValueIsNotNull((Object)classBuilderFactory, (String)"ClassBuilderFactories.THROW_EXCEPTION");
            ModuleDescriptor moduleDescriptor = analysisResult.getModuleDescriptor();
            BindingContext bindingContext2 = analysisResult.getBindingContext();
            List list2 = CollectionsKt.listOf((Object)file2);
            CompilerConfiguration compilerConfiguration = CompilerConfiguration.EMPTY;
            Intrinsics.checkExpressionValueIsNotNull((Object)compilerConfiguration, (String)"CompilerConfiguration.EMPTY");
            GenerationState state = new GenerationState.Builder(project, classBuilderFactory, moduleDescriptor, bindingContext2, list2, compilerConfiguration).build();
            state.beforeCompile();
            return state.getTypeMapper();
        }

        public final void addTypeMapper(@NotNull KtFile file2, @NotNull KotlinTypeMapper typeMapper) {
            Intrinsics.checkParameterIsNotNull((Object)file2, (String)"file");
            Intrinsics.checkParameterIsNotNull((Object)typeMapper, (String)"typeMapper");
            Project project = file2.getProject();
            Intrinsics.checkExpressionValueIsNotNull((Object)project, (String)"file.project");
            Object object = this.getInstance(project).cachedTypeMappers.getValue();
            Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"getInstance(file.project).cachedTypeMappers.value");
            Map map2 = (Map)object;
            KotlinTypeMapper kotlinTypeMapper = typeMapper;
            map2.put(file2, kotlinTypeMapper);
        }

        private Companion() {
        }

        public static final /* synthetic */ KotlinTypeMapper access$createTypeMapper(Companion $this, KtFile file2, AnalysisResult analysisResult) {
            return $this.createTypeMapper(file2, analysisResult);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

