/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.testfixtures.internal;

import java.io.File;
import java.util.Collections;
import org.gradle.api.Project;
import org.gradle.api.artifacts.component.BuildIdentifier;
import org.gradle.api.artifacts.component.ProjectComponentIdentifier;
import org.gradle.api.internal.AsmBackedClassGenerator;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.api.internal.artifacts.DefaultBuildIdentifier;
import org.gradle.api.internal.artifacts.DefaultProjectComponentIdentifier;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.TmpDirTemporaryFileProvider;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.project.DefaultProject;
import org.gradle.api.internal.project.IProjectFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectStateRegistry;
import org.gradle.groovy.scripts.StringScriptSource;
import org.gradle.initialization.DefaultBuildCancellationToken;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.initialization.DefaultProjectDescriptor;
import org.gradle.initialization.DefaultProjectDescriptorRegistry;
import org.gradle.initialization.LegacyTypesSupport;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.internal.FileUtils;
import org.gradle.internal.build.AbstractBuildState;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.BuildStateRegistry;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.logging.services.LoggingServiceRegistry;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.resources.DefaultResourceLockCoordinationService;
import org.gradle.internal.resources.ResourceLockCoordinationService;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.internal.service.scopes.BuildSessionScopeServices;
import org.gradle.internal.service.scopes.BuildTreeScopeServices;
import org.gradle.internal.service.scopes.CrossBuildSessionScopeServices;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.internal.time.Time;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.invocation.DefaultGradle;
import org.gradle.testfixtures.internal.TestBuildScopeServices;
import org.gradle.testfixtures.internal.TestGlobalScopeServices;
import org.gradle.util.Path;

public class ProjectBuilderImpl {
    private static ServiceRegistry globalServices;
    private static final AsmBackedClassGenerator CLASS_GENERATOR;

    public Project createChildProject(String name, Project parent, File projectDir) {
        ProjectInternal parentProject = (ProjectInternal)parent;
        projectDir = projectDir != null ? projectDir.getAbsoluteFile() : new File(parentProject.getProjectDir(), name);
        DefaultProject project = CLASS_GENERATOR.newInstance(DefaultProject.class, name, parentProject, projectDir, new File(projectDir, "build.gradle"), new StringScriptSource("test build file", null), parentProject.getGradle(), parentProject.getGradle().getServiceRegistryFactory(), parentProject.getClassLoaderScope().createChild("project-" + name), parentProject.getBaseClassLoaderScope());
        parentProject.addChildProject(project);
        parentProject.getProjectRegistry().addProject(project);
        BuildState build = project.getServices().get(BuildStateRegistry.class).getBuild(DefaultBuildIdentifier.ROOT);
        project.getServices().get(ProjectStateRegistry.class).register(build, project);
        return project;
    }

    public Project createProject(String name, File inputProjectDir, File gradleUserHomeDir) {
        File projectDir = this.prepareProjectDir(inputProjectDir);
        File homeDir = new File(projectDir, "gradleHome");
        StartParameterInternal startParameter = new StartParameterInternal();
        File userHomeDir = gradleUserHomeDir == null ? new File(projectDir, "userHome") : FileUtils.canonicalize(gradleUserHomeDir);
        startParameter.setGradleUserHomeDir(userHomeDir);
        NativeServices.initialize(userHomeDir);
        DefaultBuildRequestMetaData buildRequestMetaData = new DefaultBuildRequestMetaData(Time.currentTimeMillis());
        CrossBuildSessionScopeServices crossBuildSessionScopeServices = new CrossBuildSessionScopeServices(this.getGlobalServices(), startParameter);
        ServiceRegistry userHomeServices = this.getUserHomeServices(userHomeDir);
        BuildSessionScopeServices buildSessionScopeServices = new BuildSessionScopeServices(userHomeServices, crossBuildSessionScopeServices, startParameter, buildRequestMetaData, ClassPath.EMPTY, new DefaultBuildCancellationToken());
        BuildTreeScopeServices buildTreeScopeServices = new BuildTreeScopeServices((ServiceRegistry)buildSessionScopeServices);
        TestBuildScopeServices topLevelRegistry = new TestBuildScopeServices((ServiceRegistry)buildTreeScopeServices, homeDir);
        TestRootBuild build = new TestRootBuild();
        topLevelRegistry.add(BuildState.class, build);
        GradleInternal gradle = CLASS_GENERATOR.newInstance(DefaultGradle.class, null, startParameter, topLevelRegistry.get(ServiceRegistryFactory.class));
        gradle.setIncludedBuilds(Collections.emptyList());
        DefaultProjectDescriptor projectDescriptor = new DefaultProjectDescriptor(null, name, projectDir, new DefaultProjectDescriptorRegistry(), topLevelRegistry.get(FileResolver.class));
        ClassLoaderScope baseScope = gradle.getClassLoaderScope();
        ClassLoaderScope rootProjectScope = baseScope.createChild("root-project");
        ProjectInternal project = topLevelRegistry.get(IProjectFactory.class).createProject(projectDescriptor, null, gradle, rootProjectScope, baseScope);
        project.getServices().get(BuildStateRegistry.class).register(build);
        project.getServices().get(ProjectStateRegistry.class).register(build, project);
        gradle.setRootProject(project);
        gradle.setDefaultProject(project);
        ResourceLockCoordinationService coordinationService = topLevelRegistry.get(ResourceLockCoordinationService.class);
        WorkerLeaseService workerLeaseService = topLevelRegistry.get(WorkerLeaseService.class);
        coordinationService.withStateLock(DefaultResourceLockCoordinationService.lock(workerLeaseService.getWorkerLease()));
        return project;
    }

    private ServiceRegistry getUserHomeServices(File userHomeDir) {
        ServiceRegistry globalServices = this.getGlobalServices();
        GradleUserHomeScopeServiceRegistry userHomeScopeServiceRegistry = globalServices.get(GradleUserHomeScopeServiceRegistry.class);
        return userHomeScopeServiceRegistry.getServicesFor(userHomeDir);
    }

    private ServiceRegistry getGlobalServices() {
        if (globalServices == null) {
            globalServices = ServiceRegistryBuilder.builder().displayName("global services").parent(LoggingServiceRegistry.newNestedLogging()).parent(NativeServices.getInstance()).provider(new TestGlobalScopeServices()).build();
            globalServices.get(LegacyTypesSupport.class).injectEmptyInterfacesIntoClassLoader(this.getClass().getClassLoader());
        }
        return globalServices;
    }

    public File prepareProjectDir(File projectDir) {
        if (projectDir == null) {
            TmpDirTemporaryFileProvider temporaryFileProvider = new TmpDirTemporaryFileProvider();
            projectDir = temporaryFileProvider.createTemporaryDirectory("gradle", "projectDir", new String[0]);
            projectDir.deleteOnExit();
        } else {
            projectDir = FileUtils.canonicalize(projectDir);
        }
        return projectDir;
    }

    static {
        CLASS_GENERATOR = new AsmBackedClassGenerator();
    }

    private static class TestRootBuild
    extends AbstractBuildState {
        private TestRootBuild() {
        }

        @Override
        public BuildIdentifier getBuildIdentifier() {
            return DefaultBuildIdentifier.ROOT;
        }

        @Override
        public Path getIdentityPath() {
            return Path.ROOT;
        }

        @Override
        public boolean isImplicitBuild() {
            return false;
        }

        @Override
        public SettingsInternal getLoadedSettings() {
            throw new UnsupportedOperationException();
        }

        @Override
        public NestedBuildFactory getNestedBuildFactory() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Path getCurrentPrefixForProjectsInChildBuilds() {
            return Path.ROOT;
        }

        @Override
        public Path getIdentityPathForProject(Path projectPath) {
            return projectPath;
        }

        @Override
        public ProjectComponentIdentifier getIdentifierForProject(Path projectPath) {
            String name = projectPath.getName();
            if (name == null) {
                name = "root";
            }
            return new DefaultProjectComponentIdentifier(this.getBuildIdentifier(), projectPath, projectPath, name);
        }
    }
}

