/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.plugins.ear;

import groovy.lang.Closure;
import java.io.File;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.model.InstantiatorBackedObjectFactory;
import org.gradle.api.model.ObjectFactory;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.plugins.ear.descriptor.DeploymentDescriptor;
import org.gradle.plugins.ear.descriptor.internal.DefaultDeploymentDescriptor;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;

public class EarPluginConvention {
    private FileResolver fileResolver;
    private ObjectFactory objectFactory;
    private DeploymentDescriptor deploymentDescriptor;
    private String appDirName;
    private String libDirName;

    @Deprecated
    public EarPluginConvention(FileResolver fileResolver, Instantiator instantiator) {
        this(fileResolver, new InstantiatorBackedObjectFactory(instantiator));
    }

    @Inject
    @Deprecated
    public EarPluginConvention(FileResolver fileResolver, ObjectFactory objectFactory) {
        DeprecationLogger.nagUserOfDeprecated("Creating instances of EarPluginConvention");
        this.fileResolver = fileResolver;
        this.objectFactory = objectFactory;
        this.deploymentDescriptor = objectFactory.newInstance(DefaultDeploymentDescriptor.class, fileResolver, objectFactory);
        this.deploymentDescriptor.readFrom("META-INF/application.xml");
        this.deploymentDescriptor.readFrom(this.appDirName + "/META-INF/" + this.deploymentDescriptor.getFileName());
    }

    public String getAppDirName() {
        return this.appDirName;
    }

    public void setAppDirName(String appDirName) {
        this.appDirName = appDirName;
        if (this.deploymentDescriptor != null) {
            this.deploymentDescriptor.readFrom(new File(appDirName, "META-INF/" + this.deploymentDescriptor.getFileName()));
        }
    }

    public void appDirName(String appDirName) {
        this.setAppDirName(appDirName);
    }

    public String getLibDirName() {
        return this.libDirName;
    }

    public void setLibDirName(String libDirName) {
        this.libDirName = libDirName;
    }

    public void libDirName(String libDirName) {
        this.libDirName = libDirName;
    }

    public DeploymentDescriptor getDeploymentDescriptor() {
        return this.deploymentDescriptor;
    }

    public void setDeploymentDescriptor(DeploymentDescriptor deploymentDescriptor) {
        this.deploymentDescriptor = deploymentDescriptor;
    }

    public EarPluginConvention deploymentDescriptor(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.forceDeploymentDescriptor());
        return this;
    }

    public EarPluginConvention deploymentDescriptor(Action<? super DeploymentDescriptor> configureAction) {
        configureAction.execute(this.forceDeploymentDescriptor());
        return this;
    }

    private DeploymentDescriptor forceDeploymentDescriptor() {
        if (this.deploymentDescriptor == null) {
            this.deploymentDescriptor = this.objectFactory.newInstance(DefaultDeploymentDescriptor.class, this.fileResolver, this.objectFactory);
            assert (this.deploymentDescriptor != null);
        }
        return this.deploymentDescriptor;
    }
}

