/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.tasks;

import java.util.List;
import javax.inject.Inject;
import org.gradle.api.DefaultTask;
import org.gradle.api.Incubating;
import org.gradle.api.Transformer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.OutputFile;
import org.gradle.api.tasks.SkipWhenEmpty;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.WorkResult;
import org.gradle.internal.Cast;
import org.gradle.internal.operations.logging.BuildOperationLogger;
import org.gradle.internal.operations.logging.BuildOperationLoggerFactory;
import org.gradle.language.base.compile.CompilerVersion;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.VersionAwareCompiler;
import org.gradle.language.base.internal.tasks.SimpleStaleClassCleaner;
import org.gradle.nativeplatform.internal.BuildOperationLoggingCompilerDecorator;
import org.gradle.nativeplatform.internal.LinkerSpec;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.platform.internal.NativePlatformInternal;
import org.gradle.nativeplatform.tasks.ObjectFilesToBinary;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.NativeToolChainInternal;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

@Incubating
public abstract class AbstractLinkTask
extends DefaultTask
implements ObjectFilesToBinary {
    private final RegularFileProperty linkedFile;
    private final DirectoryProperty destinationDirectory;
    private final ListProperty<String> linkerArgs;
    private final ConfigurableFileCollection source;
    private final ConfigurableFileCollection libs;
    private final Property<Boolean> debuggable;
    private final Property<NativePlatform> targetPlatform;
    private final Property<NativeToolChain> toolChain;

    public AbstractLinkTask() {
        ObjectFactory objectFactory = this.getProject().getObjects();
        this.libs = this.getProject().files(new Object[0]);
        this.source = this.getProject().files(new Object[0]);
        this.linkedFile = this.newOutputFile();
        this.destinationDirectory = this.newOutputDirectory();
        this.destinationDirectory.set(this.linkedFile.map(new Transformer<Directory, RegularFile>(){

            @Override
            public Directory transform(RegularFile regularFile) {
                DirectoryProperty dirProp = AbstractLinkTask.this.getProject().getLayout().directoryProperty();
                dirProp.set(regularFile.getAsFile().getParentFile());
                return (Directory)dirProp.get();
            }
        }));
        this.linkerArgs = this.getProject().getObjects().listProperty(String.class);
        this.debuggable = objectFactory.property(Boolean.class);
        this.targetPlatform = objectFactory.property(NativePlatform.class);
        this.toolChain = objectFactory.property(NativeToolChain.class);
    }

    @Internal
    public Property<NativeToolChain> getToolChain() {
        return this.toolChain;
    }

    @Nested
    public Property<NativePlatform> getTargetPlatform() {
        return this.targetPlatform;
    }

    @OutputDirectory
    public DirectoryProperty getDestinationDirectory() {
        return this.destinationDirectory;
    }

    @OutputFile
    public RegularFileProperty getLinkedFile() {
        return this.linkedFile;
    }

    @Input
    public ListProperty<String> getLinkerArgs() {
        return this.linkerArgs;
    }

    @Internal
    public boolean isDebuggable() {
        return (Boolean)this.debuggable.get();
    }

    @Input
    public Property<Boolean> getDebuggable() {
        return this.debuggable;
    }

    @InputFiles
    @SkipWhenEmpty
    public ConfigurableFileCollection getSource() {
        return this.source;
    }

    public void setSource(FileCollection source) {
        this.source.setFrom(source);
    }

    @InputFiles
    public ConfigurableFileCollection getLibs() {
        return this.libs;
    }

    public void setLibs(FileCollection libs) {
        this.libs.setFrom(libs);
    }

    @Override
    public void source(Object source) {
        this.source.from(source);
    }

    public void lib(Object libs) {
        this.libs.from(libs);
    }

    @Nested
    protected CompilerVersion getCompilerVersion() {
        return ((VersionAwareCompiler)this.createCompiler()).getVersion();
    }

    @Inject
    public BuildOperationLoggerFactory getOperationLoggerFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void link() {
        SimpleStaleClassCleaner cleaner = new SimpleStaleClassCleaner(this.getOutputs());
        cleaner.addDirToClean(((Directory)this.getDestinationDirectory().get()).getAsFile());
        cleaner.execute();
        if (this.getSource().isEmpty()) {
            this.setDidWork(cleaner.getDidWork());
            return;
        }
        LinkerSpec spec = this.createLinkerSpec();
        spec.setTargetPlatform((NativePlatform)this.getTargetPlatform().get());
        spec.setTempDir(this.getTemporaryDir());
        spec.setOutputFile(((RegularFile)this.getLinkedFile().get()).getAsFile());
        spec.objectFiles(this.getSource());
        spec.libraries(this.getLibs());
        spec.args((List)this.getLinkerArgs().get());
        spec.setDebuggable((Boolean)this.getDebuggable().get());
        BuildOperationLogger operationLogger = this.getOperationLoggerFactory().newOperationLogger(this.getName(), this.getTemporaryDir());
        spec.setOperationLogger(operationLogger);
        Compiler<LinkerSpec> compiler = this.createCompiler();
        compiler = BuildOperationLoggingCompilerDecorator.wrap(compiler);
        WorkResult result = compiler.execute(spec);
        this.setDidWork(result.getDidWork());
    }

    private Compiler<LinkerSpec> createCompiler() {
        NativePlatformInternal targetPlatform = Cast.cast(NativePlatformInternal.class, this.targetPlatform.get());
        NativeToolChainInternal toolChain = Cast.cast(NativeToolChainInternal.class, this.getToolChain().get());
        PlatformToolProvider toolProvider = toolChain.select(targetPlatform);
        Class<?> linkerSpecType = this.createLinkerSpec().getClass();
        return toolProvider.newCompiler(linkerSpecType);
    }

    protected abstract LinkerSpec createLinkerSpec();
}

