/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.logging.console;

import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.UncheckedIOException;
import org.gradle.internal.impldep.org.fusesource.jansi.Ansi;
import org.gradle.internal.logging.console.AnsiContext;
import org.gradle.internal.logging.console.AnsiExecutor;
import org.gradle.internal.logging.console.AnsiFactory;
import org.gradle.internal.logging.console.ColorMap;
import org.gradle.internal.logging.console.Cursor;
import org.gradle.internal.logging.text.Style;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.nativeintegration.console.ConsoleMetaData;

public class DefaultAnsiExecutor
implements AnsiExecutor {
    private static final NewLineListener NO_OP_LISTENER = new NoOpListener();
    private final Appendable target;
    private final ColorMap colorMap;
    private final AnsiFactory factory;
    private final ConsoleMetaData consoleMetaData;
    private final NewLineListener listener;
    private final Cursor writeCursor;

    public DefaultAnsiExecutor(Appendable target, ColorMap colorMap, AnsiFactory factory, ConsoleMetaData consoleMetaData) {
        this(target, colorMap, factory, consoleMetaData, new Cursor());
    }

    public DefaultAnsiExecutor(Appendable target, ColorMap colorMap, AnsiFactory factory, ConsoleMetaData consoleMetaData, Cursor writeCursor) {
        this(target, colorMap, factory, consoleMetaData, writeCursor, NO_OP_LISTENER);
    }

    public DefaultAnsiExecutor(Appendable target, ColorMap colorMap, AnsiFactory factory, ConsoleMetaData consoleMetaData, Cursor writeCursor, NewLineListener listener) {
        this.target = target;
        this.colorMap = colorMap;
        this.factory = factory;
        this.consoleMetaData = consoleMetaData;
        this.writeCursor = writeCursor;
        this.listener = listener;
    }

    @Override
    public void write(Action<? super AnsiContext> action) {
        Ansi ansi = this.factory.create();
        action.execute(new AnsiContextImpl(ansi, this.colorMap, this.writeCursor));
        this.write(ansi);
    }

    @Override
    public void writeAt(Cursor writePos, Action<? super AnsiContext> action) {
        Ansi ansi = this.factory.create();
        this.positionCursorAt(writePos, ansi);
        action.execute(new AnsiContextImpl(ansi, this.colorMap, writePos));
        this.write(ansi);
    }

    private void charactersWritten(Cursor cursor, int count) {
        this.writeCursor.col += count;
        cursor.copyFrom(this.writeCursor);
    }

    private void newLineWritten(Cursor cursor) {
        this.writeCursor.col = 0;
        this.writeCursor.row = this.writeCursor.row > 0 ? --this.writeCursor.row : 0;
        cursor.copyFrom(this.writeCursor);
    }

    private void positionCursorAt(Cursor position, Ansi ansi) {
        if (this.writeCursor.row == position.row) {
            if (this.writeCursor.col == position.col) {
                return;
            }
            if (this.writeCursor.col < position.col) {
                ansi.cursorRight(position.col - this.writeCursor.col);
            } else {
                ansi.cursorLeft(this.writeCursor.col - position.col);
            }
        } else {
            if (this.writeCursor.col > 0) {
                ansi.cursorLeft(this.writeCursor.col);
            }
            if (this.writeCursor.row < position.row) {
                ansi.cursorUp(position.row - this.writeCursor.row);
            } else {
                ansi.cursorDown(this.writeCursor.row - position.row);
            }
            if (position.col > 0) {
                ansi.cursorRight(position.col);
            }
        }
        this.writeCursor.copyFrom(position);
    }

    private void write(Ansi ansi) {
        try {
            this.target.append(ansi.toString());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private class AnsiContextImpl
    implements AnsiContext {
        private final Ansi delegate;
        private final ColorMap colorMap;
        private final Cursor writePos;

        AnsiContextImpl(Ansi delegate, ColorMap colorMap, Cursor writePos) {
            this.delegate = delegate;
            this.colorMap = colorMap;
            this.writePos = writePos;
        }

        @Override
        public AnsiContext withColor(ColorMap.Color color, Action<? super AnsiContext> action) {
            color.on(this.delegate);
            action.execute(this);
            color.off(this.delegate);
            return this;
        }

        @Override
        public AnsiContext withStyle(Style style, Action<? super AnsiContext> action) {
            if (Style.NORMAL.equals(style)) {
                action.execute(this);
                return this;
            }
            return this.withColor(this.colorMap.getColourFor(style), action);
        }

        @Override
        public AnsiContext withStyle(StyledTextOutput.Style style, Action<? super AnsiContext> action) {
            return this.withColor(this.colorMap.getColourFor(style), action);
        }

        @Override
        public AnsiContext a(CharSequence value) {
            if (value.length() > 0) {
                int cols = DefaultAnsiExecutor.this.consoleMetaData.getCols();
                int numberOfWrapBefore = cols > 0 ? ((DefaultAnsiExecutor)DefaultAnsiExecutor.this).writeCursor.col / (cols + 1) : 0;
                this.delegate.a(value);
                DefaultAnsiExecutor.this.charactersWritten(this.writePos, value.length());
                int numberOfWrapAfter = cols > 0 ? ((DefaultAnsiExecutor)DefaultAnsiExecutor.this).writeCursor.col / (cols + 1) : 0;
                int numberOfWrap = numberOfWrapAfter - numberOfWrapBefore;
                if (numberOfWrap > 0) {
                    while (numberOfWrap-- > 0) {
                        DefaultAnsiExecutor.this.listener.beforeLineWrap(this, Cursor.at(this.writePos.row, cols));
                        if (this.writePos.row != 0) {
                            --this.writePos.row;
                        }
                        if (((DefaultAnsiExecutor)DefaultAnsiExecutor.this).writeCursor.row == 0) continue;
                        --((DefaultAnsiExecutor)DefaultAnsiExecutor.this).writeCursor.row;
                    }
                    int col = ((DefaultAnsiExecutor)DefaultAnsiExecutor.this).writeCursor.col % cols;
                    DefaultAnsiExecutor.this.listener.afterLineWrap(this, Cursor.at(this.writePos.row, col));
                }
            }
            return this;
        }

        @Override
        public AnsiContext newLines(int numberOfNewLines) {
            while (0 < numberOfNewLines--) {
                this.newLine();
            }
            return this;
        }

        @Override
        public AnsiContext newLine() {
            int cols = DefaultAnsiExecutor.this.consoleMetaData.getCols();
            int col = cols > 0 ? ((DefaultAnsiExecutor)DefaultAnsiExecutor.this).writeCursor.col % cols : 0;
            DefaultAnsiExecutor.this.listener.beforeNewLineWritten(this, Cursor.at(((DefaultAnsiExecutor)DefaultAnsiExecutor.this).writeCursor.row, col));
            this.delegate.newline();
            DefaultAnsiExecutor.this.newLineWritten(this.writePos);
            return this;
        }

        @Override
        public AnsiContext eraseForward() {
            this.delegate.eraseLine(Ansi.Erase.FORWARD);
            return this;
        }

        @Override
        public AnsiContext eraseAll() {
            this.delegate.eraseLine(Ansi.Erase.ALL);
            return this;
        }

        @Override
        public AnsiContext cursorAt(Cursor cursor) {
            DefaultAnsiExecutor.this.positionCursorAt(cursor, this.delegate);
            return this;
        }

        @Override
        public AnsiContext writeAt(Cursor writePos) {
            DefaultAnsiExecutor.this.positionCursorAt(writePos, this.delegate);
            return new AnsiContextImpl(this.delegate, this.colorMap, writePos);
        }
    }

    private static class NoOpListener
    implements NewLineListener {
        private NoOpListener() {
        }

        @Override
        public void beforeNewLineWritten(AnsiContext ansi, Cursor writeCursor) {
        }

        @Override
        public void beforeLineWrap(AnsiContext ansi, Cursor writeCursor) {
        }

        @Override
        public void afterLineWrap(AnsiContext ansi, Cursor writeCursor) {
        }
    }

    static interface NewLineListener {
        public void beforeNewLineWritten(AnsiContext var1, Cursor var2);

        public void beforeLineWrap(AnsiContext var1, Cursor var2);

        public void afterLineWrap(AnsiContext var1, Cursor var2);
    }
}

