/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.gradle.api.internal.changedetection.rules.FileChange;
import org.gradle.api.internal.changedetection.rules.TaskStateChangeVisitor;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.fingerprint.NormalizedFileSnapshot;
import org.gradle.internal.fingerprint.impl.FilePathWithType;
import org.gradle.internal.fingerprint.impl.FingerprintCompareStrategy;
import org.gradle.internal.fingerprint.impl.NormalizedPathFingerprintCompareStrategy;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.impldep.com.google.common.collect.ListMultimap;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.MultimapBuilder;

public class IgnoredPathCompareStrategy
implements FingerprintCompareStrategy.Impl {
    private static final Comparator<Map.Entry<HashCode, FilePathWithType>> ENTRY_COMPARATOR = new Comparator<Map.Entry<HashCode, FilePathWithType>>(){

        @Override
        public int compare(Map.Entry<HashCode, FilePathWithType> o1, Map.Entry<HashCode, FilePathWithType> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    };

    @Override
    public boolean visitChangesSince(TaskStateChangeVisitor visitor, Map<String, NormalizedFileSnapshot> current, Map<String, NormalizedFileSnapshot> previous, String propertyTitle, boolean includeAdded) {
        ListMultimap unaccountedForPreviousFiles = MultimapBuilder.hashKeys((int)previous.size()).linkedListValues().build();
        for (Map.Entry<String, NormalizedFileSnapshot> entry : previous.entrySet()) {
            String absolutePath = entry.getKey();
            NormalizedFileSnapshot previousSnapshot = entry.getValue();
            unaccountedForPreviousFiles.put((Object)previousSnapshot.getNormalizedContentHash(), (Object)new FilePathWithType(absolutePath, previousSnapshot.getType()));
        }
        for (Map.Entry<String, NormalizedFileSnapshot> entry : current.entrySet()) {
            String currentAbsolutePath = entry.getKey();
            NormalizedFileSnapshot currentSnapshot = entry.getValue();
            HashCode normalizedContentHash = currentSnapshot.getNormalizedContentHash();
            List previousFilesForContent = unaccountedForPreviousFiles.get((Object)normalizedContentHash);
            if (previousFilesForContent.isEmpty()) {
                if (!includeAdded || visitor.visitChange(FileChange.added(currentAbsolutePath, propertyTitle, currentSnapshot.getType()))) continue;
                return false;
            }
            previousFilesForContent.remove(0);
        }
        ArrayList unaccountedForPreviousEntries = Lists.newArrayList((Iterable)unaccountedForPreviousFiles.entries());
        Collections.sort(unaccountedForPreviousEntries, ENTRY_COMPARATOR);
        for (Map.Entry unaccountedForPreviousEntry : unaccountedForPreviousEntries) {
            FilePathWithType removedFile = (FilePathWithType)unaccountedForPreviousEntry.getValue();
            if (visitor.visitChange(FileChange.removed(removedFile.getAbsolutePath(), propertyTitle, removedFile.getFileType()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void appendToHasher(BuildCacheHasher hasher, Collection<NormalizedFileSnapshot> snapshots) {
        NormalizedPathFingerprintCompareStrategy.appendSortedToHasher(hasher, snapshots);
    }
}

