/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.capabilities.CapabilitiesMetadata;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.changedetection.state.CoercingStringValueSnapshot;
import org.gradle.api.internal.model.NamedObjectInstantiator;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.MavenScope;
import org.gradle.internal.component.external.model.AbstractRealisedModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.ConfigurationBoundExternalDependencyMetadata;
import org.gradle.internal.component.external.model.DefaultModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.LazyToRealisedModuleComponentResolveMetadataHelper;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.RealisedConfigurationMetadata;
import org.gradle.internal.component.external.model.VariantMetadataRules;
import org.gradle.internal.component.external.model.maven.DefaultMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.MavenDependencyDescriptor;
import org.gradle.internal.component.external.model.maven.MavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.MutableMavenModuleResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DefaultIvyArtifactName;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.base.Optional;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;

public class RealisedMavenModuleResolveMetadata
extends AbstractRealisedModuleComponentResolveMetadata
implements MavenModuleResolveMetadata {
    private final boolean improvedPomSupportEnabled;
    private final NamedObjectInstantiator objectInstantiator;
    private final ImmutableList<MavenDependencyDescriptor> dependencies;
    private final DefaultMavenModuleResolveMetadata metadata;
    private final String packaging;
    private final boolean relocated;
    private final String snapshotTimestamp;
    private final ImmutableList<? extends ConfigurationMetadata> derivedVariants;

    public static RealisedMavenModuleResolveMetadata transform(DefaultMavenModuleResolveMetadata metadata) {
        VariantMetadataRules variantMetadataRules = metadata.getVariantMetadataRules();
        ImmutableList<AbstractRealisedModuleComponentResolveMetadata.ImmutableRealisedVariantImpl> variants = LazyToRealisedModuleComponentResolveMetadataHelper.realiseVariants(metadata, variantMetadataRules, (ImmutableList<? extends ComponentVariant>)metadata.getVariants());
        boolean computeDerivedVariants = metadata.getVariants().size() == 0;
        ArrayList derivedVariants = Lists.newArrayListWithCapacity((int)2);
        HashMap configurations = Maps.newHashMapWithExpectedSize((int)metadata.getConfigurationNames().size());
        for (String configurationName : metadata.getConfigurationNames()) {
            ImmutableMap<String, Configuration> configurationDefinitions = metadata.getConfigurationDefinitions();
            Configuration configuration = (Configuration)configurationDefinitions.get((Object)configurationName);
            AbstractRealisedModuleComponentResolveMetadata.NameOnlyVariantResolveMetadata variant = new AbstractRealisedModuleComponentResolveMetadata.NameOnlyVariantResolveMetadata(configurationName);
            ImmutableAttributes variantAttributes = variantMetadataRules.applyVariantAttributeRules(variant, metadata.getAttributes());
            CapabilitiesMetadata capabilitiesMetadata = variantMetadataRules.applyCapabilitiesRules(variant, ImmutableCapabilities.EMPTY);
            RealisedConfigurationMetadata realisedConfiguration = RealisedMavenModuleResolveMetadata.createConfiguration(variantMetadataRules, metadata.getId(), configurationName, configuration.isTransitive(), configuration.isVisible(), LazyToRealisedModuleComponentResolveMetadataHelper.constructHierarchy(configuration, configurationDefinitions), metadata.getDependencies(), metadata.isImprovedPomSupportEnabled(), variantAttributes, ImmutableCapabilities.of(capabilitiesMetadata.getCapabilities()));
            configurations.put(configurationName, realisedConfiguration);
            if (!computeDerivedVariants) continue;
            if (configurationName.equals("compile")) {
                derivedVariants.add(RealisedMavenModuleResolveMetadata.withUsageAttribute(realisedConfiguration, "java-api", metadata.getAttributesFactory(), variantAttributes, metadata.getObjectInstantiator()));
                continue;
            }
            if (!configurationName.equals("runtime")) continue;
            derivedVariants.add(RealisedMavenModuleResolveMetadata.withUsageAttribute(realisedConfiguration, "java-runtime", metadata.getAttributesFactory(), variantAttributes, metadata.getObjectInstantiator()));
        }
        return new RealisedMavenModuleResolveMetadata(metadata, variants, derivedVariants, configurations);
    }

    private static RealisedConfigurationMetadata createConfiguration(VariantMetadataRules variantMetadataRules, ModuleComponentIdentifier componentId, String name, boolean transitive, boolean visible, ImmutableList<String> hierarchy, ImmutableList<MavenDependencyDescriptor> dependencies, boolean improvedPomSupport, ImmutableAttributes attributes, ImmutableCapabilities capabilities) {
        ImmutableList<? extends ModuleComponentArtifactMetadata> artifacts = RealisedMavenModuleResolveMetadata.getArtifactsForConfiguration(componentId, name);
        RealisedConfigurationMetadata configuration = new RealisedConfigurationMetadata(componentId, name, transitive, visible, hierarchy, artifacts, (ImmutableList<ExcludeMetadata>)ImmutableList.of(), attributes, capabilities);
        ImmutableList dependencyMetadata = RealisedMavenModuleResolveMetadata.filterDependencies(componentId, configuration, dependencies, improvedPomSupport);
        dependencyMetadata = ImmutableList.copyOf(variantMetadataRules.applyDependencyMetadataRules(new AbstractRealisedModuleComponentResolveMetadata.NameOnlyVariantResolveMetadata(name), dependencyMetadata));
        configuration.setDependencies((List<ModuleDependencyMetadata>)dependencyMetadata);
        return configuration;
    }

    static ConfigurationMetadata withUsageAttribute(RealisedConfigurationMetadata conf, String usage, ImmutableAttributesFactory attributesFactory, ImmutableAttributes additionalAttributes, NamedObjectInstantiator instantiator) {
        ImmutableAttributes attributes = attributesFactory.concat(additionalAttributes, DefaultMavenModuleResolveMetadata.USAGE_ATTRIBUTE, new CoercingStringValueSnapshot(usage, instantiator));
        return conf.withAttributes(attributes);
    }

    static ImmutableList<? extends ModuleComponentArtifactMetadata> getArtifactsForConfiguration(ModuleComponentIdentifier id, String name) {
        ImmutableList artifacts = name.equals("compile") || name.equals("runtime") || name.equals("default") || name.equals("test") ? ImmutableList.of((Object)new DefaultModuleComponentArtifactMetadata(id, new DefaultIvyArtifactName(id.getModule(), "jar", "jar"))) : ImmutableList.of();
        return artifacts;
    }

    private static ImmutableList<ModuleDependencyMetadata> filterDependencies(ModuleComponentIdentifier componentId, ConfigurationMetadata config, ImmutableList<MavenDependencyDescriptor> dependencies, boolean improvedPomSupport) {
        ImmutableList.Builder filteredDependencies = ImmutableList.builder();
        boolean isOptionalConfiguration = "optional".equals(config.getName());
        for (MavenDependencyDescriptor dependency : dependencies) {
            if (isOptionalConfiguration && RealisedMavenModuleResolveMetadata.includeInOptionalConfiguration(dependency)) {
                filteredDependencies.add((Object)new DefaultMavenModuleResolveMetadata.OptionalConfigurationDependencyMetadata(config, componentId, dependency));
                continue;
            }
            if (!RealisedMavenModuleResolveMetadata.include(dependency, config.getHierarchy(), improvedPomSupport)) continue;
            filteredDependencies.add((Object)RealisedMavenModuleResolveMetadata.contextualize(config, componentId, dependency, improvedPomSupport));
        }
        return filteredDependencies.build();
    }

    static ModuleDependencyMetadata contextualize(ConfigurationMetadata config, ModuleComponentIdentifier componentId, MavenDependencyDescriptor incoming, boolean improvedPomSupport) {
        ConfigurationBoundExternalDependencyMetadata dependency = new ConfigurationBoundExternalDependencyMetadata(config, componentId, incoming);
        if (improvedPomSupport) {
            dependency.alwaysUseAttributeMatching();
        }
        return dependency;
    }

    private static boolean includeInOptionalConfiguration(MavenDependencyDescriptor dependency) {
        MavenScope dependencyScope = dependency.getScope();
        return dependency.isOptional() && dependencyScope != MavenScope.Test && dependencyScope != MavenScope.System;
    }

    private static boolean include(MavenDependencyDescriptor dependency, Collection<String> hierarchy, boolean improvedPomSupport) {
        MavenScope dependencyScope = dependency.getScope();
        if (dependency.isOptional() && !improvedPomSupport) {
            return false;
        }
        return hierarchy.contains(dependencyScope.getLowerName());
    }

    RealisedMavenModuleResolveMetadata(DefaultMavenModuleResolveMetadata metadata, ImmutableList<? extends ComponentVariant> variants, List<ConfigurationMetadata> derivedVariants, Map<String, ConfigurationMetadata> configurations) {
        super(metadata, variants, configurations);
        this.improvedPomSupportEnabled = metadata.isImprovedPomSupportEnabled();
        this.objectInstantiator = metadata.getObjectInstantiator();
        this.packaging = metadata.getPackaging();
        this.relocated = metadata.isRelocated();
        this.snapshotTimestamp = metadata.getSnapshotTimestamp();
        this.dependencies = metadata.getDependencies();
        this.metadata = metadata;
        this.derivedVariants = ImmutableList.copyOf(derivedVariants);
    }

    private RealisedMavenModuleResolveMetadata(RealisedMavenModuleResolveMetadata metadata, ModuleSource source) {
        super(metadata, source);
        this.improvedPomSupportEnabled = metadata.improvedPomSupportEnabled;
        this.objectInstantiator = metadata.objectInstantiator;
        this.packaging = metadata.packaging;
        this.relocated = metadata.relocated;
        this.snapshotTimestamp = metadata.snapshotTimestamp;
        this.dependencies = metadata.dependencies;
        this.derivedVariants = metadata.derivedVariants;
        this.metadata = metadata.metadata.withSource(source);
    }

    @Override
    protected Optional<ImmutableList<? extends ConfigurationMetadata>> maybeDeriveVariants() {
        return this.isJavaLibrary() ? Optional.of(this.getDerivedVariants()) : Optional.absent();
    }

    ImmutableList<? extends ConfigurationMetadata> getDerivedVariants() {
        return this.derivedVariants;
    }

    @Override
    public RealisedMavenModuleResolveMetadata withSource(ModuleSource source) {
        return new RealisedMavenModuleResolveMetadata(this, source);
    }

    @Override
    public MutableMavenModuleResolveMetadata asMutable() {
        return this.metadata.asMutable();
    }

    @Override
    public String getPackaging() {
        return this.packaging;
    }

    @Override
    public boolean isRelocated() {
        return this.relocated;
    }

    @Override
    public boolean isPomPackaging() {
        return "pom".equals(this.packaging);
    }

    @Override
    public boolean isKnownJarPackaging() {
        return DefaultMavenModuleResolveMetadata.JAR_PACKAGINGS.contains(this.packaging);
    }

    private boolean isJavaLibrary() {
        return this.improvedPomSupportEnabled && (this.isKnownJarPackaging() || this.isPomPackaging());
    }

    @Override
    @Nullable
    public String getSnapshotTimestamp() {
        return this.snapshotTimestamp;
    }

    @Override
    public ImmutableList<MavenDependencyDescriptor> getDependencies() {
        return this.dependencies;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RealisedMavenModuleResolveMetadata that = (RealisedMavenModuleResolveMetadata)o;
        return this.relocated == that.relocated && Objects.equal(this.dependencies, that.dependencies) && Objects.equal((Object)this.packaging, (Object)that.packaging) && Objects.equal((Object)this.snapshotTimestamp, (Object)that.snapshotTimestamp);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.dependencies, this.packaging, this.relocated, this.snapshotTimestamp});
    }
}

