/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import org.gradle.concurrent.ParallelismConfiguration;
import org.gradle.internal.concurrent.DefaultParallelismConfiguration;
import org.gradle.internal.concurrent.ParallelismConfigurationListener;
import org.gradle.internal.concurrent.ParallelismConfigurationManager;
import org.gradle.internal.event.ListenerManager;

public class DefaultParallelismConfigurationManager
implements ParallelismConfigurationManager {
    private final ListenerManager listenerManager;
    private final ParallelismConfigurationListener broadcaster;
    private ParallelismConfiguration parallelismConfiguration = DefaultParallelismConfiguration.DEFAULT;

    public DefaultParallelismConfigurationManager(ListenerManager listenerManager) {
        this.listenerManager = listenerManager;
        this.broadcaster = listenerManager.getBroadcaster(ParallelismConfigurationListener.class);
    }

    @Override
    public ParallelismConfiguration getParallelismConfiguration() {
        return this.parallelismConfiguration;
    }

    @Override
    public void setParallelismConfiguration(ParallelismConfiguration parallelismConfiguration) {
        this.parallelismConfiguration = parallelismConfiguration;
        this.broadcaster.onParallelismConfigurationChange(parallelismConfiguration);
    }

    @Override
    public void addListener(ParallelismConfigurationListener listener) {
        this.listenerManager.addListener(listener);
    }

    @Override
    public void removeListener(ParallelismConfigurationListener listener) {
        this.listenerManager.removeListener(listener);
    }
}

