/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.ide.visualstudio.tasks;

import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.tasks.Nested;
import org.gradle.ide.visualstudio.VisualStudioProject;
import org.gradle.ide.visualstudio.internal.DefaultVisualStudioProject;
import org.gradle.ide.visualstudio.tasks.internal.RelativeFileNameTransformer;
import org.gradle.ide.visualstudio.tasks.internal.VisualStudioFiltersFile;
import org.gradle.plugins.ide.api.XmlGeneratorTask;

@Incubating
public class GenerateFiltersFileTask
extends XmlGeneratorTask<VisualStudioFiltersFile> {
    private DefaultVisualStudioProject visualStudioProject;

    @Override
    protected boolean getIncremental() {
        return true;
    }

    public void setVisualStudioProject(VisualStudioProject vsProject) {
        this.visualStudioProject = (DefaultVisualStudioProject)vsProject;
    }

    @Nested
    public VisualStudioProject getVisualStudioProject() {
        return this.visualStudioProject;
    }

    @Override
    public File getInputFile() {
        return null;
    }

    @Override
    public File getOutputFile() {
        return this.visualStudioProject.getFiltersFile().getLocation();
    }

    @Override
    protected void configure(VisualStudioFiltersFile filtersFile) {
        DefaultVisualStudioProject vsProject = this.visualStudioProject;
        for (File file : vsProject.getSourceFiles()) {
            filtersFile.addSource(file);
        }
        for (File file : vsProject.getHeaderFiles()) {
            filtersFile.addHeader(file);
        }
        for (Action action : vsProject.getFiltersFile().getXmlActions()) {
            this.getXmlTransformer().addAction(action);
        }
    }

    @Override
    protected VisualStudioFiltersFile create() {
        return new VisualStudioFiltersFile(this.getXmlTransformer(), RelativeFileNameTransformer.forFile(this.getProject().getRootDir(), this.visualStudioProject.getFiltersFile().getLocation()));
    }
}

