/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.taskgraph;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.BuildCancelledException;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.GradleException;
import org.gradle.api.NonNullApi;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.execution.DefaultTaskProperties;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.api.internal.tasks.properties.PropertyWalker;
import org.gradle.api.specs.Spec;
import org.gradle.api.specs.Specs;
import org.gradle.execution.taskgraph.LocalTaskInfo;
import org.gradle.execution.taskgraph.TaskDependencyResolver;
import org.gradle.execution.taskgraph.TaskExecutionPlan;
import org.gradle.execution.taskgraph.TaskFailureCollector;
import org.gradle.execution.taskgraph.TaskInfo;
import org.gradle.execution.taskgraph.TaskInfoFactory;
import org.gradle.execution.taskgraph.WorkInfo;
import org.gradle.internal.Pair;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.graph.CachingDirectedGraphWalker;
import org.gradle.internal.graph.DirectedGraph;
import org.gradle.internal.graph.DirectedGraphRenderer;
import org.gradle.internal.graph.GraphNodeRenderer;
import org.gradle.internal.impldep.com.google.common.annotations.VisibleForTesting;
import org.gradle.internal.impldep.com.google.common.base.Function;
import org.gradle.internal.impldep.com.google.common.base.Predicate;
import org.gradle.internal.impldep.com.google.common.collect.HashMultimap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableCollection;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Iterables;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.collect.Sets;
import org.gradle.internal.logging.text.StyledTextOutput;
import org.gradle.internal.resources.ResourceDeadlockException;
import org.gradle.internal.resources.ResourceLock;
import org.gradle.internal.resources.ResourceLockState;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.work.WorkerLeaseRegistry;
import org.gradle.internal.work.WorkerLeaseService;
import org.gradle.util.CollectionUtils;
import org.gradle.util.Path;

@NonNullApi
public class DefaultTaskExecutionPlan
implements TaskExecutionPlan {
    private final Set<WorkInfo> workInUnknownState = Sets.newLinkedHashSet();
    private final Set<TaskInfo> entryTasks = new LinkedHashSet<TaskInfo>();
    private final WorkInfoMapping workInfoMapping = new WorkInfoMapping();
    private final List<WorkInfo> executionQueue = Lists.newLinkedList();
    private final Map<Project, ResourceLock> projectLocks = Maps.newHashMap();
    private final TaskFailureCollector failureCollector = new TaskFailureCollector();
    private final TaskInfoFactory nodeFactory;
    private final TaskDependencyResolver dependencyResolver;
    private Spec<? super Task> filter = Specs.satisfyAll();
    private boolean continueOnFailure;
    private final Set<WorkInfo> runningNodes = Sets.newIdentityHashSet();
    private final Set<WorkInfo> filteredNodes = Sets.newIdentityHashSet();
    private final Map<WorkInfo, MutationInfo> workMutations = Maps.newIdentityHashMap();
    private final Map<File, String> canonicalizedFileCache = Maps.newIdentityHashMap();
    private final Map<Pair<WorkInfo, WorkInfo>, Boolean> reachableCache = Maps.newHashMap();
    private final Set<WorkInfo> dependenciesCompleteCache = Sets.newHashSet();
    private final WorkerLeaseService workerLeaseService;
    private final GradleInternal gradle;
    private boolean tasksCancelled;

    public DefaultTaskExecutionPlan(WorkerLeaseService workerLeaseService, GradleInternal gradle, TaskInfoFactory taskInfoFactory, TaskDependencyResolver dependencyResolver) {
        this.workerLeaseService = workerLeaseService;
        this.gradle = gradle;
        this.nodeFactory = taskInfoFactory;
        this.dependencyResolver = dependencyResolver;
    }

    @Override
    public String getDisplayName() {
        Path path = this.gradle.findIdentityPath();
        if (path == null) {
            return "gradle";
        }
        return path.toString();
    }

    @VisibleForTesting
    TaskInfo getNode(Task task) {
        return this.workInfoMapping.get(task);
    }

    public void addToTaskGraph(Collection<? extends Task> tasks) {
        final ArrayDeque<TaskInfo> queue = new ArrayDeque<TaskInfo>();
        ArrayList<? extends Task> sortedTasks = new ArrayList<Task>(tasks);
        Collections.sort(sortedTasks);
        for (Task task : sortedTasks) {
            TaskInfo node = this.nodeFactory.getOrCreateNode(task);
            if (node.isMustNotRun()) {
                this.requireWithDependencies(node);
            } else if (this.filter.isSatisfiedBy(task)) {
                node.require();
            }
            this.entryTasks.add(node);
            queue.add(node);
        }
        final HashSet visiting = Sets.newHashSet();
        while (!queue.isEmpty()) {
            boolean filtered;
            WorkInfo workInfo = (WorkInfo)queue.getFirst();
            if (workInfo.getDependenciesProcessed()) {
                queue.removeFirst();
                continue;
            }
            boolean bl = filtered = !this.nodeSatisfiesTaskFilter(workInfo);
            if (filtered) {
                queue.removeFirst();
                workInfo.dependenciesProcessed();
                workInfo.doNotRequire();
                this.filteredNodes.add(workInfo);
                continue;
            }
            if (visiting.add(workInfo)) {
                workInfo.prepareForExecution();
                workInfo.resolveDependencies(this.dependencyResolver, new Action<WorkInfo>(){

                    @Override
                    public void execute(WorkInfo targetNode) {
                        if (!visiting.contains(targetNode)) {
                            queue.addFirst(targetNode);
                        }
                    }
                });
                if (workInfo.isRequired()) {
                    for (WorkInfo successor : workInfo.getDependencySuccessors()) {
                        if (!this.nodeSatisfiesTaskFilter(successor)) continue;
                        successor.require();
                    }
                    continue;
                }
                this.workInUnknownState.add(workInfo);
                continue;
            }
            queue.removeFirst();
            visiting.remove(workInfo);
            workInfo.dependenciesProcessed();
        }
        this.resolveWorkInUnknownState();
    }

    private boolean nodeSatisfiesTaskFilter(WorkInfo successor) {
        if (successor instanceof LocalTaskInfo) {
            return this.filter.isSatisfiedBy(((LocalTaskInfo)successor).getTask());
        }
        return true;
    }

    private void resolveWorkInUnknownState() {
        ArrayList queue = Lists.newArrayList(this.workInUnknownState);
        HashSet visiting = Sets.newHashSet();
        block0: while (!queue.isEmpty()) {
            WorkInfo workInfo = (WorkInfo)queue.get(0);
            if (workInfo.isInKnownState()) {
                queue.remove(0);
                continue;
            }
            if (visiting.add(workInfo)) {
                for (WorkInfo hardPredecessor : workInfo.getDependencyPredecessors()) {
                    if (visiting.contains(hardPredecessor)) continue;
                    queue.add(0, hardPredecessor);
                }
                continue;
            }
            queue.remove(0);
            visiting.remove(workInfo);
            workInfo.mustNotRun();
            for (WorkInfo predecessor : workInfo.getDependencyPredecessors()) {
                assert (predecessor.isRequired() || predecessor.isMustNotRun());
                if (!predecessor.isRequired()) continue;
                workInfo.require();
                continue block0;
            }
        }
    }

    private void requireWithDependencies(WorkInfo workInfo) {
        if (workInfo.isMustNotRun() && this.nodeSatisfiesTaskFilter(workInfo)) {
            workInfo.require();
            for (WorkInfo dependency : workInfo.getDependencySuccessors()) {
                this.requireWithDependencies(dependency);
            }
        }
    }

    public void determineExecutionPlan() {
        ArrayList nodeQueue = Lists.newArrayList((Iterable)Iterables.transform(this.entryTasks, (Function)new Function<TaskInfo, WorkInfoInVisitingSegment>(){
            private int index;

            public WorkInfoInVisitingSegment apply(TaskInfo taskInfo) {
                return new WorkInfoInVisitingSegment(taskInfo, this.index++);
            }
        }));
        int visitingSegmentCounter = nodeQueue.size();
        HashMultimap visitingNodes = HashMultimap.create();
        ArrayDeque<GraphEdge> walkedShouldRunAfterEdges = new ArrayDeque<GraphEdge>();
        ArrayDeque<WorkInfo> path = new ArrayDeque<WorkInfo>();
        HashMap planBeforeVisiting = Maps.newHashMap();
        while (!nodeQueue.isEmpty()) {
            WorkInfoInVisitingSegment workInfoInVisitingSegment = (WorkInfoInVisitingSegment)nodeQueue.get(0);
            int currentSegment = workInfoInVisitingSegment.visitingSegment;
            WorkInfo workInfo = workInfoInVisitingSegment.workInfo;
            if (workInfo.isIncludeInGraph() || this.workInfoMapping.contains(workInfo)) {
                nodeQueue.remove(0);
                visitingNodes.remove((Object)workInfo, (Object)currentSegment);
                this.maybeRemoveProcessedShouldRunAfterEdge(walkedShouldRunAfterEdges, workInfo);
                continue;
            }
            boolean alreadyVisited = visitingNodes.containsKey((Object)workInfo);
            visitingNodes.put((Object)workInfo, (Object)currentSegment);
            if (!alreadyVisited) {
                this.recordEdgeIfArrivedViaShouldRunAfter(walkedShouldRunAfterEdges, path, workInfo);
                this.removeShouldRunAfterSuccessorsIfTheyImposeACycle((HashMultimap<WorkInfo, Integer>)visitingNodes, workInfoInVisitingSegment);
                this.takePlanSnapshotIfCanBeRestoredToCurrentTask(planBeforeVisiting, workInfo);
                for (WorkInfo successor : workInfo.getAllSuccessorsInReverseOrder()) {
                    if (visitingNodes.containsEntry((Object)successor, (Object)currentSegment)) {
                        if (!walkedShouldRunAfterEdges.isEmpty()) {
                            GraphEdge toBeRemoved = (GraphEdge)walkedShouldRunAfterEdges.pop();
                            TaskInfo sourceTask = (TaskInfo)toBeRemoved.from;
                            TaskInfo targetTask = (TaskInfo)toBeRemoved.to;
                            sourceTask.removeShouldSuccessor(targetTask);
                            this.restorePath(path, toBeRemoved);
                            this.restoreQueue(nodeQueue, (HashMultimap<WorkInfo, Integer>)visitingNodes, toBeRemoved);
                            this.restoreExecutionPlan(planBeforeVisiting, toBeRemoved);
                            break;
                        }
                        this.onOrderingCycle(successor, workInfo);
                    }
                    nodeQueue.add(0, new WorkInfoInVisitingSegment(successor, currentSegment));
                }
                path.push(workInfo);
                continue;
            }
            nodeQueue.remove(0);
            this.maybeRemoveProcessedShouldRunAfterEdge(walkedShouldRunAfterEdges, workInfo);
            visitingNodes.remove((Object)workInfo, (Object)currentSegment);
            path.pop();
            this.workInfoMapping.add(workInfo);
            MutationInfo mutations = this.getOrCreateMutationsOf(workInfo);
            for (WorkInfo dependency : workInfo.getDependencySuccessors()) {
                this.getOrCreateMutationsOf((WorkInfo)dependency).consumingWork.add(workInfo);
                mutations.consumesOutputOf.add(dependency);
            }
            if (!(workInfo instanceof LocalTaskInfo)) continue;
            LocalTaskInfo taskInfo = (LocalTaskInfo)workInfo;
            TaskInternal task = taskInfo.getTask();
            Project project = task.getProject();
            this.projectLocks.put(project, this.getOrCreateProjectLock(project));
            for (WorkInfo finalizer : taskInfo.getFinalizers()) {
                if (visitingNodes.containsKey((Object)finalizer)) continue;
                nodeQueue.add(this.finalizerTaskPosition(finalizer, nodeQueue), new WorkInfoInVisitingSegment(finalizer, visitingSegmentCounter++));
            }
        }
        this.executionQueue.clear();
        Iterables.addAll(this.executionQueue, (Iterable)this.workInfoMapping);
    }

    @Override
    public Set<Task> getDependencies(Task task) {
        TaskInfo node = this.workInfoMapping.get(task);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (WorkInfo taskInfo : node.getDependencySuccessors()) {
            taskInfo.collectTaskInto((ImmutableCollection.Builder<Task>)builder);
        }
        return builder.build();
    }

    private MutationInfo getOrCreateMutationsOf(WorkInfo workInfo) {
        MutationInfo mutations = this.workMutations.get(workInfo);
        if (mutations == null) {
            mutations = new MutationInfo(workInfo);
            this.workMutations.put(workInfo, mutations);
        }
        return mutations;
    }

    private void maybeRemoveProcessedShouldRunAfterEdge(Deque<GraphEdge> walkedShouldRunAfterEdges, WorkInfo workInfo) {
        GraphEdge edge = walkedShouldRunAfterEdges.peek();
        if (edge != null && edge.to.equals(workInfo)) {
            walkedShouldRunAfterEdges.pop();
        }
    }

    private void restoreExecutionPlan(Map<WorkInfo, Integer> planBeforeVisiting, GraphEdge toBeRemoved) {
        int count = planBeforeVisiting.get(toBeRemoved.from);
        this.workInfoMapping.retainFirst(count);
    }

    private void restoreQueue(List<WorkInfoInVisitingSegment> nodeQueue, HashMultimap<WorkInfo, Integer> visitingNodes, GraphEdge toBeRemoved) {
        WorkInfoInVisitingSegment nextInQueue = null;
        while (nextInQueue == null || !toBeRemoved.from.equals(nextInQueue.workInfo)) {
            nextInQueue = nodeQueue.get(0);
            visitingNodes.remove((Object)nextInQueue.workInfo, (Object)nextInQueue.visitingSegment);
            if (toBeRemoved.from.equals(nextInQueue.workInfo)) continue;
            nodeQueue.remove(0);
        }
    }

    private void restorePath(Deque<WorkInfo> path, GraphEdge toBeRemoved) {
        WorkInfo removedFromPath = null;
        while (!toBeRemoved.from.equals(removedFromPath)) {
            removedFromPath = path.pop();
        }
    }

    private void removeShouldRunAfterSuccessorsIfTheyImposeACycle(final HashMultimap<WorkInfo, Integer> visitingNodes, final WorkInfoInVisitingSegment taskNodeWithVisitingSegment) {
        WorkInfo workInfo = taskNodeWithVisitingSegment.workInfo;
        if (!(workInfo instanceof TaskInfo)) {
            return;
        }
        Iterables.removeIf(((TaskInfo)workInfo).getShouldSuccessors(), (Predicate)new Predicate<WorkInfo>(){

            public boolean apply(WorkInfo input) {
                return visitingNodes.containsEntry((Object)input, (Object)taskNodeWithVisitingSegment.visitingSegment);
            }
        });
    }

    private void takePlanSnapshotIfCanBeRestoredToCurrentTask(Map<WorkInfo, Integer> planBeforeVisiting, WorkInfo workInfo) {
        if (workInfo instanceof TaskInfo && !((TaskInfo)workInfo).getShouldSuccessors().isEmpty()) {
            planBeforeVisiting.put(workInfo, this.workInfoMapping.size());
        }
    }

    private void recordEdgeIfArrivedViaShouldRunAfter(Deque<GraphEdge> walkedShouldRunAfterEdges, Deque<WorkInfo> path, WorkInfo workInfo) {
        if (!(workInfo instanceof TaskInfo)) {
            return;
        }
        WorkInfo previous = path.peek();
        if (previous instanceof TaskInfo && ((TaskInfo)previous).getShouldSuccessors().contains(workInfo)) {
            walkedShouldRunAfterEdges.push(new GraphEdge(previous, workInfo));
        }
    }

    private int finalizerTaskPosition(WorkInfo finalizer, final List<WorkInfoInVisitingSegment> nodeQueue) {
        if (nodeQueue.size() == 0) {
            return 0;
        }
        Set<WorkInfo> precedingTasks = this.getAllPrecedingTasks(finalizer);
        Set<Integer> precedingTaskIndices = CollectionUtils.collect(precedingTasks, new Transformer<Integer, WorkInfo>(){

            @Override
            public Integer transform(final WorkInfo dependsOnTask) {
                return Iterables.indexOf((Iterable)nodeQueue, (Predicate)new Predicate<WorkInfoInVisitingSegment>(){

                    public boolean apply(WorkInfoInVisitingSegment taskInfoInVisitingSegment) {
                        return taskInfoInVisitingSegment.workInfo.equals(dependsOnTask);
                    }
                });
            }
        });
        return Collections.max(precedingTaskIndices) + 1;
    }

    private Set<WorkInfo> getAllPrecedingTasks(WorkInfo finalizer) {
        HashSet precedingTasks = Sets.newHashSet();
        ArrayDeque<WorkInfo> candidateTasks = new ArrayDeque<WorkInfo>();
        Iterables.addAll(candidateTasks, finalizer.getAllSuccessors());
        while (!candidateTasks.isEmpty()) {
            WorkInfo precedingTask = (WorkInfo)candidateTasks.pop();
            if (!precedingTasks.add(precedingTask) || !(precedingTask instanceof TaskInfo)) continue;
            candidateTasks.addAll(((TaskInfo)precedingTask).getMustSuccessors());
            candidateTasks.addAll(((TaskInfo)precedingTask).getFinalizingSuccessors());
        }
        return precedingTasks;
    }

    private void onOrderingCycle(WorkInfo successor, WorkInfo workInfo) {
        CachingDirectedGraphWalker<WorkInfo, Void> graphWalker = new CachingDirectedGraphWalker<WorkInfo, Void>(new DirectedGraph<WorkInfo, Void>(){

            @Override
            public void getNodeValues(WorkInfo node, Collection<? super Void> values, Collection<? super WorkInfo> connectedNodes) {
                connectedNodes.addAll(node.getDependencySuccessors());
                if (node instanceof TaskInfo) {
                    TaskInfo taskInfo = (TaskInfo)node;
                    connectedNodes.addAll(taskInfo.getMustSuccessors());
                    connectedNodes.addAll(taskInfo.getFinalizingSuccessors());
                }
            }
        });
        graphWalker.add((Iterable<WorkInfo>)this.entryTasks);
        List<Set<WorkInfo>> cycles = graphWalker.findCycles();
        if (cycles.isEmpty()) {
            throw new GradleException("Misdetected cycle between " + workInfo + " and " + successor + ". Help us by reporting this to https://github.com/gradle/gradle/issues/2293");
        }
        final ArrayList firstCycle = new ArrayList(cycles.get(0));
        Collections.sort(firstCycle);
        DirectedGraphRenderer<WorkInfo> graphRenderer = new DirectedGraphRenderer<WorkInfo>(new GraphNodeRenderer<WorkInfo>(){

            @Override
            public void renderTo(WorkInfo node, StyledTextOutput output) {
                output.withStyle(StyledTextOutput.Style.Identifier).text(node);
            }
        }, new DirectedGraph<WorkInfo, Object>(){

            @Override
            public void getNodeValues(WorkInfo node, Collection<? super Object> values, Collection<? super WorkInfo> connectedNodes) {
                for (WorkInfo dependency : firstCycle) {
                    if (!node.hasHardSuccessor(dependency)) continue;
                    connectedNodes.add(dependency);
                }
            }
        });
        StringWriter writer = new StringWriter();
        graphRenderer.renderTo((WorkInfo)firstCycle.get(0), writer);
        throw new CircularReferenceException(String.format("Circular dependency between the following tasks:%n%s", writer.toString()));
    }

    public void clear() {
        this.nodeFactory.clear();
        this.dependencyResolver.clear();
        this.entryTasks.clear();
        this.workInfoMapping.clear();
        this.executionQueue.clear();
        this.projectLocks.clear();
        this.failureCollector.clearFailures();
        this.workMutations.clear();
        this.canonicalizedFileCache.clear();
        this.reachableCache.clear();
        this.dependenciesCompleteCache.clear();
        this.runningNodes.clear();
    }

    @Override
    public Set<Task> getTasks() {
        return this.workInfoMapping.getTasks();
    }

    @Override
    public Set<Task> getFilteredTasks() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (WorkInfo filteredNode : this.filteredNodes) {
            if (!(filteredNode instanceof LocalTaskInfo)) continue;
            builder.add((Object)((LocalTaskInfo)filteredNode).getTask());
        }
        return builder.build();
    }

    public void useFilter(Spec<? super Task> filter) {
        this.filter = filter;
    }

    public void setContinueOnFailure(boolean continueOnFailre) {
        this.continueOnFailure = continueOnFailre;
    }

    @Override
    @Nullable
    public WorkInfo selectNext(WorkerLeaseRegistry.WorkerLease workerLease, ResourceLockState resourceLockState) {
        if (this.allProjectsLocked()) {
            return null;
        }
        Iterator<WorkInfo> iterator = this.executionQueue.iterator();
        while (iterator.hasNext()) {
            WorkInfo workInfo = iterator.next();
            if (!workInfo.isReady() || !this.allDependenciesComplete(workInfo)) continue;
            MutationInfo mutations = this.getResolvedMutationInfo(workInfo);
            if (!(this.tryLockProjectFor(workInfo) && workerLease.tryLock() && this.canRunWithCurrentlyExecutedTasks(workInfo, mutations))) {
                resourceLockState.releaseLocks();
                continue;
            }
            if (workInfo.allDependenciesSuccessful()) {
                this.recordWorkStarted(workInfo);
                workInfo.startExecution();
            } else {
                workInfo.skipExecution();
            }
            iterator.remove();
            return workInfo;
        }
        return null;
    }

    private boolean tryLockProjectFor(WorkInfo workInfo) {
        if (workInfo instanceof LocalTaskInfo) {
            return this.getProjectLock((LocalTaskInfo)workInfo).tryLock();
        }
        return true;
    }

    private void unlockProjectFor(WorkInfo workInfo) {
        if (workInfo instanceof LocalTaskInfo) {
            this.getProjectLock((LocalTaskInfo)workInfo).unlock();
        }
    }

    private ResourceLock getProjectLock(LocalTaskInfo taskInfo) {
        return this.projectLocks.get(taskInfo.getTask().getProject());
    }

    private MutationInfo getResolvedMutationInfo(WorkInfo workInfo) {
        MutationInfo mutations = this.workMutations.get(workInfo);
        if (!mutations.resolved) {
            this.resolveMutations(mutations, workInfo);
        }
        return mutations;
    }

    private void resolveMutations(MutationInfo mutations, WorkInfo workInfo) {
        if (workInfo instanceof LocalTaskInfo) {
            LocalTaskInfo taskInfo = (LocalTaskInfo)workInfo;
            TaskInternal task = taskInfo.getTask();
            ProjectInternal project = (ProjectInternal)task.getProject();
            ServiceRegistry serviceRegistry = project.getServices();
            PathToFileResolver resolver = serviceRegistry.get(PathToFileResolver.class);
            PropertyWalker propertyWalker = serviceRegistry.get(PropertyWalker.class);
            TaskProperties taskProperties = DefaultTaskProperties.resolve(propertyWalker, resolver, task);
            mutations.outputPaths.addAll(DefaultTaskExecutionPlan.getOutputPaths(this.canonicalizedFileCache, taskInfo, taskProperties.getOutputFiles(), taskProperties.getLocalStateFiles()));
            mutations.destroyablePaths.addAll(DefaultTaskExecutionPlan.getDestroyablePaths(this.canonicalizedFileCache, taskInfo, taskProperties.getDestroyableFiles()));
            mutations.hasFileInputs = !taskProperties.getInputFileProperties().isEmpty();
            mutations.hasOutputs = taskProperties.hasDeclaredOutputs();
            mutations.hasLocalState = !taskProperties.getLocalStateFiles().isEmpty();
            mutations.resolved = true;
            if (!mutations.destroyablePaths.isEmpty()) {
                if (mutations.hasOutputs) {
                    throw new IllegalStateException("Task " + taskInfo + " has both outputs and destroyables defined.  A task can define either outputs or destroyables, but not both.");
                }
                if (mutations.hasFileInputs) {
                    throw new IllegalStateException("Task " + taskInfo + " has both inputs and destroyables defined.  A task can define either inputs or destroyables, but not both.");
                }
                if (mutations.hasLocalState) {
                    throw new IllegalStateException("Task " + taskInfo + " has both local state and destroyables defined.  A task can define either local state or destroyables, but not both.");
                }
            }
        }
    }

    private boolean allDependenciesComplete(WorkInfo workInfo) {
        if (this.dependenciesCompleteCache.contains(workInfo)) {
            return true;
        }
        boolean dependenciesComplete = workInfo.allDependenciesComplete();
        if (dependenciesComplete) {
            this.dependenciesCompleteCache.add(workInfo);
        }
        return dependenciesComplete;
    }

    private boolean allProjectsLocked() {
        for (ResourceLock lock : this.projectLocks.values()) {
            if (lock.isLocked()) continue;
            return false;
        }
        return true;
    }

    private ResourceLock getOrCreateProjectLock(Project project) {
        String gradlePath = ((GradleInternal)project.getGradle()).getIdentityPath().toString();
        String projectPath = ((ProjectInternal)project).getIdentityPath().toString();
        return this.workerLeaseService.getProjectLock(gradlePath, projectPath);
    }

    private boolean canRunWithCurrentlyExecutedTasks(WorkInfo taskInfo, MutationInfo mutations) {
        Set<String> candidateTaskDestroyables = mutations.destroyablePaths;
        if (!this.runningNodes.isEmpty()) {
            Set<String> candidateMutations;
            Set<String> candidateTaskOutputs = mutations.outputPaths;
            Set<String> set = candidateMutations = !candidateTaskOutputs.isEmpty() ? candidateTaskOutputs : candidateTaskDestroyables;
            if (this.hasTaskWithOverlappingMutations(candidateMutations)) {
                return false;
            }
        }
        return !this.doesDestroyNotYetConsumedOutputOfAnotherTask(taskInfo, candidateTaskDestroyables);
    }

    private static ImmutableSet<String> canonicalizedPaths(Map<File, String> cache, Iterable<File> files) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (File file : files) {
            try {
                String path = cache.get(file);
                if (path == null) {
                    path = file.getCanonicalPath();
                    cache.put(file, path);
                }
                builder.add((Object)path);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return builder.build();
    }

    private boolean hasTaskWithOverlappingMutations(Set<String> candidateMutationPaths) {
        if (!candidateMutationPaths.isEmpty()) {
            for (WorkInfo runningWork : this.runningNodes) {
                MutationInfo runningMutations = this.workMutations.get(runningWork);
                Iterable runningMutationPaths = Iterables.concat(runningMutations.outputPaths, runningMutations.destroyablePaths);
                if (!DefaultTaskExecutionPlan.hasOverlap(candidateMutationPaths, runningMutationPaths)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean doesDestroyNotYetConsumedOutputOfAnotherTask(WorkInfo destroyerTask, Set<String> destroyablePaths) {
        if (!destroyablePaths.isEmpty()) {
            for (MutationInfo producingWork : this.workMutations.values()) {
                if (!producingWork.workInfo.isComplete() || producingWork.consumingWork.isEmpty() || !DefaultTaskExecutionPlan.hasOverlap(destroyablePaths, producingWork.outputPaths)) continue;
                for (WorkInfo consumer : producingWork.consumingWork) {
                    if (this.doesConsumerDependOnDestroyer(consumer, destroyerTask)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean doesConsumerDependOnDestroyer(WorkInfo consumer, WorkInfo destroyer) {
        if (consumer == destroyer) {
            return true;
        }
        Pair<WorkInfo, WorkInfo> workPair = Pair.of(consumer, destroyer);
        if (this.reachableCache.get(workPair) != null) {
            return this.reachableCache.get(workPair);
        }
        boolean reachable = false;
        for (WorkInfo dependency : consumer.getAllSuccessors()) {
            if (dependency.isComplete() || !this.doesConsumerDependOnDestroyer(dependency, destroyer)) continue;
            reachable = true;
        }
        this.reachableCache.put(workPair, reachable);
        return reachable;
    }

    private static boolean hasOverlap(Iterable<String> paths1, Iterable<String> paths2) {
        for (String path1 : paths1) {
            for (String path2 : paths2) {
                String overLappedPath = DefaultTaskExecutionPlan.getOverLappedPath(path1, path2);
                if (overLappedPath == null) continue;
                return true;
            }
        }
        return false;
    }

    private static Set<String> getOutputPaths(Map<File, String> canonicalizedFileCache, TaskInfo task, FileCollection outputFiles, FileCollection localStateFiles) {
        try {
            return DefaultTaskExecutionPlan.canonicalizedPaths(canonicalizedFileCache, Iterables.concat((Iterable)outputFiles, (Iterable)localStateFiles));
        }
        catch (ResourceDeadlockException e) {
            throw new IllegalStateException(DefaultTaskExecutionPlan.deadlockMessage(task, "an output or local state", "outputs"), e);
        }
    }

    private static Set<String> getDestroyablePaths(Map<File, String> canonicalizedFileCache, TaskInfo task, FileCollection destroyableFiles) {
        try {
            return DefaultTaskExecutionPlan.canonicalizedPaths(canonicalizedFileCache, destroyableFiles);
        }
        catch (ResourceDeadlockException e) {
            throw new IllegalStateException(DefaultTaskExecutionPlan.deadlockMessage(task, "a destroyable", "destroyables"), e);
        }
    }

    private static String deadlockMessage(TaskInfo task, String singular, String plural) {
        return String.format("A deadlock was detected while resolving the %s for task '%s'. This can be caused, for instance, by %s property causing dependency resolution.", plural, task, singular);
    }

    @Nullable
    private static String getOverLappedPath(String firstPath, String secondPath) {
        boolean isOverlapping;
        String longer;
        String shorter;
        if (firstPath.equals(secondPath)) {
            return firstPath;
        }
        if (firstPath.length() == secondPath.length()) {
            return null;
        }
        if (firstPath.length() > secondPath.length()) {
            shorter = secondPath;
            longer = firstPath;
        } else {
            shorter = firstPath;
            longer = secondPath;
        }
        boolean bl = isOverlapping = longer.startsWith(shorter) && longer.charAt(shorter.length()) == File.separatorChar;
        if (isOverlapping) {
            return shorter;
        }
        return null;
    }

    private void recordWorkStarted(WorkInfo workInfo) {
        this.runningNodes.add(workInfo);
    }

    private void recordWorkCompleted(WorkInfo workInfo) {
        this.runningNodes.remove(workInfo);
        MutationInfo mutations = this.workMutations.get(workInfo);
        for (WorkInfo producer : mutations.consumesOutputOf) {
            MutationInfo producerMutations = this.workMutations.get(producer);
            if (!producerMutations.consumingWork.remove(workInfo) || !DefaultTaskExecutionPlan.canRemoveMutation(producerMutations)) continue;
            this.workMutations.remove(producer);
        }
        if (DefaultTaskExecutionPlan.canRemoveMutation(mutations)) {
            this.workMutations.remove(workInfo);
        }
    }

    private static boolean canRemoveMutation(@Nullable MutationInfo mutations) {
        return mutations != null && mutations.workInfo.isComplete() && mutations.consumingWork.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void workComplete(WorkInfo workInfo) {
        try {
            if (!workInfo.isComplete()) {
                DefaultTaskExecutionPlan.enforceFinalizerTasks(workInfo);
                if (workInfo.isFailed()) {
                    this.handleFailure(workInfo);
                }
                workInfo.finishExecution();
                this.recordWorkCompleted(workInfo);
            }
        }
        finally {
            this.unlockProjectFor(workInfo);
        }
    }

    private static void enforceFinalizerTasks(WorkInfo workInfo) {
        if (!(workInfo instanceof TaskInfo)) {
            return;
        }
        for (WorkInfo finalizerNode : ((TaskInfo)workInfo).getFinalizers()) {
            if (!finalizerNode.isRequired() && !finalizerNode.isMustNotRun()) continue;
            DefaultTaskExecutionPlan.enforceWithDependencies(finalizerNode, Sets.newHashSet());
        }
    }

    private static void enforceWithDependencies(WorkInfo nodeInfo, Set<WorkInfo> enforcedNodes) {
        ArrayDeque<WorkInfo> candidateNodes = new ArrayDeque<WorkInfo>();
        candidateNodes.add(nodeInfo);
        while (!candidateNodes.isEmpty()) {
            WorkInfo node = (WorkInfo)candidateNodes.pop();
            if (enforcedNodes.contains(node)) continue;
            enforcedNodes.add(node);
            candidateNodes.addAll(node.getDependencySuccessors());
            if (!node.isMustNotRun() && !node.isRequired()) continue;
            node.enforceRun();
        }
    }

    @Override
    public void abortAllAndFail(Throwable t) {
        this.abortExecution(true);
        this.failureCollector.addFailure(t);
    }

    private void handleFailure(WorkInfo workInfo) {
        Throwable executionFailure = workInfo.getExecutionFailure();
        if (executionFailure != null) {
            this.abortExecution();
            this.failureCollector.addFailure(executionFailure);
            return;
        }
        try {
            if (!this.continueOnFailure) {
                workInfo.rethrowFailure();
            }
            this.failureCollector.addFailure(workInfo.getWorkFailure());
        }
        catch (Exception e) {
            this.abortExecution();
            this.failureCollector.addFailure(e);
        }
    }

    private boolean abortExecution() {
        return this.abortExecution(false);
    }

    @Override
    public void cancelExecution() {
        this.tasksCancelled = this.abortExecution() || this.tasksCancelled;
    }

    private boolean abortExecution(boolean abortAll) {
        boolean aborted = false;
        for (WorkInfo workInfo : this.workInfoMapping) {
            if (workInfo.isRequired()) {
                workInfo.skipExecution();
                aborted = true;
            }
            if (!abortAll || !workInfo.isReady()) continue;
            workInfo.abortExecution();
            aborted = true;
        }
        return aborted;
    }

    @Override
    public void collectFailures(Collection<? super Throwable> failures) {
        if (this.tasksCancelled) {
            failures.add(new BuildCancelledException());
        }
        failures.addAll(this.failureCollector.getFailures());
    }

    @Override
    public boolean allTasksComplete() {
        for (WorkInfo workInfo : this.workInfoMapping) {
            if (workInfo.isComplete()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasWorkRemaining() {
        for (WorkInfo workInfo : this.executionQueue) {
            if (workInfo.isComplete()) continue;
            return true;
        }
        return !this.runningNodes.isEmpty();
    }

    @Override
    public int size() {
        return this.workInfoMapping.workInfos.size();
    }

    private static class WorkInfoMapping
    extends AbstractCollection<WorkInfo> {
        private final Map<Task, LocalTaskInfo> taskMapping = Maps.newLinkedHashMap();
        private final Set<WorkInfo> workInfos = Sets.newLinkedHashSet();

        private WorkInfoMapping() {
        }

        @Override
        public boolean contains(Object o) {
            return this.workInfos.contains(o);
        }

        @Override
        public boolean add(WorkInfo workInfo) {
            if (!this.workInfos.add(workInfo)) {
                return false;
            }
            if (workInfo instanceof LocalTaskInfo) {
                LocalTaskInfo taskInfo = (LocalTaskInfo)workInfo;
                this.taskMapping.put(taskInfo.getTask(), taskInfo);
            }
            return true;
        }

        public TaskInfo get(Task task) {
            TaskInfo taskInfo = this.taskMapping.get(task);
            if (taskInfo == null) {
                throw new IllegalStateException("Task is not part of the execution plan, no dependency information is available.");
            }
            return taskInfo;
        }

        public Set<Task> getTasks() {
            return this.taskMapping.keySet();
        }

        @Override
        public Iterator<WorkInfo> iterator() {
            return this.workInfos.iterator();
        }

        @Override
        public void clear() {
            this.workInfos.clear();
            this.taskMapping.clear();
        }

        @Override
        public int size() {
            return this.workInfos.size();
        }

        public void retainFirst(int count) {
            Iterator<WorkInfo> executionPlanIterator = this.workInfos.iterator();
            for (int i = 0; i < count; ++i) {
                executionPlanIterator.next();
            }
            while (executionPlanIterator.hasNext()) {
                WorkInfo removedWork = executionPlanIterator.next();
                executionPlanIterator.remove();
                if (!(removedWork instanceof LocalTaskInfo)) continue;
                this.taskMapping.remove(((LocalTaskInfo)removedWork).getTask());
            }
        }
    }

    private static class MutationInfo {
        final WorkInfo workInfo;
        final Set<WorkInfo> consumingWork = Sets.newHashSet();
        final Set<WorkInfo> consumesOutputOf = Sets.newHashSet();
        final Set<String> outputPaths = Sets.newHashSet();
        final Set<String> destroyablePaths = Sets.newHashSet();
        boolean hasFileInputs;
        boolean hasOutputs;
        boolean hasLocalState;
        boolean resolved;

        MutationInfo(WorkInfo workInfo) {
            this.workInfo = workInfo;
        }
    }

    private static class WorkInfoInVisitingSegment {
        private final WorkInfo workInfo;
        private final int visitingSegment;

        private WorkInfoInVisitingSegment(WorkInfo workInfo, int visitingSegment) {
            this.workInfo = workInfo;
            this.visitingSegment = visitingSegment;
        }
    }

    private static class GraphEdge {
        private final WorkInfo from;
        private final WorkInfo to;

        private GraphEdge(WorkInfo from, WorkInfo to) {
            this.from = from;
            this.to = to;
        }
    }
}

