/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.caching.internal.tasks;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedSet;
import org.gradle.api.GradleException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.internal.TaskInternal;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.changedetection.TaskArtifactState;
import org.gradle.api.internal.changedetection.state.FileSystemMirror;
import org.gradle.api.internal.changedetection.state.mirror.FileSystemSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalMissingSnapshot;
import org.gradle.api.internal.changedetection.state.mirror.PhysicalSnapshot;
import org.gradle.api.internal.tasks.OriginTaskExecutionMetadata;
import org.gradle.api.internal.tasks.ResolvedTaskOutputFilePropertySpec;
import org.gradle.api.internal.tasks.execution.TaskOutputChangesListener;
import org.gradle.api.internal.tasks.execution.TaskProperties;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.caching.BuildCacheKey;
import org.gradle.caching.internal.controller.BuildCacheLoadCommand;
import org.gradle.caching.internal.controller.BuildCacheStoreCommand;
import org.gradle.caching.internal.tasks.TaskOutputCachingBuildCacheKey;
import org.gradle.caching.internal.tasks.TaskOutputPacker;
import org.gradle.caching.internal.tasks.UnrecoverableTaskOutputUnpackingException;
import org.gradle.caching.internal.tasks.origin.TaskOutputOriginFactory;
import org.gradle.internal.file.FileType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.impl.AbsolutePathFingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultCurrentFileCollectionFingerprint;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSortedMap;
import org.gradle.internal.impldep.org.apache.commons.io.FileUtils;
import org.gradle.internal.nativeintegration.filesystem.DefaultFileMetadata;

public class TaskOutputCacheCommandFactory {
    private static final Logger LOGGER = Logging.getLogger(TaskOutputCacheCommandFactory.class);
    private final TaskOutputPacker packer;
    private final TaskOutputOriginFactory taskOutputOriginFactory;
    private final FileSystemMirror fileSystemMirror;
    private final StringInterner stringInterner;

    public TaskOutputCacheCommandFactory(TaskOutputPacker packer, TaskOutputOriginFactory taskOutputOriginFactory, FileSystemMirror fileSystemMirror, StringInterner stringInterner) {
        this.packer = packer;
        this.taskOutputOriginFactory = taskOutputOriginFactory;
        this.fileSystemMirror = fileSystemMirror;
        this.stringInterner = stringInterner;
    }

    public BuildCacheLoadCommand<OriginTaskExecutionMetadata> createLoad(TaskOutputCachingBuildCacheKey cacheKey, SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties, TaskInternal task, TaskProperties taskProperties, TaskOutputChangesListener taskOutputChangesListener, TaskArtifactState taskArtifactState) {
        return new LoadCommand(cacheKey, outputProperties, task, taskProperties, taskOutputChangesListener, taskArtifactState);
    }

    public BuildCacheStoreCommand createStore(TaskOutputCachingBuildCacheKey cacheKey, SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties, Map<String, CurrentFileCollectionFingerprint> outputFingerprints, TaskInternal task, long taskExecutionTime) {
        return new StoreCommand(cacheKey, outputProperties, outputFingerprints, task, taskExecutionTime);
    }

    private String internedAbsolutePath(File outputFile) {
        return this.stringInterner.intern(outputFile.getAbsolutePath());
    }

    private class StoreCommand
    implements BuildCacheStoreCommand {
        private final TaskOutputCachingBuildCacheKey cacheKey;
        private final SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties;
        private final Map<String, CurrentFileCollectionFingerprint> outputFingerprints;
        private final TaskInternal task;
        private final long taskExecutionTime;

        private StoreCommand(TaskOutputCachingBuildCacheKey cacheKey, SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties, Map<String, CurrentFileCollectionFingerprint> outputFingerprints, TaskInternal task, long taskExecutionTime) {
            this.cacheKey = cacheKey;
            this.outputProperties = outputProperties;
            this.outputFingerprints = outputFingerprints;
            this.task = task;
            this.taskExecutionTime = taskExecutionTime;
        }

        @Override
        public BuildCacheKey getKey() {
            return this.cacheKey;
        }

        @Override
        public BuildCacheStoreCommand.Result store(OutputStream output) throws IOException {
            LOGGER.info("Packing {}", this.task);
            final TaskOutputPacker.PackResult packResult = TaskOutputCacheCommandFactory.this.packer.pack(this.outputProperties, this.outputFingerprints, output, TaskOutputCacheCommandFactory.this.taskOutputOriginFactory.createWriter(this.task, this.taskExecutionTime));
            return new BuildCacheStoreCommand.Result(){

                @Override
                public long getArtifactEntryCount() {
                    return packResult.getEntries();
                }
            };
        }
    }

    private class LoadCommand
    implements BuildCacheLoadCommand<OriginTaskExecutionMetadata> {
        private final TaskOutputCachingBuildCacheKey cacheKey;
        private final SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties;
        private final TaskInternal task;
        private final TaskProperties taskProperties;
        private final TaskOutputChangesListener taskOutputChangesListener;
        private final TaskArtifactState taskArtifactState;

        private LoadCommand(TaskOutputCachingBuildCacheKey cacheKey, SortedSet<ResolvedTaskOutputFilePropertySpec> outputProperties, TaskInternal task, TaskProperties taskProperties, TaskOutputChangesListener taskOutputChangesListener, TaskArtifactState taskArtifactState) {
            this.cacheKey = cacheKey;
            this.outputProperties = outputProperties;
            this.task = task;
            this.taskProperties = taskProperties;
            this.taskOutputChangesListener = taskOutputChangesListener;
            this.taskArtifactState = taskArtifactState;
        }

        @Override
        public BuildCacheKey getKey() {
            return this.cacheKey;
        }

        @Override
        public BuildCacheLoadCommand.Result<OriginTaskExecutionMetadata> load(InputStream input) {
            TaskOutputPacker.UnpackResult unpackResult;
            this.taskOutputChangesListener.beforeTaskOutputChanged();
            try {
                unpackResult = TaskOutputCacheCommandFactory.this.packer.unpack(this.outputProperties, input, TaskOutputCacheCommandFactory.this.taskOutputOriginFactory.createReader(this.task));
                this.updateSnapshots(unpackResult.getSnapshots(), unpackResult.getOriginMetadata());
            }
            catch (Exception e) {
                LOGGER.warn("Cleaning outputs for {} after failed load from cache.", this.task);
                try {
                    this.cleanupOutputsAfterUnpackFailure();
                    this.taskArtifactState.afterOutputsRemovedBeforeTask();
                }
                catch (Exception eCleanup) {
                    LOGGER.warn("Unrecoverable error during cleaning up after task output unpack failure", eCleanup);
                    throw new UnrecoverableTaskOutputUnpackingException(String.format("Failed to unpack outputs for %s, and then failed to clean up; see log above for details", this.task), e);
                }
                throw new GradleException(String.format("Failed to unpack outputs for %s", this.task), e);
            }
            finally {
                this.cleanLocalState();
            }
            LOGGER.info("Unpacked output for {} from cache.", this.task);
            return new BuildCacheLoadCommand.Result<OriginTaskExecutionMetadata>(){

                @Override
                public long getArtifactEntryCount() {
                    return unpackResult.getEntries();
                }

                @Override
                public OriginTaskExecutionMetadata getMetadata() {
                    return unpackResult.getOriginMetadata();
                }
            };
        }

        private void updateSnapshots(Map<String, ? extends PhysicalSnapshot> propertiesSnapshots, OriginTaskExecutionMetadata originMetadata) {
            ImmutableSortedMap.Builder propertyFingerprintsBuilder = ImmutableSortedMap.naturalOrder();
            AbsolutePathFingerprintingStrategy fingerprintingStrategy = AbsolutePathFingerprintingStrategy.IGNORE_MISSING;
            for (ResolvedTaskOutputFilePropertySpec property : this.outputProperties) {
                String propertyName = property.getPropertyName();
                File outputFile = property.getOutputFile();
                if (outputFile == null) {
                    propertyFingerprintsBuilder.put((Object)propertyName, (Object)fingerprintingStrategy.getIdentifier().getEmptyFingerprint());
                    continue;
                }
                PhysicalSnapshot snapshot = propertiesSnapshots.get(propertyName);
                String absolutePath = TaskOutputCacheCommandFactory.this.internedAbsolutePath(outputFile);
                ArrayList<FileSystemSnapshot> roots = new ArrayList<FileSystemSnapshot>();
                if (snapshot == null) {
                    TaskOutputCacheCommandFactory.this.fileSystemMirror.putMetadata(absolutePath, DefaultFileMetadata.missing());
                    TaskOutputCacheCommandFactory.this.fileSystemMirror.putSnapshot(new PhysicalMissingSnapshot(absolutePath, property.getOutputFile().getName()));
                    propertyFingerprintsBuilder.put((Object)propertyName, (Object)fingerprintingStrategy.getIdentifier().getEmptyFingerprint());
                    continue;
                }
                switch (property.getOutputType()) {
                    case FILE: {
                        if (snapshot.getType() != FileType.RegularFile) {
                            throw new IllegalStateException(String.format("Only a regular file should be produced by unpacking property '%s', but saw a %s", new Object[]{propertyName, snapshot.getType()}));
                        }
                        roots.add(snapshot);
                        TaskOutputCacheCommandFactory.this.fileSystemMirror.putSnapshot(snapshot);
                        break;
                    }
                    case DIRECTORY: {
                        roots.add(snapshot);
                        TaskOutputCacheCommandFactory.this.fileSystemMirror.putMetadata(absolutePath, DefaultFileMetadata.directory());
                        TaskOutputCacheCommandFactory.this.fileSystemMirror.putSnapshot(snapshot);
                        break;
                    }
                    default: {
                        throw new AssertionError();
                    }
                }
                propertyFingerprintsBuilder.put((Object)propertyName, (Object)DefaultCurrentFileCollectionFingerprint.from(roots, fingerprintingStrategy));
            }
            this.taskArtifactState.snapshotAfterLoadedFromCache((ImmutableSortedMap<String, CurrentFileCollectionFingerprint>)propertyFingerprintsBuilder.build(), originMetadata);
        }

        private void cleanLocalState() {
            for (File localStateFile : this.taskProperties.getLocalStateFiles()) {
                try {
                    this.remove(localStateFile);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(String.format("Failed to clean up local state files for %s: %s", this.task, localStateFile), ex);
                }
            }
        }

        private void cleanupOutputsAfterUnpackFailure() {
            for (ResolvedTaskOutputFilePropertySpec outputProperty : this.outputProperties) {
                File outputFile = outputProperty.getOutputFile();
                try {
                    this.remove(outputFile);
                }
                catch (IOException ex) {
                    throw new UncheckedIOException(String.format("Failed to clean up files for output property '%s' of %s: %s", outputProperty.getPropertyName(), this.task, outputFile), ex);
                }
            }
        }

        private void remove(File file) throws IOException {
            if (file != null && file.exists()) {
                if (file.isDirectory()) {
                    FileUtils.cleanDirectory((File)file);
                } else {
                    FileUtils.forceDelete((File)file);
                }
            }
        }
    }
}

