/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal;

import java.util.Comparator;
import java.util.Set;
import org.gradle.api.tasks.diagnostics.internal.TaskDetails;
import org.gradle.api.tasks.diagnostics.internal.TaskReportModel;
import org.gradle.internal.impldep.com.google.common.collect.SetMultimap;
import org.gradle.internal.impldep.com.google.common.collect.TreeMultimap;
import org.gradle.util.GUtil;
import org.gradle.util.Path;

public class DefaultGroupTaskReportModel
implements TaskReportModel {
    public static final String OTHER_GROUP = "other";
    private static final Comparator<String> STRING_COMPARATOR = GUtil.caseInsensitive();
    private SetMultimap<String, TaskDetails> groups;

    public void build(TaskReportModel model) {
        Comparator<String> keyComparator = GUtil.last(GUtil.last(STRING_COMPARATOR, OTHER_GROUP), "");
        Comparator<TaskDetails> taskComparator = new Comparator<TaskDetails>(){

            @Override
            public int compare(TaskDetails task1, TaskDetails task2) {
                int diff = STRING_COMPARATOR.compare(task1.getPath().getName(), task2.getPath().getName());
                if (diff != 0) {
                    return diff;
                }
                Path parent1 = task1.getPath().getParent();
                Path parent2 = task2.getPath().getParent();
                if (parent1 == null && parent2 != null) {
                    return -1;
                }
                if (parent1 != null && parent2 == null) {
                    return 1;
                }
                if (parent1 == null) {
                    return 0;
                }
                return parent1.compareTo(parent2);
            }
        };
        this.groups = TreeMultimap.create(keyComparator, (Comparator)taskComparator);
        for (String group : model.getGroups()) {
            this.groups.putAll((Object)group, model.getTasksForGroup(group));
        }
        String otherGroupName = this.findOtherGroup(this.groups.keySet());
        if (otherGroupName != null && this.groups.keySet().contains("")) {
            this.groups.putAll((Object)otherGroupName, (Iterable)this.groups.removeAll((Object)""));
        }
        if (this.groups.keySet().contains("") && this.groups.keySet().size() > 1) {
            this.groups.putAll((Object)OTHER_GROUP, (Iterable)this.groups.removeAll((Object)""));
        }
    }

    private String findOtherGroup(Set<String> groupNames) {
        for (String groupName : groupNames) {
            if (!groupName.equalsIgnoreCase(OTHER_GROUP)) continue;
            return groupName;
        }
        return null;
    }

    @Override
    public Set<String> getGroups() {
        return this.groups.keySet();
    }

    @Override
    public Set<TaskDetails> getTasksForGroup(String group) {
        return this.groups.get((Object)group);
    }
}

