/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import groovy.lang.Closure;
import java.io.File;
import org.gradle.api.Action;
import org.gradle.api.JavaVersion;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.SourceDirectorySetFactory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.DefaultSourceSetContainer;
import org.gradle.api.java.archives.Manifest;
import org.gradle.api.java.archives.internal.DefaultManifest;
import org.gradle.api.reporting.ReportingExtension;
import org.gradle.api.tasks.SourceSetContainer;
import org.gradle.internal.Actions;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;

public class JavaPluginConvention {
    private ProjectInternal project;
    private String docsDirName;
    private String testResultsDirName;
    private String testReportDirName;
    private final SourceSetContainer sourceSets;
    private JavaVersion srcCompat;
    private JavaVersion targetCompat;

    @Deprecated
    public JavaPluginConvention(ProjectInternal project, Instantiator instantiator) {
        DeprecationLogger.nagUserOfDeprecated("Creating instances of JavaPluginConvention");
        this.project = project;
        this.sourceSets = instantiator.newInstance(DefaultSourceSetContainer.class, project.getFileResolver(), project.getTasks(), instantiator, project.getServices().get(SourceDirectorySetFactory.class));
        this.docsDirName = "docs";
        this.testResultsDirName = "test-results";
        this.testReportDirName = "tests";
    }

    public Object sourceSets(Closure closure) {
        return this.sourceSets.configure(closure);
    }

    public File getDocsDir() {
        return this.project.getServices().get(FileLookup.class).getFileResolver(this.project.getBuildDir()).resolve(this.docsDirName);
    }

    public File getTestResultsDir() {
        return this.project.getServices().get(FileLookup.class).getFileResolver(this.project.getBuildDir()).resolve(this.testResultsDirName);
    }

    public File getTestReportDir() {
        return this.project.getServices().get(FileLookup.class).getFileResolver(this.getReportsDir()).resolve(this.testReportDirName);
    }

    private File getReportsDir() {
        return this.project.getExtensions().getByType(ReportingExtension.class).getBaseDir();
    }

    public JavaVersion getSourceCompatibility() {
        return this.srcCompat != null ? this.srcCompat : JavaVersion.current();
    }

    public void setSourceCompatibility(Object value) {
        this.setSourceCompatibility(JavaVersion.toVersion(value));
    }

    public void setSourceCompatibility(JavaVersion value) {
        this.srcCompat = value;
    }

    public JavaVersion getTargetCompatibility() {
        return this.targetCompat != null ? this.targetCompat : this.getSourceCompatibility();
    }

    public void setTargetCompatibility(Object value) {
        this.setTargetCompatibility(JavaVersion.toVersion(value));
    }

    public void setTargetCompatibility(JavaVersion value) {
        this.targetCompat = value;
    }

    public Manifest manifest() {
        return this.manifest(Actions.doNothing());
    }

    public Manifest manifest(Closure closure) {
        return ConfigureUtil.configure(closure, this.createManifest());
    }

    public Manifest manifest(Action<? super Manifest> action) {
        Manifest manifest = this.createManifest();
        action.execute(manifest);
        return manifest;
    }

    private Manifest createManifest() {
        return new DefaultManifest(this.project.getFileResolver());
    }

    public String getDocsDirName() {
        return this.docsDirName;
    }

    public void setDocsDirName(String docsDirName) {
        this.docsDirName = docsDirName;
    }

    public String getTestResultsDirName() {
        return this.testResultsDirName;
    }

    public void setTestResultsDirName(String testResultsDirName) {
        this.testResultsDirName = testResultsDirName;
    }

    public String getTestReportDirName() {
        return this.testReportDirName;
    }

    public void setTestReportDirName(String testReportDirName) {
        this.testReportDirName = testReportDirName;
    }

    public SourceSetContainer getSourceSets() {
        return this.sourceSets;
    }

    public ProjectInternal getProject() {
        return this.project;
    }
}

