/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile;

import java.io.Serializable;
import org.gradle.api.internal.ClassPathRegistry;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.compile.AnnotationProcessorDiscoveringCompiler;
import org.gradle.api.internal.tasks.compile.ApiGroovyCompiler;
import org.gradle.api.internal.tasks.compile.CommandLineJavaCompileSpec;
import org.gradle.api.internal.tasks.compile.CommandLineJavaCompiler;
import org.gradle.api.internal.tasks.compile.GroovyJavaJointCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaCompileSpec;
import org.gradle.api.internal.tasks.compile.JavaHomeBasedJavaCompilerFactory;
import org.gradle.api.internal.tasks.compile.JdkJavaCompiler;
import org.gradle.api.internal.tasks.compile.NormalizingGroovyCompiler;
import org.gradle.api.internal.tasks.compile.daemon.DaemonGroovyCompiler;
import org.gradle.api.internal.tasks.compile.processing.AnnotationProcessorDetector;
import org.gradle.api.tasks.WorkResult;
import org.gradle.api.tasks.compile.GroovyCompileOptions;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.language.base.internal.compile.Compiler;
import org.gradle.language.base.internal.compile.CompilerFactory;
import org.gradle.process.internal.DefaultExecActionFactory;
import org.gradle.process.internal.worker.child.WorkerDirectoryProvider;
import org.gradle.workers.internal.IsolatedClassloaderWorkerFactory;
import org.gradle.workers.internal.WorkerDaemonFactory;
import org.gradle.workers.internal.WorkerFactory;

public class GroovyCompilerFactory
implements CompilerFactory<GroovyJavaJointCompileSpec> {
    private final ProjectInternal project;
    private final WorkerDaemonFactory workerDaemonFactory;
    private final IsolatedClassloaderWorkerFactory inProcessWorkerFactory;
    private final PathToFileResolver fileResolver;
    private AnnotationProcessorDetector processorDetector;

    public GroovyCompilerFactory(ProjectInternal project, WorkerDaemonFactory workerDaemonFactory, IsolatedClassloaderWorkerFactory inProcessWorkerFactory, PathToFileResolver fileResolver, AnnotationProcessorDetector processorDetector) {
        this.project = project;
        this.workerDaemonFactory = workerDaemonFactory;
        this.inProcessWorkerFactory = inProcessWorkerFactory;
        this.fileResolver = fileResolver;
        this.processorDetector = processorDetector;
    }

    @Override
    public Compiler<GroovyJavaJointCompileSpec> newCompiler(GroovyJavaJointCompileSpec spec) {
        GroovyCompileOptions groovyOptions = spec.getGroovyCompileOptions();
        WorkerFactory workerFactory = groovyOptions.isFork() ? this.workerDaemonFactory : this.inProcessWorkerFactory;
        DaemonGroovyCompiler groovyCompiler = new DaemonGroovyCompiler(this.project.getServices().get(WorkerDirectoryProvider.class).getIdleWorkingDirectory(), new DaemonSideCompiler(), this.project.getServices().get(ClassPathRegistry.class), workerFactory, this.fileResolver);
        return new AnnotationProcessorDiscoveringCompiler<GroovyJavaJointCompileSpec>(new NormalizingGroovyCompiler(groovyCompiler), this.processorDetector);
    }

    private static class DaemonSideCompiler
    implements Compiler<GroovyJavaJointCompileSpec>,
    Serializable {
        private DaemonSideCompiler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public WorkResult execute(GroovyJavaJointCompileSpec spec) {
            DefaultExecActionFactory execHandleFactory = new DefaultExecActionFactory(new IdentityFileResolver());
            try {
                Compiler<JavaCompileSpec> javaCompiler = CommandLineJavaCompileSpec.class.isAssignableFrom(spec.getClass()) ? new CommandLineJavaCompiler(execHandleFactory) : new JdkJavaCompiler(new JavaHomeBasedJavaCompilerFactory());
                ApiGroovyCompiler groovyCompiler = new ApiGroovyCompiler(javaCompiler);
                WorkResult workResult = groovyCompiler.execute(spec);
                return workResult;
            }
            finally {
                execHandleFactory.stop();
            }
        }
    }
}

