/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks;

import org.gradle.api.NonNullApi;
import org.gradle.internal.id.UniqueId;

@NonNullApi
public class OriginTaskExecutionMetadata {
    private final UniqueId buildInvocationId;
    private final long executionTime;

    public OriginTaskExecutionMetadata(UniqueId buildInvocationId, long executionTime) {
        if (buildInvocationId == null) {
            throw new IllegalArgumentException("buildInvocationId cannot be null");
        }
        this.buildInvocationId = buildInvocationId;
        this.executionTime = executionTime;
    }

    public UniqueId getBuildInvocationId() {
        return this.buildInvocationId;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OriginTaskExecutionMetadata that = (OriginTaskExecutionMetadata)o;
        return this.executionTime == that.executionTime && this.buildInvocationId.equals(that.buildInvocationId);
    }

    public int hashCode() {
        int result = this.buildInvocationId.hashCode();
        result = 31 * result + (int)(this.executionTime ^ this.executionTime >>> 32);
        return result;
    }

    public String toString() {
        return "OriginTaskExecutionMetadata{buildInvocationId=" + this.buildInvocationId + ", executionTime=" + this.executionTime + '}';
    }
}

