/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.changedetection.state;

import java.util.Set;
import org.gradle.api.internal.changedetection.state.ResourceFilter;
import org.gradle.api.internal.file.pattern.PathMatcher;
import org.gradle.api.internal.file.pattern.PatternMatcherFactory;
import org.gradle.caching.internal.BuildCacheHasher;
import org.gradle.internal.Factory;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;

public class IgnoringResourceFilter
implements ResourceFilter {
    private final Set<String> ignores;
    private final ImmutableSet<PathMatcher> ignoreMatchers;

    public IgnoringResourceFilter(Set<String> ignores) {
        this.ignores = ImmutableSet.copyOf(ignores);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String ignore : ignores) {
            PathMatcher matcher = PatternMatcherFactory.compile(true, ignore);
            builder.add((Object)matcher);
        }
        this.ignoreMatchers = builder.build();
    }

    private boolean shouldBeIgnored(String[] relativePath) {
        for (PathMatcher ignoreSpec : this.ignoreMatchers) {
            if (!ignoreSpec.matches(relativePath, 0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void appendConfigurationToHasher(BuildCacheHasher hasher) {
        hasher.putString(this.getClass().getName());
        for (String ignore : this.ignores) {
            hasher.putString(ignore);
        }
    }

    @Override
    public boolean shouldBeIgnored(Factory<String[]> relativePathFactory) {
        if (this.ignoreMatchers.isEmpty()) {
            return false;
        }
        return this.shouldBeIgnored(relativePathFactory.create());
    }
}

