/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.gradle.api.internal.artifacts.ResolvedVersionConstraint;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.strategy.VersionSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.ComponentResolutionState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ComponentStateFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.graph.selectors.ResolvableSelectorState;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.impldep.com.google.common.collect.Lists;
import org.gradle.internal.resolve.ModuleVersionResolveException;
import org.gradle.internal.resolve.result.ComponentIdResolveResult;

class SelectorStateResolverResults {
    private final List<Registration> results;

    public SelectorStateResolverResults(int size) {
        this.results = Lists.newArrayListWithCapacity((int)size);
    }

    public <T extends ComponentResolutionState> List<T> getResolved(ComponentStateFactory<T> componentFactory) {
        ModuleVersionResolveException failure = null;
        ArrayList resolved = null;
        for (Registration entry : this.results) {
            ResolvableSelectorState selectorState = entry.selector;
            ComponentIdResolveResult idResolveResult = entry.result;
            if (selectorState.isForce()) {
                T forcedComponent = SelectorStateResolverResults.componentForIdResolveResult(componentFactory, idResolveResult, selectorState);
                forcedComponent.addCause(VersionSelectionReasons.FORCED);
                return Collections.singletonList(forcedComponent);
            }
            if (!idResolveResult.mark(this)) continue;
            if (idResolveResult.getFailure() == null) {
                T componentState = SelectorStateResolverResults.componentForIdResolveResult(componentFactory, idResolveResult, selectorState);
                if (resolved == null) {
                    resolved = Lists.newArrayList();
                }
                resolved.add(componentState);
                continue;
            }
            if (failure != null) continue;
            failure = idResolveResult.getFailure();
        }
        if (resolved == null && failure != null) {
            throw failure;
        }
        return resolved == null ? Collections.emptyList() : resolved;
    }

    public static <T extends ComponentResolutionState> T componentForIdResolveResult(ComponentStateFactory<T> componentFactory, ComponentIdResolveResult idResolveResult, ResolvableSelectorState selector) {
        T component = componentFactory.getRevision(idResolveResult.getId(), idResolveResult.getModuleVersionId(), idResolveResult.getMetadata());
        component.selectedBy(selector);
        component.unmatched(idResolveResult.getUnmatchedVersions());
        component.rejected(idResolveResult.getRejectedVersions());
        if (idResolveResult.isRejected()) {
            component.reject();
        }
        return component;
    }

    boolean alreadyHaveResolution(ResolvableSelectorState dep) {
        for (Registration registration : this.results) {
            ComponentIdResolveResult discovered = registration.result;
            if (!this.included(dep, discovered)) continue;
            this.results.add(new Registration(dep, discovered));
            return true;
        }
        return false;
    }

    void registerResolution(ResolvableSelectorState dep, ComponentIdResolveResult resolveResult) {
        if (resolveResult.getFailure() != null) {
            this.results.add(new Registration(dep, resolveResult));
            return;
        }
        for (Registration registration : this.results) {
            if (!this.included(registration.selector, resolveResult) && !this.sameVersion(registration.result, resolveResult)) continue;
            registration.result = resolveResult;
        }
        this.results.add(new Registration(dep, resolveResult));
    }

    private boolean sameVersion(ComponentIdResolveResult existing, ComponentIdResolveResult resolveResult) {
        if (existing.getFailure() == null && resolveResult.getFailure() == null) {
            return existing.getId().equals(resolveResult.getId());
        }
        return false;
    }

    private boolean included(ResolvableSelectorState dep, ComponentIdResolveResult candidate) {
        if (candidate.getFailure() != null) {
            return false;
        }
        ResolvedVersionConstraint versionConstraint = dep.getVersionConstraint();
        if (versionConstraint == null) {
            return dep.getSelector().matchesStrictly(candidate.getId());
        }
        VersionSelector preferredSelector = versionConstraint.getPreferredSelector();
        if (preferredSelector == null || !preferredSelector.canShortCircuitWhenVersionAlreadyPreselected()) {
            return false;
        }
        return preferredSelector.accept(candidate.getModuleVersionId().getVersion());
    }

    private static class Registration {
        private final ResolvableSelectorState selector;
        private ComponentIdResolveResult result;

        private Registration(ResolvableSelectorState selector, ComponentIdResolveResult result) {
            this.selector = selector;
            this.result = result;
        }

        public String toString() {
            return this.selector.toString() + " -> " + this.result.getModuleVersionId();
        }
    }
}

