/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact;

import java.util.ArrayList;
import java.util.Collection;
import org.gradle.api.Buildable;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.DownloadArtifactBuildOperationType;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BuildDependenciesVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.BuildableSingleResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.CompositeResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvedVariant;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.internal.DisplayName;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationQueue;
import org.gradle.internal.operations.RunnableBuildOperation;

class ArtifactBackedResolvedVariant
implements ResolvedVariant {
    private final DisplayName displayName;
    private final AttributeContainerInternal attributes;
    private final ResolvedArtifactSet artifacts;

    private ArtifactBackedResolvedVariant(DisplayName displayName, AttributeContainerInternal attributes, ResolvedArtifactSet artifacts) {
        this.displayName = displayName;
        this.attributes = attributes;
        this.artifacts = artifacts;
    }

    public static ResolvedVariant create(DisplayName displayName, AttributeContainerInternal attributes, Collection<? extends ResolvableArtifact> artifacts) {
        if (artifacts.isEmpty()) {
            return new ArtifactBackedResolvedVariant(displayName, attributes, ResolvedArtifactSet.EMPTY);
        }
        if (artifacts.size() == 1) {
            return new ArtifactBackedResolvedVariant(displayName, attributes, new SingleArtifactSet(displayName, attributes, artifacts.iterator().next()));
        }
        ArrayList<SingleArtifactSet> artifactSets = new ArrayList<SingleArtifactSet>();
        for (ResolvableArtifact resolvableArtifact : artifacts) {
            artifactSets.add(new SingleArtifactSet(displayName, attributes, resolvableArtifact));
        }
        return new ArtifactBackedResolvedVariant(displayName, attributes, CompositeResolvedArtifactSet.of(artifactSets));
    }

    public String toString() {
        return this.displayName.getDisplayName();
    }

    @Override
    public DisplayName asDescribable() {
        return this.displayName;
    }

    @Override
    public ResolvedArtifactSet getArtifacts() {
        return this.artifacts;
    }

    @Override
    public AttributeContainerInternal getAttributes() {
        return this.attributes;
    }

    private static class DownloadArtifactFile
    implements RunnableBuildOperation {
        private final ResolvableArtifact artifact;
        private final SingleArtifactSet owner;
        private final ResolvedArtifactSet.AsyncArtifactListener listener;

        DownloadArtifactFile(ResolvableArtifact artifact, SingleArtifactSet owner, ResolvedArtifactSet.AsyncArtifactListener visitor) {
            this.artifact = artifact;
            this.owner = owner;
            this.listener = visitor;
        }

        @Override
        public void run(BuildOperationContext context) {
            try {
                this.artifact.getFile();
                this.listener.artifactAvailable(this.artifact);
                if (context != null) {
                    context.setResult(DownloadArtifactBuildOperationType.RESULT);
                }
            }
            catch (Throwable t) {
                this.owner.failure = t;
            }
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName("Resolve " + this.artifact).details(new DownloadArtifactBuildOperationType.DetailsImpl(this.artifact.getId().getDisplayName()));
        }
    }

    private static class SingleArtifactSet
    implements BuildableSingleResolvedArtifactSet,
    ResolvedArtifactSet.Completion {
        private final DisplayName variantName;
        private final AttributeContainer variantAttributes;
        private final ResolvableArtifact artifact;
        private volatile Throwable failure;

        SingleArtifactSet(DisplayName variantName, AttributeContainer variantAttributes, ResolvableArtifact artifact) {
            this.variantName = variantName;
            this.variantAttributes = variantAttributes;
            this.artifact = artifact;
        }

        @Override
        public ResolvedArtifactSet.Completion startVisit(BuildOperationQueue<RunnableBuildOperation> actions, ResolvedArtifactSet.AsyncArtifactListener listener) {
            if (listener.requireArtifactFiles()) {
                if (this.artifact.isResolveSynchronously()) {
                    new DownloadArtifactFile(this.artifact, this, listener).run(null);
                } else {
                    actions.add(new DownloadArtifactFile(this.artifact, this, listener));
                }
            }
            return this;
        }

        @Override
        public void visit(ArtifactVisitor visitor) {
            if (this.failure != null) {
                visitor.visitFailure(this.failure);
            } else {
                visitor.visitArtifact(this.variantName, this.variantAttributes, this.artifact);
            }
        }

        @Override
        public void collectBuildDependencies(BuildDependenciesVisitor visitor) {
            visitor.visitDependency(this.getBuildDependencies());
        }

        @Override
        public ComponentArtifactIdentifier getArtifactId() {
            return this.artifact.getId();
        }

        @Override
        public TaskDependency getBuildDependencies() {
            return ((Buildable)((Object)this.artifact)).getBuildDependencies();
        }

        public String toString() {
            return this.getArtifactId().getDisplayName();
        }
    }
}

