/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts;

import java.math.BigInteger;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ArtifactsAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.CachedArtifacts;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.DefaultCachedArtifacts;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ModuleArtifactsCache;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.util.BuildCommencedTimeProvider;

public class InMemoryModuleArtifactsCache
implements ModuleArtifactsCache {
    protected final BuildCommencedTimeProvider timeProvider;
    private final Map<ArtifactsAtRepositoryKey, ModuleArtifactsCacheEntry> inMemoryCache = Maps.newConcurrentMap();

    public InMemoryModuleArtifactsCache(BuildCommencedTimeProvider timeProvider) {
        this.timeProvider = timeProvider;
    }

    @Override
    public CachedArtifacts cacheArtifacts(ModuleComponentRepository repository, ComponentIdentifier componentId, String context, BigInteger descriptorHash, Collection<? extends ComponentArtifactMetadata> artifacts) {
        ArtifactsAtRepositoryKey key = new ArtifactsAtRepositoryKey(repository.getId(), componentId, context);
        ModuleArtifactsCacheEntry entry = new ModuleArtifactsCacheEntry((Set<? extends ComponentArtifactMetadata>)ImmutableSet.copyOf(artifacts), this.timeProvider.getCurrentTime(), descriptorHash);
        this.store(key, entry);
        return this.createCacheArtifacts(entry);
    }

    protected void store(ArtifactsAtRepositoryKey key, ModuleArtifactsCacheEntry entry) {
        this.inMemoryCache.put(key, entry);
    }

    @Override
    public CachedArtifacts getCachedArtifacts(ModuleComponentRepository repository, ComponentIdentifier componentId, String context) {
        ArtifactsAtRepositoryKey key = new ArtifactsAtRepositoryKey(repository.getId(), componentId, context);
        ModuleArtifactsCacheEntry entry = this.get(key);
        return entry == null ? null : this.createCacheArtifacts(entry);
    }

    protected ModuleArtifactsCacheEntry get(ArtifactsAtRepositoryKey key) {
        return this.inMemoryCache.get(key);
    }

    private CachedArtifacts createCacheArtifacts(ModuleArtifactsCacheEntry entry) {
        long entryAge = this.timeProvider.getCurrentTime() - entry.createTimestamp;
        return new DefaultCachedArtifacts(entry.artifacts, entry.moduleDescriptorHash, entryAge);
    }

    protected static class ModuleArtifactsCacheEntry {
        protected final Set<ComponentArtifactMetadata> artifacts;
        protected final BigInteger moduleDescriptorHash;
        protected final long createTimestamp;

        ModuleArtifactsCacheEntry(Set<? extends ComponentArtifactMetadata> artifacts, long createTimestamp, BigInteger moduleDescriptorHash) {
            this.artifacts = new LinkedHashSet<ComponentArtifactMetadata>(artifacts);
            this.createTimestamp = createTimestamp;
            this.moduleDescriptorHash = moduleDescriptorHash;
        }
    }
}

