/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.modulecache;

import java.io.EOFException;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataSerializer;
import org.gradle.internal.component.external.model.AbstractLazyModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.AbstractRealisedModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ivy.DefaultIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.ivy.RealisedIvyModuleResolveMetadata;
import org.gradle.internal.component.external.model.ivy.RealisedIvyModuleResolveMetadataSerializationHelper;
import org.gradle.internal.component.external.model.maven.DefaultMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.RealisedMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.RealisedMavenModuleResolveMetadataSerializationHelper;
import org.gradle.internal.resolve.caching.DesugaringAttributeContainerSerializer;
import org.gradle.internal.serialize.AbstractSerializer;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class ModuleComponentResolveMetadataSerializer
extends AbstractSerializer<ModuleComponentResolveMetadata> {
    private final RealisedIvyModuleResolveMetadataSerializationHelper ivySerializationHelper;
    private final RealisedMavenModuleResolveMetadataSerializationHelper mavenSerializationHelper;
    private final ModuleMetadataSerializer delegate;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;

    public ModuleComponentResolveMetadataSerializer(ModuleMetadataSerializer delegate, DesugaringAttributeContainerSerializer attributeContainerSerializer, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this.delegate = delegate;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.ivySerializationHelper = new RealisedIvyModuleResolveMetadataSerializationHelper(attributeContainerSerializer, moduleIdentifierFactory);
        this.mavenSerializationHelper = new RealisedMavenModuleResolveMetadataSerializationHelper(attributeContainerSerializer, moduleIdentifierFactory);
    }

    @Override
    public ModuleComponentResolveMetadata read(Decoder decoder) throws EOFException, Exception {
        AbstractLazyModuleComponentResolveMetadata resolveMetadata = (AbstractLazyModuleComponentResolveMetadata)this.delegate.read(decoder, this.moduleIdentifierFactory).asImmutable();
        if (resolveMetadata instanceof DefaultIvyModuleResolveMetadata) {
            return this.ivySerializationHelper.readMetadata(decoder, (DefaultIvyModuleResolveMetadata)resolveMetadata);
        }
        if (resolveMetadata instanceof DefaultMavenModuleResolveMetadata) {
            return this.mavenSerializationHelper.readMetadata(decoder, (DefaultMavenModuleResolveMetadata)resolveMetadata);
        }
        throw new IllegalStateException("Unknown resolved metadata type: " + resolveMetadata.getClass());
    }

    @Override
    public void write(Encoder encoder, ModuleComponentResolveMetadata value) throws Exception {
        AbstractRealisedModuleComponentResolveMetadata transformed = this.transformToRealisedForSerialization(value);
        this.delegate.write(encoder, transformed);
        if (transformed instanceof RealisedIvyModuleResolveMetadata) {
            this.ivySerializationHelper.writeRealisedVariantsData(encoder, transformed);
            this.ivySerializationHelper.writeRealisedConfigurationsData(encoder, transformed);
        } else if (transformed instanceof RealisedMavenModuleResolveMetadata) {
            this.mavenSerializationHelper.writeRealisedVariantsData(encoder, transformed);
            this.mavenSerializationHelper.writeRealisedConfigurationsData(encoder, transformed);
        } else {
            throw new IllegalStateException("Unexpected realised module component resolve metadata type: " + transformed.getClass());
        }
    }

    private AbstractRealisedModuleComponentResolveMetadata transformToRealisedForSerialization(ModuleComponentResolveMetadata metadata) {
        if (metadata instanceof AbstractRealisedModuleComponentResolveMetadata) {
            return (AbstractRealisedModuleComponentResolveMetadata)metadata;
        }
        if (metadata instanceof DefaultIvyModuleResolveMetadata) {
            return RealisedIvyModuleResolveMetadata.transform((DefaultIvyModuleResolveMetadata)metadata);
        }
        if (metadata instanceof DefaultMavenModuleResolveMetadata) {
            return RealisedMavenModuleResolveMetadata.transform((DefaultMavenModuleResolveMetadata)metadata);
        }
        throw new IllegalStateException("The type of metadata received is not supported - " + metadata.getClass().getName());
    }
}

