/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution;

import java.util.LinkedHashSet;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.DependencyResolveDetails;
import org.gradle.api.artifacts.DependencySubstitution;
import org.gradle.api.artifacts.DependencySubstitutions;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionSelector;
import org.gradle.api.artifacts.component.ComponentSelector;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.artifacts.component.ProjectComponentSelector;
import org.gradle.api.artifacts.result.ComponentSelectionDescriptor;
import org.gradle.api.internal.artifacts.ComponentSelectorConverter;
import org.gradle.api.internal.artifacts.DependencySubstitutionInternal;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.component.ComponentIdentifierFactory;
import org.gradle.api.internal.artifacts.configurations.MutationValidator;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencyResolveDetails;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DefaultDependencySubstitution;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.DependencySubstitutionsInternal;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.ModuleSelectorStringNotationConverter;
import org.gradle.api.internal.artifacts.ivyservice.dependencysubstitution.UnversionedModuleComponentSelector;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.ComponentSelectionDescriptorInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.VersionSelectionReasons;
import org.gradle.internal.Actions;
import org.gradle.internal.Describables;
import org.gradle.internal.build.IncludedBuildState;
import org.gradle.internal.component.local.model.DefaultProjectComponentSelector;
import org.gradle.internal.exceptions.DiagnosticsVisitor;
import org.gradle.internal.typeconversion.NotationConvertResult;
import org.gradle.internal.typeconversion.NotationConverter;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.internal.typeconversion.NotationParserBuilder;
import org.gradle.internal.typeconversion.TypeConversionException;
import org.gradle.util.Path;

public class DefaultDependencySubstitutions
implements DependencySubstitutionsInternal {
    private final Set<Action<? super DependencySubstitution>> substitutionRules;
    private final NotationParser<Object, ComponentSelector> moduleSelectorNotationParser;
    private final NotationParser<Object, ComponentSelector> projectSelectorNotationParser;
    private final ComponentSelectionDescriptor reason;
    private MutationValidator mutationValidator = MutationValidator.IGNORE;
    private boolean hasDependencySubstitutionRule;

    private static NotationParser<Object, ComponentSelector> moduleSelectorNotationConverter(ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        return NotationParserBuilder.toType(ComponentSelector.class).converter(new ModuleSelectorStringNotationConverter(moduleIdentifierFactory)).toComposite();
    }

    public static DefaultDependencySubstitutions forResolutionStrategy(ComponentIdentifierFactory componentIdentifierFactory, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        NotationParser<Object, ComponentSelector> projectSelectorNotationParser = NotationParserBuilder.toType(ComponentSelector.class).fromCharSequence(new ProjectPathConverter(componentIdentifierFactory)).toComposite();
        return new DefaultDependencySubstitutions(VersionSelectionReasons.SELECTED_BY_RULE, projectSelectorNotationParser, moduleIdentifierFactory);
    }

    public static DefaultDependencySubstitutions forIncludedBuild(IncludedBuildState build, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        NotationParser<Object, ComponentSelector> projectSelectorNotationParser = NotationParserBuilder.toType(ComponentSelector.class).fromCharSequence(new CompositeProjectPathConverter(build)).toComposite();
        return new DefaultDependencySubstitutions(VersionSelectionReasons.COMPOSITE_BUILD, projectSelectorNotationParser, moduleIdentifierFactory);
    }

    private DefaultDependencySubstitutions(ComponentSelectionDescriptor reason, NotationParser<Object, ComponentSelector> projectSelectorNotationParser, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        this(reason, new LinkedHashSet<Action<? super DependencySubstitution>>(), DefaultDependencySubstitutions.moduleSelectorNotationConverter(moduleIdentifierFactory), projectSelectorNotationParser);
    }

    private DefaultDependencySubstitutions(ComponentSelectionDescriptor reason, Set<Action<? super DependencySubstitution>> substitutionRules, NotationParser<Object, ComponentSelector> moduleSelectorNotationParser, NotationParser<Object, ComponentSelector> projectSelectorNotationParser) {
        this.reason = reason;
        this.substitutionRules = substitutionRules;
        this.moduleSelectorNotationParser = moduleSelectorNotationParser;
        this.projectSelectorNotationParser = projectSelectorNotationParser;
    }

    @Override
    public boolean hasRules() {
        return this.hasDependencySubstitutionRule;
    }

    @Override
    public Action<DependencySubstitution> getRuleAction() {
        return Actions.composite(this.substitutionRules);
    }

    private void addRule(Action<? super DependencySubstitution> rule) {
        this.mutationValidator.validateMutation(MutationValidator.MutationType.STRATEGY);
        this.substitutionRules.add(rule);
    }

    @Override
    public DependencySubstitutions all(Action<? super DependencySubstitution> rule) {
        this.addRule(rule);
        this.hasDependencySubstitutionRule = true;
        return this;
    }

    @Override
    public DependencySubstitutions allWithDependencyResolveDetails(Action<? super DependencyResolveDetails> rule, ComponentSelectorConverter componentSelectorConverter) {
        this.addRule(new DependencyResolveDetailsWrapperAction(rule, componentSelectorConverter));
        return this;
    }

    @Override
    public ComponentSelector module(String notation) {
        return this.moduleSelectorNotationParser.parseNotation(notation);
    }

    @Override
    public ComponentSelector project(String path) {
        return this.projectSelectorNotationParser.parseNotation(path);
    }

    @Override
    public DependencySubstitutions.Substitution substitute(final ComponentSelector substituted) {
        return new DependencySubstitutions.Substitution(){
            ComponentSelectionDescriptorInternal substitutionReason;
            {
                this.substitutionReason = (ComponentSelectionDescriptorInternal)DefaultDependencySubstitutions.this.reason;
            }

            @Override
            public DependencySubstitutions.Substitution because(String description) {
                this.substitutionReason = this.substitutionReason.withReason(Describables.of(description));
                return this;
            }

            @Override
            public void with(ComponentSelector substitute) {
                DefaultDependencySubstitution.validateTarget(substitute);
                if (substituted instanceof UnversionedModuleComponentSelector) {
                    ModuleIdentifier moduleId = ((UnversionedModuleComponentSelector)substituted).getModuleIdentifier();
                    DefaultDependencySubstitutions.this.all(new ModuleMatchDependencySubstitutionAction(this.substitutionReason, moduleId, substitute));
                } else {
                    DefaultDependencySubstitutions.this.all(new ExactMatchDependencySubstitutionAction(this.substitutionReason, substituted, substitute));
                }
            }
        };
    }

    @Override
    public void setMutationValidator(MutationValidator validator) {
        this.mutationValidator = validator;
    }

    @Override
    public DependencySubstitutionsInternal copy() {
        return new DefaultDependencySubstitutions(this.reason, new LinkedHashSet<Action<? super DependencySubstitution>>(this.substitutionRules), this.moduleSelectorNotationParser, this.projectSelectorNotationParser);
    }

    private static class DependencyResolveDetailsWrapperAction
    implements Action<DependencySubstitution> {
        private final Action<? super DependencyResolveDetails> delegate;
        private final ComponentSelectorConverter componentSelectorConverter;

        public DependencyResolveDetailsWrapperAction(Action<? super DependencyResolveDetails> delegate, ComponentSelectorConverter componentSelectorConverter) {
            this.delegate = delegate;
            this.componentSelectorConverter = componentSelectorConverter;
        }

        @Override
        public void execute(DependencySubstitution substitution) {
            ModuleVersionSelector requested = this.componentSelectorConverter.getSelector(substitution.getRequested());
            DefaultDependencyResolveDetails details = new DefaultDependencyResolveDetails((DependencySubstitutionInternal)substitution, requested);
            this.delegate.execute(details);
        }
    }

    private static class ModuleMatchDependencySubstitutionAction
    implements Action<DependencySubstitution> {
        private final ComponentSelectionDescriptorInternal selectionReason;
        private final ModuleIdentifier moduleId;
        private final ComponentSelector substitute;

        public ModuleMatchDependencySubstitutionAction(ComponentSelectionDescriptorInternal selectionReason, ModuleIdentifier moduleId, ComponentSelector substitute) {
            this.selectionReason = selectionReason;
            this.moduleId = moduleId;
            this.substitute = substitute;
        }

        @Override
        public void execute(DependencySubstitution dependencySubstitution) {
            ModuleComponentSelector requested;
            if (dependencySubstitution.getRequested() instanceof ModuleComponentSelector && this.moduleId.equals((requested = (ModuleComponentSelector)dependencySubstitution.getRequested()).getModuleIdentifier())) {
                ((DependencySubstitutionInternal)dependencySubstitution).useTarget((Object)this.substitute, this.selectionReason);
            }
        }
    }

    private static class ExactMatchDependencySubstitutionAction
    implements Action<DependencySubstitution> {
        private final ComponentSelectionDescriptorInternal selectionReason;
        private final ComponentSelector substituted;
        private final ComponentSelector substitute;

        public ExactMatchDependencySubstitutionAction(ComponentSelectionDescriptorInternal selectionReason, ComponentSelector substituted, ComponentSelector substitute) {
            this.selectionReason = selectionReason;
            this.substituted = substituted;
            this.substitute = substitute;
        }

        @Override
        public void execute(DependencySubstitution dependencySubstitution) {
            if (this.substituted.equals(dependencySubstitution.getRequested())) {
                ((DependencySubstitutionInternal)dependencySubstitution).useTarget((Object)this.substitute, this.selectionReason);
            }
        }
    }

    private static class CompositeProjectPathConverter
    implements NotationConverter<String, ProjectComponentSelector> {
        private final IncludedBuildState build;

        private CompositeProjectPathConverter(IncludedBuildState build) {
            this.build = build;
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.example("Project paths, e.g. ':api'.");
        }

        @Override
        public void convert(String notation, NotationConvertResult<? super ProjectComponentSelector> result) throws TypeConversionException {
            result.converted(DefaultProjectComponentSelector.newSelector(this.build.getIdentifierForProject(Path.path(notation))));
        }
    }

    private static class ProjectPathConverter
    implements NotationConverter<String, ProjectComponentSelector> {
        private final ComponentIdentifierFactory componentIdentifierFactory;

        private ProjectPathConverter(ComponentIdentifierFactory componentIdentifierFactory) {
            this.componentIdentifierFactory = componentIdentifierFactory;
        }

        @Override
        public void describe(DiagnosticsVisitor visitor) {
            visitor.example("Project paths, e.g. ':api'.");
        }

        @Override
        public void convert(String notation, NotationConvertResult<? super ProjectComponentSelector> result) throws TypeConversionException {
            result.converted(this.componentIdentifierFactory.createProjectComponentSelector(notation));
        }
    }
}

