/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ConcurrentIntObjectMap;
import com.intellij.util.containers.ContainerUtil;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.SingleConnectionNetService;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.io.ChannelExceptionHandler;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.ClientInfo;
import org.jetbrains.io.fastCgi.FastCgiDecoder;
import org.jetbrains.io.fastCgi.FastCgiRequest;
import org.jetbrains.io.fastCgi.FastCgiService$configureBootstrap$;
import org.jetbrains.io.fastCgi.FastCgiServiceKt;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0014J\u001a\u0010\u0018\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\u0018\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\f2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001cJ\u0016\u0010 \u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cR\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/jetbrains/io/fastCgi/FastCgiService;", "Lorg/jetbrains/builtInWebServer/SingleConnectionNetService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "requestIdCounter", "Ljava/util/concurrent/atomic/AtomicInteger;", "requests", "Lcom/intellij/util/containers/ConcurrentIntObjectMap;", "Lorg/jetbrains/io/fastCgi/ClientInfo;", "kotlin.jvm.PlatformType", "allocateRequestId", "", "channel", "Lio/netty/channel/Channel;", "extraHeaders", "Lio/netty/handler/codec/http/HttpHeaders;", "configureBootstrap", "", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "errorOutputConsumer", "Lcom/intellij/util/Consumer;", "", "handleError", "fastCgiRequest", "Lorg/jetbrains/io/fastCgi/FastCgiRequest;", "content", "Lio/netty/buffer/ByteBuf;", "responseReceived", "id", "buffer", "send", "intellij.platform.builtInServer.impl"})
public abstract class FastCgiService
extends SingleConnectionNetService {
    private final AtomicInteger requestIdCounter;
    private final ConcurrentIntObjectMap<ClientInfo> requests;

    @Override
    protected void configureBootstrap(@NotNull Bootstrap bootstrap, @NotNull Consumer<String> errorOutputConsumer) {
        Intrinsics.checkParameterIsNotNull((Object)bootstrap, (String)"bootstrap");
        Intrinsics.checkParameterIsNotNull(errorOutputConsumer, (String)"errorOutputConsumer");
        Bootstrap $receiver$iv = bootstrap;
        boolean $i$f$handler = false;
        $receiver$iv.handler((ChannelHandler)new ChannelInitializer<Channel>(this, errorOutputConsumer){
            final /* synthetic */ FastCgiService this$0;
            final /* synthetic */ Consumer $errorOutputConsumer$inlined;
            {
                this.this$0 = fastCgiService;
                this.$errorOutputConsumer$inlined = consumer;
            }

            protected void initChannel(@NotNull Channel channel) {
                Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
                Channel it = channel;
                boolean bl = false;
                it.pipeline().addLast("fastCgiDecoder", (ChannelHandler)new FastCgiDecoder((Consumer<String>)this.$errorOutputConsumer$inlined, this.this$0));
                it.pipeline().addLast("exceptionHandler", ChannelExceptionHandler.getInstance());
                ChannelFuture channelFuture = it.closeFuture();
                Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it.closeFuture()");
                ChannelFuture $receiver$iv = channelFuture;
                boolean $i$f$addChannelListener = false;
                $receiver$iv.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(this){
                    final /* synthetic */ configureBootstrap$$inlined$handler$1 this$0;
                    {
                        this.this$0 = var1_1;
                    }

                    public final void operationComplete(ChannelFuture it) {
                        ChannelFuture channelFuture = it;
                        Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it");
                        ChannelFuture it2 = channelFuture;
                        boolean bl = false;
                        FastCgiService.access$getRequestIdCounter$p(this.this$0.this$0).set(0);
                        if (!FastCgiService.access$getRequests$p(this.this$0.this$0).isEmpty()) {
                            Enumeration enumeration = FastCgiService.access$getRequests$p(this.this$0.this$0).elements();
                            Intrinsics.checkExpressionValueIsNotNull((Object)enumeration, (String)"requests.elements()");
                            Enumeration enumeration2 = enumeration;
                            ArrayList<T> arrayList = Collections.list(enumeration2);
                            Intrinsics.checkExpressionValueIsNotNull(arrayList, (String)"java.util.Collections.list(this)");
                            List waitingClients = arrayList;
                            FastCgiService.access$getRequests$p(this.this$0.this$0).clear();
                            for (ClientInfo client : waitingClients) {
                                FastCgiServiceKt.access$sendBadGateway(client.getChannel(), client.getExtraHeaders());
                            }
                        }
                    }
                });
            }
        });
    }

    public final void send(@NotNull FastCgiRequest fastCgiRequest, @NotNull ByteBuf content) {
        Intrinsics.checkParameterIsNotNull((Object)fastCgiRequest, (String)"fastCgiRequest");
        Intrinsics.checkParameterIsNotNull((Object)content, (String)"content");
        ByteBuf notEmptyContent = null;
        if (content.isReadable()) {
            content.retain();
            notEmptyContent = content;
            notEmptyContent.touch();
        } else {
            notEmptyContent = null;
        }
        try {
            Promise<OSProcessHandler> promise = null;
            OSProcessHandler handler2 = this.getProcessHandler().getResultIfFullFilled();
            if (handler2 == null) {
                Promise<OSProcessHandler> promise2 = this.getProcessHandler().get();
                Intrinsics.checkExpressionValueIsNotNull(promise2, (String)"processHandler.get()");
                promise = promise2;
            } else {
                Channel channel = this.getProcessChannel().get();
                if (channel == null || !channel.isOpen()) {
                    promise = this.connectAgain();
                } else {
                    fastCgiRequest.writeToServerChannel(notEmptyContent, channel);
                    return;
                }
            }
            promise.onSuccess((java.util.function.Consumer)new java.util.function.Consumer<Object>(this, fastCgiRequest, notEmptyContent){
                final /* synthetic */ FastCgiService this$0;
                final /* synthetic */ FastCgiRequest $fastCgiRequest;
                final /* synthetic */ ByteBuf $notEmptyContent;

                public final void accept(Object it) {
                    V v = FastCgiService.access$getProcessChannel$p(this.this$0).get();
                    if (v == null) {
                        Intrinsics.throwNpe();
                    }
                    this.$fastCgiRequest.writeToServerChannel(this.$notEmptyContent, (Channel)v);
                }
                {
                    this.this$0 = fastCgiService;
                    this.$fastCgiRequest = fastCgiRequest;
                    this.$notEmptyContent = byteBuf;
                }
            }).onError((java.util.function.Consumer)new java.util.function.Consumer<Throwable>(this, fastCgiRequest, notEmptyContent){
                final /* synthetic */ FastCgiService this$0;
                final /* synthetic */ FastCgiRequest $fastCgiRequest;
                final /* synthetic */ ByteBuf $notEmptyContent;

                public final void accept(Throwable it) {
                    Logger logger = FastCgiServiceKt.getLOG();
                    Throwable throwable = it;
                    Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"it");
                    Promises.errorIfNotMessage((Logger)logger, (Throwable)throwable);
                    FastCgiService.access$handleError(this.this$0, this.$fastCgiRequest, this.$notEmptyContent);
                }
                {
                    this.this$0 = fastCgiService;
                    this.$fastCgiRequest = fastCgiRequest;
                    this.$notEmptyContent = byteBuf;
                }
            });
        }
        catch (Throwable e) {
            FastCgiServiceKt.getLOG().error(e);
            this.handleError(fastCgiRequest, notEmptyContent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void handleError(FastCgiRequest fastCgiRequest, ByteBuf content) {
        try {
            if (content != null && content.refCnt() != 0) {
                content.release();
            }
        }
        finally {
            ClientInfo clientInfo = (ClientInfo)this.requests.remove(fastCgiRequest.getRequestId());
            if (clientInfo != null) {
                ClientInfo clientInfo2;
                ClientInfo it = clientInfo2 = clientInfo;
                boolean bl = false;
                FastCgiServiceKt.access$sendBadGateway(it.getChannel(), it.getExtraHeaders());
            }
        }
    }

    public final int allocateRequestId(@NotNull Channel channel, @NotNull HttpHeaders extraHeaders) {
        Intrinsics.checkParameterIsNotNull((Object)channel, (String)"channel");
        Intrinsics.checkParameterIsNotNull((Object)extraHeaders, (String)"extraHeaders");
        int requestId = this.requestIdCounter.getAndIncrement();
        if (requestId >= Short.MAX_VALUE) {
            this.requestIdCounter.set(0);
            requestId = this.requestIdCounter.getAndDecrement();
        }
        this.requests.put(requestId, (Object)new ClientInfo(channel, extraHeaders));
        return requestId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void responseReceived(int id, @Nullable ByteBuf buffer) {
        ClientInfo client = (ClientInfo)this.requests.remove(id);
        if (client == null || !client.getChannel().isActive()) {
            ByteBuf byteBuf = buffer;
            if (byteBuf != null) {
                byteBuf.release();
            }
            return;
        }
        Channel channel = client.getChannel();
        if (buffer == null) {
            HttpResponseStatus httpResponseStatus = HttpResponseStatus.BAD_GATEWAY;
            Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.BAD_GATEWAY");
            Responses.send$default(httpResponseStatus, channel, null, null, null, 14, null);
            return;
        }
        DefaultFullHttpResponse httpResponse = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buffer);
        try {
            FastCgiServiceKt.access$parseHeaders((HttpResponse)httpResponse, buffer);
            Responses.addServer((HttpResponse)httpResponse);
            if (!HttpUtil.isContentLengthSet((HttpMessage)((HttpMessage)httpResponse))) {
                HttpUtil.setContentLength((HttpMessage)((HttpMessage)httpResponse), (long)buffer.readableBytes());
            }
            httpResponse.headers().add(client.getExtraHeaders());
        }
        catch (Throwable e) {
            buffer.release();
            try {
                FastCgiServiceKt.getLOG().error(e);
            }
            finally {
                HttpResponseStatus httpResponseStatus = HttpResponseStatus.INTERNAL_SERVER_ERROR;
                Intrinsics.checkExpressionValueIsNotNull((Object)httpResponseStatus, (String)"HttpResponseStatus.INTERNAL_SERVER_ERROR");
                Responses.send$default(httpResponseStatus, channel, null, null, null, 14, null);
            }
            return;
        }
        channel.writeAndFlush((Object)httpResponse);
    }

    public FastCgiService(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        super(project);
        this.requestIdCounter = new AtomicInteger();
        ConcurrentIntObjectMap concurrentIntObjectMap = ContainerUtil.createConcurrentIntObjectMap();
        Intrinsics.checkExpressionValueIsNotNull((Object)concurrentIntObjectMap, (String)"ContainerUtil.createConc\u2026ntObjectMap<ClientInfo>()");
        this.requests = concurrentIntObjectMap;
    }

    public static final /* synthetic */ AtomicInteger access$getRequestIdCounter$p(FastCgiService $this) {
        return $this.requestIdCounter;
    }

    public static final /* synthetic */ ConcurrentIntObjectMap access$getRequests$p(FastCgiService $this) {
        return $this.requests;
    }

    public static final /* synthetic */ AtomicReference access$getProcessChannel$p(FastCgiService $this) {
        return $this.getProcessChannel();
    }

    public static final /* synthetic */ void access$handleError(FastCgiService $this, FastCgiRequest fastCgiRequest, ByteBuf content) {
        $this.handleError(fastCgiRequest, content);
    }
}

