/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.relaxNG.config;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.editor.HectorComponentPanel;
import com.intellij.openapi.editor.HectorComponentPanelsProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import java.util.HashMap;
import java.util.Map;
import org.intellij.plugins.relaxNG.config.NoNamespaceConfig;
import org.intellij.plugins.relaxNG.config.NoNamespaceConfigPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NoNamespaceConfig.Mappings", storages={@Storage(value="$WORKSPACE_FILE$")})
class NoNamespaceConfigImpl
extends NoNamespaceConfig
implements PersistentStateComponent<Mappings> {
    private final Map<VirtualFilePointer, VirtualFilePointer> myMappings = new HashMap<VirtualFilePointer, VirtualFilePointer>();
    private final Project myProject;

    NoNamespaceConfigImpl(Project project) {
        this.myProject = project;
    }

    private VirtualFilePointer getMappedPointer(@NotNull PsiFile file2) {
        VirtualFile virtualFile;
        if (file2 == null) {
            NoNamespaceConfigImpl.$$$reportNull$$$0(0);
        }
        if ((virtualFile = file2.getVirtualFile()) == null) {
            return null;
        }
        String url = virtualFile.getUrl();
        for (VirtualFilePointer pointer : this.myMappings.keySet()) {
            if (!url.equals(pointer.getUrl())) continue;
            return this.myMappings.get(pointer);
        }
        return null;
    }

    @Override
    @Nullable
    public String getMapping(@NotNull PsiFile file2) {
        VirtualFilePointer pointer;
        if (file2 == null) {
            NoNamespaceConfigImpl.$$$reportNull$$$0(1);
        }
        return (pointer = this.getMappedPointer(file2)) != null ? pointer.getUrl() : null;
    }

    @Override
    public VirtualFile getMappedFile(@NotNull PsiFile file2) {
        VirtualFilePointer url;
        if (file2 == null) {
            NoNamespaceConfigImpl.$$$reportNull$$$0(2);
        }
        return (url = this.getMappedPointer(file2)) != null ? url.getFile() : null;
    }

    @Override
    public void setMapping(@NotNull PsiFile file2, String location) {
        if (file2 == null) {
            NoNamespaceConfigImpl.$$$reportNull$$$0(3);
        }
        VirtualFile virtualFile = file2.getVirtualFile();
        assert (virtualFile != null);
        String url = virtualFile.getUrl();
        VirtualFilePointerManager manager = VirtualFilePointerManager.getInstance();
        for (VirtualFilePointer pointer : this.myMappings.keySet()) {
            if (!url.equals(pointer.getUrl())) continue;
            if (location == null) {
                this.myMappings.remove(pointer);
                return;
            }
            if (location.equals(this.myMappings.get(pointer).getUrl())) continue;
            this.myMappings.remove(pointer);
            this.myMappings.put(pointer, manager.create(location, (Disposable)this.myProject, null));
            return;
        }
        if (location != null) {
            this.myMappings.put(manager.create(url, (Disposable)this.myProject, null), manager.create(location, (Disposable)this.myProject, null));
        }
    }

    @NotNull
    public String getComponentName() {
        if ("RELAX-NG.NoNamespaceConfig" == null) {
            NoNamespaceConfigImpl.$$$reportNull$$$0(4);
        }
        return "RELAX-NG.NoNamespaceConfig";
    }

    public void projectClosed() {
        this.reset();
    }

    public Mappings getState() {
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (Map.Entry<VirtualFilePointer, VirtualFilePointer> entry : this.myMappings.entrySet()) {
            map2.put(entry.getKey().getUrl(), entry.getValue().getUrl());
        }
        return new Mappings(map2);
    }

    public void loadState(@NotNull Mappings state) {
        if (state == null) {
            NoNamespaceConfigImpl.$$$reportNull$$$0(5);
        }
        this.reset();
        VirtualFilePointerManager manager = VirtualFilePointerManager.getInstance();
        Map<String, String> map2 = state.myMappings;
        for (String file2 : map2.keySet()) {
            this.myMappings.put(manager.create(file2, (Disposable)this.myProject, null), manager.create(map2.get(file2), (Disposable)this.myProject, null));
        }
    }

    private void reset() {
        this.myMappings.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/plugins/relaxNG/config/NoNamespaceConfigImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/plugins/relaxNG/config/NoNamespaceConfigImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getMappedPointer";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMapping";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMappedFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setMapping";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class HectorProvider
    implements HectorComponentPanelsProvider {
        @Nullable
        public HectorComponentPanel createConfigurable(@NotNull PsiFile file2) {
            if (file2 == null) {
                HectorProvider.$$$reportNull$$$0(0);
            }
            if (file2 instanceof XmlFile) {
                try {
                    XmlTag rootTag = ((XmlFile)file2).getDocument().getRootTag();
                    if (rootTag.getNamespace().length() == 0) {
                        return new NoNamespaceConfigPanel(NoNamespaceConfig.getInstance(file2.getProject()), file2);
                    }
                }
                catch (NullPointerException e) {
                    return null;
                }
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/intellij/plugins/relaxNG/config/NoNamespaceConfigImpl$HectorProvider", "createConfigurable"));
        }
    }

    public static class Mappings {
        @MapAnnotation(surroundWithTag=false, entryTagName="mapping", keyAttributeName="file", valueAttributeName="schema")
        public Map<String, String> myMappings;

        public Mappings() {
            this.myMappings = new HashMap<String, String>();
        }

        Mappings(Map<String, String> map2) {
            this.myMappings = map2;
        }
    }
}

