/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.util.Processor;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonSchemaAnnotatorChecker;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaTreeNode;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaResolver {
    @NotNull
    private final Project myProject;
    @NotNull
    private final JsonSchemaObject mySchema;
    private final boolean myIsName;
    @NotNull
    private final JsonPointerPosition myPosition;

    public JsonSchemaResolver(@NotNull Project project, @NotNull JsonSchemaObject schema, boolean isName, @NotNull JsonPointerPosition position) {
        if (project == null) {
            JsonSchemaResolver.$$$reportNull$$$0(0);
        }
        if (schema == null) {
            JsonSchemaResolver.$$$reportNull$$$0(1);
        }
        if (position == null) {
            JsonSchemaResolver.$$$reportNull$$$0(2);
        }
        this.myProject = project;
        this.mySchema = schema;
        this.myIsName = isName;
        this.myPosition = position;
    }

    public JsonSchemaResolver(@NotNull Project project, @NotNull JsonSchemaObject schema) {
        if (project == null) {
            JsonSchemaResolver.$$$reportNull$$$0(3);
        }
        if (schema == null) {
            JsonSchemaResolver.$$$reportNull$$$0(4);
        }
        this.myProject = project;
        this.mySchema = schema;
        this.myIsName = true;
        this.myPosition = new JsonPointerPosition();
    }

    public MatchResult detailedResolve() {
        JsonSchemaTreeNode node = JsonSchemaVariantsTreeBuilder.buildTree(this.myProject, this.mySchema, this.myPosition, false, !this.myIsName);
        return MatchResult.create(node);
    }

    @NotNull
    public Collection<JsonSchemaObject> resolve() {
        MatchResult result2 = this.detailedResolve();
        ArrayList<JsonSchemaObject> list2 = new ArrayList<JsonSchemaObject>(result2.mySchemas);
        list2.addAll(result2.myExcludingSchemas.stream().flatMap(Collection::stream).collect(Collectors.toList()));
        ArrayList<JsonSchemaObject> arrayList = list2;
        if (arrayList == null) {
            JsonSchemaResolver.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    @Nullable
    public PsiElement findNavigationTarget(@Nullable PsiElement element, boolean acceptAdditionalPropertiesSchema) {
        JsonSchemaTreeNode node = JsonSchemaVariantsTreeBuilder.buildTree(this.myProject, this.mySchema, this.myPosition, true, acceptAdditionalPropertiesSchema || !this.myIsName);
        JsonSchemaObject schema = this.selectSchema(node, element, this.myPosition.isEmpty());
        if (schema == null) {
            return null;
        }
        VirtualFile file2 = JsonSchemaService.Impl.get(this.myProject).resolveSchemaFile(schema);
        if (file2 == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file2);
        if (psiFile == null) {
            return null;
        }
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker((PsiElement)psiFile, schema);
        return walker == null ? null : JsonSchemaResolver.resolvePosition(walker, (PsiElement)psiFile, JsonPointerPosition.parsePointer(schema.getPointer()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    private static PsiElement resolvePosition(@NotNull JsonLikePsiWalker walker, @Nullable PsiElement element, @NotNull JsonPointerPosition position) {
        PsiElement psiElement;
        PsiElement psiElement2;
        if (walker == null) {
            JsonSchemaResolver.$$$reportNull$$$0(6);
        }
        if (position == null) {
            JsonSchemaResolver.$$$reportNull$$$0(7);
        }
        PsiElement psiElement3 = psiElement2 = element instanceof PsiFile ? walker.getRoot((PsiFile)element) : element;
        if (psiElement2 == null) {
            return null;
        }
        JsonValueAdapter value = walker.createValueAdapter(psiElement2);
        while (position != null && !position.isEmpty()) {
            block13: {
                int index;
                if (value instanceof JsonObjectValueAdapter) {
                    String name = position.getFirstName();
                    if (name == null) {
                        return null;
                    }
                    JsonPropertyAdapter property = JsonSchemaResolver.findProperty((JsonObjectValueAdapter)value, name);
                    if (property != null) {
                        value = JsonSchemaResolver.getValue(property);
                        if (value == null) {
                            return null;
                        }
                        break block13;
                    } else {
                        JsonPropertyAdapter props = JsonSchemaResolver.findProperty((JsonObjectValueAdapter)value, "properties");
                        if (props != null) {
                            value = JsonSchemaResolver.getValue(props);
                            continue;
                        }
                        JsonPropertyAdapter defs = JsonSchemaResolver.findProperty((JsonObjectValueAdapter)value, "definitions");
                        if (defs == null) return null;
                        value = JsonSchemaResolver.getValue(defs);
                        continue;
                    }
                }
                if (value instanceof JsonArrayValueAdapter && (index = position.getFirstIndex()) >= 0) {
                    List<JsonValueAdapter> values = ((JsonArrayValueAdapter)value).getElements();
                    if (values.size() <= index) return null;
                    value = values.get(index);
                }
            }
            position = position.skip(1);
        }
        if (value == null) {
            return null;
        }
        PsiElement delegate = value.getDelegate();
        PsiElement propertyNameElement = walker.getPropertyNameElement(delegate.getParent());
        if (propertyNameElement == null) {
            psiElement = delegate;
            return psiElement;
        }
        psiElement = propertyNameElement;
        return psiElement;
    }

    @Nullable
    private static JsonValueAdapter getValue(@NotNull JsonPropertyAdapter property) {
        Collection<JsonValueAdapter> values;
        if (property == null) {
            JsonSchemaResolver.$$$reportNull$$$0(8);
        }
        return (values = property.getValues()).size() == 1 ? values.iterator().next() : null;
    }

    @Nullable
    private static JsonPropertyAdapter findProperty(@NotNull JsonObjectValueAdapter value, @NotNull String name) {
        if (value == null) {
            JsonSchemaResolver.$$$reportNull$$$0(9);
        }
        if (name == null) {
            JsonSchemaResolver.$$$reportNull$$$0(10);
        }
        List<JsonPropertyAdapter> list2 = value.getPropertyList();
        return list2.stream().filter(p -> name.equals(p.getName())).findFirst().orElse(null);
    }

    @Nullable
    private JsonSchemaObject selectSchema(@NotNull JsonSchemaTreeNode resolveRoot, @Nullable PsiElement element, boolean topLevelSchema) {
        JsonValueAdapter parentAdapter;
        JsonValueAdapter adapter;
        if (resolveRoot == null) {
            JsonSchemaResolver.$$$reportNull$$$0(11);
        }
        MatchResult matchResult = MatchResult.create(resolveRoot);
        ArrayList<JsonSchemaObject> schemas = new ArrayList<JsonSchemaObject>(matchResult.mySchemas);
        schemas.addAll(matchResult.myExcludingSchemas.stream().flatMap(Collection::stream).collect(Collectors.toList()));
        JsonSchemaObject firstSchema = JsonSchemaResolver.getFirstValidSchema(schemas);
        if (element == null || schemas.size() == 1 || firstSchema == null) {
            return firstSchema;
        }
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(element, firstSchema);
        if (walker == null || (adapter = walker.createValueAdapter(element)) == null) {
            return null;
        }
        if (topLevelSchema) {
            parentAdapter = null;
        } else {
            PsiElement parentValue = walker.getParentContainer(element);
            if (parentValue == null || (parentAdapter = walker.createValueAdapter(parentValue)) == null) {
                return null;
            }
        }
        Ref schemaRef = new Ref();
        MatchResult.iterateTree(resolveRoot, (Processor<? super JsonSchemaTreeNode>)((Processor)node -> {
            JsonSchemaTreeNode parent = node.getParent();
            if (node.getSchema() == null || parentAdapter != null && parent != null && parent.isNothing()) {
                return true;
            }
            if (!this.isCorrect(adapter, node.getSchema())) {
                return true;
            }
            if (parentAdapter == null || parent == null || parent.getSchema() == null || parent.isAny() || this.isCorrect(parentAdapter, parent.getSchema())) {
                schemaRef.set((Object)node.getSchema());
                return false;
            }
            return true;
        }));
        return (JsonSchemaObject)schemaRef.get();
    }

    @Nullable
    private static JsonSchemaObject getFirstValidSchema(List<JsonSchemaObject> schemas) {
        return schemas.stream().findFirst().orElse(null);
    }

    private boolean isCorrect(@NotNull JsonValueAdapter value, @NotNull JsonSchemaObject schema) {
        JsonSchemaType type;
        if (value == null) {
            JsonSchemaResolver.$$$reportNull$$$0(12);
        }
        if (schema == null) {
            JsonSchemaResolver.$$$reportNull$$$0(13);
        }
        if ((type = JsonSchemaType.getType(value)) == null) {
            return true;
        }
        if (!JsonSchemaAnnotatorChecker.areSchemaTypesCompatible(schema, type)) {
            return false;
        }
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(this.myProject, JsonComplianceCheckerOptions.RELAX_ENUM_CHECK);
        checker.checkByScheme(value, schema);
        return checker.isCorrect();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "position";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaResolver";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "walker";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveRoot";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaResolver";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "resolve";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "resolvePosition";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findProperty";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "selectSchema";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isCorrect";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

