/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.http.HttpVirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import com.jetbrains.jsonSchema.JsonPointerUtil;
import com.jetbrains.jsonSchema.JsonSchemaVfsListener;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import com.jetbrains.jsonSchema.impl.IfThenElse;
import com.jetbrains.jsonSchema.impl.JsonCachedValues;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.remote.JsonFileResolver;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JsonSchemaObject {
    private static final Logger LOG = Logger.getInstance(JsonSchemaObject.class);
    public static final String MOCK_URL = "mock:///";
    @NonNls
    public static final String DEFINITIONS = "definitions";
    @NonNls
    public static final String PROPERTIES = "properties";
    @NonNls
    public static final String ITEMS = "items";
    @NonNls
    public static final String ADDITIONAL_ITEMS = "additionalItems";
    @NonNls
    public static final String X_INTELLIJ_HTML_DESCRIPTION = "x-intellij-html-description";
    @Nullable
    private final String myFileUrl;
    @NotNull
    private final String myPointer;
    @Nullable
    private final VirtualFile myRawFile;
    @Nullable
    private Map<String, JsonSchemaObject> myDefinitionsMap;
    @NotNull
    public static final JsonSchemaObject NULL_OBJ = new JsonSchemaObject("$_NULL_$");
    @NotNull
    private final ConcurrentMap<String, JsonSchemaObject> myComputedRefs;
    @NotNull
    private final AtomicBoolean mySubscribed;
    @NotNull
    private Map<String, JsonSchemaObject> myProperties;
    @Nullable
    private PatternProperties myPatternProperties;
    @Nullable
    private PropertyNamePattern myPattern;
    @Nullable
    private String myId;
    @Nullable
    private String mySchema;
    @Nullable
    private String myTitle;
    @Nullable
    private String myDescription;
    @Nullable
    private String myHtmlDescription;
    @Nullable
    private JsonSchemaType myType;
    @Nullable
    private Object myDefault;
    @Nullable
    private String myRef;
    @Nullable
    private String myFormat;
    @Nullable
    private Set<JsonSchemaType> myTypeVariants;
    @Nullable
    private Number myMultipleOf;
    @Nullable
    private Number myMaximum;
    private boolean myExclusiveMaximum;
    @Nullable
    private Number myExclusiveMaximumNumber;
    @Nullable
    private Number myMinimum;
    private boolean myExclusiveMinimum;
    @Nullable
    private Number myExclusiveMinimumNumber;
    @Nullable
    private Integer myMaxLength;
    @Nullable
    private Integer myMinLength;
    @Nullable
    private Boolean myAdditionalPropertiesAllowed;
    @Nullable
    private Set<String> myAdditionalPropertiesNotAllowedFor;
    @Nullable
    private JsonSchemaObject myAdditionalPropertiesSchema;
    @Nullable
    private JsonSchemaObject myPropertyNamesSchema;
    @Nullable
    private Boolean myAdditionalItemsAllowed;
    @Nullable
    private JsonSchemaObject myAdditionalItemsSchema;
    @Nullable
    private JsonSchemaObject myItemsSchema;
    @Nullable
    private JsonSchemaObject myContainsSchema;
    @Nullable
    private List<JsonSchemaObject> myItemsSchemaList;
    @Nullable
    private Integer myMaxItems;
    @Nullable
    private Integer myMinItems;
    @Nullable
    private Boolean myUniqueItems;
    @Nullable
    private Integer myMaxProperties;
    @Nullable
    private Integer myMinProperties;
    @Nullable
    private Set<String> myRequired;
    @Nullable
    private Map<String, List<String>> myPropertyDependencies;
    @Nullable
    private Map<String, JsonSchemaObject> mySchemaDependencies;
    @Nullable
    private List<Object> myEnum;
    @Nullable
    private List<JsonSchemaObject> myAllOf;
    @Nullable
    private List<JsonSchemaObject> myAnyOf;
    @Nullable
    private List<JsonSchemaObject> myOneOf;
    @Nullable
    private JsonSchemaObject myNot;
    @Nullable
    private List<IfThenElse> myIfThenElse;
    @Nullable
    private JsonSchemaObject myIf;
    @Nullable
    private JsonSchemaObject myThen;
    @Nullable
    private JsonSchemaObject myElse;
    private boolean myShouldValidateAgainstJSType;
    @Nullable
    private String myDeprecationMessage;
    @Nullable
    private Map<String, String> myIdsMap;
    private boolean myIsValidByExclusion;

    public boolean isValidByExclusion() {
        return this.myIsValidByExclusion;
    }

    public JsonSchemaObject(@Nullable VirtualFile file2, @NotNull String pointer) {
        if (pointer == null) {
            JsonSchemaObject.$$$reportNull$$$0(0);
        }
        this.myComputedRefs = new ConcurrentHashMap<String, JsonSchemaObject>();
        this.mySubscribed = new AtomicBoolean(false);
        this.myIsValidByExclusion = true;
        this.myFileUrl = file2 == null ? null : file2.getUrl();
        this.myRawFile = this.myFileUrl != null && this.myFileUrl.startsWith(MOCK_URL) ? file2 : null;
        this.myPointer = pointer;
        this.myProperties = new HashMap<String, JsonSchemaObject>();
    }

    private JsonSchemaObject(@Nullable VirtualFile rawFile, @Nullable String fileUrl, @NotNull String pointer) {
        if (pointer == null) {
            JsonSchemaObject.$$$reportNull$$$0(1);
        }
        this.myComputedRefs = new ConcurrentHashMap<String, JsonSchemaObject>();
        this.mySubscribed = new AtomicBoolean(false);
        this.myIsValidByExclusion = true;
        this.myFileUrl = fileUrl;
        this.myRawFile = rawFile;
        this.myPointer = pointer;
        this.myProperties = new HashMap<String, JsonSchemaObject>();
    }

    private JsonSchemaObject(@NotNull String pointer) {
        if (pointer == null) {
            JsonSchemaObject.$$$reportNull$$$0(2);
        }
        this(null, pointer);
    }

    public void completeInitialization(JsonValueAdapter jsonObject) {
        if (this.myIf != null) {
            this.myIfThenElse = ContainerUtil.newArrayList();
            this.myIfThenElse.add(new IfThenElse(this.myIf, this.myThen, this.myElse));
        }
        this.myIdsMap = JsonCachedValues.getOrComputeIdsMap(jsonObject.getDelegate().getContainingFile());
    }

    public String resolveId(@NotNull String id) {
        if (id == null) {
            JsonSchemaObject.$$$reportNull$$$0(3);
        }
        return this.myIdsMap == null ? null : this.myIdsMap.get(id);
    }

    @NotNull
    public String getPointer() {
        String string = this.myPointer;
        if (string == null) {
            JsonSchemaObject.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    public String getFileUrl() {
        return this.myFileUrl;
    }

    @Nullable
    public VirtualFile getRawFile() {
        return this.myRawFile;
    }

    @Nullable
    private static JsonSchemaType getSubtypeOfBoth(@NotNull JsonSchemaType selfType, @NotNull JsonSchemaType otherType) {
        if (selfType == null) {
            JsonSchemaObject.$$$reportNull$$$0(5);
        }
        if (otherType == null) {
            JsonSchemaObject.$$$reportNull$$$0(6);
        }
        if (otherType == JsonSchemaType._any) {
            return selfType;
        }
        if (selfType == JsonSchemaType._any) {
            return otherType;
        }
        switch (selfType) {
            case _string: {
                return otherType == JsonSchemaType._string || otherType == JsonSchemaType._string_number ? JsonSchemaType._string : null;
            }
            case _number: {
                if (otherType == JsonSchemaType._integer) {
                    return JsonSchemaType._integer;
                }
                return otherType == JsonSchemaType._number || otherType == JsonSchemaType._string_number ? JsonSchemaType._number : null;
            }
            case _integer: {
                return otherType == JsonSchemaType._number || otherType == JsonSchemaType._string_number || otherType == JsonSchemaType._integer ? JsonSchemaType._integer : null;
            }
            case _object: {
                return otherType == JsonSchemaType._object ? JsonSchemaType._object : null;
            }
            case _array: {
                return otherType == JsonSchemaType._array ? JsonSchemaType._array : null;
            }
            case _boolean: {
                return otherType == JsonSchemaType._boolean ? JsonSchemaType._boolean : null;
            }
            case _null: {
                return otherType == JsonSchemaType._null ? JsonSchemaType._null : null;
            }
            case _string_number: {
                return otherType == JsonSchemaType._integer || otherType == JsonSchemaType._number || otherType == JsonSchemaType._string || otherType == JsonSchemaType._string_number ? otherType : null;
            }
        }
        return otherType;
    }

    @Nullable
    private JsonSchemaType mergeTypes(@Nullable JsonSchemaType selfType, @Nullable JsonSchemaType otherType, @Nullable Set<JsonSchemaType> otherTypeVariants) {
        if (selfType == null) {
            return otherType;
        }
        if (otherType == null) {
            if (otherTypeVariants != null && !otherTypeVariants.isEmpty()) {
                HashSet filteredVariants = ContainerUtil.newHashSet((int)otherTypeVariants.size());
                for (JsonSchemaType variant : otherTypeVariants) {
                    JsonSchemaType subtype = JsonSchemaObject.getSubtypeOfBoth(selfType, variant);
                    if (subtype == null) continue;
                    filteredVariants.add(subtype);
                }
                if (filteredVariants.size() == 0) {
                    this.myIsValidByExclusion = false;
                    return selfType;
                }
                if (filteredVariants.size() == 1) {
                    return (JsonSchemaType)((Object)filteredVariants.iterator().next());
                }
                return null;
            }
            return selfType;
        }
        JsonSchemaType subtypeOfBoth = JsonSchemaObject.getSubtypeOfBoth(selfType, otherType);
        if (subtypeOfBoth == null) {
            this.myIsValidByExclusion = false;
            return otherType;
        }
        return subtypeOfBoth;
    }

    private Set<JsonSchemaType> mergeTypeVariantSets(@Nullable Set<JsonSchemaType> self, @Nullable Set<JsonSchemaType> other) {
        if (self == null) {
            return other;
        }
        if (other == null) {
            return self;
        }
        HashSet resultSet = ContainerUtil.newHashSet((int)self.size());
        for (JsonSchemaType type : self) {
            JsonSchemaType merged = this.mergeTypes(type, null, other);
            if (merged == null) continue;
            resultSet.add(merged);
        }
        if (resultSet.isEmpty()) {
            this.myIsValidByExclusion = false;
            return other;
        }
        return resultSet;
    }

    public void mergeValues(@NotNull JsonSchemaObject other) {
        if (other == null) {
            JsonSchemaObject.$$$reportNull$$$0(7);
        }
        JsonSchemaObject.mergeProperties(this, other);
        this.myDefinitionsMap = JsonSchemaObject.copyMap(this.myDefinitionsMap, other.myDefinitionsMap);
        Map<String, JsonSchemaObject> map2 = JsonSchemaObject.copyMap(this.myPatternProperties == null ? null : this.myPatternProperties.mySchemasMap, other.myPatternProperties == null ? null : other.myPatternProperties.mySchemasMap);
        PatternProperties patternProperties = this.myPatternProperties = map2 == null ? null : new PatternProperties(map2);
        if (!StringUtil.isEmptyOrSpaces((String)other.myTitle)) {
            this.myTitle = other.myTitle;
        }
        if (!StringUtil.isEmptyOrSpaces((String)other.myDescription)) {
            this.myDescription = other.myDescription;
        }
        if (!StringUtil.isEmptyOrSpaces((String)other.myHtmlDescription)) {
            this.myHtmlDescription = other.myHtmlDescription;
        }
        this.myType = this.mergeTypes(this.myType, other.myType, other.myTypeVariants);
        if (other.myDefault != null) {
            this.myDefault = other.myDefault;
        }
        if (other.myRef != null) {
            this.myRef = other.myRef;
        }
        if (other.myFormat != null) {
            this.myFormat = other.myFormat;
        }
        this.myTypeVariants = this.mergeTypeVariantSets(this.myTypeVariants, other.myTypeVariants);
        if (other.myMultipleOf != null) {
            this.myMultipleOf = other.myMultipleOf;
        }
        if (other.myMaximum != null) {
            this.myMaximum = other.myMaximum;
        }
        if (other.myExclusiveMaximumNumber != null) {
            this.myExclusiveMaximumNumber = other.myExclusiveMaximumNumber;
        }
        this.myExclusiveMaximum |= other.myExclusiveMaximum;
        if (other.myMinimum != null) {
            this.myMinimum = other.myMinimum;
        }
        if (other.myExclusiveMinimumNumber != null) {
            this.myExclusiveMinimumNumber = other.myExclusiveMinimumNumber;
        }
        this.myExclusiveMinimum |= other.myExclusiveMinimum;
        if (other.myMaxLength != null) {
            this.myMaxLength = other.myMaxLength;
        }
        if (other.myMinLength != null) {
            this.myMinLength = other.myMinLength;
        }
        if (other.myPattern != null) {
            this.myPattern = other.myPattern;
        }
        if (other.myAdditionalPropertiesAllowed != null) {
            this.myAdditionalPropertiesAllowed = other.myAdditionalPropertiesAllowed;
            if (other.myAdditionalPropertiesAllowed == Boolean.FALSE) {
                this.addAdditionalPropsNotAllowedFor(other.myFileUrl, other.myPointer);
            }
        }
        if (other.myAdditionalPropertiesSchema != null) {
            this.myAdditionalPropertiesSchema = other.myAdditionalPropertiesSchema;
        }
        if (other.myPropertyNamesSchema != null) {
            this.myPropertyNamesSchema = other.myPropertyNamesSchema;
        }
        if (other.myAdditionalItemsAllowed != null) {
            this.myAdditionalItemsAllowed = other.myAdditionalItemsAllowed;
        }
        if (other.myAdditionalItemsSchema != null) {
            this.myAdditionalItemsSchema = other.myAdditionalItemsSchema;
        }
        if (other.myItemsSchema != null) {
            this.myItemsSchema = other.myItemsSchema;
        }
        if (other.myContainsSchema != null) {
            this.myContainsSchema = other.myContainsSchema;
        }
        this.myItemsSchemaList = JsonSchemaObject.copyList(this.myItemsSchemaList, other.myItemsSchemaList);
        if (other.myMaxItems != null) {
            this.myMaxItems = other.myMaxItems;
        }
        if (other.myMinItems != null) {
            this.myMinItems = other.myMinItems;
        }
        if (other.myUniqueItems != null) {
            this.myUniqueItems = other.myUniqueItems;
        }
        if (other.myMaxProperties != null) {
            this.myMaxProperties = other.myMaxProperties;
        }
        if (other.myMinProperties != null) {
            this.myMinProperties = other.myMinProperties;
        }
        if (this.myRequired != null && other.myRequired != null) {
            this.myRequired.addAll(other.myRequired);
        } else if (other.myRequired != null) {
            this.myRequired = other.myRequired;
        }
        this.myPropertyDependencies = JsonSchemaObject.copyMap(this.myPropertyDependencies, other.myPropertyDependencies);
        this.mySchemaDependencies = JsonSchemaObject.copyMap(this.mySchemaDependencies, other.mySchemaDependencies);
        if (other.myEnum != null) {
            this.myEnum = other.myEnum;
        }
        this.myAllOf = JsonSchemaObject.copyList(this.myAllOf, other.myAllOf);
        this.myAnyOf = JsonSchemaObject.copyList(this.myAnyOf, other.myAnyOf);
        this.myOneOf = JsonSchemaObject.copyList(this.myOneOf, other.myOneOf);
        if (other.myNot != null) {
            this.myNot = other.myNot;
        }
        if (other.myIfThenElse != null) {
            this.myIfThenElse = this.myIfThenElse == null ? other.myIfThenElse : ContainerUtil.concat(this.myIfThenElse, other.myIfThenElse);
        }
        this.myShouldValidateAgainstJSType |= other.myShouldValidateAgainstJSType;
    }

    private static void mergeProperties(@NotNull JsonSchemaObject thisObject, @NotNull JsonSchemaObject otherObject) {
        if (thisObject == null) {
            JsonSchemaObject.$$$reportNull$$$0(8);
        }
        if (otherObject == null) {
            JsonSchemaObject.$$$reportNull$$$0(9);
        }
        for (Map.Entry<String, JsonSchemaObject> prop : otherObject.myProperties.entrySet()) {
            String key = prop.getKey();
            JsonSchemaObject otherProp = prop.getValue();
            if (!thisObject.myProperties.containsKey(key)) {
                thisObject.myProperties.put(key, otherProp);
                continue;
            }
            JsonSchemaObject existingProp = thisObject.myProperties.get(key);
            thisObject.myProperties.put(key, JsonSchemaObject.merge(existingProp, otherProp, otherProp));
        }
    }

    public void setShouldValidateAgainstJSType() {
        this.myShouldValidateAgainstJSType = true;
    }

    public boolean isShouldValidateAgainstJSType() {
        return this.myShouldValidateAgainstJSType;
    }

    @Nullable
    private static <T> List<T> copyList(@Nullable List<T> target2, @Nullable List<T> source) {
        if (source == null || source.isEmpty()) {
            return target2;
        }
        if (target2 == null) {
            target2 = ContainerUtil.newArrayListWithCapacity((int)source.size());
        }
        target2.addAll(source);
        return target2;
    }

    @Nullable
    private static <K, V> Map<K, V> copyMap(@Nullable Map<K, V> target2, @Nullable Map<K, V> source) {
        if (source == null || source.isEmpty()) {
            return target2;
        }
        if (target2 == null) {
            target2 = ContainerUtilRt.newHashMap((int)source.size());
        }
        target2.putAll(source);
        return target2;
    }

    @Nullable
    public Map<String, JsonSchemaObject> getDefinitionsMap() {
        return this.myDefinitionsMap;
    }

    public void setDefinitionsMap(@NotNull Map<String, JsonSchemaObject> definitionsMap) {
        if (definitionsMap == null) {
            JsonSchemaObject.$$$reportNull$$$0(10);
        }
        this.myDefinitionsMap = definitionsMap;
    }

    @NotNull
    public Map<String, JsonSchemaObject> getProperties() {
        Map<String, JsonSchemaObject> map2 = this.myProperties;
        if (map2 == null) {
            JsonSchemaObject.$$$reportNull$$$0(11);
        }
        return map2;
    }

    public void setProperties(@NotNull Map<String, JsonSchemaObject> properties) {
        if (properties == null) {
            JsonSchemaObject.$$$reportNull$$$0(12);
        }
        this.myProperties = properties;
    }

    public boolean hasPatternProperties() {
        return this.myPatternProperties != null;
    }

    public void setPatternProperties(@NotNull Map<String, JsonSchemaObject> patternProperties) {
        if (patternProperties == null) {
            JsonSchemaObject.$$$reportNull$$$0(13);
        }
        this.myPatternProperties = new PatternProperties(patternProperties);
    }

    @Nullable
    public JsonSchemaType getType() {
        return this.myType;
    }

    public void setType(@Nullable JsonSchemaType type) {
        this.myType = type;
    }

    @Nullable
    public Number getMultipleOf() {
        return this.myMultipleOf;
    }

    public void setMultipleOf(@Nullable Number multipleOf) {
        this.myMultipleOf = multipleOf;
    }

    @Nullable
    public Number getMaximum() {
        return this.myMaximum;
    }

    public void setMaximum(@Nullable Number maximum) {
        this.myMaximum = maximum;
    }

    public boolean isExclusiveMaximum() {
        return this.myExclusiveMaximum;
    }

    @Nullable
    public Number getExclusiveMaximumNumber() {
        return this.myExclusiveMaximumNumber;
    }

    public void setExclusiveMaximumNumber(@Nullable Number exclusiveMaximumNumber) {
        this.myExclusiveMaximumNumber = exclusiveMaximumNumber;
    }

    @Nullable
    public Number getExclusiveMinimumNumber() {
        return this.myExclusiveMinimumNumber;
    }

    public void setExclusiveMinimumNumber(@Nullable Number exclusiveMinimumNumber) {
        this.myExclusiveMinimumNumber = exclusiveMinimumNumber;
    }

    public void setExclusiveMaximum(boolean exclusiveMaximum) {
        this.myExclusiveMaximum = exclusiveMaximum;
    }

    @Nullable
    public Number getMinimum() {
        return this.myMinimum;
    }

    public void setMinimum(@Nullable Number minimum) {
        this.myMinimum = minimum;
    }

    public boolean isExclusiveMinimum() {
        return this.myExclusiveMinimum;
    }

    public void setExclusiveMinimum(boolean exclusiveMinimum) {
        this.myExclusiveMinimum = exclusiveMinimum;
    }

    @Nullable
    public Integer getMaxLength() {
        return this.myMaxLength;
    }

    public void setMaxLength(@Nullable Integer maxLength) {
        this.myMaxLength = maxLength;
    }

    @Nullable
    public Integer getMinLength() {
        return this.myMinLength;
    }

    public void setMinLength(@Nullable Integer minLength) {
        this.myMinLength = minLength;
    }

    @Nullable
    public String getPattern() {
        return this.myPattern == null ? null : this.myPattern.getPattern();
    }

    public void setPattern(@Nullable String pattern) {
        this.myPattern = pattern == null ? null : new PropertyNamePattern(pattern);
    }

    @Nullable
    public Boolean getAdditionalPropertiesAllowed() {
        return this.myAdditionalPropertiesAllowed == null || this.myAdditionalPropertiesAllowed != false;
    }

    public void setAdditionalPropertiesAllowed(@Nullable Boolean additionalPropertiesAllowed) {
        this.myAdditionalPropertiesAllowed = additionalPropertiesAllowed;
        if (additionalPropertiesAllowed == Boolean.FALSE) {
            this.addAdditionalPropsNotAllowedFor(this.myFileUrl, this.myPointer);
        }
    }

    public boolean hasOwnExtraPropertyProhibition() {
        return this.getAdditionalPropertiesAllowed() == Boolean.FALSE && (this.myAdditionalPropertiesNotAllowedFor == null || this.myAdditionalPropertiesNotAllowedFor.contains(this.myFileUrl + this.myPointer));
    }

    private void addAdditionalPropsNotAllowedFor(String url, String pointer) {
        HashSet newSet = this.myAdditionalPropertiesNotAllowedFor == null ? ContainerUtil.newHashSet() : ContainerUtil.newHashSet(this.myAdditionalPropertiesNotAllowedFor);
        newSet.add(url + pointer);
        this.myAdditionalPropertiesNotAllowedFor = newSet;
    }

    @Nullable
    public JsonSchemaObject getPropertyNamesSchema() {
        return this.myPropertyNamesSchema;
    }

    public void setPropertyNamesSchema(@Nullable JsonSchemaObject propertyNamesSchema) {
        this.myPropertyNamesSchema = propertyNamesSchema;
    }

    @Nullable
    public JsonSchemaObject getAdditionalPropertiesSchema() {
        return this.myAdditionalPropertiesSchema;
    }

    public void setAdditionalPropertiesSchema(@Nullable JsonSchemaObject additionalPropertiesSchema) {
        this.myAdditionalPropertiesSchema = additionalPropertiesSchema;
    }

    @Nullable
    public Boolean getAdditionalItemsAllowed() {
        return this.myAdditionalItemsAllowed == null || this.myAdditionalItemsAllowed != false;
    }

    public void setAdditionalItemsAllowed(@Nullable Boolean additionalItemsAllowed) {
        this.myAdditionalItemsAllowed = additionalItemsAllowed;
    }

    @Nullable
    public String getDeprecationMessage() {
        return this.myDeprecationMessage;
    }

    public void setDeprecationMessage(@Nullable String deprecationMessage) {
        this.myDeprecationMessage = deprecationMessage;
    }

    @Nullable
    public JsonSchemaObject getAdditionalItemsSchema() {
        return this.myAdditionalItemsSchema;
    }

    public void setAdditionalItemsSchema(@Nullable JsonSchemaObject additionalItemsSchema) {
        this.myAdditionalItemsSchema = additionalItemsSchema;
    }

    @Nullable
    public JsonSchemaObject getItemsSchema() {
        return this.myItemsSchema;
    }

    public void setItemsSchema(@Nullable JsonSchemaObject itemsSchema) {
        this.myItemsSchema = itemsSchema;
    }

    @Nullable
    public JsonSchemaObject getContainsSchema() {
        return this.myContainsSchema;
    }

    public void setContainsSchema(@Nullable JsonSchemaObject containsSchema) {
        this.myContainsSchema = containsSchema;
    }

    @Nullable
    public List<JsonSchemaObject> getItemsSchemaList() {
        return this.myItemsSchemaList;
    }

    public void setItemsSchemaList(@Nullable List<JsonSchemaObject> itemsSchemaList) {
        this.myItemsSchemaList = itemsSchemaList;
    }

    @Nullable
    public Integer getMaxItems() {
        return this.myMaxItems;
    }

    public void setMaxItems(@Nullable Integer maxItems) {
        this.myMaxItems = maxItems;
    }

    @Nullable
    public Integer getMinItems() {
        return this.myMinItems;
    }

    public void setMinItems(@Nullable Integer minItems) {
        this.myMinItems = minItems;
    }

    public boolean isUniqueItems() {
        return Boolean.TRUE.equals(this.myUniqueItems);
    }

    public void setUniqueItems(boolean uniqueItems) {
        this.myUniqueItems = uniqueItems;
    }

    @Nullable
    public Integer getMaxProperties() {
        return this.myMaxProperties;
    }

    public void setMaxProperties(@Nullable Integer maxProperties) {
        this.myMaxProperties = maxProperties;
    }

    @Nullable
    public Integer getMinProperties() {
        return this.myMinProperties;
    }

    public void setMinProperties(@Nullable Integer minProperties) {
        this.myMinProperties = minProperties;
    }

    @Nullable
    public Set<String> getRequired() {
        return this.myRequired;
    }

    public void setRequired(@Nullable Set<String> required) {
        this.myRequired = required;
    }

    @Nullable
    public Map<String, List<String>> getPropertyDependencies() {
        return this.myPropertyDependencies;
    }

    public void setPropertyDependencies(@Nullable Map<String, List<String>> propertyDependencies) {
        this.myPropertyDependencies = propertyDependencies;
    }

    @Nullable
    public Map<String, JsonSchemaObject> getSchemaDependencies() {
        return this.mySchemaDependencies;
    }

    public void setSchemaDependencies(@Nullable Map<String, JsonSchemaObject> schemaDependencies) {
        this.mySchemaDependencies = schemaDependencies;
    }

    @Nullable
    public List<Object> getEnum() {
        return this.myEnum;
    }

    public void setEnum(@Nullable List<Object> anEnum) {
        this.myEnum = anEnum;
    }

    @Nullable
    public List<JsonSchemaObject> getAllOf() {
        return this.myAllOf;
    }

    public void setAllOf(@Nullable List<JsonSchemaObject> allOf) {
        this.myAllOf = allOf;
    }

    @Nullable
    public List<JsonSchemaObject> getAnyOf() {
        return this.myAnyOf;
    }

    public void setAnyOf(@Nullable List<JsonSchemaObject> anyOf) {
        this.myAnyOf = anyOf;
    }

    @Nullable
    public List<JsonSchemaObject> getOneOf() {
        return this.myOneOf;
    }

    public void setOneOf(@Nullable List<JsonSchemaObject> oneOf) {
        this.myOneOf = oneOf;
    }

    @Nullable
    public JsonSchemaObject getNot() {
        return this.myNot;
    }

    public void setNot(@Nullable JsonSchemaObject not) {
        this.myNot = not;
    }

    @Nullable
    public List<IfThenElse> getIfThenElse() {
        return this.myIfThenElse;
    }

    public void setIf(@Nullable JsonSchemaObject anIf) {
        this.myIf = anIf;
    }

    public void setThen(@Nullable JsonSchemaObject then) {
        this.myThen = then;
    }

    public void setElse(@Nullable JsonSchemaObject anElse) {
        this.myElse = anElse;
    }

    @Nullable
    public Set<JsonSchemaType> getTypeVariants() {
        return this.myTypeVariants;
    }

    public void setTypeVariants(@Nullable Set<JsonSchemaType> typeVariants) {
        this.myTypeVariants = typeVariants;
    }

    @Nullable
    public String getRef() {
        return this.myRef;
    }

    public void setRef(@Nullable String ref) {
        this.myRef = ref;
    }

    @Nullable
    public Object getDefault() {
        if (JsonSchemaType._integer.equals((Object)this.myType)) {
            return this.myDefault instanceof Number ? Integer.valueOf(((Number)this.myDefault).intValue()) : this.myDefault;
        }
        return this.myDefault;
    }

    public void setDefault(@Nullable Object aDefault) {
        this.myDefault = aDefault;
    }

    @Nullable
    public String getFormat() {
        return this.myFormat;
    }

    public void setFormat(@Nullable String format) {
        this.myFormat = format;
    }

    @Nullable
    public String getId() {
        return this.myId;
    }

    public void setId(@Nullable String id) {
        this.myId = id;
    }

    @Nullable
    public String getSchema() {
        return this.mySchema;
    }

    public void setSchema(@Nullable String schema) {
        this.mySchema = schema;
    }

    @Nullable
    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(@NotNull String description) {
        if (description == null) {
            JsonSchemaObject.$$$reportNull$$$0(14);
        }
        this.myDescription = JsonSchemaObject.unescapeJsonString(description);
    }

    @Nullable
    public String getHtmlDescription() {
        return this.myHtmlDescription;
    }

    public void setHtmlDescription(@NotNull String htmlDescription) {
        if (htmlDescription == null) {
            JsonSchemaObject.$$$reportNull$$$0(15);
        }
        this.myHtmlDescription = JsonSchemaObject.unescapeJsonString(htmlDescription);
    }

    @Nullable
    public String getTitle() {
        return this.myTitle;
    }

    public void setTitle(@NotNull String title) {
        if (title == null) {
            JsonSchemaObject.$$$reportNull$$$0(16);
        }
        this.myTitle = JsonSchemaObject.unescapeJsonString(title);
    }

    private static String unescapeJsonString(@NotNull String text) {
        if (text == null) {
            JsonSchemaObject.$$$reportNull$$$0(17);
        }
        try {
            String object = String.format("{\"prop\": \"%s\"}", text);
            return ((JsonObject)new Gson().fromJson(object, JsonObject.class)).get("prop").getAsString();
        }
        catch (JsonParseException e) {
            return text;
        }
    }

    @Nullable
    public JsonSchemaObject getMatchingPatternPropertySchema(@NotNull String name) {
        if (name == null) {
            JsonSchemaObject.$$$reportNull$$$0(18);
        }
        if (this.myPatternProperties == null) {
            return null;
        }
        return this.myPatternProperties.getPatternPropertySchema(name);
    }

    public boolean checkByPattern(@NotNull String value) {
        if (value == null) {
            JsonSchemaObject.$$$reportNull$$$0(19);
        }
        return this.myPattern != null && this.myPattern.checkByPattern(value);
    }

    @Nullable
    public String getPatternError() {
        return this.myPattern == null ? null : this.myPattern.getPatternError();
    }

    @Nullable
    public JsonSchemaObject findRelativeDefinition(@NotNull String ref) {
        if (ref == null) {
            JsonSchemaObject.$$$reportNull$$$0(20);
        }
        if (JsonPointerUtil.isSelfReference(ref)) {
            return this;
        }
        if (!ref.startsWith("#/")) {
            return null;
        }
        ref = ref.substring(2);
        List<String> parts = JsonPointerUtil.split(ref);
        JsonSchemaObject current = this;
        for (int i = 0; i < parts.size(); ++i) {
            if (current == null) {
                return null;
            }
            String part = parts.get(i);
            if (DEFINITIONS.equals(part)) {
                if (i == parts.size() - 1) {
                    return null;
                }
                String nextPart = parts.get(++i);
                current = current.getDefinitionsMap() == null ? null : current.getDefinitionsMap().get(JsonPointerUtil.unescapeJsonPointerPart(nextPart));
                continue;
            }
            if (PROPERTIES.equals(part)) {
                if (i == parts.size() - 1) {
                    return null;
                }
                current = current.getProperties().get(JsonPointerUtil.unescapeJsonPointerPart(parts.get(++i)));
                continue;
            }
            if (ITEMS.equals(part)) {
                if (i == parts.size() - 1) {
                    current = current.getItemsSchema();
                    continue;
                }
                Integer next = JsonSchemaObject.tryParseInt(parts.get(++i));
                List<JsonSchemaObject> itemsSchemaList = current.getItemsSchemaList();
                if (itemsSchemaList == null || next == null || next >= itemsSchemaList.size()) continue;
                current = itemsSchemaList.get(next);
                continue;
            }
            if (ADDITIONAL_ITEMS.equals(part)) {
                if (i != parts.size() - 1) continue;
                current = current.getAdditionalItemsSchema();
                continue;
            }
            current = current.getDefinitionsMap() == null ? null : current.getDefinitionsMap().get(part);
        }
        return current;
    }

    @Nullable
    private static Integer tryParseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (Exception __) {
            return null;
        }
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonSchemaObject object = (JsonSchemaObject)o;
        return Objects.equals(this.myFileUrl, object.myFileUrl) && Objects.equals(this.myPointer, object.myPointer);
    }

    public int hashCode() {
        return Objects.hash(this.myFileUrl, this.myPointer);
    }

    @NotNull
    private static String adaptSchemaPattern(String pattern) {
        pattern = pattern.startsWith("^") || pattern.startsWith("*") || pattern.startsWith(".") ? pattern : ".*" + pattern;
        pattern = pattern.endsWith("+") || pattern.endsWith("*") || pattern.endsWith("$") ? pattern : pattern + ".*";
        String string = pattern = pattern.replace("\\\\", "\\");
        if (string == null) {
            JsonSchemaObject.$$$reportNull$$$0(21);
        }
        return string;
    }

    private static Pair<Pattern, String> compilePattern(@NotNull String pattern) {
        if (pattern == null) {
            JsonSchemaObject.$$$reportNull$$$0(22);
        }
        try {
            return Pair.create((Object)Pattern.compile(JsonSchemaObject.adaptSchemaPattern(pattern)), null);
        }
        catch (PatternSyntaxException e) {
            return Pair.create(null, (Object)e.getMessage());
        }
    }

    public static boolean matchPattern(@NotNull Pattern pattern, @NotNull String s) {
        if (pattern == null) {
            JsonSchemaObject.$$$reportNull$$$0(23);
        }
        if (s == null) {
            JsonSchemaObject.$$$reportNull$$$0(24);
        }
        try {
            return pattern.matcher(StringUtil.newBombedCharSequence((CharSequence)s, (long)300L)).matches();
        }
        catch (ProcessCanceledException e) {
            Logger.getInstance(JsonSchemaObject.class).info("Pattern matching canceled");
            return false;
        }
        catch (Exception e) {
            Logger.getInstance(JsonSchemaObject.class).info((Throwable)e);
            return false;
        }
    }

    @Nullable
    public String getTypeDescription(boolean shortDesc) {
        JsonSchemaType type = this.getType();
        if (type != null) {
            return type.getDescription();
        }
        Set<JsonSchemaType> possibleTypes = this.getTypeVariants();
        String description = JsonSchemaObject.getTypesDescription(shortDesc, possibleTypes);
        if (description != null) {
            return description;
        }
        List<Object> anEnum = this.getEnum();
        if (anEnum != null) {
            return shortDesc ? "enum" : anEnum.stream().map(o -> o.toString()).collect(Collectors.joining(" | "));
        }
        JsonSchemaType guessedType = this.guessType();
        if (guessedType != null) {
            return guessedType.getDescription();
        }
        return null;
    }

    @Nullable
    public JsonSchemaType guessType() {
        JsonSchemaType type = this.getType();
        if (type != null) {
            return type;
        }
        Set<JsonSchemaType> typeVariants = this.getTypeVariants();
        if (typeVariants != null) {
            int size = typeVariants.size();
            if (size == 1) {
                return typeVariants.iterator().next();
            }
            if (size >= 2) {
                return null;
            }
        }
        boolean hasObjectChecks = this.hasObjectChecks();
        boolean hasNumericChecks = this.hasNumericChecks();
        boolean hasStringChecks = this.hasStringChecks();
        boolean hasArrayChecks = this.hasArrayChecks();
        if (hasObjectChecks && !hasNumericChecks && !hasStringChecks && !hasArrayChecks) {
            return JsonSchemaType._object;
        }
        if (!hasObjectChecks && hasNumericChecks && !hasStringChecks && !hasArrayChecks) {
            return JsonSchemaType._number;
        }
        if (!hasObjectChecks && !hasNumericChecks && hasStringChecks && !hasArrayChecks) {
            return JsonSchemaType._string;
        }
        if (!hasObjectChecks && !hasNumericChecks && !hasStringChecks && hasArrayChecks) {
            return JsonSchemaType._array;
        }
        return null;
    }

    public boolean hasNumericChecks() {
        return this.getMultipleOf() != null || this.getExclusiveMinimumNumber() != null || this.getExclusiveMaximumNumber() != null || this.getMaximum() != null || this.getMinimum() != null;
    }

    public boolean hasStringChecks() {
        return this.getPattern() != null || this.getFormat() != null;
    }

    public boolean hasArrayChecks() {
        return this.isUniqueItems() || this.getContainsSchema() != null || this.getItemsSchema() != null || this.getItemsSchemaList() != null || this.getMinItems() != null || this.getMaxItems() != null;
    }

    public boolean hasObjectChecks() {
        return !this.getProperties().isEmpty() || this.getPropertyNamesSchema() != null || this.getPropertyDependencies() != null || this.hasPatternProperties() || this.getRequired() != null || this.getMinProperties() != null || this.getMaxProperties() != null;
    }

    @Nullable
    static String getTypesDescription(boolean shortDesc, @Nullable Collection<JsonSchemaType> possibleTypes) {
        if (possibleTypes == null || possibleTypes.size() == 0) {
            return null;
        }
        if (possibleTypes.size() == 1) {
            return possibleTypes.iterator().next().getDescription();
        }
        if (possibleTypes.contains((Object)JsonSchemaType._any)) {
            return JsonSchemaType._any.getDescription();
        }
        Stream<String> typeDescriptions = possibleTypes.stream().map(t -> t.getDescription()).distinct().sorted();
        boolean isShort = false;
        if (shortDesc) {
            typeDescriptions = typeDescriptions.limit(3L);
            if (possibleTypes.size() > 3) {
                isShort = true;
            }
        }
        return typeDescriptions.collect(Collectors.joining(" | ", "", isShort ? "| ..." : ""));
    }

    @Nullable
    public JsonSchemaObject resolveRefSchema(@NotNull JsonSchemaService service2) {
        JsonSchemaObject object;
        if (service2 == null) {
            JsonSchemaObject.$$$reportNull$$$0(25);
        }
        String ref = this.getRef();
        assert (!StringUtil.isEmptyOrSpaces((String)ref));
        if (!this.myComputedRefs.containsKey(ref)) {
            VirtualFile virtualFile;
            JsonSchemaObject value = JsonSchemaObject.fetchSchemaFromRefDefinition(ref, this, service2);
            if (!this.mySubscribed.get()) {
                service2.getProject().getMessageBus().connect().subscribe(JsonSchemaVfsListener.JSON_DEPS_CHANGED, () -> this.myComputedRefs.clear());
                this.mySubscribed.set(true);
            }
            if (!JsonFileResolver.isHttpPath(ref)) {
                service2.registerReference(ref);
            } else if (value != null && (virtualFile = service2.resolveSchemaFile(value)) != null && !(virtualFile instanceof HttpVirtualFile)) {
                service2.registerReference(virtualFile.getName());
            }
            this.myComputedRefs.put(ref, value == null ? NULL_OBJ : value);
        }
        return (object = (JsonSchemaObject)this.myComputedRefs.getOrDefault(ref, null)) == NULL_OBJ ? null : object;
    }

    @Nullable
    private static JsonSchemaObject fetchSchemaFromRefDefinition(@NotNull String ref, @NotNull JsonSchemaObject schema, @NotNull JsonSchemaService service2) {
        VirtualFile schemaFile;
        if (ref == null) {
            JsonSchemaObject.$$$reportNull$$$0(26);
        }
        if (schema == null) {
            JsonSchemaObject.$$$reportNull$$$0(27);
        }
        if (service2 == null) {
            JsonSchemaObject.$$$reportNull$$$0(28);
        }
        if ((schemaFile = service2.resolveSchemaFile(schema)) == null) {
            return null;
        }
        JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter splitter = new JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter(ref);
        String schemaId = splitter.getSchemaId();
        if (schemaId != null) {
            JsonSchemaObject refSchema = JsonSchemaObject.resolveSchemaByReference(service2, schemaFile, schemaId);
            if (refSchema == null) {
                return null;
            }
            return JsonSchemaObject.findRelativeDefinition(refSchema, splitter, service2);
        }
        JsonSchemaObject rootSchema = service2.getSchemaObjectForSchemaFile(schemaFile);
        if (rootSchema == null) {
            LOG.debug(String.format("Schema object not found for %s", schemaFile.getPath()));
            return null;
        }
        return JsonSchemaObject.findRelativeDefinition(rootSchema, splitter, service2);
    }

    @Nullable
    private static JsonSchemaObject resolveSchemaByReference(@NotNull JsonSchemaService service2, @NotNull VirtualFile schemaFile, @NotNull String schemaId) {
        VirtualFile refFile;
        if (service2 == null) {
            JsonSchemaObject.$$$reportNull$$$0(29);
        }
        if (schemaFile == null) {
            JsonSchemaObject.$$$reportNull$$$0(30);
        }
        if (schemaId == null) {
            JsonSchemaObject.$$$reportNull$$$0(31);
        }
        if ((refFile = service2.findSchemaFileByReference(schemaId, schemaFile)) == null) {
            LOG.debug(String.format("Schema file not found by reference: '%s' from %s", schemaId, schemaFile.getPath()));
            return null;
        }
        JsonSchemaObject refSchema = service2.getSchemaObjectForSchemaFile(refFile);
        if (refSchema == null) {
            LOG.debug(String.format("Schema object not found by reference: '%s' from %s", schemaId, schemaFile.getPath()));
            return null;
        }
        return refSchema;
    }

    private static JsonSchemaObject findRelativeDefinition(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter splitter, @NotNull JsonSchemaService service2) {
        String path;
        if (schema == null) {
            JsonSchemaObject.$$$reportNull$$$0(32);
        }
        if (splitter == null) {
            JsonSchemaObject.$$$reportNull$$$0(33);
        }
        if (service2 == null) {
            JsonSchemaObject.$$$reportNull$$$0(34);
        }
        if (StringUtil.isEmptyOrSpaces((String)(path = splitter.getRelativePath()))) {
            String id = splitter.getSchemaId();
            if (JsonPointerUtil.isSelfReference(id)) {
                return schema;
            }
            if (id != null && id.startsWith("#")) {
                String resolvedId = schema.resolveId(id);
                if (resolvedId == null || id.equals("#" + resolvedId)) {
                    return null;
                }
                return JsonSchemaObject.findRelativeDefinition(schema, new JsonSchemaVariantsTreeBuilder.SchemaUrlSplitter("#" + resolvedId), service2);
            }
            return schema;
        }
        JsonSchemaObject definition = schema.findRelativeDefinition(path);
        if (definition == null) {
            VirtualFile schemaFile = service2.resolveSchemaFile(schema);
            LOG.debug(String.format("Definition not found by reference: '%s' in file %s", path, schemaFile == null ? "(no file)" : schemaFile.getPath()));
        }
        return definition;
    }

    @NotNull
    public static JsonSchemaObject merge(@NotNull JsonSchemaObject base, @NotNull JsonSchemaObject other, @NotNull JsonSchemaObject pointTo) {
        if (base == null) {
            JsonSchemaObject.$$$reportNull$$$0(35);
        }
        if (other == null) {
            JsonSchemaObject.$$$reportNull$$$0(36);
        }
        if (pointTo == null) {
            JsonSchemaObject.$$$reportNull$$$0(37);
        }
        JsonSchemaObject object = new JsonSchemaObject(pointTo.myRawFile, pointTo.myFileUrl, pointTo.getPointer());
        object.mergeValues(other);
        object.mergeValues(base);
        object.setRef(other.getRef());
        JsonSchemaObject jsonSchemaObject = object;
        if (jsonSchemaObject == null) {
            JsonSchemaObject.$$$reportNull$$$0(38);
        }
        return jsonSchemaObject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 11: 
            case 21: 
            case 38: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 11: 
            case 21: 
            case 38: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 4: 
            case 11: 
            case 21: 
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selfType";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherType";
                break;
            }
            case 7: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "other";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thisObject";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherObject";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "definitionsMap";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = PROPERTIES;
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternProperties";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "htmlDescription";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 20: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 22: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 25: 
            case 28: 
            case 29: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 27: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaFile";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaId";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "splitter";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointTo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getPointer";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getProperties";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "adaptSchemaPattern";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "merge";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resolveId";
                break;
            }
            case 4: 
            case 11: 
            case 21: 
            case 38: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSubtypeOfBoth";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "mergeValues";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mergeProperties";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setDefinitionsMap";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setProperties";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setPatternProperties";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "setDescription";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setHtmlDescription";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "setTitle";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "unescapeJsonString";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingPatternPropertySchema";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkByPattern";
                break;
            }
            case 20: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "findRelativeDefinition";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "compilePattern";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "matchPattern";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveRefSchema";
                break;
            }
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "fetchSchemaFromRefDefinition";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "resolveSchemaByReference";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "merge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 11: 
            case 21: 
            case 38: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class PatternProperties {
        @NotNull
        private final Map<String, JsonSchemaObject> mySchemasMap;
        @NotNull
        private final Map<String, Pattern> myCachedPatterns;
        @NotNull
        private final Map<String, String> myCachedPatternProperties;

        PatternProperties(@NotNull Map<String, JsonSchemaObject> schemasMap) {
            if (schemasMap == null) {
                PatternProperties.$$$reportNull$$$0(0);
            }
            this.mySchemasMap = new HashMap<String, JsonSchemaObject>();
            schemasMap.keySet().forEach(key -> this.mySchemasMap.put(StringUtil.unescapeBackSlashes((String)key), (JsonSchemaObject)schemasMap.get(key)));
            this.myCachedPatterns = new HashMap<String, Pattern>();
            this.myCachedPatternProperties = ContainerUtil.createConcurrentWeakKeyWeakValueMap();
            this.mySchemasMap.keySet().forEach(key -> {
                Pair pair = JsonSchemaObject.compilePattern(key);
                if (pair.getSecond() == null) {
                    assert (pair.getFirst() != null);
                    this.myCachedPatterns.put((String)key, (Pattern)pair.getFirst());
                }
            });
        }

        @Nullable
        public JsonSchemaObject getPatternPropertySchema(@NotNull String name) {
            String value;
            if (name == null) {
                PatternProperties.$$$reportNull$$$0(1);
            }
            if ((value = this.myCachedPatternProperties.get(name)) != null) {
                assert (this.mySchemasMap.containsKey(value));
                return this.mySchemasMap.get(value);
            }
            value = this.myCachedPatterns.keySet().stream().filter(key -> JsonSchemaObject.matchPattern(this.myCachedPatterns.get(key), name)).findFirst().orElse(null);
            if (value != null) {
                this.myCachedPatternProperties.put(name, value);
                assert (this.mySchemasMap.containsKey(value));
                return this.mySchemasMap.get(value);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "schemasMap";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PatternProperties";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getPatternPropertySchema";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class PropertyNamePattern {
        @NotNull
        private final String myPattern;
        @Nullable
        private final Pattern myCompiledPattern;
        @Nullable
        private final String myPatternError;
        @NotNull
        private final Map<String, Boolean> myValuePatternCache;

        PropertyNamePattern(@NotNull String pattern) {
            if (pattern == null) {
                PropertyNamePattern.$$$reportNull$$$0(0);
            }
            this.myPattern = StringUtil.unescapeBackSlashes((String)pattern);
            Pair pair = JsonSchemaObject.compilePattern(pattern);
            this.myPatternError = (String)pair.getSecond();
            this.myCompiledPattern = (Pattern)pair.getFirst();
            this.myValuePatternCache = ContainerUtil.createConcurrentWeakKeyWeakValueMap();
        }

        @Nullable
        public String getPatternError() {
            return this.myPatternError;
        }

        boolean checkByPattern(@NotNull String name) {
            if (name == null) {
                PropertyNamePattern.$$$reportNull$$$0(1);
            }
            if (this.myPatternError != null) {
                return true;
            }
            if (Boolean.TRUE.equals(this.myValuePatternCache.get(name))) {
                return true;
            }
            assert (this.myCompiledPattern != null);
            boolean matches = JsonSchemaObject.matchPattern(this.myCompiledPattern, name);
            this.myValuePatternCache.put(name, matches);
            return matches;
        }

        @NotNull
        public String getPattern() {
            String string = this.myPattern;
            if (string == null) {
                PropertyNamePattern.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PropertyNamePattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaObject$PropertyNamePattern";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPattern";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "checkByPattern";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

