/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.impl;

import com.intellij.json.JsonBundle;
import com.intellij.json.pointer.JsonPointerPosition;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.adapters.JsonArrayValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonObjectValueAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonPropertyAdapter;
import com.jetbrains.jsonSchema.extension.adapters.JsonValueAdapter;
import com.jetbrains.jsonSchema.impl.EnumArrayValueWrapper;
import com.jetbrains.jsonSchema.impl.EnumObjectValueWrapper;
import com.jetbrains.jsonSchema.impl.IfThenElse;
import com.jetbrains.jsonSchema.impl.JsonComplianceCheckerOptions;
import com.jetbrains.jsonSchema.impl.JsonErrorPriority;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaResolver;
import com.jetbrains.jsonSchema.impl.JsonSchemaType;
import com.jetbrains.jsonSchema.impl.JsonSchemaVariantsTreeBuilder;
import com.jetbrains.jsonSchema.impl.JsonValidationError;
import com.jetbrains.jsonSchema.impl.MatchResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JsonSchemaAnnotatorChecker {
    private static final Set<JsonSchemaType> PRIMITIVE_TYPES = ContainerUtil.set((Object[])new JsonSchemaType[]{JsonSchemaType._integer, JsonSchemaType._number, JsonSchemaType._boolean, JsonSchemaType._string, JsonSchemaType._null});
    private final Map<PsiElement, JsonValidationError> myErrors;
    @NotNull
    private final Project myProject;
    @NotNull
    private final JsonComplianceCheckerOptions myOptions;
    private boolean myHadTypeError;
    private static final String ENUM_MISMATCH_PREFIX = "Value should be one of: ";
    private static final String ACTUAL_PREFIX = "Actual: ";
    private static final JsonSchemaType[] NO_TYPES = new JsonSchemaType[0];

    protected JsonSchemaAnnotatorChecker(@NotNull Project project, @NotNull JsonComplianceCheckerOptions options) {
        if (project == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(0);
        }
        if (options == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myOptions = options;
        this.myErrors = new HashMap<PsiElement, JsonValidationError>();
    }

    public Map<PsiElement, JsonValidationError> getErrors() {
        return this.myErrors;
    }

    public boolean isHadTypeError() {
        return this.myHadTypeError;
    }

    public static JsonSchemaAnnotatorChecker checkByMatchResult(@NotNull Project project, @NotNull JsonValueAdapter elementToCheck, @NotNull MatchResult result2, @NotNull JsonComplianceCheckerOptions options) {
        if (project == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(2);
        }
        if (elementToCheck == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(3);
        }
        if (result2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(4);
        }
        if (options == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(5);
        }
        ArrayList<Object> checkers = new ArrayList<Object>();
        if (result2.myExcludingSchemas.isEmpty() && result2.mySchemas.size() == 1) {
            JsonSchemaAnnotatorChecker checker2 = new JsonSchemaAnnotatorChecker(project, options);
            checker2.checkByScheme(elementToCheck, result2.mySchemas.iterator().next());
            checkers.add(checker2);
        } else {
            if (!result2.mySchemas.isEmpty()) {
                checkers.add(JsonSchemaAnnotatorChecker.processSchemasVariants(project, result2.mySchemas, elementToCheck, false, options).getSecond());
            }
            if (!result2.myExcludingSchemas.isEmpty()) {
                List list2 = ContainerUtil.map(result2.myExcludingSchemas, group -> (JsonSchemaAnnotatorChecker)JsonSchemaAnnotatorChecker.processSchemasVariants(project, group, elementToCheck, true, options).getSecond());
                checkers.add(JsonSchemaAnnotatorChecker.mergeErrors(project, list2, options, result2.myExcludingSchemas));
            }
        }
        if (checkers.isEmpty()) {
            return null;
        }
        if (checkers.size() == 1) {
            return (JsonSchemaAnnotatorChecker)checkers.get(0);
        }
        return checkers.stream().filter(checker -> !checker.isHadTypeError()).findFirst().orElse((JsonSchemaAnnotatorChecker)checkers.get(0));
    }

    private static JsonSchemaAnnotatorChecker mergeErrors(@NotNull Project project, @NotNull List<JsonSchemaAnnotatorChecker> list2, @NotNull JsonComplianceCheckerOptions options, @NotNull List<Collection<? extends JsonSchemaObject>> excludingSchemas) {
        if (project == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(6);
        }
        if (list2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(7);
        }
        if (options == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(8);
        }
        if (excludingSchemas == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(9);
        }
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(project, options);
        for (JsonSchemaAnnotatorChecker ch : list2) {
            for (Map.Entry<PsiElement, JsonValidationError> element : ch.myErrors.entrySet()) {
                JsonValidationError error = element.getValue();
                if (error.getFixableIssueKind() == JsonValidationError.FixableIssueKind.ProhibitedProperty) {
                    String propertyName = ((JsonValidationError.ProhibitedPropertyIssueData)error.getIssueData()).propertyName;
                    boolean skip = false;
                    for (Collection<? extends JsonSchemaObject> objects : excludingSchemas) {
                        Set keys = objects.stream().filter(o -> !o.hasOwnExtraPropertyProhibition()).map(o -> o.getProperties().keySet()).flatMap(Collection::stream).collect(Collectors.toSet());
                        if (!keys.contains(propertyName)) continue;
                        skip = true;
                    }
                    if (skip) continue;
                }
                checker.myErrors.put(element.getKey(), error);
            }
        }
        return checker;
    }

    private void error(String error, PsiElement holder, JsonErrorPriority priority) {
        this.error(error, holder, JsonValidationError.FixableIssueKind.None, null, priority);
    }

    private void error(PsiElement newHolder, JsonValidationError error) {
        this.error(error.getMessage(), newHolder, error.getFixableIssueKind(), error.getIssueData(), error.getPriority());
    }

    private void error(String error, PsiElement holder, JsonValidationError.FixableIssueKind fixableIssueKind, JsonValidationError.IssueData data, JsonErrorPriority priority) {
        if (this.myErrors.containsKey(holder)) {
            return;
        }
        this.myErrors.put(holder, new JsonValidationError(error, fixableIssueKind, data, priority));
    }

    private void typeError(@NotNull PsiElement value, @Nullable JsonSchemaType currentType, JsonSchemaType ... allowedTypes) {
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(10);
        }
        if (allowedTypes == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(11);
        }
        if (allowedTypes.length == 0) {
            return;
        }
        String currentTypeDesc = currentType == null ? "" : " Actual: " + currentType.getName() + ".";
        String prefix = "Incompatible types.\n";
        if (allowedTypes.length == 1) {
            this.error(String.format(prefix + " Required: %s.%s", allowedTypes[0].getName(), currentTypeDesc), value, JsonValidationError.FixableIssueKind.ProhibitedType, new JsonValidationError.TypeMismatchIssueData(allowedTypes), JsonErrorPriority.TYPE_MISMATCH);
        } else {
            String typesText = Arrays.stream(allowedTypes).map(JsonSchemaType::getName).distinct().sorted(Comparator.naturalOrder()).collect(Collectors.joining(", "));
            this.error(String.format(prefix + " Required one of: %s.%s", typesText, currentTypeDesc), value, JsonValidationError.FixableIssueKind.ProhibitedType, new JsonValidationError.TypeMismatchIssueData(allowedTypes), JsonErrorPriority.TYPE_MISMATCH);
        }
        this.myHadTypeError = true;
    }

    public void checkByScheme(@NotNull JsonValueAdapter value, @NotNull JsonSchemaObject schema) {
        List<IfThenElse> ifThenElseList;
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(12);
        }
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(13);
        }
        JsonSchemaType type = JsonSchemaType.getType(value);
        this.checkForEnum(value.getDelegate(), schema);
        boolean checkedNumber = false;
        boolean checkedString = false;
        boolean checkedArray = false;
        boolean checkedObject = false;
        if (type != null) {
            JsonSchemaType schemaType = JsonSchemaAnnotatorChecker.getMatchingSchemaType(schema, type);
            if (schemaType != null && !schemaType.equals((Object)type)) {
                this.typeError(value.getDelegate(), type, schemaType);
            } else if (JsonSchemaType._string_number.equals((Object)type)) {
                this.checkNumber(value.getDelegate(), schema, type);
                checkedNumber = true;
                this.checkString(value.getDelegate(), schema);
                checkedString = true;
            } else if (JsonSchemaType._number.equals((Object)type) || JsonSchemaType._integer.equals((Object)type)) {
                this.checkNumber(value.getDelegate(), schema, type);
                checkedNumber = true;
            } else if (JsonSchemaType._string.equals((Object)type)) {
                this.checkString(value.getDelegate(), schema);
                checkedString = true;
            } else if (JsonSchemaType._array.equals((Object)type)) {
                this.checkArray(value, schema);
                checkedArray = true;
            } else if (JsonSchemaType._object.equals((Object)type)) {
                this.checkObject(value, schema);
                checkedObject = true;
            }
        }
        if (!(this.myHadTypeError && !this.myErrors.isEmpty() || value.isShouldBeIgnored())) {
            PsiElement delegate = value.getDelegate();
            if (!checkedNumber && schema.hasNumericChecks() && value.isNumberLiteral()) {
                this.checkNumber(delegate, schema, JsonSchemaType._number);
            }
            if (!checkedString && schema.hasStringChecks() && value.isStringLiteral()) {
                this.checkString(delegate, schema);
                checkedString = true;
            }
            if (!checkedArray && schema.hasArrayChecks() && value.isArray()) {
                this.checkArray(value, schema);
                checkedArray = true;
            }
            if (JsonSchemaAnnotatorChecker.hasMinMaxLengthChecks(schema)) {
                if (value.isStringLiteral()) {
                    if (!checkedString) {
                        this.checkString(delegate, schema);
                    }
                } else if (value.isArray() && !checkedArray) {
                    this.checkArray(value, schema);
                }
            }
            if (!checkedObject && schema.hasObjectChecks() && value.isObject()) {
                this.checkObject(value, schema);
            }
        }
        if (schema.getNot() != null) {
            MatchResult result2 = new JsonSchemaResolver(this.myProject, schema.getNot()).detailedResolve();
            if (result2.mySchemas.isEmpty() && result2.myExcludingSchemas.isEmpty()) {
                return;
            }
            if (result2.mySchemas.stream().anyMatch(s -> schema.equals(s)) || result2.myExcludingSchemas.stream().flatMap(Collection::stream).anyMatch(s -> schema.equals(s))) {
                return;
            }
            JsonSchemaAnnotatorChecker checker = JsonSchemaAnnotatorChecker.checkByMatchResult(this.myProject, value, result2, this.myOptions);
            if (checker == null || checker.isCorrect()) {
                this.error("Validates against 'not' schema", value.getDelegate(), JsonErrorPriority.NOT_SCHEMA);
            }
        }
        if ((ifThenElseList = schema.getIfThenElse()) != null) {
            for (IfThenElse ifThenElse : ifThenElseList) {
                MatchResult result3 = new JsonSchemaResolver(this.myProject, ifThenElse.getIf()).detailedResolve();
                if (result3.mySchemas.isEmpty() && result3.myExcludingSchemas.isEmpty()) {
                    return;
                }
                JsonSchemaAnnotatorChecker checker = JsonSchemaAnnotatorChecker.checkByMatchResult(this.myProject, value, result3, this.myOptions);
                if (checker == null) continue;
                if (checker.isCorrect()) {
                    JsonSchemaObject then = ifThenElse.getThen();
                    if (then == null) continue;
                    this.checkObjectBySchemaRecordErrors(then, value);
                    continue;
                }
                JsonSchemaObject schemaElse = ifThenElse.getElse();
                if (schemaElse == null) continue;
                this.checkObjectBySchemaRecordErrors(schemaElse, value);
            }
        }
    }

    private void checkObjectBySchemaRecordErrors(@NotNull JsonSchemaObject schema, @NotNull JsonValueAdapter object) {
        JsonSchemaAnnotatorChecker checker;
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(14);
        }
        if (object == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(15);
        }
        if ((checker = JsonSchemaAnnotatorChecker.checkByMatchResult(this.myProject, object, new JsonSchemaResolver(this.myProject, schema).detailedResolve(), this.myOptions)) != null) {
            this.myHadTypeError = checker.isHadTypeError();
            this.myErrors.putAll(checker.getErrors());
        }
    }

    private void checkObject(@NotNull JsonValueAdapter value, @NotNull JsonSchemaObject schema) {
        JsonObjectValueAdapter object;
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(16);
        }
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(17);
        }
        if ((object = value.getAsObject()) == null) {
            return;
        }
        List<JsonPropertyAdapter> propertyList = object.getPropertyList();
        HashSet<String> set2 = new HashSet<String>();
        for (JsonPropertyAdapter property : propertyList) {
            JsonPointerPosition step;
            Pair<ThreeState, JsonSchemaObject> pair;
            JsonValueAdapter nameValueAdapter;
            String name = StringUtil.notNullize((String)property.getName());
            JsonSchemaObject jsonSchemaObject = schema.getPropertyNamesSchema();
            if (jsonSchemaObject != null && (nameValueAdapter = property.getNameValueAdapter()) != null) {
                this.checkByScheme(nameValueAdapter, jsonSchemaObject);
            }
            if (ThreeState.NO.equals((pair = JsonSchemaVariantsTreeBuilder.doSingleStep(step = JsonPointerPosition.createSingleProperty(name), schema, true, false)).getFirst()) && !set2.contains(name)) {
                this.error(JsonBundle.message("json.schema.annotation.not.allowed.property", name), property.getDelegate(), JsonValidationError.FixableIssueKind.ProhibitedProperty, new JsonValidationError.ProhibitedPropertyIssueData(name), JsonErrorPriority.LOW_PRIORITY);
            } else if (ThreeState.UNSURE.equals(pair.getFirst())) {
                for (JsonValueAdapter propertyValue : property.getValues()) {
                    this.checkObjectBySchemaRecordErrors((JsonSchemaObject)pair.getSecond(), propertyValue);
                }
            }
            set2.add(name);
        }
        if (object.shouldCheckIntegralRequirements()) {
            Map<String, JsonSchemaObject> schemaDependencies;
            Map<String, List<String>> dependencies;
            Set<String> required = schema.getRequired();
            if (required != null) {
                LinkedHashSet requiredNames = ContainerUtil.newLinkedHashSet(required);
                requiredNames.removeAll(set2);
                if (!requiredNames.isEmpty()) {
                    JsonValidationError.MissingMultiplePropsIssueData data = this.createMissingPropertiesData(schema, requiredNames);
                    this.error("Missing required " + data.getMessage(false), value.getDelegate(), JsonValidationError.FixableIssueKind.MissingProperty, data, JsonErrorPriority.MISSING_PROPS);
                }
            }
            if (schema.getMinProperties() != null && propertyList.size() < schema.getMinProperties()) {
                this.error("Number of properties is less than " + schema.getMinProperties(), value.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
            }
            if (schema.getMaxProperties() != null && propertyList.size() > schema.getMaxProperties()) {
                this.error("Number of properties is greater than " + schema.getMaxProperties(), value.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
            }
            if ((dependencies = schema.getPropertyDependencies()) != null) {
                for (Map.Entry entry : dependencies.entrySet()) {
                    if (!set2.contains(entry.getKey())) continue;
                    List list2 = (List)entry.getValue();
                    HashSet deps = ContainerUtil.newHashSet((Iterable)list2);
                    deps.removeAll(set2);
                    if (deps.isEmpty()) continue;
                    JsonValidationError.MissingMultiplePropsIssueData data = this.createMissingPropertiesData(schema, deps);
                    this.error("Dependency is violated: " + data.getMessage(false) + " must be specified, since '" + (String)entry.getKey() + "' is specified", value.getDelegate(), JsonValidationError.FixableIssueKind.MissingProperty, data, JsonErrorPriority.MISSING_PROPS);
                }
            }
            if ((schemaDependencies = schema.getSchemaDependencies()) != null) {
                for (Map.Entry<String, JsonSchemaObject> entry : schemaDependencies.entrySet()) {
                    if (!set2.contains(entry.getKey())) continue;
                    this.checkObjectBySchemaRecordErrors(entry.getValue(), value);
                }
            }
        }
    }

    @Nullable
    private static Object getDefaultValueFromEnum(@NotNull JsonSchemaObject propertySchema, @NotNull Ref<Integer> enumCount) {
        List<Object> enumValues;
        if (propertySchema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(18);
        }
        if (enumCount == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(19);
        }
        if ((enumValues = propertySchema.getEnum()) != null) {
            enumCount.set((Object)enumValues.size());
            if (enumValues.size() == 1) {
                Object defaultObject = enumValues.get(0);
                return defaultObject instanceof String ? StringUtil.unquoteString((String)((String)defaultObject)) : defaultObject;
            }
        }
        return null;
    }

    @NotNull
    private JsonValidationError.MissingMultiplePropsIssueData createMissingPropertiesData(@NotNull JsonSchemaObject schema, HashSet<String> requiredNames) {
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(20);
        }
        ArrayList allProps = ContainerUtil.newArrayList();
        for (String req : requiredNames) {
            JsonSchemaObject propertySchema = JsonSchemaAnnotatorChecker.resolvePropertySchema(schema, req);
            Object defaultValue = propertySchema == null ? null : propertySchema.getDefault();
            Ref enumCount = Ref.create((Object)0);
            JsonSchemaType type = null;
            if (propertySchema != null) {
                MatchResult result2 = null;
                Object valueFromEnum = JsonSchemaAnnotatorChecker.getDefaultValueFromEnum(propertySchema, (Ref<Integer>)enumCount);
                if (valueFromEnum != null) {
                    defaultValue = valueFromEnum;
                } else {
                    result2 = new JsonSchemaResolver(this.myProject, propertySchema).detailedResolve();
                    if (result2.mySchemas.size() == 1 && (valueFromEnum = JsonSchemaAnnotatorChecker.getDefaultValueFromEnum(result2.mySchemas.get(0), (Ref<Integer>)enumCount)) != null) {
                        defaultValue = valueFromEnum;
                    }
                }
                type = propertySchema.getType();
                if (type == null) {
                    if (result2 == null) {
                        result2 = new JsonSchemaResolver(this.myProject, propertySchema).detailedResolve();
                    }
                    if (result2.mySchemas.size() == 1) {
                        type = result2.mySchemas.get(0).getType();
                    }
                }
            }
            allProps.add(new JsonValidationError.MissingPropertyIssueData(req, type, defaultValue, (Integer)enumCount.get()));
        }
        JsonValidationError.MissingMultiplePropsIssueData missingMultiplePropsIssueData = new JsonValidationError.MissingMultiplePropsIssueData(allProps);
        if (missingMultiplePropsIssueData == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(21);
        }
        return missingMultiplePropsIssueData;
    }

    private static JsonSchemaObject resolvePropertySchema(@NotNull JsonSchemaObject schema, String req) {
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(22);
        }
        if (schema.getProperties().containsKey(req)) {
            return schema.getProperties().get(req);
        }
        JsonSchemaObject propertySchema = schema.getMatchingPatternPropertySchema(req);
        if (propertySchema != null) {
            return propertySchema;
        }
        JsonSchemaObject additionalPropertiesSchema = schema.getAdditionalPropertiesSchema();
        if (additionalPropertiesSchema != null) {
            return additionalPropertiesSchema;
        }
        return null;
    }

    private static boolean checkEnumValue(@NotNull Object object, @NotNull JsonLikePsiWalker walker, @Nullable JsonValueAdapter adapter, @NotNull String text, @NotNull BiFunction<String, String, Boolean> stringEq) {
        if (object == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(23);
        }
        if (walker == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(24);
        }
        if (text == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(25);
        }
        if (stringEq == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(26);
        }
        if (adapter != null && !adapter.shouldCheckAsValue()) {
            return true;
        }
        if (object instanceof EnumArrayValueWrapper) {
            if (adapter instanceof JsonArrayValueAdapter) {
                List<JsonValueAdapter> elements = ((JsonArrayValueAdapter)adapter).getElements();
                Object[] values = ((EnumArrayValueWrapper)object).getValues();
                if (elements.size() == values.length) {
                    for (int i = 0; i < values.length; ++i) {
                        if (JsonSchemaAnnotatorChecker.checkEnumValue(values[i], walker, elements.get(i), walker.getNodeTextForValidation(elements.get(i).getDelegate()), stringEq)) continue;
                        return false;
                    }
                    return true;
                }
            }
        } else if (object instanceof EnumObjectValueWrapper) {
            if (adapter instanceof JsonObjectValueAdapter) {
                List<JsonPropertyAdapter> props = ((JsonObjectValueAdapter)adapter).getPropertyList();
                Map<String, Object> values = ((EnumObjectValueWrapper)object).getValues();
                if (props.size() == values.size()) {
                    for (JsonPropertyAdapter prop : props) {
                        if (!values.containsKey(prop.getName())) {
                            return false;
                        }
                        for (JsonValueAdapter value : prop.getValues()) {
                            if (JsonSchemaAnnotatorChecker.checkEnumValue(values.get(prop.getName()), walker, value, walker.getNodeTextForValidation(value.getDelegate()), stringEq)) continue;
                            return false;
                        }
                    }
                    return true;
                }
            }
        } else if (!walker.allowsSingleQuotes() ? stringEq.apply(object.toString(), text) != false : JsonSchemaAnnotatorChecker.equalsIgnoreQuotes(object.toString(), text, walker.requiresValueQuotes(), stringEq)) {
            return true;
        }
        return false;
    }

    private void checkForEnum(PsiElement value, JsonSchemaObject schema) {
        List<Object> enumItems = schema.getEnum();
        if (enumItems == null) {
            return;
        }
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(value, schema);
        if (walker == null) {
            return;
        }
        String text = StringUtil.notNullize((String)walker.getNodeTextForValidation(value));
        BiFunction<String, String, Boolean> eq = this.myOptions.isCaseInsensitiveEnumCheck() ? String::equalsIgnoreCase : String::equals;
        for (Object object : enumItems) {
            if (!JsonSchemaAnnotatorChecker.checkEnumValue(object, walker, walker.createValueAdapter(value), text, eq)) continue;
            return;
        }
        this.error(ENUM_MISMATCH_PREFIX + StringUtil.join(enumItems, o -> o.toString(), (String)", "), value, JsonValidationError.FixableIssueKind.NonEnumValue, null, JsonErrorPriority.MEDIUM_PRIORITY);
    }

    private static boolean equalsIgnoreQuotes(@NotNull String s1, @NotNull String s2, boolean requireQuotedValues, BiFunction<String, String, Boolean> eq) {
        if (s1 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(27);
        }
        if (s2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(28);
        }
        boolean quoted1 = StringUtil.isQuotedString((String)s1);
        boolean quoted2 = StringUtil.isQuotedString((String)s2);
        if (requireQuotedValues && quoted1 != quoted2) {
            return false;
        }
        if (requireQuotedValues && !quoted1) {
            return eq.apply(s1, s2);
        }
        return eq.apply(StringUtil.unquoteString((String)s1), StringUtil.unquoteString((String)s2));
    }

    private void checkArray(JsonValueAdapter value, JsonSchemaObject schema) {
        JsonArrayValueAdapter asArray = value.getAsArray();
        if (asArray == null) {
            return;
        }
        List<JsonValueAdapter> elements = asArray.getElements();
        if (schema.getMinLength() != null && elements.size() < schema.getMinLength()) {
            this.error("Array is shorter than " + schema.getMinLength(), value.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
            return;
        }
        this.checkArrayItems(value, elements, schema);
    }

    @NotNull
    private static Pair<JsonSchemaObject, JsonSchemaAnnotatorChecker> processSchemasVariants(@NotNull Project project, @NotNull Collection<? extends JsonSchemaObject> collection, @NotNull JsonValueAdapter value, boolean isOneOf, JsonComplianceCheckerOptions options) {
        if (project == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(29);
        }
        if (collection == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(30);
        }
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(31);
        }
        JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(project, options);
        JsonSchemaType type = JsonSchemaType.getType(value);
        JsonSchemaObject selected = null;
        if (type == null) {
            if (!value.isShouldBeIgnored()) {
                checker.typeError(value.getDelegate(), null, JsonSchemaAnnotatorChecker.getExpectedTypes(collection));
            }
        } else {
            ArrayList filtered = ContainerUtil.newArrayListWithCapacity((int)collection.size());
            for (JsonSchemaObject jsonSchemaObject : collection) {
                if (!JsonSchemaAnnotatorChecker.areSchemaTypesCompatible(jsonSchemaObject, type)) continue;
                filtered.add(jsonSchemaObject);
            }
            if (filtered.isEmpty()) {
                checker.typeError(value.getDelegate(), type, JsonSchemaAnnotatorChecker.getExpectedTypes(collection));
            } else if (filtered.size() == 1) {
                selected = (JsonSchemaObject)filtered.get(0);
                checker.checkByScheme(value, selected);
            } else {
                selected = isOneOf ? checker.processOneOf(value, filtered) : checker.processAnyOf(value, filtered);
            }
        }
        Pair pair = Pair.create(selected, (Object)checker);
        if (pair == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(32);
        }
        return pair;
    }

    private static JsonSchemaType[] getExpectedTypes(Collection<? extends JsonSchemaObject> schemas) {
        ArrayList<JsonSchemaType> list2 = new ArrayList<JsonSchemaType>();
        for (JsonSchemaObject jsonSchemaObject : schemas) {
            JsonSchemaType type = jsonSchemaObject.getType();
            if (type != null) {
                list2.add(type);
                continue;
            }
            Set<JsonSchemaType> variants = jsonSchemaObject.getTypeVariants();
            if (variants == null) continue;
            list2.addAll(variants);
        }
        return list2.isEmpty() ? NO_TYPES : list2.toArray(NO_TYPES);
    }

    public static boolean areSchemaTypesCompatible(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaType type) {
        JsonSchemaType matchingSchemaType;
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(33);
        }
        if (type == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(34);
        }
        if ((matchingSchemaType = JsonSchemaAnnotatorChecker.getMatchingSchemaType(schema, type)) != null) {
            return matchingSchemaType.equals((Object)type);
        }
        if (schema.getEnum() != null) {
            return PRIMITIVE_TYPES.contains((Object)type);
        }
        return true;
    }

    @Nullable
    private static JsonSchemaType getMatchingSchemaType(@NotNull JsonSchemaObject schema, @NotNull JsonSchemaType input) {
        JsonSchemaType matchType;
        if (schema == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(35);
        }
        if (input == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(36);
        }
        if (schema.getType() != null && (matchType = schema.getType()) != null) {
            if (JsonSchemaType._integer.equals((Object)input) && JsonSchemaType._number.equals((Object)matchType)) {
                return input;
            }
            if (JsonSchemaType._string_number.equals((Object)input) && (JsonSchemaType._number.equals((Object)matchType) || JsonSchemaType._integer.equals((Object)matchType) || JsonSchemaType._string.equals((Object)matchType))) {
                return input;
            }
            return matchType;
        }
        if (schema.getTypeVariants() != null) {
            Set<JsonSchemaType> matchTypes = schema.getTypeVariants();
            if (matchTypes.contains((Object)input)) {
                return input;
            }
            if (JsonSchemaType._integer.equals((Object)input) && matchTypes.contains((Object)JsonSchemaType._number)) {
                return input;
            }
            if (JsonSchemaType._string_number.equals((Object)input) && (matchTypes.contains((Object)JsonSchemaType._number) || matchTypes.contains((Object)JsonSchemaType._integer) || matchTypes.contains((Object)JsonSchemaType._string))) {
                return input;
            }
            return matchTypes.iterator().next();
        }
        if (!schema.getProperties().isEmpty() && JsonSchemaType._object.equals((Object)input)) {
            return JsonSchemaType._object;
        }
        return null;
    }

    private void checkArrayItems(@NotNull JsonValueAdapter array, @NotNull List<JsonValueAdapter> list2, JsonSchemaObject schema) {
        if (array == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(37);
        }
        if (list2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(38);
        }
        if (schema.isUniqueItems()) {
            MultiMap valueTexts = new MultiMap();
            JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(array.getDelegate(), schema);
            assert (walker != null);
            for (JsonValueAdapter adapter : list2) {
                valueTexts.putValue((Object)walker.getNodeTextForValidation(adapter.getDelegate()), (Object)adapter);
            }
            for (Map.Entry entry : valueTexts.entrySet()) {
                if (((Collection)entry.getValue()).size() <= 1) continue;
                for (JsonValueAdapter item : (Collection)entry.getValue()) {
                    if (!item.shouldCheckAsValue()) continue;
                    this.error("Item is not unique", item.getDelegate(), JsonErrorPriority.TYPE_MISMATCH);
                }
            }
        }
        if (schema.getContainsSchema() != null) {
            boolean match = false;
            for (JsonValueAdapter item : list2) {
                JsonSchemaAnnotatorChecker checker = JsonSchemaAnnotatorChecker.checkByMatchResult(this.myProject, item, new JsonSchemaResolver(this.myProject, schema.getContainsSchema()).detailedResolve(), this.myOptions);
                if (checker != null && (checker.myErrors.size() != 0 || checker.myHadTypeError)) continue;
                match = true;
                break;
            }
            if (!match) {
                this.error("No match for 'contains' rule", array.getDelegate(), JsonErrorPriority.MEDIUM_PRIORITY);
            }
        }
        if (schema.getItemsSchema() != null) {
            for (JsonValueAdapter item : list2) {
                this.checkObjectBySchemaRecordErrors(schema.getItemsSchema(), item);
            }
        } else if (schema.getItemsSchemaList() != null) {
            Iterator<JsonSchemaObject> iterator = schema.getItemsSchemaList().iterator();
            for (JsonValueAdapter arrayValue : list2) {
                if (iterator.hasNext()) {
                    this.checkObjectBySchemaRecordErrors(iterator.next(), arrayValue);
                    continue;
                }
                if (!Boolean.TRUE.equals(schema.getAdditionalItemsAllowed())) {
                    this.error("Additional items are not allowed", arrayValue.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
                    continue;
                }
                if (schema.getAdditionalItemsSchema() == null) continue;
                this.checkObjectBySchemaRecordErrors(schema.getAdditionalItemsSchema(), arrayValue);
            }
        }
        if (schema.getMinItems() != null && list2.size() < schema.getMinItems()) {
            this.error("Array is shorter than " + schema.getMinItems(), array.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
        if (schema.getMaxItems() != null && list2.size() > schema.getMaxItems()) {
            this.error("Array is longer than " + schema.getMaxItems(), array.getDelegate(), JsonErrorPriority.LOW_PRIORITY);
        }
    }

    private static boolean hasMinMaxLengthChecks(JsonSchemaObject schema) {
        return schema.getMinLength() != null || schema.getMaxLength() != null;
    }

    private void checkString(PsiElement propValue, JsonSchemaObject schema) {
        String v = JsonSchemaAnnotatorChecker.getValue(propValue, schema);
        if (v == null) {
            return;
        }
        String value = StringUtil.unquoteString((String)v);
        if (schema.getMinLength() != null && value.length() < schema.getMinLength()) {
            this.error("String is shorter than " + schema.getMinLength(), propValue, JsonErrorPriority.LOW_PRIORITY);
            return;
        }
        if (schema.getMaxLength() != null && value.length() > schema.getMaxLength()) {
            this.error("String is longer than " + schema.getMaxLength(), propValue, JsonErrorPriority.LOW_PRIORITY);
            return;
        }
        if (schema.getPattern() != null) {
            if (schema.getPatternError() != null) {
                this.error("Can not check string by pattern because of error: " + StringUtil.convertLineSeparators((String)schema.getPatternError()), propValue, JsonErrorPriority.LOW_PRIORITY);
            }
            if (!schema.checkByPattern(value)) {
                this.error("String is violating the pattern: '" + StringUtil.convertLineSeparators((String)schema.getPattern()) + "'", propValue, JsonErrorPriority.LOW_PRIORITY);
            }
        }
    }

    @Nullable
    private static String getValue(PsiElement propValue, JsonSchemaObject schema) {
        JsonLikePsiWalker walker = JsonLikePsiWalker.getWalker(propValue, schema);
        assert (walker != null);
        JsonValueAdapter adapter = walker.createValueAdapter(propValue);
        if (adapter != null && !adapter.shouldCheckAsValue()) {
            return null;
        }
        return walker.getNodeTextForValidation(propValue);
    }

    private void checkNumber(PsiElement propValue, JsonSchemaObject schema, JsonSchemaType schemaType) {
        double leftOver;
        Number multipleOf;
        Number value;
        String valueText = JsonSchemaAnnotatorChecker.getValue(propValue, schema);
        if (valueText == null) {
            return;
        }
        if (JsonSchemaType._integer.equals((Object)schemaType)) {
            value = JsonSchemaType.getIntegerValue(valueText);
            if (value == null) {
                this.error("Integer value expected", propValue, JsonValidationError.FixableIssueKind.TypeMismatch, new JsonValidationError.TypeMismatchIssueData(new JsonSchemaType[]{schemaType}), JsonErrorPriority.TYPE_MISMATCH);
                return;
            }
        } else {
            try {
                value = Double.valueOf(valueText);
            }
            catch (NumberFormatException e) {
                if (!JsonSchemaType._string_number.equals((Object)schemaType)) {
                    this.error("Double value expected", propValue, JsonValidationError.FixableIssueKind.TypeMismatch, new JsonValidationError.TypeMismatchIssueData(new JsonSchemaType[]{schemaType}), JsonErrorPriority.TYPE_MISMATCH);
                }
                return;
            }
        }
        if ((multipleOf = schema.getMultipleOf()) != null && (leftOver = value.doubleValue() % multipleOf.doubleValue()) > 1.0E-6) {
            String multipleOfValue = String.valueOf(Math.abs(multipleOf.doubleValue() - (double)multipleOf.intValue()) < 1.0E-6 ? (Number)multipleOf.intValue() : (Number)multipleOf);
            this.error("Is not multiple of " + multipleOfValue, propValue, JsonErrorPriority.LOW_PRIORITY);
            return;
        }
        this.checkMinimum(schema, value, propValue, schemaType);
        this.checkMaximum(schema, value, propValue, schemaType);
    }

    private void checkMaximum(JsonSchemaObject schema, Number value, PsiElement propertyValue, @NotNull JsonSchemaType propValueType) {
        Number maximum;
        Number exclusiveMaximumNumber;
        if (propValueType == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(39);
        }
        if ((exclusiveMaximumNumber = schema.getExclusiveMaximumNumber()) != null) {
            if (JsonSchemaType._integer.equals((Object)propValueType)) {
                int intValue = exclusiveMaximumNumber.intValue();
                if (value.intValue() >= intValue) {
                    this.error("Greater than an exclusive maximum " + intValue, propertyValue, JsonErrorPriority.LOW_PRIORITY);
                }
            } else {
                double doubleValue = exclusiveMaximumNumber.doubleValue();
                if (value.doubleValue() >= doubleValue) {
                    this.error("Greater than an exclusive maximum " + exclusiveMaximumNumber, propertyValue, JsonErrorPriority.LOW_PRIORITY);
                }
            }
        }
        if ((maximum = schema.getMaximum()) == null) {
            return;
        }
        boolean isExclusive = Boolean.TRUE.equals(schema.isExclusiveMaximum());
        if (JsonSchemaType._integer.equals((Object)propValueType)) {
            int intValue = maximum.intValue();
            if (isExclusive) {
                if (value.intValue() >= intValue) {
                    this.error("Greater than an exclusive maximum " + intValue, propertyValue, JsonErrorPriority.LOW_PRIORITY);
                }
            } else if (value.intValue() > intValue) {
                this.error("Greater than a maximum " + intValue, propertyValue, JsonErrorPriority.LOW_PRIORITY);
            }
        } else {
            double doubleValue = maximum.doubleValue();
            if (isExclusive) {
                if (value.doubleValue() >= doubleValue) {
                    this.error("Greater than an exclusive maximum " + maximum, propertyValue, JsonErrorPriority.LOW_PRIORITY);
                }
            } else if (value.doubleValue() > doubleValue) {
                this.error("Greater than a maximum " + maximum, propertyValue, JsonErrorPriority.LOW_PRIORITY);
            }
        }
    }

    private void checkMinimum(JsonSchemaObject schema, Number value, PsiElement propertyValue, @NotNull JsonSchemaType schemaType) {
        Number minimum;
        Number exclusiveMinimumNumber;
        if (schemaType == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(40);
        }
        if ((exclusiveMinimumNumber = schema.getExclusiveMinimumNumber()) != null) {
            if (JsonSchemaType._integer.equals((Object)schemaType)) {
                int intValue = exclusiveMinimumNumber.intValue();
                if (value.intValue() <= intValue) {
                    this.error("Less than an exclusive minimum" + intValue, propertyValue, JsonErrorPriority.LOW_PRIORITY);
                }
            } else {
                double doubleValue = exclusiveMinimumNumber.doubleValue();
                if (value.doubleValue() <= doubleValue) {
                    this.error("Less than an exclusive minimum " + exclusiveMinimumNumber, propertyValue, JsonErrorPriority.LOW_PRIORITY);
                }
            }
        }
        if ((minimum = schema.getMinimum()) == null) {
            return;
        }
        boolean isExclusive = Boolean.TRUE.equals(schema.isExclusiveMinimum());
        if (JsonSchemaType._integer.equals((Object)schemaType)) {
            int intValue = minimum.intValue();
            if (isExclusive) {
                if (value.intValue() <= intValue) {
                    this.error("Less than an exclusive minimum " + intValue, propertyValue, JsonErrorPriority.LOW_PRIORITY);
                }
            } else if (value.intValue() < intValue) {
                this.error("Less than a minimum " + intValue, propertyValue, JsonErrorPriority.LOW_PRIORITY);
            }
        } else {
            double doubleValue = minimum.doubleValue();
            if (isExclusive) {
                if (value.doubleValue() <= doubleValue) {
                    this.error("Less than an exclusive minimum " + minimum, propertyValue, JsonErrorPriority.LOW_PRIORITY);
                }
            } else if (value.doubleValue() < doubleValue) {
                this.error("Less than a minimum " + minimum, propertyValue, JsonErrorPriority.LOW_PRIORITY);
            }
        }
    }

    private JsonSchemaObject processOneOf(@NotNull JsonValueAdapter value, List<JsonSchemaObject> oneOf) {
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(41);
        }
        ArrayList candidateErroneousCheckers = ContainerUtil.newArrayList();
        ArrayList candidateErroneousSchemas = ContainerUtil.newArrayList();
        SmartList correct = new SmartList();
        for (JsonSchemaObject object : oneOf) {
            if (object.isShouldValidateAgainstJSType()) continue;
            JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(this.myProject, this.myOptions);
            checker.checkByScheme(value, object);
            if (checker.isCorrect()) {
                candidateErroneousCheckers.clear();
                candidateErroneousSchemas.clear();
                correct.add(object);
                continue;
            }
            candidateErroneousCheckers.add(checker);
            candidateErroneousSchemas.add(object);
        }
        if (correct.size() == 1) {
            return (JsonSchemaObject)correct.get(0);
        }
        if (correct.size() > 0) {
            JsonSchemaType type = JsonSchemaType.getType(value);
            if (type != null && ContainerUtil.newHashSet((Iterable)correct).size() > 1 && !JsonSchemaAnnotatorChecker.schemesDifferWithNotCheckedProperties((List<JsonSchemaObject>)correct)) {
                this.error("Validates to more than one variant", value.getDelegate(), JsonErrorPriority.MEDIUM_PRIORITY);
            }
            return (JsonSchemaObject)ContainerUtil.getLastItem((List)correct);
        }
        return this.showErrorsAndGetLeastErroneous(candidateErroneousCheckers, candidateErroneousSchemas, true);
    }

    private static boolean schemesDifferWithNotCheckedProperties(@NotNull List<JsonSchemaObject> list2) {
        if (list2 == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(42);
        }
        return list2.stream().anyMatch(s -> !StringUtil.isEmptyOrSpaces((String)s.getFormat()));
    }

    @NotNull
    private static AverageFailureAmount getAverageFailureAmount(@NotNull JsonSchemaAnnotatorChecker checker) {
        if (checker == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(43);
        }
        int lowPriorityCount = 0;
        boolean hasMedium = false;
        boolean hasMissing = false;
        boolean hasHard = false;
        Collection<JsonValidationError> values = checker.getErrors().values();
        for (JsonValidationError value : values) {
            switch (value.getPriority()) {
                case LOW_PRIORITY: {
                    ++lowPriorityCount;
                    break;
                }
                case MISSING_PROPS: {
                    hasMissing = true;
                    break;
                }
                case MEDIUM_PRIORITY: {
                    hasMedium = true;
                    break;
                }
                case TYPE_MISMATCH: {
                    hasHard = true;
                    break;
                }
                case NOT_SCHEMA: {
                    AverageFailureAmount averageFailureAmount = AverageFailureAmount.NotSchema;
                    if (averageFailureAmount == null) {
                        JsonSchemaAnnotatorChecker.$$$reportNull$$$0(44);
                    }
                    return averageFailureAmount;
                }
            }
        }
        if (hasHard) {
            AverageFailureAmount averageFailureAmount = AverageFailureAmount.Hard;
            if (averageFailureAmount == null) {
                JsonSchemaAnnotatorChecker.$$$reportNull$$$0(45);
            }
            return averageFailureAmount;
        }
        if (hasMissing) {
            AverageFailureAmount averageFailureAmount = AverageFailureAmount.MissingItems;
            if (averageFailureAmount == null) {
                JsonSchemaAnnotatorChecker.$$$reportNull$$$0(46);
            }
            return averageFailureAmount;
        }
        if (hasMedium) {
            AverageFailureAmount averageFailureAmount = AverageFailureAmount.Medium;
            if (averageFailureAmount == null) {
                JsonSchemaAnnotatorChecker.$$$reportNull$$$0(47);
            }
            return averageFailureAmount;
        }
        AverageFailureAmount averageFailureAmount = lowPriorityCount <= 3 ? AverageFailureAmount.Light : AverageFailureAmount.Medium;
        if (averageFailureAmount == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(48);
        }
        return averageFailureAmount;
    }

    private JsonSchemaObject processAnyOf(@NotNull JsonValueAdapter value, List<JsonSchemaObject> anyOf) {
        if (value == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(49);
        }
        ArrayList candidateErroneousCheckers = ContainerUtil.newArrayList();
        ArrayList candidateErroneousSchemas = ContainerUtil.newArrayList();
        for (JsonSchemaObject object : anyOf) {
            JsonSchemaAnnotatorChecker checker = new JsonSchemaAnnotatorChecker(this.myProject, this.myOptions);
            checker.checkByScheme(value, object);
            if (checker.isCorrect()) {
                return object;
            }
            candidateErroneousCheckers.add(checker);
            candidateErroneousSchemas.add(object);
        }
        return this.showErrorsAndGetLeastErroneous(candidateErroneousCheckers, candidateErroneousSchemas, false);
    }

    @Nullable
    private JsonSchemaObject showErrorsAndGetLeastErroneous(@NotNull List<JsonSchemaAnnotatorChecker> candidateErroneousCheckers, @NotNull List<JsonSchemaObject> candidateErroneousSchemas, boolean isOneOf) {
        if (candidateErroneousCheckers == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(50);
        }
        if (candidateErroneousSchemas == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(51);
        }
        JsonSchemaObject current = null;
        JsonSchemaObject currentWithMinAverage = null;
        Optional<AverageFailureAmount> minAverage = candidateErroneousCheckers.stream().map(c -> JsonSchemaAnnotatorChecker.getAverageFailureAmount(c)).min(Comparator.comparingInt(c -> c.ordinal()));
        int min = minAverage.orElse(AverageFailureAmount.Hard).ordinal();
        int minErrorCount = candidateErroneousCheckers.stream().map(c -> c.getErrors().size()).min(Integer::compareTo).orElse(Integer.MAX_VALUE);
        MultiMap errorsWithMinAverage = MultiMap.create();
        MultiMap allErrors = MultiMap.create();
        for (int i = 0; i < candidateErroneousCheckers.size(); ++i) {
            boolean isMoreThanAverage;
            JsonSchemaAnnotatorChecker checker = candidateErroneousCheckers.get(i);
            boolean isMoreThanMinErrors = checker.getErrors().size() > minErrorCount;
            boolean bl = isMoreThanAverage = JsonSchemaAnnotatorChecker.getAverageFailureAmount(checker).ordinal() > min;
            if (isMoreThanMinErrors) continue;
            if (isMoreThanAverage) {
                currentWithMinAverage = candidateErroneousSchemas.get(i);
            } else {
                current = candidateErroneousSchemas.get(i);
            }
            for (Map.Entry<Object, JsonValidationError> entry : checker.getErrors().entrySet()) {
                (isMoreThanAverage ? errorsWithMinAverage : allErrors).putValue(entry.getKey(), (Object)entry.getValue());
            }
        }
        if (allErrors.isEmpty()) {
            allErrors = errorsWithMinAverage;
        }
        for (Map.Entry entry : allErrors.entrySet()) {
            Collection value = (Collection)entry.getValue();
            if (value.size() == 0) continue;
            if (value.size() == 1) {
                this.error((PsiElement)entry.getKey(), (JsonValidationError)value.iterator().next());
                continue;
            }
            JsonValidationError error = JsonSchemaAnnotatorChecker.tryMergeErrors(value, isOneOf);
            if (error != null) {
                this.error((PsiElement)entry.getKey(), error);
                continue;
            }
            for (JsonValidationError jsonValidationError : value) {
                this.error((PsiElement)entry.getKey(), jsonValidationError);
            }
        }
        if (current == null) {
            current = currentWithMinAverage;
        }
        if (current == null) {
            current = (JsonSchemaObject)ContainerUtil.getLastItem(candidateErroneousSchemas);
        }
        return current;
    }

    @Nullable
    private static JsonValidationError tryMergeErrors(@NotNull Collection<JsonValidationError> errors, boolean isOneOf) {
        if (errors == null) {
            JsonSchemaAnnotatorChecker.$$$reportNull$$$0(52);
        }
        JsonValidationError.FixableIssueKind commonIssueKind = null;
        for (JsonValidationError error : errors) {
            JsonValidationError.FixableIssueKind currentIssueKind = error.getFixableIssueKind();
            if (currentIssueKind == JsonValidationError.FixableIssueKind.None) {
                return null;
            }
            if (commonIssueKind == null) {
                commonIssueKind = currentIssueKind;
                continue;
            }
            if (currentIssueKind == commonIssueKind) continue;
            return null;
        }
        if (commonIssueKind == JsonValidationError.FixableIssueKind.NonEnumValue) {
            return new JsonValidationError(ENUM_MISMATCH_PREFIX + errors.stream().map(e -> StringUtil.trimStart((String)e.getMessage(), (String)ENUM_MISMATCH_PREFIX)).map(e -> StringUtil.split((String)e, (String)", ")).flatMap(e -> e.stream()).distinct().collect(Collectors.joining(", ")), commonIssueKind, null, errors.iterator().next().getPriority());
        }
        if (commonIssueKind == JsonValidationError.FixableIssueKind.MissingProperty) {
            String prefix = isOneOf ? "One of the following property sets is required: " : "Should have at least one of the following property sets: ";
            return new JsonValidationError(prefix + errors.stream().map(e -> (JsonValidationError.MissingMultiplePropsIssueData)e.getIssueData()).map(d -> d.getMessage(false)).collect(Collectors.joining(", or ")), isOneOf ? JsonValidationError.FixableIssueKind.MissingOneOfProperty : JsonValidationError.FixableIssueKind.MissingAnyOfProperty, new JsonValidationError.MissingOneOfPropsIssueData(ContainerUtil.map(errors, e -> (JsonValidationError.MissingMultiplePropsIssueData)e.getIssueData())), errors.iterator().next().getPriority());
        }
        if (commonIssueKind == JsonValidationError.FixableIssueKind.ProhibitedType) {
            Set allTypes = errors.stream().map(e -> (JsonValidationError.TypeMismatchIssueData)e.getIssueData()).flatMap(d -> Arrays.stream(d.expectedTypes)).collect(Collectors.toSet());
            if (allTypes.size() == 1) {
                return errors.iterator().next();
            }
            List actualInfos = errors.stream().map(e -> e.getMessage()).map(JsonSchemaAnnotatorChecker::fetchActual).distinct().collect(Collectors.toList());
            String actualInfo = actualInfos.size() == 1 ? " Actual: " + (String)actualInfos.get(0) + "." : "";
            String commonTypeMessage = "Incompatible types.\n Required one of: " + allTypes.stream().map(t -> t.getDescription()).sorted().collect(Collectors.joining(", ")) + "." + actualInfo;
            return new JsonValidationError(commonTypeMessage, JsonValidationError.FixableIssueKind.TypeMismatch, new JsonValidationError.TypeMismatchIssueData((JsonSchemaType[])ContainerUtil.toArray(allTypes, JsonSchemaType[]::new)), errors.iterator().next().getPriority());
        }
        return null;
    }

    private static String fetchActual(String message) {
        int actual = message.indexOf(ACTUAL_PREFIX);
        if (actual == -1) {
            return null;
        }
        String substring = message.substring(actual + ACTUAL_PREFIX.length());
        return StringUtil.trimEnd((String)substring, (String)".");
    }

    public boolean isCorrect() {
        return this.myErrors.isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 21: 
            case 32: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 21: 
            case 32: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToCheck";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: 
            case 38: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludingSchemas";
                break;
            }
            case 10: 
            case 12: 
            case 16: 
            case 31: 
            case 41: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allowedTypes";
                break;
            }
            case 13: 
            case 14: 
            case 17: 
            case 20: 
            case 22: 
            case 33: 
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schema";
                break;
            }
            case 15: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertySchema";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enumCount";
                break;
            }
            case 21: 
            case 32: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "walker";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stringEq";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s1";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s2";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propValueType";
                break;
            }
            case 40: {
                objectArray2 = objectArray3;
                objectArray3[0] = "schemaType";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checker";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateErroneousCheckers";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidateErroneousSchemas";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/jsonSchema/impl/JsonSchemaAnnotatorChecker";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createMissingPropertiesData";
                break;
            }
            case 32: {
                objectArray = objectArray2;
                objectArray2[1] = "processSchemasVariants";
                break;
            }
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "getAverageFailureAmount";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "checkByMatchResult";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "mergeErrors";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "typeError";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "checkByScheme";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "checkObjectBySchemaRecordErrors";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "checkObject";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultValueFromEnum";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createMissingPropertiesData";
                break;
            }
            case 21: 
            case 32: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "resolvePropertySchema";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "checkEnumValue";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "equalsIgnoreQuotes";
                break;
            }
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processSchemasVariants";
                break;
            }
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "areSchemaTypesCompatible";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "getMatchingSchemaType";
                break;
            }
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "checkArrayItems";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkMaximum";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "checkMinimum";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "processOneOf";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "schemesDifferWithNotCheckedProperties";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getAverageFailureAmount";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "processAnyOf";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "showErrorsAndGetLeastErroneous";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "tryMergeErrors";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 21: 
            case 32: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum AverageFailureAmount {
        Light,
        MissingItems,
        Medium,
        Hard,
        NotSchema;

    }
}

