/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.jsonSchema.ide;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.jsonSchema.extension.JsonLikePsiWalker;
import com.jetbrains.jsonSchema.extension.JsonSchemaFileProvider;
import com.jetbrains.jsonSchema.extension.JsonSchemaInfo;
import com.jetbrains.jsonSchema.impl.JsonSchemaObject;
import com.jetbrains.jsonSchema.impl.JsonSchemaVersion;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface JsonSchemaService {
    public static boolean isSchemaFile(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            JsonSchemaService.$$$reportNull$$$0(0);
        }
        if (JsonLikePsiWalker.getWalker((PsiElement)psiFile, JsonSchemaObject.NULL_OBJ) == null) {
            return false;
        }
        VirtualFile file2 = psiFile.getViewProvider().getVirtualFile();
        JsonSchemaService service2 = Impl.get(psiFile.getProject());
        return service2.isSchemaFile(file2) && service2.isApplicableToFile(file2);
    }

    public boolean isSchemaFile(@NotNull VirtualFile var1);

    public boolean isSchemaFile(@NotNull JsonSchemaObject var1);

    @NotNull
    public Project getProject();

    @Nullable
    public JsonSchemaVersion getSchemaVersion(@NotNull VirtualFile var1);

    @NotNull
    public Collection<VirtualFile> getSchemaFilesForFile(@NotNull VirtualFile var1);

    public void registerRemoteUpdateCallback(Runnable var1);

    public void unregisterRemoteUpdateCallback(Runnable var1);

    public void registerResetAction(Runnable var1);

    public void unregisterResetAction(Runnable var1);

    public void registerReference(String var1);

    public boolean possiblyHasReference(String var1);

    public void triggerUpdateRemote();

    @Nullable
    public JsonSchemaObject getSchemaObject(@NotNull VirtualFile var1);

    @Nullable
    public JsonSchemaObject getSchemaObjectForSchemaFile(@NotNull VirtualFile var1);

    @Nullable
    public VirtualFile findSchemaFileByReference(@NotNull String var1, @Nullable VirtualFile var2);

    @Nullable
    public JsonSchemaFileProvider getSchemaProvider(@NotNull VirtualFile var1);

    @Nullable
    public JsonSchemaFileProvider getSchemaProvider(@NotNull JsonSchemaObject var1);

    @Nullable
    public VirtualFile resolveSchemaFile(@NotNull JsonSchemaObject var1);

    public void reset();

    public List<JsonSchemaInfo> getAllUserVisibleSchemas();

    public boolean isApplicableToFile(@Nullable VirtualFile var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/jetbrains/jsonSchema/ide/JsonSchemaService", "isSchemaFile"));
    }

    public static class Impl {
        public static JsonSchemaService get(@NotNull Project project) {
            if (project == null) {
                Impl.$$$reportNull$$$0(0);
            }
            return (JsonSchemaService)ServiceManager.getService((Project)project, JsonSchemaService.class);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/jetbrains/jsonSchema/ide/JsonSchemaService$Impl", "get"));
        }
    }
}

