/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.ide.DataManager;
import com.intellij.ide.ui.UISettings;
import com.intellij.lang.Language;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.options.CompositeConfigurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.colors.pages.GeneralColorsPage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.breadcrumbs.BreadcrumbsProvider;
import com.intellij.ui.components.labels.LinkLabel;
import com.intellij.ui.components.panels.HorizontalLayout;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class BreadcrumbsConfigurable
extends CompositeConfigurable<BreadcrumbsProviderConfigurable>
implements SearchableConfigurable {
    private final HashMap<String, JCheckBox> map = new HashMap();
    private JComponent component;
    private JCheckBox show;
    private JRadioButton above;
    private JRadioButton below;
    private JLabel placement;
    private JLabel languages;

    BreadcrumbsConfigurable() {
    }

    @NotNull
    public String getId() {
        if ("editor.breadcrumbs" == null) {
            BreadcrumbsConfigurable.$$$reportNull$$$0(0);
        }
        return "editor.breadcrumbs";
    }

    public String getDisplayName() {
        return ApplicationBundle.message((String)"configurable.breadcrumbs", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return "reference.settings.editor.general.breadcrumbs";
    }

    public JComponent createComponent() {
        if (this.component == null) {
            for (BreadcrumbsProviderConfigurable configurable : this.getConfigurables()) {
                String id = configurable.getId();
                if (this.map.containsKey(id)) continue;
                this.map.put(id, configurable.createComponent());
            }
            JPanel boxes = new JPanel(new GridLayout(0, 3, UIUtil.isUnderDarcula() ? JBUI.scale((int)10) : 0, 0));
            this.map.values().stream().sorted((box1, box2) -> StringUtil.naturalCompare((String)box1.getText(), (String)box2.getText())).forEach(box -> boxes.add((Component)box));
            this.show = new JCheckBox(ApplicationBundle.message((String)"checkbox.show.breadcrumbs", (Object[])new Object[0]));
            this.show.addItemListener(event -> this.updateEnabled());
            this.above = new JRadioButton(ApplicationBundle.message((String)"radio.show.breadcrumbs.above", (Object[])new Object[0]));
            this.below = new JRadioButton(ApplicationBundle.message((String)"radio.show.breadcrumbs.below", (Object[])new Object[0]));
            ButtonGroup group = new ButtonGroup();
            group.add(this.above);
            group.add(this.below);
            this.placement = new JLabel(ApplicationBundle.message((String)"label.breadcrumbs.placement", (Object[])new Object[0]));
            JPanel placementPanel = new JPanel((LayoutManager)new HorizontalLayout(JBUI.scale((int)10)));
            placementPanel.setBorder((Border)JBUI.Borders.emptyLeft((int)24));
            placementPanel.add(this.placement);
            placementPanel.add(this.above);
            placementPanel.add(this.below);
            this.languages = new JLabel(ApplicationBundle.message((String)"label.breadcrumbs.languages", (Object[])new Object[0]));
            JPanel languagesPanel = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)6)));
            languagesPanel.setBorder((Border)JBUI.Borders.empty((int)0, (int)24, (int)12, (int)0));
            languagesPanel.add(this.languages);
            languagesPanel.add(boxes);
            this.component = new JPanel((LayoutManager)new VerticalLayout(JBUI.scale((int)12), 2));
            this.component.add(this.show);
            this.component.add(placementPanel);
            this.component.add(languagesPanel);
            this.component.add((Component)LinkLabel.create((String)ApplicationBundle.message((String)"configure.breadcrumbs.colors", (Object[])new Object[0]), () -> {
                DataContext context = DataManager.getInstance().getDataContext((Component)this.component);
                ColorAndFontOptions.selectOrEditColor(context, "Breadcrumbs//Current", GeneralColorsPage.class);
            }));
        }
        return this.component;
    }

    @Override
    public void reset() {
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        this.setBreadcrumbsAbove(settings.isBreadcrumbsAbove());
        this.setBreadcrumbsShown(settings.isBreadcrumbsShown());
        for (Map.Entry<String, JCheckBox> entry : this.map.entrySet()) {
            entry.getValue().setSelected(settings.isBreadcrumbsShownFor(entry.getKey()));
        }
        this.updateEnabled();
    }

    @Override
    public boolean isModified() {
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        if (this.isBreadcrumbsAbove() != settings.isBreadcrumbsAbove()) {
            return true;
        }
        if (this.isBreadcrumbsShown() != settings.isBreadcrumbsShown()) {
            return true;
        }
        for (Map.Entry<String, JCheckBox> entry : this.map.entrySet()) {
            if (settings.isBreadcrumbsShownFor(entry.getKey()) == entry.getValue().isSelected()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    protected List<BreadcrumbsProviderConfigurable> createConfigurables() {
        List configurables = ContainerUtil.newSmartList();
        for (BreadcrumbsProvider provider : BreadcrumbsProvider.EP_NAME.getExtensionList()) {
            for (Language language : provider.getLanguages()) {
                configurables.add(new BreadcrumbsProviderConfigurable(provider, language));
            }
        }
        List list2 = configurables;
        if (list2 == null) {
            BreadcrumbsConfigurable.$$$reportNull$$$0(1);
        }
        return list2;
    }

    @Override
    public void apply() {
        boolean modified = false;
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        if (settings.setBreadcrumbsAbove(this.isBreadcrumbsAbove())) {
            modified = true;
        }
        if (settings.setBreadcrumbsShown(this.isBreadcrumbsShown())) {
            modified = true;
        }
        for (Map.Entry<String, JCheckBox> entry : this.map.entrySet()) {
            if (!settings.setBreadcrumbsShownFor(entry.getKey(), entry.getValue().isSelected())) continue;
            modified = true;
        }
        if (modified) {
            UISettings.getInstance().fireUISettingsChanged();
        }
    }

    private boolean isBreadcrumbsAbove() {
        return this.above != null && this.above.isSelected();
    }

    private void setBreadcrumbsAbove(boolean value) {
        JRadioButton button;
        JRadioButton jRadioButton = button = value ? this.above : this.below;
        if (button != null) {
            button.setSelected(true);
        }
    }

    private boolean isBreadcrumbsShown() {
        return this.show != null && this.show.isSelected();
    }

    private void setBreadcrumbsShown(boolean value) {
        if (this.show != null) {
            this.show.setSelected(value);
        }
    }

    private void updateEnabled() {
        boolean enabled = this.isBreadcrumbsShown();
        if (this.above != null) {
            this.above.setEnabled(enabled);
        }
        if (this.below != null) {
            this.below.setEnabled(enabled);
        }
        if (this.placement != null) {
            this.placement.setEnabled(enabled);
        }
        if (this.languages != null) {
            this.languages.setEnabled(enabled);
        }
        for (JCheckBox box : this.map.values()) {
            box.setEnabled(enabled);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/xml/breadcrumbs/BreadcrumbsConfigurable";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfigurables";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    static class BreadcrumbsProviderConfigurable
    implements SearchableConfigurable {
        private final BreadcrumbsProvider myProvider;
        private final Language myLanguage;

        private BreadcrumbsProviderConfigurable(@NotNull BreadcrumbsProvider provider, @NotNull Language language) {
            if (provider == null) {
                BreadcrumbsProviderConfigurable.$$$reportNull$$$0(0);
            }
            if (language == null) {
                BreadcrumbsProviderConfigurable.$$$reportNull$$$0(1);
            }
            this.myProvider = provider;
            this.myLanguage = language;
        }

        @Nullable
        public JCheckBox createComponent() {
            return new JCheckBox(this.myLanguage.getDisplayName());
        }

        public boolean isModified() {
            return false;
        }

        public void apply() throws ConfigurationException {
        }

        @NotNull
        public String getId() {
            String string = this.myLanguage.getID();
            if (string == null) {
                BreadcrumbsProviderConfigurable.$$$reportNull$$$0(2);
            }
            return string;
        }

        @Nls(capitalization=Nls.Capitalization.Title)
        public String getDisplayName() {
            return this.myLanguage.getDisplayName();
        }

        @NotNull
        public Class<?> getOriginalClass() {
            Class<?> clazz = this.myProvider.getClass();
            if (clazz == null) {
                BreadcrumbsProviderConfigurable.$$$reportNull$$$0(3);
            }
            return clazz;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "language";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/xml/breadcrumbs/BreadcrumbsConfigurable$BreadcrumbsProviderConfigurable";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/xml/breadcrumbs/BreadcrumbsConfigurable$BreadcrumbsProviderConfigurable";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOriginalClass";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

