/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.actions;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.actions.BaseCodeInsightAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlEntityDecl;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ParameterizedCachedValueImpl;
import com.intellij.xml.Html5SchemaProvider;
import com.intellij.xml.util.XmlUtil;
import gnu.trove.TIntObjectHashMap;
import org.jetbrains.annotations.NotNull;

public class EscapeEntitiesAction
extends BaseCodeInsightAction
implements CodeInsightActionHandler {
    private static final ParameterizedCachedValueImpl<TIntObjectHashMap<String>, PsiFile> ESCAPES = new ParameterizedCachedValueImpl<TIntObjectHashMap<String>, PsiFile>(param -> {
        XmlFile file2 = XmlUtil.findXmlFile(param, Html5SchemaProvider.getCharsDtdLocation());
        assert (file2 != null);
        TIntObjectHashMap result2 = new TIntObjectHashMap();
        XmlUtil.processXmlElements((XmlElement)file2, element -> {
            String value;
            int key;
            if (element instanceof XmlEntityDecl && !result2.containsKey(key = Integer.parseInt((value = ((XmlEntityDecl)element).getValueElement().getValue()).substring(2, value.length() - 1)))) {
                result2.put(key, (Object)((XmlEntityDecl)element).getName());
            }
            return true;
        }, true);
        return new CachedValueProvider.Result((Object)result2, new Object[]{ModificationTracker.NEVER_CHANGED});
    }){

        @Override
        public boolean isFromMyProject(Project project) {
            return true;
        }
    };

    private static String escape(XmlFile file2, String text, int start2) {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < text.length(); ++i) {
            String escape;
            char c = text.charAt(i);
            PsiElement element = file2.findElementAt(start2 + i);
            if (element != null && EscapeEntitiesAction.isCharacterElement(element) && (c == '<' || c == '>' || c == '&' || c == '\"' || c == '\'' || c > '\u007f') && (escape = (String)ESCAPES.getValue((PsiFile)file2).get((int)c)) != null) {
                result2.append("&").append(escape).append(";");
                continue;
            }
            result2.append(c);
        }
        return result2.toString();
    }

    private static boolean isCharacterElement(PsiElement element) {
        IElementType type = element.getNode().getElementType();
        if (type == XmlTokenType.XML_DATA_CHARACTERS) {
            return true;
        }
        if (type == XmlTokenType.XML_ATTRIBUTE_VALUE_TOKEN && element.getParent().getParent() instanceof XmlAttribute) {
            return true;
        }
        if (type == XmlTokenType.XML_BAD_CHARACTER) {
            return true;
        }
        if (type == XmlTokenType.XML_START_TAG_START) {
            if (element.getNextSibling() instanceof PsiErrorElement) {
                return true;
            }
            if (element.getParent() instanceof PsiErrorElement) {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidForFile(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(2);
        }
        return file2 instanceof XmlFile;
    }

    @NotNull
    protected CodeInsightActionHandler getHandler() {
        EscapeEntitiesAction escapeEntitiesAction = this;
        if (escapeEntitiesAction == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(3);
        }
        return escapeEntitiesAction;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(5);
        }
        if (file2 == null) {
            EscapeEntitiesAction.$$$reportNull$$$0(6);
        }
        int[] starts = editor.getSelectionModel().getBlockSelectionStarts();
        int[] ends = editor.getSelectionModel().getBlockSelectionEnds();
        Document document = editor.getDocument();
        for (int i = starts.length - 1; i >= 0; --i) {
            String newText;
            int start2 = starts[i];
            int end = ends[i];
            String oldText = document.getText(new TextRange(start2, end));
            if (oldText.equals(newText = EscapeEntitiesAction.escape((XmlFile)file2, oldText, start2))) continue;
            document.replaceString(start2, end, (CharSequence)newText);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xml/actions/EscapeEntitiesAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xml/actions/EscapeEntitiesAction";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidForFile";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

