/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.actions.handlers;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.ui.AppUIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.actions.handlers.XDebuggerActionHandler;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.evaluate.XDebuggerEvaluationDialog;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class XDebuggerEvaluateActionHandler
extends XDebuggerActionHandler {
    @Override
    protected void perform(@NotNull XDebugSession session2, DataContext dataContext) {
        String selectedText;
        if (session2 == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(0);
        }
        XDebuggerEditorsProvider editorsProvider = session2.getDebugProcess().getEditorsProvider();
        XStackFrame stackFrame = session2.getCurrentStackFrame();
        XDebuggerEvaluator evaluator = session2.getDebugProcess().getEvaluator();
        if (evaluator == null) {
            return;
        }
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        EvaluationMode mode = EvaluationMode.EXPRESSION;
        String string = selectedText = editor != null ? editor.getSelectionModel().getSelectedText() : null;
        if (selectedText != null) {
            selectedText = evaluator.formatTextForEvaluation(selectedText);
            mode = evaluator.getEvaluationMode(selectedText, editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd(), (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext));
        }
        Promise<String> expressionTextPromise = Promises.resolvedPromise((Object)selectedText);
        if (selectedText == null && editor != null) {
            expressionTextPromise = XDebuggerEvaluateActionHandler.getExpressionText(evaluator, (Project)CommonDataKeys.PROJECT.getData(dataContext), editor);
        }
        VirtualFile file2 = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        EvaluationMode finalMode = mode;
        XValue value = XDebuggerTreeActionBase.getSelectedValue(dataContext);
        expressionTextPromise.onSuccess(expressionText -> {
            if (expressionText == null && value != null) {
                value.calculateEvaluationExpression().onSuccess(expression -> AppUIUtil.invokeOnEdt(() -> XDebuggerEvaluateActionHandler.showDialog(session2, file2, editorsProvider, stackFrame, evaluator, expression)));
            } else {
                AppUIUtil.invokeOnEdt(() -> XDebuggerEvaluateActionHandler.showDialog(session2, file2, editorsProvider, stackFrame, evaluator, XExpressionImpl.fromText(expressionText, finalMode)));
            }
        });
    }

    private static void showDialog(@NotNull XDebugSession session2, VirtualFile file2, XDebuggerEditorsProvider editorsProvider, XStackFrame stackFrame, XDebuggerEvaluator evaluator, @Nullable XExpression expression) {
        if (session2 == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(1);
        }
        if (expression == null) {
            expression = XExpressionImpl.EMPTY_EXPRESSION;
        }
        if (expression.getLanguage() == null) {
            XSourcePosition position;
            Language language = null;
            if (stackFrame != null && (position = stackFrame.getSourcePosition()) != null) {
                language = LanguageUtil.getFileLanguage((VirtualFile)position.getFile());
            }
            if (language == null && file2 != null) {
                language = LanguageUtil.getFileTypeLanguage((FileType)file2.getFileType());
            }
            expression = new XExpressionImpl(expression.getExpression(), language, expression.getCustomInfo(), expression.getMode());
        }
        XSourcePosition position = stackFrame == null ? null : stackFrame.getSourcePosition();
        new XDebuggerEvaluationDialog(session2, editorsProvider, expression, position, evaluator.isCodeFragmentEvaluationSupported()).show();
    }

    @NotNull
    public static Promise<String> getExpressionText(@Nullable XDebuggerEvaluator evaluator, @Nullable Project project, @NotNull Editor editor) {
        if (editor == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(2);
        }
        if (project == null || evaluator == null) {
            Promise promise = Promises.resolvedPromise(null);
            if (promise == null) {
                XDebuggerEvaluateActionHandler.$$$reportNull$$$0(3);
            }
            return promise;
        }
        Document document = editor.getDocument();
        Promise expressionInfoPromise = evaluator.getExpressionInfoAtOffsetAsync(project, document, editor.getCaretModel().getOffset(), true);
        Promise promise = expressionInfoPromise.then(expressionInfo -> XDebuggerEvaluateActionHandler.getExpressionText(expressionInfo, document));
        if (promise == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(4);
        }
        return promise;
    }

    @Nullable
    public static String getExpressionText(@Nullable ExpressionInfo expressionInfo, @NotNull Document document) {
        if (document == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(5);
        }
        if (expressionInfo == null) {
            return null;
        }
        String text = expressionInfo.getExpressionText();
        return text == null ? document.getText(expressionInfo.getTextRange()) : text;
    }

    @Nullable
    public static String getDisplayText(@Nullable ExpressionInfo expressionInfo, @NotNull Document document) {
        if (document == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(6);
        }
        if (expressionInfo == null) {
            return null;
        }
        String text = expressionInfo.getDisplayText();
        return text == null ? document.getText(expressionInfo.getTextRange()) : text;
    }

    @Override
    protected boolean isEnabled(@NotNull XDebugSession session2, DataContext dataContext) {
        if (session2 == null) {
            XDebuggerEvaluateActionHandler.$$$reportNull$$$0(7);
        }
        return session2.getDebugProcess().getEvaluator() != null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "session";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/xdebugger/impl/actions/handlers/XDebuggerEvaluateActionHandler";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpressionText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "perform";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "showDialog";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getExpressionText";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayText";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isEnabled";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

