/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsApplicationSettings;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.IgnoredFileContentProvider;
import com.intellij.openapi.vcs.changes.IgnoredFileGenerator;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.WaitForProgressToShow;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.SystemIndependent;

public class VcsImplUtil {
    private static final Logger LOG = Logger.getInstance(VcsImplUtil.class);
    public static final String MANAGE_IGNORE_FILES_PROPERTY = "MANAGE_IGNORE_FILES_PROPERTY";

    public static void showErrorMessage(Project project, String message, String title) {
        Runnable task2 = () -> Messages.showErrorDialog((Project)project, (String)message, (String)title);
        WaitForProgressToShow.runOrInvokeLaterAboveProgress((Runnable)task2, null, (Project)project);
    }

    @NotNull
    public static String getShortVcsRootName(@NotNull Project project, @NotNull VirtualFile root) {
        String relativePath;
        if (project == null) {
            VcsImplUtil.$$$reportNull$$$0(0);
        }
        if (root == null) {
            VcsImplUtil.$$$reportNull$$$0(1);
        }
        VirtualFile projectDir = project.getBaseDir();
        String repositoryPath = root.getPresentableUrl();
        if (projectDir != null && (relativePath = VfsUtilCore.getRelativePath((VirtualFile)root, (VirtualFile)projectDir, (char)File.separatorChar)) != null) {
            repositoryPath = relativePath;
        }
        String string = repositoryPath.isEmpty() ? root.getName() : repositoryPath;
        if (string == null) {
            VcsImplUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    public static boolean isNonModalCommit() {
        return Registry.is((String)"vcs.non.modal.commit");
    }

    public static void proposeUpdateIgnoreFile(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull VirtualFile ignoreFileRoot) {
        IgnoredFileContentProvider ignoreContentProvider;
        if (project == null) {
            VcsImplUtil.$$$reportNull$$$0(3);
        }
        if (vcs == null) {
            VcsImplUtil.$$$reportNull$$$0(4);
        }
        if (ignoreFileRoot == null) {
            VcsImplUtil.$$$reportNull$$$0(5);
        }
        if ((ignoreContentProvider = VcsImplUtil.getIgnoredFileContentProvider(project, vcs)) == null) {
            LOG.debug("Cannot get ignore content provider for vcs " + vcs.getName());
            return;
        }
        String ignoreFileName = ignoreContentProvider.getFileName();
        File ignoreFile = Paths.get(ignoreFileRoot.getPath(), ignoreFileName).toFile();
        if (VcsImplUtil.canManageIgnoreFiles(project)) {
            VcsImplUtil.updateIgnoreFileIfNeeded(project, vcs, ignoreFileRoot, ignoreFile.exists());
        } else {
            VcsImplUtil.notifyVcsIgnoreFileManage(project, () -> VcsImplUtil.updateIgnoreFileAndOpen(project, vcs, ignoreFileRoot, ignoreFile));
        }
    }

    private static void notifyVcsIgnoreFileManage(@NotNull Project project, @NotNull Runnable manageIgnore) {
        if (project == null) {
            VcsImplUtil.$$$reportNull$$$0(6);
        }
        if (manageIgnore == null) {
            VcsImplUtil.$$$reportNull$$$0(7);
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        VcsApplicationSettings applicationSettings = VcsApplicationSettings.getInstance();
        VcsNotifier.getInstance(project).notifyMinorInfo("", VcsBundle.message((String)"ignored.file.manage.message", (Object[])new Object[0]), NotificationAction.create((String)VcsBundle.message((String)"ignored.file.manage.this.project", (Object[])new Object[0]), (event, notification) -> {
            manageIgnore.run();
            propertiesComponent.setValue(MANAGE_IGNORE_FILES_PROPERTY, true);
            notification.expire();
        }), NotificationAction.create((String)VcsBundle.message((String)"ignored.file.manage.all.project", (Object[])new Object[0]), (event, notification) -> {
            manageIgnore.run();
            applicationSettings.MANAGE_IGNORE_FILES = true;
            notification.expire();
        }), NotificationAction.create((String)VcsBundle.message((String)"ignored.file.manage.notnow", (Object[])new Object[0]), (event, notification) -> notification.expire()));
    }

    public static boolean generateIgnoreFileIfNeeded(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull VirtualFile ignoreFileRoot) {
        if (project == null) {
            VcsImplUtil.$$$reportNull$$$0(8);
        }
        if (vcs == null) {
            VcsImplUtil.$$$reportNull$$$0(9);
        }
        if (ignoreFileRoot == null) {
            VcsImplUtil.$$$reportNull$$$0(10);
        }
        return VcsImplUtil.updateIgnoreFileIfNeeded(project, vcs, ignoreFileRoot, false);
    }

    public static boolean updateIgnoreFileIfNeeded(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull VirtualFile ignoreFileRoot, boolean append) {
        IgnoredFileGenerator ignoredFileGenerator;
        if (project == null) {
            VcsImplUtil.$$$reportNull$$$0(11);
        }
        if (vcs == null) {
            VcsImplUtil.$$$reportNull$$$0(12);
        }
        if (ignoreFileRoot == null) {
            VcsImplUtil.$$$reportNull$$$0(13);
        }
        if ((ignoredFileGenerator = (IgnoredFileGenerator)ServiceManager.getService((Project)project, IgnoredFileGenerator.class)) == null) {
            LOG.debug("Cannot find ignore file ignoredFileGenerator for " + vcs.getName() + " VCS");
            return false;
        }
        try {
            return append ? ignoredFileGenerator.appendFile(ignoreFileRoot, vcs) : ignoredFileGenerator.generateFile(ignoreFileRoot, vcs);
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
            return false;
        }
    }

    private static void updateIgnoreFileAndOpen(@NotNull Project project, @NotNull AbstractVcs vcs, @NotNull VirtualFile ignoreFileRoot, @NotNull File ignoreFile) {
        if (project == null) {
            VcsImplUtil.$$$reportNull$$$0(14);
        }
        if (vcs == null) {
            VcsImplUtil.$$$reportNull$$$0(15);
        }
        if (ignoreFileRoot == null) {
            VcsImplUtil.$$$reportNull$$$0(16);
        }
        if (ignoreFile == null) {
            VcsImplUtil.$$$reportNull$$$0(17);
        }
        if (VcsImplUtil.updateIgnoreFileIfNeeded(project, vcs, ignoreFileRoot, ignoreFile.exists())) {
            VirtualFile ignoreVFile = VfsUtil.findFileByIoFile((File)ignoreFile, (boolean)true);
            if (ignoreVFile == null) {
                return;
            }
            new OpenFileDescriptor(project, ignoreVFile).navigate(true);
        }
    }

    private static IgnoredFileContentProvider getIgnoredFileContentProvider(@NotNull Project project, @NotNull AbstractVcs vcs) {
        if (project == null) {
            VcsImplUtil.$$$reportNull$$$0(18);
        }
        if (vcs == null) {
            VcsImplUtil.$$$reportNull$$$0(19);
        }
        return IgnoredFileContentProvider.IGNORE_FILE_CONTENT_PROVIDER.extensions((AreaInstance)project).filter(provider -> provider.getSupportedVcs().equals((Object)vcs.getKeyInstanceMethod())).findFirst().orElse(null);
    }

    public static boolean canManageIgnoreFiles(@NotNull Project project) {
        if (project == null) {
            VcsImplUtil.$$$reportNull$$$0(20);
        }
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance((Project)project);
        VcsApplicationSettings applicationSettings = VcsApplicationSettings.getInstance();
        return applicationSettings.MANAGE_IGNORE_FILES || propertiesComponent.getBoolean(MANAGE_IGNORE_FILES_PROPERTY, false);
    }

    private static boolean isFileSharedInVcs(@NotNull Project project, @NotNull ChangeListManagerEx changeListManager, @NotNull String filePath) {
        VirtualFile file2;
        if (project == null) {
            VcsImplUtil.$$$reportNull$$$0(21);
        }
        if (changeListManager == null) {
            VcsImplUtil.$$$reportNull$$$0(22);
        }
        if (filePath == null) {
            VcsImplUtil.$$$reportNull$$$0(23);
        }
        if ((file2 = LocalFileSystem.getInstance().findFileByPath(filePath)) == null) {
            return false;
        }
        FileStatus fileStatus = changeListManager.getStatus(file2);
        return VcsUtil.isFileUnderVcs((Project)project, (String)filePath) && fileStatus != FileStatus.UNKNOWN && fileStatus != FileStatus.IGNORED;
    }

    public static boolean isProjectSharedInVcs(@NotNull Project project) {
        if (project == null) {
            VcsImplUtil.$$$reportNull$$$0(24);
        }
        return (Boolean)ReadAction.compute(() -> {
            if (project.isDisposed()) {
                return false;
            }
            @SystemIndependent String projectFilePath = project.getProjectFilePath();
            ChangeListManagerEx changeListManager = (ChangeListManagerEx)ChangeListManager.getInstance((Project)project);
            return !changeListManager.isInUpdate() && projectFilePath != null && VcsImplUtil.isFileSharedInVcs(project, changeListManager, projectFilePath);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcsUtil/VcsImplUtil";
                break;
            }
            case 4: 
            case 9: 
            case 12: 
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 5: 
            case 10: 
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreFileRoot";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manageIgnore";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ignoreFile";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeListManager";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcsUtil/VcsImplUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortVcsRootName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getShortVcsRootName";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "proposeUpdateIgnoreFile";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "notifyVcsIgnoreFileManage";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "generateIgnoreFileIfNeeded";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "updateIgnoreFileIfNeeded";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "updateIgnoreFileAndOpen";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getIgnoredFileContentProvider";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "canManageIgnoreFiles";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isFileSharedInVcs";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isProjectSharedInVcs";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

