/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcsUtil;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableNotNullFunction;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManager;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConsumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class VcsFileUtil {
    public static final int FILE_PATH_LIMIT = 7600;

    @NotNull
    public static <T> List<T> foreachChunk(@NotNull List<String> arguments, int groupSize, @NotNull ThrowableNotNullFunction<? super List<String>, ? extends List<? extends T>, ? extends VcsException> processor2) throws VcsException {
        if (arguments == null) {
            VcsFileUtil.$$$reportNull$$$0(0);
        }
        if (processor2 == null) {
            VcsFileUtil.$$$reportNull$$$0(1);
        }
        ArrayList result2 = ContainerUtil.newArrayList();
        VcsFileUtil.foreachChunk(arguments, groupSize, (ThrowableConsumer<? super List<String>, ? extends VcsException>)((ThrowableConsumer)chunk -> result2.addAll((Collection)processor2.fun(chunk))));
        ArrayList arrayList = result2;
        if (arrayList == null) {
            VcsFileUtil.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    public static void foreachChunk(@NotNull List<String> arguments, int groupSize, @NotNull ThrowableConsumer<? super List<String>, ? extends VcsException> consumer) throws VcsException {
        if (arguments == null) {
            VcsFileUtil.$$$reportNull$$$0(3);
        }
        if (consumer == null) {
            VcsFileUtil.$$$reportNull$$$0(4);
        }
        List<List<String>> chunks = VcsFileUtil.chunkArguments(arguments, groupSize);
        for (List<String> chunk : chunks) {
            ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
            if (indicator != null) {
                indicator.checkCanceled();
            }
            consumer.consume(chunk);
        }
    }

    @NotNull
    public static List<List<String>> chunkArguments(@NotNull List<String> arguments) {
        if (arguments == null) {
            VcsFileUtil.$$$reportNull$$$0(5);
        }
        List<List<String>> list2 = VcsFileUtil.chunkArguments(arguments, 1);
        if (list2 == null) {
            VcsFileUtil.$$$reportNull$$$0(6);
        }
        return list2;
    }

    @NotNull
    public static List<List<String>> chunkArguments(@NotNull List<String> arguments, int groupSize) {
        int i;
        if (arguments == null) {
            VcsFileUtil.$$$reportNull$$$0(7);
        }
        assert (arguments.size() % groupSize == 0) : "Arguments size should be divisible by group size";
        ArrayList<List<String>> rc = new ArrayList<List<String>>();
        int start2 = 0;
        int size = 0;
        for (i = 0; i < arguments.size(); i += groupSize) {
            int length = 0;
            for (int j = 0; j < groupSize; ++j) {
                length += arguments.get(i + j).length();
            }
            if (size + length > 7600) {
                if (start2 == i) {
                    rc.add(arguments.subList(i, i + groupSize));
                    start2 = i + groupSize;
                    size = 0;
                    continue;
                }
                rc.add(arguments.subList(start2, i));
                start2 = i;
                size = length;
                continue;
            }
            size += length;
        }
        if (start2 != arguments.size()) {
            rc.add(arguments.subList(start2, i));
        }
        ArrayList<List<String>> arrayList = rc;
        if (arrayList == null) {
            VcsFileUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    public static List<List<String>> chunkPaths(VirtualFile root, Collection<? extends FilePath> files2) {
        return VcsFileUtil.chunkArguments(VcsFileUtil.toRelativePaths(root, files2));
    }

    public static List<List<String>> chunkFiles(@NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files2) {
        if (root == null) {
            VcsFileUtil.$$$reportNull$$$0(9);
        }
        if (files2 == null) {
            VcsFileUtil.$$$reportNull$$$0(10);
        }
        return VcsFileUtil.chunkArguments(VcsFileUtil.toRelativeFiles(root, files2));
    }

    public static String getRelativeFilePath(VirtualFile file2, @NotNull VirtualFile baseDir) {
        if (baseDir == null) {
            VcsFileUtil.$$$reportNull$$$0(11);
        }
        return VcsFileUtil.getRelativeFilePath(file2.getPath(), baseDir);
    }

    public static String getRelativeFilePath(String file2, @NotNull VirtualFile baseDir) {
        String basePath;
        if (baseDir == null) {
            VcsFileUtil.$$$reportNull$$$0(12);
        }
        if (SystemInfo.isWindows) {
            file2 = file2.replace('\\', '/');
        }
        if (!file2.startsWith(basePath = baseDir.getPath())) {
            return file2;
        }
        if (file2.equals(basePath)) {
            return ".";
        }
        return file2.substring(baseDir.getPath().length() + 1);
    }

    public static boolean isOctal(char ch) {
        return '0' <= ch && ch <= '7';
    }

    public static String relativePath(VirtualFile root, FilePath path) {
        return VcsFileUtil.relativePath(VfsUtilCore.virtualToIoFile((VirtualFile)root), path.getIOFile());
    }

    public static String relativePath(File root, FilePath path) {
        return VcsFileUtil.relativePath(root, path.getIOFile());
    }

    public static String relativePath(File root, VirtualFile file2) {
        return VcsFileUtil.relativePath(root, VfsUtilCore.virtualToIoFile((VirtualFile)file2));
    }

    public static String relativePath(VirtualFile root, VirtualFile file2) {
        return VcsFileUtil.relativePath(VfsUtilCore.virtualToIoFile((VirtualFile)root), VfsUtilCore.virtualToIoFile((VirtualFile)file2));
    }

    public static String relativeOrFullPath(VirtualFile root, VirtualFile file2) {
        if (root == null) {
            file2.getPath();
        }
        return VcsFileUtil.relativePath(VfsUtilCore.virtualToIoFile((VirtualFile)root), VfsUtilCore.virtualToIoFile((VirtualFile)file2));
    }

    public static String relativePath(File root, File path) {
        String rc = FileUtil.getRelativePath((File)root, (File)path);
        if (rc == null) {
            throw new IllegalArgumentException("The file " + path + " cannot be made relative to " + root);
        }
        return rc.replace(File.separatorChar, '/');
    }

    public static List<String> toRelativePaths(@NotNull VirtualFile root, @NotNull Collection<? extends FilePath> filePaths) {
        if (root == null) {
            VcsFileUtil.$$$reportNull$$$0(13);
        }
        if (filePaths == null) {
            VcsFileUtil.$$$reportNull$$$0(14);
        }
        ArrayList<String> rc = new ArrayList<String>(filePaths.size());
        for (FilePath filePath : filePaths) {
            rc.add(VcsFileUtil.relativePath(root, filePath));
        }
        return rc;
    }

    public static List<String> toRelativeFiles(@NotNull VirtualFile root, @NotNull Collection<? extends VirtualFile> files2) {
        if (root == null) {
            VcsFileUtil.$$$reportNull$$$0(15);
        }
        if (files2 == null) {
            VcsFileUtil.$$$reportNull$$$0(16);
        }
        ArrayList<String> rc = new ArrayList<String>(files2.size());
        for (VirtualFile virtualFile : files2) {
            rc.add(VcsFileUtil.relativePath(root, virtualFile));
        }
        return rc;
    }

    public static void markFilesDirty(@NotNull Project project, @NotNull Collection<? extends VirtualFile> affectedFiles2) {
        if (project == null) {
            VcsFileUtil.$$$reportNull$$$0(17);
        }
        if (affectedFiles2 == null) {
            VcsFileUtil.$$$reportNull$$$0(18);
        }
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project);
        for (VirtualFile virtualFile : affectedFiles2) {
            if (virtualFile.isDirectory()) {
                dirty.dirDirtyRecursively(virtualFile);
                continue;
            }
            dirty.fileDirty(virtualFile);
        }
    }

    public static void markFilesDirty(@NotNull Project project, @NotNull List<? extends FilePath> affectedFiles2) {
        if (project == null) {
            VcsFileUtil.$$$reportNull$$$0(19);
        }
        if (affectedFiles2 == null) {
            VcsFileUtil.$$$reportNull$$$0(20);
        }
        VcsDirtyScopeManager dirty = VcsDirtyScopeManager.getInstance((Project)project);
        for (FilePath filePath : affectedFiles2) {
            if (filePath.isDirectory()) {
                dirty.dirDirtyRecursively(filePath);
                continue;
            }
            dirty.fileDirty(filePath);
        }
    }

    public static void addFilesToVcsWithConfirmation(@NotNull Project project, VirtualFile ... virtualFiles) {
        if (project == null) {
            VcsFileUtil.$$$reportNull$$$0(21);
        }
        VcsFileUtil.addFilesToVcsWithConfirmation(project, Arrays.asList(virtualFiles));
    }

    public static void addFilesToVcsWithConfirmation(@NotNull Project project, @NotNull Collection<? extends VirtualFile> virtualFiles) {
        if (project == null) {
            VcsFileUtil.$$$reportNull$$$0(22);
        }
        if (virtualFiles == null) {
            VcsFileUtil.$$$reportNull$$$0(23);
        }
        if (virtualFiles.isEmpty()) {
            return;
        }
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        ArrayListMultimap vcsMap = ArrayListMultimap.create();
        for (VirtualFile virtualFile : virtualFiles) {
            AbstractVcs vcs = vcsManager.getVcsFor(virtualFile);
            if (vcs == null) continue;
            VfsUtil.processFileRecursivelyWithoutIgnored((VirtualFile)virtualFile, arg_0 -> VcsFileUtil.lambda$addFilesToVcsWithConfirmation$1((Multimap)vcsMap, vcs, arg_0));
        }
        for (AbstractVcs abstractVcs : vcsMap.keySet()) {
            VcsShowConfirmationOption addOption = vcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, abstractVcs);
            if (addOption.getValue() == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
                return;
            }
            ArrayList<VirtualFile> filesList = new ArrayList<VirtualFile>(vcsMap.get((Object)abstractVcs));
            if (addOption.getValue() == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
                VcsFileUtil.performAdditions(abstractVcs, filesList);
                continue;
            }
            AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)project);
            Ref filesToAdd = Ref.create();
            ApplicationManager.getApplication().invokeAndWait(() -> filesToAdd.set((Object)helper.selectFilesToProcess(new ArrayList(filesList), VcsBundle.message((String)"confirmation.title.add.files.to", (Object[])new Object[]{vcs.getDisplayName()}), null, VcsBundle.message((String)"confirmation.title.add.file.to", (Object[])new Object[]{vcs.getDisplayName()}), null, addOption)));
            if (filesToAdd.isNull()) continue;
            VcsFileUtil.performAdditions(abstractVcs, new ArrayList<VirtualFile>((Collection)filesToAdd.get()));
        }
    }

    private static void performAdditions(@NotNull AbstractVcs vcs, @NotNull List<VirtualFile> value) {
        CheckinEnvironment checkinEnvironment;
        if (vcs == null) {
            VcsFileUtil.$$$reportNull$$$0(24);
        }
        if (value == null) {
            VcsFileUtil.$$$reportNull$$$0(25);
        }
        if ((checkinEnvironment = vcs.getCheckinEnvironment()) != null) {
            checkinEnvironment.scheduleUnversionedFilesForAddition(value);
        }
    }

    private static /* synthetic */ boolean lambda$addFilesToVcsWithConfirmation$1(Multimap vcsMap, AbstractVcs vcs, VirtualFile virtualFile) {
        return vcsMap.put((Object)vcs, (Object)virtualFile);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arguments";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcsUtil/VcsFileUtil";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 9: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 17: 
            case 19: 
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "affectedFiles";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFiles";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcsUtil/VcsFileUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "foreachChunk";
                break;
            }
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "chunkArguments";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "foreachChunk";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                break;
            }
            case 5: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "chunkArguments";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "chunkFiles";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getRelativeFilePath";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "toRelativePaths";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "toRelativeFiles";
                break;
            }
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "markFilesDirty";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addFilesToVcsWithConfirmation";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "performAdditions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

