/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.util;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.Page;
import com.intellij.util.io.PersistentBTreeEnumerator;
import com.intellij.util.io.PersistentEnumeratorBase;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.util.PersistentUtil;
import com.intellij.vcs.log.util.StorageId;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0007J\u001c\u0010\u0012\u001a\u00020\u00132\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fH\u0002J*\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00160\u0015\"\u0004\b\u0000\u0010\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00160\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0007J\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u001eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u00020\u00068FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\b\u0010\u0002\u001a\u0004\b\t\u0010\n\u00a8\u0006\u001f"}, d2={"Lcom/intellij/vcs/log/util/PersistentUtil;", "", "()V", "CORRUPTION_MARKER", "", "LOG_CACHE", "Ljava/io/File;", "corruptionMarkerFile", "corruptionMarkerFile$annotations", "getCorruptionMarkerFile", "()Ljava/io/File;", "calcLogId", "project", "Lcom/intellij/openapi/project/Project;", "logProviders", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/vcs/log/VcsLogProvider;", "calcLogProvidersHash", "", "createPersistentEnumerator", "Lcom/intellij/util/io/PersistentEnumeratorBase;", "T", "keyDescriptor", "Lcom/intellij/util/io/KeyDescriptor;", "storageId", "Lcom/intellij/vcs/log/util/StorageId;", "deleteWithRenamingAllFilesStartingWith", "", "baseFile", "deleteWithRenamingAllFilesStartingWith$intellij_platform_vcs_log_impl", "intellij.platform.vcs.log.impl"})
public final class PersistentUtil {
    @JvmField
    @NotNull
    public static final File LOG_CACHE;
    private static final String CORRUPTION_MARKER = "corruption.marker";
    public static final PersistentUtil INSTANCE;

    @JvmStatic
    public static /* synthetic */ void corruptionMarkerFile$annotations() {
    }

    @NotNull
    public static final File getCorruptionMarkerFile() {
        return new File(LOG_CACHE, CORRUPTION_MARKER);
    }

    @JvmStatic
    @NotNull
    public static final String calcLogId(@NotNull Project project, @NotNull Map<VirtualFile, ? extends VcsLogProvider> logProviders) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull(logProviders, (String)"logProviders");
        int hashcode = INSTANCE.calcLogProvidersHash(logProviders);
        return project.getLocationHash() + "." + Integer.toHexString(hashcode);
    }

    private final int calcLogProvidersHash(Map<VirtualFile, ? extends VcsLogProvider> logProviders) {
        List list2 = ContainerUtil.sorted((Collection)logProviders.keySet(), Comparator.comparing(calcLogProvidersHash.sortedRoots.1.INSTANCE));
        Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"ContainerUtil.sorted(log\u2026tring> { it -> it.path })");
        List sortedRoots2 = list2;
        return StringUtil.join((Collection)sortedRoots2, (Function)new Function<T, String>(logProviders){
            final /* synthetic */ Map $logProviders;

            @NotNull
            public final String fun(VirtualFile root) {
                StringBuilder stringBuilder = new StringBuilder();
                VirtualFile virtualFile = root;
                Intrinsics.checkExpressionValueIsNotNull((Object)virtualFile, (String)"root");
                StringBuilder stringBuilder2 = stringBuilder.append(virtualFile.getPath()).append(".");
                V v = this.$logProviders.get(root);
                if (v == null) {
                    Intrinsics.throwNpe();
                }
                VcsKey vcsKey = ((VcsLogProvider)v).getSupportedVcs();
                Intrinsics.checkExpressionValueIsNotNull((Object)vcsKey, (String)"logProviders[root]!!.supportedVcs");
                return stringBuilder2.append(vcsKey.getName()).toString();
            }
            {
                this.$logProviders = map2;
            }
        }, (String)".").hashCode();
    }

    @JvmStatic
    @NotNull
    public static final <T> PersistentEnumeratorBase<T> createPersistentEnumerator(@NotNull KeyDescriptor<T> keyDescriptor, @NotNull StorageId storageId) throws IOException {
        Intrinsics.checkParameterIsNotNull(keyDescriptor, (String)"keyDescriptor");
        Intrinsics.checkParameterIsNotNull((Object)storageId, (String)"storageId");
        File storageFile = StorageId.getStorageFile$default(storageId, null, 1, null);
        Object object = IOUtil.openCleanOrResetBroken((ThrowableComputable)new ThrowableComputable<T, IOException>(storageFile, keyDescriptor, storageId){
            final /* synthetic */ File $storageFile;
            final /* synthetic */ KeyDescriptor $keyDescriptor;
            final /* synthetic */ StorageId $storageId;

            @NotNull
            public final PersistentBTreeEnumerator<T> compute() {
                return new PersistentBTreeEnumerator(this.$storageFile, this.$keyDescriptor, Page.PAGE_SIZE, null, this.$storageId.getVersion());
            }
            {
                this.$storageFile = file2;
                this.$keyDescriptor = keyDescriptor;
                this.$storageId = storageId;
            }
        }, (File)storageFile);
        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"IOUtil.openCleanOrResetB\u2026             storageFile)");
        return (PersistentEnumeratorBase)object;
    }

    public final boolean deleteWithRenamingAllFilesStartingWith$intellij_platform_vcs_log_impl(@NotNull File baseFile) {
        Intrinsics.checkParameterIsNotNull((Object)baseFile, (String)"baseFile");
        File file2 = baseFile.getParentFile();
        if (file2 == null) {
            return false;
        }
        File parentFile = file2;
        File[] fileArray = parentFile.listFiles(new FileFilter(baseFile){
            final /* synthetic */ File $baseFile;

            public final boolean accept(File pathname) {
                File file2 = pathname;
                Intrinsics.checkExpressionValueIsNotNull((Object)file2, (String)"pathname");
                String string = file2.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"pathname.name");
                String string2 = this.$baseFile.getName();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"baseFile.name");
                return StringsKt.startsWith$default((String)string, (String)string2, (boolean)false, (int)2, null);
            }
            {
                this.$baseFile = file2;
            }
        });
        if (fileArray == null) {
            return true;
        }
        File[] files2 = fileArray;
        boolean deleted = true;
        for (File f : files2) {
            deleted &= FileUtil.deleteWithRenaming((File)f);
        }
        return deleted;
    }

    private PersistentUtil() {
    }

    static {
        PersistentUtil persistentUtil;
        INSTANCE = persistentUtil = new PersistentUtil();
        LOG_CACHE = new File(PathManager.getSystemPath(), "vcs-log");
    }
}

