/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.render;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.changes.issueLinks.IssueLinkRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleColoredRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.paint.PaintUtil;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.graph.EdgePrintElement;
import com.intellij.vcs.log.graph.PrintElement;
import com.intellij.vcs.log.paint.GraphCellPainter;
import com.intellij.vcs.log.paint.PaintParameters;
import com.intellij.vcs.log.ui.render.GraphCommitCell;
import com.intellij.vcs.log.ui.render.LabelIconCache;
import com.intellij.vcs.log.ui.render.LabelPainter;
import com.intellij.vcs.log.ui.render.TooltipReferencesPanel;
import com.intellij.vcs.log.ui.render.TypeSafeTableCellRenderer;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GraphCommitCellRenderer
extends TypeSafeTableCellRenderer<GraphCommitCell> {
    private static final int MAX_GRAPH_WIDTH = 6;
    private static final int VERTICAL_PADDING = JBUI.scale((int)7);
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final MyComponent myComponent;
    @NotNull
    private final MyComponent myTemplateComponent;

    public GraphCommitCellRenderer(@NotNull VcsLogData logData, @NotNull GraphCellPainter painter, @NotNull VcsLogGraphTable table, boolean compact, boolean showTagNames) {
        if (logData == null) {
            GraphCommitCellRenderer.$$$reportNull$$$0(0);
        }
        if (painter == null) {
            GraphCommitCellRenderer.$$$reportNull$$$0(1);
        }
        if (table == null) {
            GraphCommitCellRenderer.$$$reportNull$$$0(2);
        }
        this.myLogData = logData;
        this.myGraphTable = table;
        LabelIconCache iconCache = new LabelIconCache();
        this.myComponent = new MyComponent(logData, painter, table, iconCache, compact, showTagNames);
        this.myTemplateComponent = new MyComponent(logData, painter, table, iconCache, compact, showTagNames);
    }

    protected SimpleColoredComponent getTableCellRendererComponentImpl(@NotNull JTable table, @NotNull GraphCommitCell value, boolean isSelected, boolean hasFocus, int row2, int column) {
        if (table == null) {
            GraphCommitCellRenderer.$$$reportNull$$$0(3);
        }
        if (value == null) {
            GraphCommitCellRenderer.$$$reportNull$$$0(4);
        }
        this.myComponent.customize(value, isSelected, hasFocus, row2, column);
        return this.myComponent;
    }

    @Nullable
    public JComponent getTooltip(@NotNull Object value, @NotNull Point point, int row2) {
        double distance2;
        GraphCommitCell cell;
        Collection<VcsRef> refs;
        if (value == null) {
            GraphCommitCellRenderer.$$$reportNull$$$0(5);
        }
        if (point == null) {
            GraphCommitCellRenderer.$$$reportNull$$$0(6);
        }
        if (!(refs = (cell = (GraphCommitCell)this.getValue(value)).getRefsToThisCommit()).isEmpty() && (this.myComponent.getReferencePainter().isLeftAligned() ? (distance2 = point.getX() - (double)this.myTemplateComponent.getGraphWidth(cell.getPrintElements())) > 0.0 && distance2 <= (double)this.getReferencesWidth(row2, cell) : (double)this.getColumnWidth() - point.getX() <= (double)this.getReferencesWidth(row2, cell))) {
            return new TooltipReferencesPanel(this.myLogData, refs);
        }
        return null;
    }

    public int getPreferredHeight() {
        return this.myComponent.getPreferredHeight();
    }

    private int getReferencesWidth(int row2) {
        return this.getReferencesWidth(row2, (GraphCommitCell)this.getValue(this.myGraphTable.getModel().getValueAt(row2, 1)));
    }

    private int getReferencesWidth(int row2, @NotNull GraphCommitCell cell) {
        Collection<VcsRef> refs;
        if (cell == null) {
            GraphCommitCellRenderer.$$$reportNull$$$0(7);
        }
        if (!(refs = cell.getRefsToThisCommit()).isEmpty()) {
            this.myTemplateComponent.customize(cell, this.myGraphTable.isRowSelected(row2), this.myGraphTable.hasFocus(), row2, 1);
            return this.myTemplateComponent.getReferencePainter().getSize().width;
        }
        return 0;
    }

    private int getGraphWidth(int row2) {
        GraphCommitCell cell = (GraphCommitCell)this.getValue(this.myGraphTable.getModel().getValueAt(row2, 1));
        return this.myTemplateComponent.getGraphWidth(cell.getPrintElements());
    }

    public int getTooltipXCoordinate(int row2) {
        int referencesWidth = this.getReferencesWidth(row2);
        if (referencesWidth != 0) {
            if (this.myComponent.getReferencePainter().isLeftAligned()) {
                return this.getGraphWidth(row2) + referencesWidth / 2;
            }
            return this.getColumnWidth() - referencesWidth / 2;
        }
        return this.getColumnWidth() / 2;
    }

    private int getColumnWidth() {
        return this.myGraphTable.getColumnByModelIndex(1).getWidth();
    }

    public void setCompactReferencesView(boolean compact) {
        this.myComponent.getReferencePainter().setCompact(compact);
        this.myTemplateComponent.getReferencePainter().setCompact(compact);
    }

    public void setShowTagsNames(boolean showTagNames) {
        this.myComponent.getReferencePainter().setShowTagNames(showTagNames);
        this.myTemplateComponent.getReferencePainter().setShowTagNames(showTagNames);
    }

    public static Font getLabelFont() {
        return UIUtil.getLabelFont();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "painter";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "point";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cell";
                break;
            }
        }
        objectArray2[1] = "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getTableCellRendererComponentImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getTooltip";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getReferencesWidth";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GraphImage {
        private final int myWidth;
        @NotNull
        private final Image myImage;

        GraphImage(@NotNull Image image, int width) {
            if (image == null) {
                GraphImage.$$$reportNull$$$0(0);
            }
            this.myImage = image;
            this.myWidth = width;
        }

        @NotNull
        Image getImage() {
            Image image = this.myImage;
            if (image == null) {
                GraphImage.$$$reportNull$$$0(1);
            }
            return image;
        }

        int getWidth() {
            return this.myWidth;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "image";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$GraphImage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$GraphImage";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImage";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class MyComponent
    extends SimpleColoredRenderer {
        private static final int DISPLAYED_MESSAGE_PART = 80;
        @NotNull
        private final VcsLogData myLogData;
        @NotNull
        private final VcsLogGraphTable myGraphTable;
        @NotNull
        private final GraphCellPainter myPainter;
        @NotNull
        private final IssueLinkRenderer myIssueLinkRenderer;
        @NotNull
        private final LabelPainter myReferencePainter;
        @NotNull
        protected GraphImage myGraphImage;
        @NotNull
        private Font myFont;
        private int myHeight;
        private AffineTransform myAffineTransform;

        MyComponent(@NotNull VcsLogData data, @NotNull GraphCellPainter painter, @NotNull VcsLogGraphTable table, @NotNull LabelIconCache iconCache, boolean compact, boolean showTags) {
            if (data == null) {
                MyComponent.$$$reportNull$$$0(0);
            }
            if (painter == null) {
                MyComponent.$$$reportNull$$$0(1);
            }
            if (table == null) {
                MyComponent.$$$reportNull$$$0(2);
            }
            if (iconCache == null) {
                MyComponent.$$$reportNull$$$0(3);
            }
            this.myGraphImage = new GraphImage(UIUtil.createImage((int)1, (int)1, (int)2), 0);
            this.myLogData = data;
            this.myPainter = painter;
            this.myGraphTable = table;
            this.myReferencePainter = new LabelPainter(this.myLogData, (JComponent)((Object)table), iconCache, compact, showTags);
            this.myIssueLinkRenderer = new IssueLinkRenderer(this.myLogData.getProject(), (SimpleColoredComponent)this);
            this.myFont = GraphCommitCellRenderer.getLabelFont();
            GraphicsConfiguration configuration = this.myGraphTable.getGraphicsConfiguration();
            this.myAffineTransform = configuration != null ? configuration.getDefaultTransform() : null;
            this.myHeight = this.calculateHeight();
        }

        @NotNull
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            int referencesSize = this.myReferencePainter.isLeftAligned() ? 0 : this.myReferencePainter.getSize().width;
            Dimension dimension = new Dimension(preferredSize.width + referencesSize, this.getPreferredHeight());
            if (dimension == null) {
                MyComponent.$$$reportNull$$$0(4);
            }
            return dimension;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            int graphImageWidth = this.myGraphImage.getWidth();
            Graphics2D g2d = (Graphics2D)g;
            if (!this.myReferencePainter.isLeftAligned()) {
                int start2 = Math.max(graphImageWidth, this.getWidth() - this.myReferencePainter.getSize().width);
                this.myReferencePainter.paint(g2d, start2, 0, this.getHeight());
            } else {
                this.myReferencePainter.paint(g2d, graphImageWidth, 0, this.getHeight());
            }
            AffineTransform origTx = PaintUtil.alignTxToInt((Graphics2D)g2d, null, (boolean)false, (boolean)true, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.ROUND_FLOOR_BIAS);
            try {
                UIUtil.drawImage((Graphics)g, (Image)this.myGraphImage.getImage(), (int)0, (int)0, null);
            }
            finally {
                if (origTx != null) {
                    g2d.setTransform(origTx);
                }
            }
        }

        public void customize(@NotNull GraphCommitCell cell, boolean isSelected, boolean hasFocus, int row2, int column) {
            if (cell == null) {
                MyComponent.$$$reportNull$$$0(5);
            }
            this.clear();
            this.setPaintFocusBorder(false);
            this.acquireState((JTable)((Object)this.myGraphTable), isSelected, hasFocus, row2, column);
            this.getCellState().updateRenderer((JComponent)((Object)this));
            this.setBorder(null);
            this.myGraphImage = this.getGraphImage(cell.getPrintElements());
            SimpleTextAttributes style = this.myGraphTable.applyHighlighters((Component)((Object)this), row2, column, hasFocus, isSelected);
            Collection<VcsRef> refs = cell.getRefsToThisCommit();
            Color baseForeground = (Color)ObjectUtils.assertNotNull((Object)this.myGraphTable.getBaseStyle(row2, column, hasFocus, isSelected).getForeground());
            this.append("");
            if (this.myReferencePainter.isLeftAligned()) {
                this.myReferencePainter.customizePainter(refs, this.getBackground(), baseForeground, isSelected, this.getAvailableWidth(column, this.myGraphImage.getWidth()));
                this.appendTextPadding(this.myGraphImage.getWidth() + this.myReferencePainter.getSize().width + LabelPainter.RIGHT_PADDING.get());
                this.appendText(cell, style, isSelected);
            } else {
                this.appendTextPadding(this.myGraphImage.getWidth());
                this.appendText(cell, style, isSelected);
                this.myReferencePainter.customizePainter(refs, this.getBackground(), baseForeground, isSelected, this.getAvailableWidth(column, this.myGraphImage.getWidth()));
            }
        }

        private void appendText(@NotNull GraphCommitCell cell, @NotNull SimpleTextAttributes style, boolean isSelected) {
            if (cell == null) {
                MyComponent.$$$reportNull$$$0(6);
            }
            if (style == null) {
                MyComponent.$$$reportNull$$$0(7);
            }
            this.myIssueLinkRenderer.appendTextWithLinks(StringUtil.replace((String)cell.getText(), (String)"\t", (String)" ").trim(), style);
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)((Object)this.myGraphTable), (SimpleColoredComponent)this, (boolean)false, (boolean)isSelected);
        }

        private int getAvailableWidth(int column, int graphWidth) {
            int textAndLabelsWidth = this.myGraphTable.getColumnModel().getColumn(column).getWidth() - graphWidth;
            int freeSpace = textAndLabelsWidth - super.getPreferredSize().width;
            int allowedSpace = this.myReferencePainter.isCompact() ? Math.min(freeSpace, textAndLabelsWidth / 3) : Math.max(freeSpace, Math.max(textAndLabelsWidth / 2, textAndLabelsWidth - JBUI.scale((int)80)));
            return Math.max(0, allowedSpace);
        }

        private int calculateHeight() {
            return Math.max(this.myReferencePainter.getSize().height, this.getFontMetrics(this.myFont).getHeight() + VERTICAL_PADDING);
        }

        public int getPreferredHeight() {
            Font font = GraphCommitCellRenderer.getLabelFont();
            GraphicsConfiguration configuration = this.myGraphTable.getGraphicsConfiguration();
            if (this.myFont != font || configuration != null && !Objects.equals(this.myAffineTransform, configuration.getDefaultTransform())) {
                this.myFont = font;
                this.myAffineTransform = configuration != null ? configuration.getDefaultTransform() : null;
                this.myHeight = this.calculateHeight();
            }
            return this.myHeight;
        }

        @NotNull
        private GraphImage getGraphImage(@NotNull Collection<? extends PrintElement> printElements) {
            if (printElements == null) {
                MyComponent.$$$reportNull$$$0(8);
            }
            double maxIndex = this.getMaxGraphElementIndex(printElements);
            BufferedImage image = UIUtil.createImage((GraphicsConfiguration)this.myGraphTable.getGraphicsConfiguration(), (double)((int)((double)PaintParameters.getNodeWidth(this.myGraphTable.getRowHeight()) * (maxIndex + 2.0))), (double)this.myGraphTable.getRowHeight(), (int)2, (PaintUtil.RoundingMode)PaintUtil.RoundingMode.CEIL);
            Graphics2D g2 = image.createGraphics();
            this.myPainter.draw(g2, printElements);
            int width = (int)(maxIndex * (double)PaintParameters.getNodeWidth(this.myGraphTable.getRowHeight()));
            GraphImage graphImage = new GraphImage(image, width);
            if (graphImage == null) {
                MyComponent.$$$reportNull$$$0(9);
            }
            return graphImage;
        }

        private int getGraphWidth(@NotNull Collection<? extends PrintElement> printElements) {
            if (printElements == null) {
                MyComponent.$$$reportNull$$$0(10);
            }
            double maxIndex = this.getMaxGraphElementIndex(printElements);
            return (int)(maxIndex * (double)PaintParameters.getNodeWidth(this.myGraphTable.getRowHeight()));
        }

        private double getMaxGraphElementIndex(@NotNull Collection<? extends PrintElement> printElements) {
            if (printElements == null) {
                MyComponent.$$$reportNull$$$0(11);
            }
            double maxIndex = 0.0;
            for (PrintElement printElement : printElements) {
                maxIndex = Math.max(maxIndex, (double)printElement.getPositionInCurrentRow());
                if (!(printElement instanceof EdgePrintElement)) continue;
                maxIndex = Math.max(maxIndex, (double)(printElement.getPositionInCurrentRow() + ((EdgePrintElement)printElement).getPositionInOtherRow()) / 2.0);
            }
            maxIndex += 1.0;
            maxIndex = Math.max(maxIndex, (double)Math.min(6, this.myGraphTable.getVisibleGraph().getRecommendedWidth()));
            return maxIndex;
        }

        @NotNull
        public LabelPainter getReferencePainter() {
            LabelPainter labelPainter = this.myReferencePainter;
            if (labelPainter == null) {
                MyComponent.$$$reportNull$$$0(12);
            }
            return labelPainter;
        }

        public FontMetrics getFontMetrics(Font font) {
            return this.myGraphTable.getFontMetrics(font);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 9: 
                case 12: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 9: 
                case 12: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "painter";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "table";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "iconCache";
                    break;
                }
                case 4: 
                case 9: 
                case 12: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$MyComponent";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cell";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "style";
                    break;
                }
                case 8: 
                case 10: 
                case 11: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "printElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/vcs/log/ui/render/GraphCommitCellRenderer$MyComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreferredSize";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getGraphImage";
                    break;
                }
                case 12: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencePainter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 9: 
                case 12: {
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "customize";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray;
                    objectArray[2] = "appendText";
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getGraphImage";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "getGraphWidth";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "getMaxGraphElementIndex";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 9: 
                case 12: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

